/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.connection;

import org.apache.directory.studio.connection.ui.actions.ActionHandlerManager;
import org.apache.directory.studio.connection.ui.actions.ConnectionViewActionProxy;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.apache.directory.studio.connection.ui.widgets.ConnectionActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.actions.ExportConnectionsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.ImportConnectionsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.ImportExportAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenSchemaBrowserAction;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.LinkWithEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ConnectionViewActionGroup
extends ConnectionActionGroup {
    private ConnectionView view;
    private LinkWithEditorAction linkWithEditorAction;
    private static final String importDsmlAction = "importDsmlAction";
    private static final String exportDsmlAction = "exportDsmlAction";
    private static final String importLdifAction = "importLdifAction";
    private static final String exportLdifAction = "exportLdifAction";
    private static final String exportCsvAction = "exportCsvAction";
    private static final String exportExcelAction = "exportExcelAction";
    private static final String exportOdfAction = "exportOdfAction";
    private static final String importConnectionsAction = "importConnectionsAction";
    private static final String exportConnectionsAction = "exportConnectionsAction";
    private static final String openSchemaBrowserAction = "openSchemaBrowserAction";

    public ConnectionViewActionGroup(ConnectionView view) {
        super(view.getMainWidget(), view.getConfiguration());
        this.view = view;
        TreeViewer viewer = view.getMainWidget().getViewer();
        this.linkWithEditorAction = new LinkWithEditorAction(view);
        this.connectionActionMap.put(importDsmlAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(4)));
        this.connectionActionMap.put(exportDsmlAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(5)));
        this.connectionActionMap.put(importLdifAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(0)));
        this.connectionActionMap.put(exportLdifAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(1)));
        this.connectionActionMap.put(exportCsvAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(2)));
        this.connectionActionMap.put(exportExcelAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(3)));
        this.connectionActionMap.put(exportOdfAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportExportAction(6)));
        this.connectionActionMap.put(importConnectionsAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ImportConnectionsAction()));
        this.connectionActionMap.put(exportConnectionsAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new ExportConnectionsAction()));
        this.connectionActionMap.put(openSchemaBrowserAction, new ConnectionViewActionProxy((Viewer)viewer, (ActionHandlerManager)this, (StudioAction)new OpenSchemaBrowserAction()));
    }

    public void dispose() {
        if (this.view != null) {
            this.linkWithEditorAction.dispose();
            this.linkWithEditorAction = null;
            this.view = null;
        }
        super.dispose();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.connectionActionMap.get("newConnectionAction"));
        menuManager.add((IAction)this.connectionActionMap.get("newConnectionFolderAction"));
        menuManager.add((IContributionItem)new Separator());
        if (((IAction)this.connectionActionMap.get("closeConnectionAction")).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get("closeConnectionAction"));
        } else if (((IAction)this.connectionActionMap.get("openConnectionAction")).isEnabled()) {
            menuManager.add((IAction)this.connectionActionMap.get("openConnectionAction"));
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get(openSchemaBrowserAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get("copyConnectionAction"));
        menuManager.add((IAction)this.connectionActionMap.get("pasteConnectionAction"));
        menuManager.add((IAction)this.connectionActionMap.get("deleteConnectionAction"));
        menuManager.add((IAction)this.connectionActionMap.get("renameConnectionAction"));
        menuManager.add((IContributionItem)new Separator());
        MenuManager importMenuManager = new MenuManager(Messages.getString("ConnectionViewActionGroup.Import"));
        importMenuManager.add((IAction)this.connectionActionMap.get(importLdifAction));
        importMenuManager.add((IAction)this.connectionActionMap.get(importDsmlAction));
        importMenuManager.add((IContributionItem)new Separator());
        importMenuManager.add((IAction)this.connectionActionMap.get(importConnectionsAction));
        importMenuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)importMenuManager);
        MenuManager exportMenuManager = new MenuManager(Messages.getString("ConnectionViewActionGroup.Export"));
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportLdifAction));
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportDsmlAction));
        exportMenuManager.add((IContributionItem)new Separator());
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportCsvAction));
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportExcelAction));
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportOdfAction));
        exportMenuManager.add((IContributionItem)new Separator());
        exportMenuManager.add((IAction)this.connectionActionMap.get(exportConnectionsAction));
        exportMenuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)exportMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.connectionActionMap.get("propertyDialogAction"));
    }
}

