/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SearchResultEditorInput
implements IEditorInput {
    private ISearch search;
    private boolean dummy;

    public SearchResultEditorInput(ISearch search) {
        this(search, false);
    }

    SearchResultEditorInput(ISearch search, boolean dummy) {
        this.search = search;
        this.dummy = dummy;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/browser_searchresulteditor.gif");
    }

    public String getName() {
        if (this.search != null) {
            return this.search.getName();
        }
        return Messages.getString("SearchResultEditorContentProvider.NoSearchSelected");
    }

    public String getToolTipText() {
        if (this.search != null) {
            String toolTipText = this.search.getUrl().toString();
            IBrowserConnection browserConnection = this.search.getBrowserConnection();
            if (browserConnection != null && browserConnection.getConnection() != null) {
                toolTipText = toolTipText + " - " + browserConnection.getConnection().getName();
            }
            return toolTipText;
        }
        return Messages.getString("SearchResultEditorContentProvider.NoSearchSelected");
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ISearch getSearch() {
        return this.search;
    }

    public int hashCode() {
        if (this.dummy) {
            return 0;
        }
        return this.getToolTipText().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchResultEditorInput)) {
            return false;
        }
        SearchResultEditorInput other = (SearchResultEditorInput)obj;
        if (this.dummy && other.dummy) {
            return true;
        }
        if (this.dummy != other.dummy) {
            return false;
        }
        if (this.search == null && other.search == null) {
            return true;
        }
        if (this.search == null || other.search == null) {
            return false;
        }
        return other.search.equals(this.search);
    }
}

