/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowserInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class SchemaBrowserNavigationLocation
extends NavigationLocation {
    SchemaBrowserNavigationLocation(SchemaBrowser schemaBrowser) {
        super((IEditorPart)schemaBrowser);
    }

    public String getText() {
        AbstractSchemaObject schemaElement = this.getSchemaElement();
        if (schemaElement != null) {
            if (schemaElement instanceof ObjectClass) {
                return Messages.getString("SchemaBrowserNavigationLocation.ObjectClass") + SchemaUtils.toString((AbstractSchemaObject)schemaElement);
            }
            if (schemaElement instanceof AttributeType) {
                return Messages.getString("SchemaBrowserNavigationLocation.AttributeType") + SchemaUtils.toString((AbstractSchemaObject)schemaElement);
            }
            if (schemaElement instanceof LdapSyntax) {
                return Messages.getString("SchemaBrowserNavigationLocation.Syntax") + SchemaUtils.toString((AbstractSchemaObject)schemaElement);
            }
            if (schemaElement instanceof MatchingRule) {
                return Messages.getString("SchemaBrowserNavigationLocation.MatchingRule") + SchemaUtils.toString((AbstractSchemaObject)schemaElement);
            }
            if (schemaElement instanceof MatchingRuleUse) {
                return Messages.getString("SchemaBrowserNavigationLocation.MatchingRuleUse") + SchemaUtils.toString((AbstractSchemaObject)schemaElement);
            }
            return SchemaUtils.toString((AbstractSchemaObject)schemaElement);
        }
        return super.getText();
    }

    public void saveState(IMemento memento) {
        IBrowserConnection connection = this.getConnection();
        AbstractSchemaObject schemaElement = this.getSchemaElement();
        memento.putString("CONNECTION", connection.getConnection().getId());
        memento.putString("SCHEMAELEMENTYPE", schemaElement.getClass().getName());
        memento.putString("SCHEMAELEMENTOID", schemaElement.getOid());
    }

    public void restoreState(IMemento memento) {
        IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
        String schemaElementType = memento.getString("SCHEMAELEMENTYPE");
        String schemaElementOid = memento.getString("SCHEMAELEMENTOID");
        MutableObjectClass schemaElement = null;
        if (ObjectClass.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getObjectClassDescription(schemaElementOid);
        } else if (AttributeType.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getAttributeTypeDescription(schemaElementOid);
        } else if (LdapSyntax.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getLdapSyntaxDescription(schemaElementOid);
        } else if (MatchingRule.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getMatchingRuleDescription(schemaElementOid);
        } else if (MatchingRuleUse.class.getName().equals(schemaElementType)) {
            schemaElement = connection.getSchema().getMatchingRuleUseDescription(schemaElementOid);
        }
        super.setInput((Object)new SchemaBrowserInput(connection, (AbstractSchemaObject)schemaElement));
    }

    public void restoreLocation() {
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart != null && editorPart instanceof SchemaBrowser) {
            SchemaBrowserInput sbi;
            SchemaBrowser schemaBrowser = (SchemaBrowser)editorPart;
            Object input = this.getInput();
            if (input != null && input instanceof SchemaBrowserInput && (sbi = (SchemaBrowserInput)input).getConnection() != null && sbi.getSchemaElement() != null) {
                schemaBrowser.setInput(sbi);
            }
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != currentLocation.getClass()) {
            return false;
        }
        SchemaBrowserNavigationLocation location = (SchemaBrowserNavigationLocation)currentLocation;
        AbstractSchemaObject other = location.getSchemaElement();
        AbstractSchemaObject element = this.getSchemaElement();
        if (other == null && element == null) {
            return true;
        }
        if (other == null || element == null) {
            return false;
        }
        return element.equals((Object)other);
    }

    public void update() {
    }

    private AbstractSchemaObject getSchemaElement() {
        SchemaBrowserInput schemaBrowserInput;
        AbstractSchemaObject schemaElement;
        Object editorInput = this.getInput();
        if (editorInput != null && editorInput instanceof SchemaBrowserInput && (schemaElement = (schemaBrowserInput = (SchemaBrowserInput)editorInput).getSchemaElement()) != null) {
            return schemaElement;
        }
        return null;
    }

    private IBrowserConnection getConnection() {
        Object editorInput = this.getInput();
        if (editorInput != null && editorInput instanceof SchemaBrowserInput) {
            SchemaBrowserInput schemaBrowserInput = (SchemaBrowserInput)editorInput;
            return schemaBrowserInput.getConnection();
        }
        return null;
    }

    public String toString() {
        return "" + this.getSchemaElement();
    }
}

