/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SearchLogsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableSearchRequestLogging;
    private Button enableSearchResultEntryLogging;
    private Text logFileCountText;
    private Text logFileSizeText;

    public SearchLogsPreferencePage() {
        super(Messages.getString("SearchLogsPreferencePage.SearchLogs"));
        super.setPreferenceStore(BrowserUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("SearchLogsPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.enableSearchRequestLogging = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchLogsPreferencePage.EnableRequestLogs"), (int)1);
        this.enableSearchRequestLogging.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("searchRequestLogsEnable"));
        this.enableSearchResultEntryLogging = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchLogsPreferencePage.EnableResultLogs"), (int)1);
        this.enableSearchResultEntryLogging.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("searchResultEntryLogsEnable"));
        Group rotateGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("SearchLogsPreferencePage.LogFileRotation"), (int)1);
        Composite rotateComposite = BaseWidgetUtils.createColumnContainer((Composite)rotateGroup, (int)5, (int)1);
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.Use"), (int)1);
        this.logFileCountText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)3, (int)1);
        this.logFileCountText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getString("searchLogsFileCount"));
        this.logFileCountText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(SearchLogsPreferencePage.this.logFileCountText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.LogFilesEach"), (int)1);
        this.logFileSizeText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)5, (int)1);
        this.logFileSizeText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getString("searchLogsFileSize"));
        this.logFileSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
                if ("".equals(SearchLogsPreferencePage.this.logFileSizeText.getText()) && e.text.matches("[0]")) {
                    e.doit = false;
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.KB"), (int)1);
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("searchRequestLogsEnable", this.enableSearchRequestLogging.getSelection());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("searchResultEntryLogsEnable", this.enableSearchResultEntryLogging.getSelection());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("searchLogsFileCount", this.logFileCountText.getText());
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("searchLogsFileSize", this.logFileSizeText.getText());
        return true;
    }

    protected void performDefaults() {
        this.enableSearchRequestLogging.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("searchRequestLogsEnable"));
        this.enableSearchResultEntryLogging.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("searchResultEntryLogsEnable"));
        this.logFileCountText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultString("searchLogsFileCount"));
        this.logFileSizeText.setText(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultString("searchLogsFileSize"));
        super.performDefaults();
    }
}

