/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EntryEditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean useUserPriority = false;
    private int openMode = 0;
    private List<EntryEditorExtension> sortedEntryEditorsList;
    private Button historicalBehaviorButton;
    private Button useApplicationWideOpenModeButton;
    private TableViewer entryEditorsTableViewer;
    private Button upEntryEditorButton;
    private Button downEntryEditorButton;
    private Button restoreDefaultsEntryEditorsButton;

    public EntryEditorsPreferencePage() {
        super(Messages.getString("EntryEditorsPreferencePage.EntryEditorsPrefPageTitle"));
        super.setPreferenceStore(BrowserUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("EntryEditorsPreferencePage.EntryEditorsPrefPageDescription"));
    }

    public void init(IWorkbench workbench) {
        this.openMode = BrowserUIPlugin.getDefault().getPluginPreferences().getInt("openMode");
        this.useUserPriority = BrowserUIPlugin.getDefault().getPluginPreferences().getBoolean("useUserPriorities");
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group openModeGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryEditorsPreferencePage.OpenMode"), (int)1);
        this.historicalBehaviorButton = BaseWidgetUtils.createRadiobutton((Composite)openModeGroup, (String)Messages.getString("EntryEditorsPreferencePage.HistoricalBehavior"), (int)1);
        Composite historicalBehaviorComposite = BaseWidgetUtils.createColumnContainer((Composite)openModeGroup, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)historicalBehaviorComposite, (int)1);
        Label historicalBehaviourLabel = BaseWidgetUtils.createWrappedLabel((Composite)historicalBehaviorComposite, (String)Messages.getString("EntryEditorsPreferencePage.HistoricalBehaviorTooltip"), (int)1);
        GridData historicalBehaviourLabelGridData = new GridData(768);
        historicalBehaviourLabelGridData.widthHint = 300;
        historicalBehaviourLabel.setLayoutData((Object)historicalBehaviourLabelGridData);
        this.useApplicationWideOpenModeButton = BaseWidgetUtils.createRadiobutton((Composite)openModeGroup, (String)Messages.getString("EntryEditorsPreferencePage.ApplicationWideSetting"), (int)1);
        Composite useApplicationWideOpenModeComposite = BaseWidgetUtils.createColumnContainer((Composite)openModeGroup, (int)2, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)useApplicationWideOpenModeComposite, (int)1);
        Link link = BaseWidgetUtils.createLink((Composite)useApplicationWideOpenModeComposite, (String)Messages.getString("EntryEditorsPreferencePage.ApplicationWideSettingTooltip"), (int)1);
        GridData linkGridData = new GridData(768);
        linkGridData.widthHint = 300;
        link.setLayoutData((Object)linkGridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)EntryEditorsPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.Workbench", null, null);
            }
        });
        if (this.openMode == 0) {
            this.historicalBehaviorButton.setSelection(true);
            this.useApplicationWideOpenModeButton.setSelection(false);
        } else if (this.openMode == 1) {
            this.historicalBehaviorButton.setSelection(false);
            this.useApplicationWideOpenModeButton.setSelection(true);
        }
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group entryEditorsGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("EntryEditorsPreferencePage.EntryEditors"), (int)1);
        Label entryEditorsLabel = BaseWidgetUtils.createWrappedLabel((Composite)entryEditorsGroup, (String)Messages.getString("EntryEditorsPreferencePage.EntryEditorsLabel"), (int)1);
        GridData entryEditorsLabelGridData = new GridData(768);
        entryEditorsLabelGridData.widthHint = 300;
        entryEditorsLabel.setLayoutData((Object)entryEditorsLabelGridData);
        Composite entryEditorsComposite = new Composite((Composite)entryEditorsGroup, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        entryEditorsComposite.setLayout((Layout)gl);
        entryEditorsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.entryEditorsTableViewer = new TableViewer(entryEditorsComposite, 67588);
        GridData gridData = new GridData(4, 0, true, false, 1, 3);
        gridData.heightHint = 125;
        this.entryEditorsTableViewer.getTable().setLayoutData((Object)gridData);
        this.entryEditorsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.entryEditorsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((EntryEditorExtension)element).getName();
            }

            public Image getImage(Object element) {
                return ((EntryEditorExtension)element).getIcon().createImage();
            }
        });
        this.entryEditorsTableViewer.setInput(BrowserUIPlugin.getDefault().getEntryEditorManager().getEntryEditorExtensions());
        this.upEntryEditorButton = BaseWidgetUtils.createButton((Composite)entryEditorsComposite, (String)Messages.getString("EntryEditorsPreferencePage.Up"), (int)1);
        this.upEntryEditorButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.upEntryEditorButton.setEnabled(false);
        this.upEntryEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryEditorsPreferencePage.this.moveSelectedEntryEditor(MoveEntryEditorDirectionEnum.UP);
            }
        });
        this.downEntryEditorButton = BaseWidgetUtils.createButton((Composite)entryEditorsComposite, (String)Messages.getString("EntryEditorsPreferencePage.Down"), (int)1);
        this.downEntryEditorButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.downEntryEditorButton.setEnabled(false);
        this.downEntryEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryEditorsPreferencePage.this.moveSelectedEntryEditor(MoveEntryEditorDirectionEnum.DOWN);
            }
        });
        this.restoreDefaultsEntryEditorsButton = BaseWidgetUtils.createButton((Composite)entryEditorsComposite, (String)Messages.getString("EntryEditorsPreferencePage.RestoreDefaults"), (int)1);
        this.restoreDefaultsEntryEditorsButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.restoreDefaultsEntryEditorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryEditorsPreferencePage.this.performDefaultsEntryEditors();
            }
        });
        BaseWidgetUtils.createLabel((Composite)entryEditorsGroup, (String)Messages.getString("EntryEditorsPreferencePage.DescriptionColon"), (int)1);
        final Text descriptionText = new Text((Composite)entryEditorsGroup, 2058);
        descriptionText.setEditable(false);
        gridData = new GridData(4, 0, true, false);
        gridData.heightHint = 27;
        gridData.widthHint = 300;
        descriptionText.setLayoutData((Object)gridData);
        this.entryEditorsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EntryEditorExtension entryEditor = (EntryEditorExtension)((StructuredSelection)EntryEditorsPreferencePage.this.entryEditorsTableViewer.getSelection()).getFirstElement();
                if (entryEditor != null) {
                    descriptionText.setText(entryEditor.getDescription());
                    EntryEditorsPreferencePage.this.updateButtonsState(entryEditor);
                }
            }
        });
        if (this.useUserPriority) {
            this.sortEntryEditorsByUserPriority();
        } else {
            this.sortEntryEditorsByDefaultPriority();
        }
        if (this.sortedEntryEditorsList.size() > 0) {
            this.entryEditorsTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.sortedEntryEditorsList.get(0)));
        }
        return composite;
    }

    private void sortEntryEditorsByUserPriority() {
        this.sortedEntryEditorsList = new ArrayList<EntryEditorExtension>(BrowserUIPlugin.getDefault().getEntryEditorManager().getEntryEditorExtensionsSortedByUserPriority());
        this.entryEditorsTableViewer.setInput(this.sortedEntryEditorsList);
    }

    private void sortEntryEditorsByDefaultPriority() {
        this.sortedEntryEditorsList = new ArrayList<EntryEditorExtension>(BrowserUIPlugin.getDefault().getEntryEditorManager().getEntryEditorExtensionsSortedByDefaultPriority());
        this.entryEditorsTableViewer.setInput(this.sortedEntryEditorsList);
    }

    private void moveSelectedEntryEditor(MoveEntryEditorDirectionEnum direction) {
        EntryEditorExtension entryEditor;
        StructuredSelection selection = (StructuredSelection)this.entryEditorsTableViewer.getSelection();
        if (selection.size() == 1 && this.sortedEntryEditorsList.contains(entryEditor = (EntryEditorExtension)selection.getFirstElement())) {
            int oldIndex = this.sortedEntryEditorsList.indexOf(entryEditor);
            int newIndex = 0;
            switch (direction) {
                case UP: {
                    newIndex = oldIndex - 1;
                    break;
                }
                case DOWN: {
                    newIndex = oldIndex + 1;
                }
            }
            if (newIndex >= 0 && newIndex < this.sortedEntryEditorsList.size()) {
                EntryEditorExtension newIndexEntryEditorBackup = this.sortedEntryEditorsList.set(newIndex, entryEditor);
                this.sortedEntryEditorsList.set(oldIndex, newIndexEntryEditorBackup);
                this.entryEditorsTableViewer.refresh();
                this.updateButtonsState(entryEditor);
                this.useUserPriority = true;
            }
        }
    }

    private void updateButtonsState(EntryEditorExtension entryEditor) {
        int index = this.sortedEntryEditorsList.indexOf(entryEditor);
        this.upEntryEditorButton.setEnabled(index > 0);
        this.downEntryEditorButton.setEnabled(index <= this.sortedEntryEditorsList.size() - 2);
    }

    private void updateButtonsState() {
        StructuredSelection selection = (StructuredSelection)this.entryEditorsTableViewer.getSelection();
        if (selection.size() == 1) {
            EntryEditorExtension entryEditor = (EntryEditorExtension)selection.getFirstElement();
            this.updateButtonsState(entryEditor);
        }
    }

    public boolean performOk() {
        if (this.historicalBehaviorButton.getSelection()) {
            BrowserUIPlugin.getDefault().getPluginPreferences().setValue("openMode", 0);
        } else if (this.useApplicationWideOpenModeButton.getSelection()) {
            BrowserUIPlugin.getDefault().getPluginPreferences().setValue("openMode", 1);
        }
        BrowserUIPlugin.getDefault().getPluginPreferences().setValue("useUserPriorities", this.useUserPriority);
        if (this.useUserPriority) {
            StringBuilder sb = new StringBuilder();
            for (EntryEditorExtension entryEditor : this.sortedEntryEditorsList) {
                sb.append(entryEditor.getId() + ",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            BrowserUIPlugin.getDefault().getPluginPreferences().setValue("userPriorities", sb.toString());
        }
        return true;
    }

    protected void performDefaults() {
        this.openMode = BrowserUIPlugin.getDefault().getPluginPreferences().getDefaultInt("openMode");
        if (this.openMode == 0) {
            this.historicalBehaviorButton.setSelection(true);
            this.useApplicationWideOpenModeButton.setSelection(false);
        } else if (this.openMode == 1) {
            this.historicalBehaviorButton.setSelection(false);
            this.useApplicationWideOpenModeButton.setSelection(true);
        }
        this.performDefaultsEntryEditors();
        super.performDefaults();
    }

    private void performDefaultsEntryEditors() {
        this.useUserPriority = BrowserUIPlugin.getDefault().getPluginPreferences().getDefaultBoolean("useUserPriorities");
        if (this.useUserPriority) {
            this.sortEntryEditorsByUserPriority();
        } else {
            this.sortEntryEditorsByDefaultPriority();
        }
        this.updateButtonsState();
    }

    private static enum MoveEntryEditorDirectionEnum {
        UP,
        DOWN;

    }
}

