/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.ArrayList;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public abstract class CopyEntryAsAction
extends BrowserAction {
    public static final int MODE_DN_ONLY = 1;
    public static final int MODE_RETURNING_ATTRIBUTES_ONLY = 2;
    public static final int MODE_NORMAL = 3;
    public static final int MODE_INCLUDE_OPERATIONAL_ATTRIBUTES = 4;
    protected int mode;
    protected String type;
    protected String appendix;

    public CopyEntryAsAction(String type, int mode) {
        this.type = type;
        this.mode = mode;
        this.appendix = this.mode == 1 ? Messages.getString("CopyEntryAsAction.DNOnly") : (this.mode == 2 ? Messages.getString("CopyEntryAsAction.AttributesOnly") : (this.mode == 4 ? Messages.getString("CopyEntryAsAction.OperationalAttributes") : (this.mode == 3 ? Messages.getString("CopyEntryAsAction.UserAttributes") : "")));
    }

    public String getText() {
        if (this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length > 0 && this.getSelectedSearches().length == 0) {
            String text = (this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length > 1 ? NLS.bind((String)Messages.getString("CopyEntryAsAction.CopyEntries"), (Object[])new String[]{this.type}) : NLS.bind((String)Messages.getString("CopyEntryAsAction.CopyEntry"), (Object[])new String[]{this.type})) + this.appendix;
            return text;
        }
        if (this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length == 0 && this.getSelectedSearches().length == 1 && this.getSelectedSearches()[0].getSearchResults() != null && this.getSelectedSearches()[0].getSearchResults().length > 0) {
            String text = (this.getSelectedSearches()[0].getSearchResults().length > 1 ? NLS.bind((String)Messages.getString("CopyEntryAsAction.CopyResults"), (Object[])new String[]{this.type}) : NLS.bind((String)Messages.getString("CopyEntryAsAction.CopyResult"), (Object[])new String[]{this.type})) + this.appendix;
            return text;
        }
        return NLS.bind((String)Messages.getString("CopyEntryAsAction.CopyEntry"), (Object[])new String[]{this.type + this.appendix});
    }

    public String getCommandId() {
        return null;
    }

    public void run() {
        int i;
        ArrayList<IEntry> entryList = new ArrayList<IEntry>();
        for (i = 0; i < this.getSelectedEntries().length; ++i) {
            entryList.add(this.getSelectedEntries()[i]);
        }
        for (i = 0; i < this.getSelectedSearchResults().length; ++i) {
            entryList.add(this.getSelectedSearchResults()[i].getEntry());
        }
        for (i = 0; i < this.getSelectedBookmarks().length; ++i) {
            IEntry entry = this.getSelectedBookmarks()[0].getBrowserConnection().getEntryFromCache(this.getSelectedBookmarks()[0].getDn());
            if (entry == null) {
                ReadEntryRunnable runnable = new ReadEntryRunnable(this.getSelectedBookmarks()[0].getBrowserConnection(), this.getSelectedBookmarks()[0].getDn());
                RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
                entry = runnable.getReadEntry();
            }
            entryList.add(entry);
        }
        if (this.getSelectedSearches().length == 1) {
            ISearchResult[] results = this.getSelectedSearches()[0].getSearchResults();
            for (int k = 0; k < results.length; ++k) {
                entryList.add(results[k].getEntry());
            }
        }
        IEntry[] entries = entryList.toArray(new IEntry[entryList.size()]);
        ArrayList<IEntry> uninitializedEntryList = new ArrayList<IEntry>();
        for (int i2 = 0; entries != null && i2 < entries.length; ++i2) {
            if (entries[i2].isAttributesInitialized()) continue;
            uninitializedEntryList.add(entries[i2]);
        }
        if (uninitializedEntryList.size() > 0 && (this.mode == 3 || this.mode == 4)) {
            IEntry[] uninitializedEntries = uninitializedEntryList.toArray(new IEntry[uninitializedEntryList.size()]);
            InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(uninitializedEntries);
            RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
        }
        StringBuffer text = new StringBuffer();
        this.serialializeEntries(entries, text);
        this.copyToClipboard(text.toString());
    }

    protected abstract void serialializeEntries(IEntry[] var1, StringBuffer var2);

    public boolean isEnabled() {
        if (this.getSelectedSearchResults().length > 0 && this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 0) {
            return this.mode == 2 || this.mode == 3 || this.mode == 1 || this.mode == 4;
        }
        if (this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length > 0 && this.getSelectedSearches().length == 0) {
            return this.mode == 3 || this.mode == 1 || this.mode == 4;
        }
        return this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length == 0 && this.getSelectedSearches().length == 1 && this.getSelectedSearches()[0].getSearchResults() != null && this.getSelectedSearches()[0].getSearchResults().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyToClipboard(String text) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }
}

