/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.entryeditors;

import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.entryeditors.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;

public class EntryEditorUtils {
    public static StudioBrowserJob ensureAttributesInitialized(IEntry entry) {
        if (!entry.isAttributesInitialized()) {
            InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(new IEntry[]{entry});
            StudioBrowserJob job = new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable});
            job.execute();
            return job;
        }
        return null;
    }

    public static EntryEditorInput getEntryEditorInput(IEditorInput input) {
        if (input instanceof EntryEditorInput) {
            EntryEditorInput eei = (EntryEditorInput)input;
            return eei;
        }
        throw new IllegalArgumentException("Expected an EntryEditorInput");
    }

    public static String getHistoryNavigationText(EntryEditorInput input) {
        if (input != null) {
            if (input.getEntryInput() != null) {
                String connectionName;
                String string = connectionName = input.getEntryInput().getBrowserConnection().getConnection() == null ? "" : " - " + input.getEntryInput().getBrowserConnection().getConnection().getName();
                if (input.getEntryInput() instanceof IRootDSE) {
                    return Messages.getString("EntryEditorNavigationLocation.RootDSE") + connectionName;
                }
                return NLS.bind((String)Messages.getString("EntryEditorNavigationLocation.Entry"), (Object)input.getEntryInput().getDn().getName()) + connectionName;
            }
            if (input.getSearchResultInput() != null) {
                String connectionName;
                String string = connectionName = input.getSearchResultInput().getEntry().getBrowserConnection().getConnection() == null ? "" : " - " + input.getSearchResultInput().getEntry().getBrowserConnection().getConnection().getName();
                if (input.getSearchResultInput() instanceof IRootDSE) {
                    return Messages.getString("EntryEditorNavigationLocation.RootDSE") + connectionName;
                }
                return NLS.bind((String)Messages.getString("EntryEditorNavigationLocation.SearchResult"), (Object)input.getSearchResultInput().getDn().getName()) + connectionName;
            }
            if (input.getBookmarkInput() != null) {
                String connectionName;
                String string = connectionName = input.getBookmarkInput().getBrowserConnection().getConnection() == null ? "" : " - " + input.getBookmarkInput().getBrowserConnection().getConnection().getName();
                if (input.getBookmarkInput() instanceof IRootDSE) {
                    return Messages.getString("EntryEditorNavigationLocation.RootDSE") + connectionName;
                }
                return NLS.bind((String)Messages.getString("EntryEditorNavigationLocation.Bookmark"), (Object)input.getBookmarkInput().getDn().getName()) + connectionName;
            }
            return Messages.getString("EntryEditorUtils.NoEntrySelected");
        }
        return null;
    }

    public static boolean askSaveSharedWorkingCopyBeforeInputChange(IEntryEditor editor) {
        EntryEditorInput eei;
        IStatus status;
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.getString("EntryEditorUtils.SaveChanges"), null, Messages.getString("EntryEditorUtils.SaveChangesDescription"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        int result = dialog.open();
        return result != 0 || (status = (eei = editor.getEntryEditorInput()).saveSharedWorkingCopy(true, editor)).isOK();
    }
}

