/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.schemamanager;

import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.util.Strings;

public class SchemaEditorSchemaLoaderUtils {
    private static final String M_COLLECTIVE = "m-collective";
    private static final String M_DESCRIPTION = "m-description";
    private static final String M_EQUALITY = "m-equality";
    private static final String M_LENGTH = "m-length";
    private static final String M_MAY = "m-may";
    private static final String M_MUST = "m-must";
    private static final String M_NAME = "m-name";
    private static final String M_NO_USER_MODIFICATION = "m-noUserModification";
    private static final String M_OBSOLETE = "m-obsolete";
    private static final String M_OID = "m-oid";
    private static final String M_ORDERING = "m-ordering";
    private static final String M_SINGLE_VALUE = "m-singleValue";
    private static final String M_SUBSTR = "m-substr";
    private static final String M_SUP_ATTRIBUTE_TYPE = "m-supAttributeType";
    private static final String M_SUP_OBJECT_CLASS = "m-supObjectClass";
    private static final String M_SYNTAX = "m-syntax";
    private static final String M_TYPE_OBJECT_CLASS = "m-typeObjectClass";
    private static final String M_USAGE = "m-usage";
    private static final String TRUE = "TRUE";

    public static Entry toEntry(AttributeType attributeType) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.setDn(SchemaEditorSchemaLoaderUtils.getDn((SchemaObject)attributeType, "ou=attributetypes"));
        SchemaEditorSchemaLoaderUtils.addSchemaObjectValues((SchemaObject)attributeType, "metaAttributeType", (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addSuperiorValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addEqualityValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addOrderingValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addSubstrValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addSyntaxValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addSingleValueValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addCollectiveValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addNoUserModificationValue(attributeType, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addUsageValue(attributeType, (Entry)entry);
        return entry;
    }

    public static Entry toEntry(MatchingRule matchingRule) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.setDn(SchemaEditorSchemaLoaderUtils.getDn((SchemaObject)matchingRule, "ou=matchingrules"));
        SchemaEditorSchemaLoaderUtils.addSchemaObjectValues((SchemaObject)matchingRule, "metaMatchingRule", (Entry)entry);
        String syntax = matchingRule.getSyntaxOid();
        if (!Strings.isEmpty((String)syntax)) {
            DefaultAttribute attribute = new DefaultAttribute(M_SYNTAX, new String[]{syntax});
            entry.add(new Attribute[]{attribute});
        }
        return entry;
    }

    public static Entry toEntry(ObjectClass objectClass) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.setDn(SchemaEditorSchemaLoaderUtils.getDn((SchemaObject)objectClass, "ou=objectclasses"));
        SchemaEditorSchemaLoaderUtils.addSchemaObjectValues((SchemaObject)objectClass, "metaObjectClass", (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addSuperiorsValue(objectClass, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addClassTypeValue(objectClass, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addMustsValue(objectClass, (Entry)entry);
        SchemaEditorSchemaLoaderUtils.addMaysValue(objectClass, (Entry)entry);
        return entry;
    }

    public static Entry toEntry(LdapSyntax syntax) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.setDn(SchemaEditorSchemaLoaderUtils.getDn((SchemaObject)syntax, "ou=matchingrules"));
        SchemaEditorSchemaLoaderUtils.addSchemaObjectValues((SchemaObject)syntax, "metaMatchingRule", (Entry)entry);
        return entry;
    }

    private static Dn getDn(SchemaObject schemaObject, String objectPath) throws LdapInvalidDnException {
        return Dn.EMPTY_DN.add(new Rdn("ou=schema")).add(new Rdn("cn", Rdn.escapeValue((String)schemaObject.getSchemaName()))).add(new Rdn(objectPath)).add(new Rdn(M_OID, schemaObject.getOid()));
    }

    private static void addSchemaObjectValues(SchemaObject schemaObject, String objectClassValue, Entry entry) throws LdapException {
        SchemaEditorSchemaLoaderUtils.addObjectClassValue(schemaObject, objectClassValue, entry);
        SchemaEditorSchemaLoaderUtils.addOidValue(schemaObject, entry);
        SchemaEditorSchemaLoaderUtils.addNamesValue(schemaObject, entry);
        SchemaEditorSchemaLoaderUtils.addDescriptionValue(schemaObject, entry);
        SchemaEditorSchemaLoaderUtils.addObsoleteValue(schemaObject, entry);
    }

    private static void addObjectClassValue(SchemaObject schemaObject, String objectClassValue, Entry entry) throws LdapException {
        DefaultAttribute objectClassAttribute = new DefaultAttribute("objectClass");
        entry.add(new Attribute[]{objectClassAttribute});
        objectClassAttribute.add(new String[]{"top"});
        objectClassAttribute.add(new String[]{"metaTop"});
        objectClassAttribute.add(new String[]{objectClassValue});
    }

    private static void addOidValue(SchemaObject schemaObject, Entry entry) throws LdapException {
        String oid = schemaObject.getOid();
        if (!Strings.isEmpty((String)oid)) {
            DefaultAttribute attribute = new DefaultAttribute(M_OID, new String[]{oid});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addNamesValue(SchemaObject schemaObject, Entry entry) throws LdapException {
        List names = schemaObject.getNames();
        if (names != null && names.size() > 0) {
            DefaultAttribute attribute = new DefaultAttribute(M_NAME);
            entry.add(new Attribute[]{attribute});
            for (String name : names) {
                attribute.add(new String[]{name});
            }
        }
    }

    private static void addDescriptionValue(SchemaObject schemaObject, Entry entry) throws LdapException {
        String description = schemaObject.getDescription();
        if (!Strings.isEmpty((String)description)) {
            DefaultAttribute attribute = new DefaultAttribute(M_DESCRIPTION, new String[]{description});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addObsoleteValue(SchemaObject schemaObject, Entry entry) throws LdapException {
        if (schemaObject.isObsolete()) {
            DefaultAttribute attribute = new DefaultAttribute(M_OBSOLETE, new String[]{TRUE});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addSuperiorValue(AttributeType attributeType, Entry entry) throws LdapException {
        String superior = attributeType.getSuperiorName();
        if (!Strings.isEmpty((String)superior)) {
            DefaultAttribute attribute = new DefaultAttribute(M_SUP_ATTRIBUTE_TYPE, new String[]{superior});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addEqualityValue(AttributeType attributeType, Entry entry) throws LdapException {
        String equality = attributeType.getEqualityName();
        if (!Strings.isEmpty((String)equality)) {
            DefaultAttribute attribute = new DefaultAttribute(M_EQUALITY, new String[]{equality});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addOrderingValue(AttributeType attributeType, Entry entry) throws LdapException {
        String ordering = attributeType.getOrderingName();
        if (!Strings.isEmpty((String)ordering)) {
            DefaultAttribute attribute = new DefaultAttribute(M_ORDERING, new String[]{ordering});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addSubstrValue(AttributeType attributeType, Entry entry) throws LdapException {
        String substr = attributeType.getSubstringName();
        if (!Strings.isEmpty((String)substr)) {
            DefaultAttribute attribute = new DefaultAttribute(M_SUBSTR, new String[]{substr});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addSyntaxValue(AttributeType attributeType, Entry entry) throws LdapException {
        String syntax = attributeType.getSyntaxName();
        if (!Strings.isEmpty((String)syntax)) {
            DefaultAttribute attribute = new DefaultAttribute(M_SYNTAX, new String[]{syntax});
            entry.add(new Attribute[]{attribute});
            long syntaxLength = attributeType.getSyntaxLength();
            if (syntaxLength != -1L) {
                attribute = new DefaultAttribute(M_LENGTH, new String[]{"" + syntaxLength});
                entry.add(new Attribute[]{attribute});
            }
        }
    }

    private static void addSingleValueValue(AttributeType attributeType, Entry entry) throws LdapException {
        if (attributeType.isSingleValued()) {
            DefaultAttribute attribute = new DefaultAttribute(M_SINGLE_VALUE, new String[]{TRUE});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addCollectiveValue(AttributeType attributeType, Entry entry) throws LdapException {
        if (attributeType.isCollective()) {
            DefaultAttribute attribute = new DefaultAttribute(M_COLLECTIVE, new String[]{TRUE});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addNoUserModificationValue(AttributeType attributeType, Entry entry) throws LdapException {
        if (!attributeType.isUserModifiable()) {
            DefaultAttribute attribute = new DefaultAttribute(M_NO_USER_MODIFICATION, new String[]{TRUE});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addUsageValue(AttributeType attributeType, Entry entry) throws LdapException {
        UsageEnum usage = attributeType.getUsage();
        if (usage != UsageEnum.USER_APPLICATIONS) {
            DefaultAttribute attribute = new DefaultAttribute(M_USAGE, new String[]{usage.render()});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addSuperiorsValue(ObjectClass objectClass, Entry entry) throws LdapException {
        List superiors = objectClass.getSuperiorOids();
        if (superiors != null && superiors.size() > 0) {
            DefaultAttribute attribute = new DefaultAttribute(M_SUP_OBJECT_CLASS);
            entry.add(new Attribute[]{attribute});
            for (String superior : superiors) {
                attribute.add(new String[]{superior});
            }
        }
    }

    private static void addClassTypeValue(ObjectClass objectClass, Entry entry) throws LdapException {
        ObjectClassTypeEnum classType = objectClass.getType();
        if (classType != ObjectClassTypeEnum.STRUCTURAL) {
            DefaultAttribute attribute = new DefaultAttribute(M_TYPE_OBJECT_CLASS, new String[]{classType.toString()});
            entry.add(new Attribute[]{attribute});
        }
    }

    private static void addMustsValue(ObjectClass objectClass, Entry entry) throws LdapException {
        List musts = objectClass.getMustAttributeTypeOids();
        if (musts != null && musts.size() > 0) {
            DefaultAttribute attribute = new DefaultAttribute(M_MUST);
            entry.add(new Attribute[]{attribute});
            for (String must : musts) {
                attribute.add(new String[]{must});
            }
        }
    }

    private static void addMaysValue(ObjectClass objectClass, Entry entry) throws LdapException {
        List mays = objectClass.getMayAttributeTypeOids();
        if (mays != null && mays.size() > 0) {
            DefaultAttribute attribute = new DefaultAttribute(M_MAY);
            entry.add(new Attribute[]{attribute});
            for (String may : mays) {
                attribute.add(new String[]{may});
            }
        }
    }
}

