/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsImportException;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImportException;
import org.apache.directory.studio.schemaeditor.model.io.XMLSchemaFileImporter;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.osgi.util.NLS;

public class ProjectsImporter {
    private static final String PROJECT_TAG = "project";
    private static final String PROJECTS_TAG = "projects";
    private static final String NAME_TAG = "name";
    private static final String SCHEMAS_TAG = "schemas";
    private static final String TYPE_TAG = "type";
    private static final String CONNECTION_TAG = "connection";
    private static final String SCHEMA_CONNECTOR_TAG = "schemaConnector";
    private static final String SCHEMA_BACKUP_TAG = "schemaBackup";

    public static Project getProject(InputStream inputStream, String path) throws ProjectsImportException {
        Project project = new Project();
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotReadCorrectly"), (Object[])new String[]{path}));
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(PROJECT_TAG)) {
            throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotValidProject"), (Object[])new String[]{path}));
        }
        ProjectsImporter.readProject(rootElement, project, path);
        return project;
    }

    public static Project[] getProjects(InputStream inputStream, String path) throws ProjectsImportException {
        ArrayList<Project> projects = new ArrayList<Project>();
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            PluginUtils.logError(NLS.bind((String)Messages.getString("ProjectsImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
            throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotReadCorrectly"), (Object[])new String[]{path}));
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(PROJECTS_TAG)) {
            throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotValidProject"), (Object[])new String[]{path}));
        }
        Iterator i = rootElement.elementIterator(PROJECT_TAG);
        while (i.hasNext()) {
            Element projectElement = (Element)i.next();
            Project project = new Project();
            ProjectsImporter.readProject(projectElement, project, path);
            projects.add(project);
        }
        return projects.toArray(new Project[0]);
    }

    private static void readProject(Element element, Project project, String path) throws ProjectsImportException {
        Element schemasElement;
        Attribute typeAttribute;
        Attribute nameAttribute = element.attribute(NAME_TAG);
        if (nameAttribute != null && !nameAttribute.getValue().equals("")) {
            project.setName(nameAttribute.getValue());
        }
        if ((typeAttribute = element.attribute(TYPE_TAG)) != null && !typeAttribute.getValue().equals("")) {
            try {
                project.setType(ProjectType.valueOf(typeAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ProjectsImportException(Messages.getString("ProjectsImporter.NotConvertableValue"));
            }
        }
        if (project.getType().equals((Object)ProjectType.ONLINE)) {
            Element schemasElement2;
            Element schemaBackupElement;
            Attribute schemaConnectorAttribute;
            Attribute connectionAttribute = element.attribute(CONNECTION_TAG);
            if (connectionAttribute != null && !connectionAttribute.getValue().equals("")) {
                project.setConnection(PluginUtils.getConnection(connectionAttribute.getValue()));
            }
            if ((schemaConnectorAttribute = element.attribute(SCHEMA_CONNECTOR_TAG)) != null && !schemaConnectorAttribute.getValue().equals("")) {
                String schemaConnectorId = schemaConnectorAttribute.getValue();
                SchemaConnector schemaConnector = null;
                List<SchemaConnector> schemaConnectors = PluginUtils.getSchemaConnectors();
                for (SchemaConnector sc : schemaConnectors) {
                    if (!sc.getId().equalsIgnoreCase(schemaConnectorId)) continue;
                    schemaConnector = sc;
                }
                if (schemaConnector == null) {
                    throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NoSchemaConnectorIDFound"), (Object[])new String[]{schemaConnectorId}));
                }
                project.setSchemaConnector(schemaConnector);
            }
            if ((schemaBackupElement = element.element(SCHEMA_BACKUP_TAG)) != null && (schemasElement2 = schemaBackupElement.element(SCHEMAS_TAG)) != null) {
                Schema[] schemas = null;
                try {
                    for (Schema schema : schemas = XMLSchemaFileImporter.readSchemas(schemasElement2, path)) {
                        schema.setProject(project);
                    }
                }
                catch (XMLSchemaFileImportException e) {
                    throw new ProjectsImportException(Messages.getString("ProjectsImporter.NotConvertableSchema"));
                }
                project.setInitialSchema(Arrays.asList(schemas));
            }
        }
        if ((schemasElement = element.element(SCHEMAS_TAG)) != null) {
            Schema[] schemas = null;
            try {
                schemas = XMLSchemaFileImporter.readSchemas(schemasElement, path);
            }
            catch (XMLSchemaFileImportException e) {
                throw new ProjectsImportException(Messages.getString("ProjectsImporter.NotConvertableSchema"));
            }
            for (Schema schema : schemas) {
                schema.setProject(project);
                project.getSchemaHandler().addSchema(schema);
            }
        }
    }

    public static ProjectFileType getProjectFileType(InputStream inputStream, String path) throws ProjectsImportException {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotReadCorrectly"), (Object[])new String[]{path}));
        }
        Element rootElement = document.getRootElement();
        if (rootElement.getName().equals(PROJECT_TAG)) {
            return ProjectFileType.SINGLE;
        }
        if (rootElement.getName().equals(PROJECTS_TAG)) {
            return ProjectFileType.MULTIPLE;
        }
        throw new ProjectsImportException(NLS.bind((String)Messages.getString("ProjectsImporter.NotValidProject"), (Object[])new String[]{path}));
    }

    public static enum ProjectFileType {
        SINGLE,
        MULTIPLE;

    }
}

