/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.AbstractSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnectorException;
import org.eclipse.osgi.util.NLS;

public class GenericSchemaConnector
extends AbstractSchemaConnector
implements SchemaConnector {
    private static final Connection.AliasDereferencingMethod DEREF_ALIAS_METHOD = Connection.AliasDereferencingMethod.ALWAYS;
    private static final Connection.ReferralHandlingMethod HANDLE_REFERALS_METHOD = Connection.ReferralHandlingMethod.FOLLOW;

    @Override
    public void importSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
        monitor.beginTask(Messages.getString("GenericSchemaConnector.FetchingSchema"), 1);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        project.setInitialSchema(schemas);
        ConnectionWrapper wrapper = project.getConnection().getConnectionWrapper();
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(0);
        constraintSearch.setReturningAttributes(new String[]{"attributeTypes", "comparators", "ditContentRules", "ditStructureRules", "ldapSyntaxes", "matchingRules", "matchingRuleUse", "nameForms", "normalizers", "objectClasses", "syntaxCheckers"});
        String schemaDn = GenericSchemaConnector.getSubschemaSubentry(wrapper, monitor);
        StudioNamingEnumeration answer = wrapper.search(schemaDn, "(objectclass=subschema)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    Schema schema = new Schema("schema");
                    schema.setProject(project);
                    schemas.add(schema);
                    GenericSchemaConnector.getSchema(schema, wrapper, (SearchResult)answer.next(), monitor);
                }
            }
            catch (SchemaConnectorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SchemaConnectorException(e);
            }
        }
        monitor.worked(1);
    }

    @Override
    public boolean isSuitableConnector(Connection connection, StudioProgressMonitor monitor) {
        return GenericSchemaConnector.getSubschemaSubentry(connection.getConnectionWrapper(), monitor) != null;
    }

    private static String getSubschemaSubentry(ConnectionWrapper wrapper, StudioProgressMonitor monitor) {
        block7: {
            SearchControls constraintSearch = new SearchControls();
            constraintSearch.setSearchScope(0);
            constraintSearch.setReturningAttributes(new String[]{"subschemaSubentry"});
            StudioNamingEnumeration answer = wrapper.search("", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
            if (answer != null) {
                try {
                    if (!answer.hasMore()) break block7;
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute subschemaSubentryAttribute = searchResult.getAttributes().get("subschemaSubentry");
                    if (subschemaSubentryAttribute == null) {
                        return null;
                    }
                    if (subschemaSubentryAttribute.size() != 1) {
                        return null;
                    }
                    String subschemaSubentry = null;
                    try {
                        subschemaSubentry = (String)subschemaSubentryAttribute.get();
                    }
                    catch (NamingException e) {
                        return null;
                    }
                    return subschemaSubentry;
                }
                catch (NamingException e) {
                    monitor.reportError((Exception)e);
                }
            }
        }
        return null;
    }

    private static void getSchema(Schema schema, ConnectionWrapper wrapper, SearchResult searchResult, StudioProgressMonitor monitor) throws NamingException, SchemaConnectorException {
        NamingEnumeration<?> ne;
        NamingEnumeration<?> ne2;
        Attribute ldapSyntaxesAttribute;
        MutableObjectClass impl;
        NamingEnumeration<?> ne3;
        Attribute objectClassesAttribute;
        NamingEnumeration<?> ne4;
        int parseErrorCount = 0;
        Attribute attributeTypesAttribute = searchResult.getAttributes().get("attributeTypes");
        if (attributeTypesAttribute != null && (ne4 = attributeTypesAttribute.getAll()) != null) {
            while (ne4.hasMoreElements()) {
                String value = (String)ne4.nextElement();
                try {
                    AttributeTypeDescriptionSchemaParser parser = new AttributeTypeDescriptionSchemaParser();
                    parser.setQuirksMode(true);
                    AttributeType atd = parser.parseAttributeTypeDescription(value);
                    MutableAttributeType impl2 = new MutableAttributeType(atd.getOid());
                    impl2.setNames(atd.getNames().toArray(new String[0]));
                    impl2.setDescription(atd.getDescription());
                    impl2.setSuperiorOid(atd.getSuperiorOid());
                    impl2.setUsage(atd.getUsage());
                    impl2.setSyntaxOid(atd.getSyntaxOid());
                    impl2.setSyntaxLength(atd.getSyntaxLength());
                    impl2.setObsolete(atd.isObsolete());
                    impl2.setCollective(atd.isCollective());
                    impl2.setSingleValued(atd.isSingleValued());
                    impl2.setUserModifiable(atd.isUserModifiable());
                    impl2.setEqualityOid(atd.getEqualityOid());
                    impl2.setOrderingOid(atd.getOrderingOid());
                    impl2.setSubstringOid(atd.getSubstringOid());
                    impl2.setSchemaName(schema.getSchemaName());
                    if (impl2.getSyntaxOid() != null && "OctetString".equalsIgnoreCase(impl2.getSyntaxOid())) {
                        impl2.setSyntaxOid("1.3.6.1.4.1.1466.115.121.1.40");
                    }
                    schema.addAttributeType((AttributeType)impl2);
                }
                catch (ParseException e) {
                    PluginUtils.logError("Unable to parse the attribute type.", e);
                    ++parseErrorCount;
                }
            }
        }
        if ((objectClassesAttribute = searchResult.getAttributes().get("objectClasses")) != null && (ne3 = objectClassesAttribute.getAll()) != null) {
            while (ne3.hasMoreElements()) {
                String value = (String)ne3.nextElement();
                try {
                    ObjectClassDescriptionSchemaParser parser = new ObjectClassDescriptionSchemaParser();
                    parser.setQuirksMode(true);
                    MutableObjectClass ocd = parser.parseObjectClassDescription(value);
                    impl = new MutableObjectClass(ocd.getOid());
                    impl.setNames(ocd.getNames().toArray(new String[0]));
                    impl.setDescription(ocd.getDescription());
                    impl.setSuperiorOids(ocd.getSuperiorOids());
                    impl.setType(ocd.getType());
                    impl.setObsolete(ocd.isObsolete());
                    impl.setMustAttributeTypeOids(ocd.getMustAttributeTypeOids());
                    impl.setMayAttributeTypeOids(ocd.getMayAttributeTypeOids());
                    impl.setSchemaName(schema.getSchemaName());
                    schema.addObjectClass(impl);
                }
                catch (ParseException e) {
                    PluginUtils.logError("Unable to parse the object class.", e);
                    ++parseErrorCount;
                }
            }
        }
        if ((ldapSyntaxesAttribute = searchResult.getAttributes().get("ldapSyntaxes")) != null && (ne2 = ldapSyntaxesAttribute.getAll()) != null) {
            while (ne2.hasMoreElements()) {
                String value = (String)ne2.nextElement();
                try {
                    LdapSyntaxDescriptionSchemaParser parser = new LdapSyntaxDescriptionSchemaParser();
                    parser.setQuirksMode(true);
                    LdapSyntax lsd = parser.parseLdapSyntaxDescription(value);
                    LdapSyntax impl3 = new LdapSyntax(lsd.getOid());
                    impl3.setDescription(lsd.getDescription());
                    impl3.setNames(new String[]{lsd.getDescription()});
                    impl3.setHumanReadable(true);
                    impl3.setSchemaName(schema.getSchemaName());
                    schema.addSyntax(impl3);
                }
                catch (ParseException e) {
                    PluginUtils.logError("Unable to parse the syntax.", e);
                    ++parseErrorCount;
                }
            }
        }
        for (AttributeType at : schema.getAttributeTypes()) {
            String syntaxOid = at.getSyntaxOid();
            if (syntaxOid == null || schema.getSyntax(syntaxOid) != null) continue;
            impl = new LdapSyntax(syntaxOid);
            impl.setSchemaName(schema.getSchemaName());
            String oidDescription = Utils.getOidDescription((String)syntaxOid);
            impl.setDescription(oidDescription != null ? oidDescription : "Dummy");
            impl.setNames(new String[]{impl.getDescription()});
            schema.addSyntax((LdapSyntax)impl);
        }
        Attribute matchingRulesAttribute = searchResult.getAttributes().get("matchingRules");
        if (matchingRulesAttribute != null && (ne = matchingRulesAttribute.getAll()) != null) {
            while (ne.hasMoreElements()) {
                String value = (String)ne.nextElement();
                try {
                    MatchingRuleDescriptionSchemaParser parser = new MatchingRuleDescriptionSchemaParser();
                    parser.setQuirksMode(true);
                    MatchingRule mrd = parser.parseMatchingRuleDescription(value);
                    MutableMatchingRule impl4 = new MutableMatchingRule(mrd.getOid());
                    impl4.setDescription(mrd.getDescription());
                    impl4.setNames(mrd.getNames().toArray(new String[0]));
                    impl4.setObsolete(mrd.isObsolete());
                    impl4.setSyntaxOid(mrd.getSyntaxOid());
                    impl4.setSchemaName(schema.getSchemaName());
                    schema.addMatchingRule((MatchingRule)impl4);
                }
                catch (ParseException e) {
                    PluginUtils.logError("Unable to parse the matching rule.", e);
                    ++parseErrorCount;
                }
            }
        }
        for (AttributeType at : schema.getAttributeTypes()) {
            String equalityName = at.getEqualityOid();
            String orderingName = at.getOrderingOid();
            String substrName = at.getSubstringOid();
            GenericSchemaConnector.checkMatchingRules(schema, equalityName, orderingName, substrName);
        }
        if (parseErrorCount > 0) {
            if (parseErrorCount == 1) {
                throw new SchemaConnectorException(Messages.getString("GenericSchemaConnector.OneSchemaElementCouldNotBeParsedError"));
            }
            throw new SchemaConnectorException(NLS.bind((String)Messages.getString("GenericSchemaConnector.MultipleSchemaElementsCouldNotBeParsedError"), (Object)parseErrorCount));
        }
    }

    private static void checkMatchingRules(Schema schema, String ... matchingRuleNames) {
        for (String matchingRuleName : matchingRuleNames) {
            if (matchingRuleName == null || schema.getMatchingRule(matchingRuleName) != null) continue;
            MatchingRule impl = new MatchingRule(matchingRuleName);
            impl.setSchemaName(schema.getSchemaName());
            impl.setDescription("Dummy");
            impl.setNames(new String[]{matchingRuleName});
            schema.addMatchingRule(impl);
        }
    }

    @Override
    public void exportSchema(Project project, StudioProgressMonitor monitor) throws SchemaConnectorException {
    }
}

