/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSearchViewPreferenceAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSearchViewSortingDialogAction;
import org.apache.directory.studio.schemaeditor.controller.actions.RunCurrentSearchAgainAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ShowSearchFieldAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ShowSearchHistoryAction;
import org.apache.directory.studio.schemaeditor.view.views.SearchView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SearchViewController {
    private SearchView view;
    private List<String> authorizedPrefs;
    private ShowSearchFieldAction showSearchField;
    private RunCurrentSearchAgainAction runCurrentSearchAgain;
    private ShowSearchHistoryAction searchHistory;
    private OpenSearchViewSortingDialogAction openSearchViewSortingDialog;
    private OpenSearchViewPreferenceAction openSearchViewPreference;

    public SearchViewController(SearchView view) {
        this.view = view;
        this.initActions();
        this.initToolbar();
        this.initMenu();
        this.initAuthorizedPrefs();
        this.initPreferencesListener();
    }

    private void initActions() {
        this.showSearchField = new ShowSearchFieldAction(this.view);
        this.runCurrentSearchAgain = new RunCurrentSearchAgainAction(this.view);
        this.searchHistory = new ShowSearchHistoryAction(this.view);
        this.openSearchViewSortingDialog = new OpenSearchViewSortingDialogAction();
        this.openSearchViewPreference = new OpenSearchViewPreferenceAction();
    }

    private void initToolbar() {
        IToolBarManager toolbar = this.view.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.showSearchField);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.runCurrentSearchAgain);
        toolbar.add((IAction)this.searchHistory);
    }

    private void initMenu() {
        IMenuManager menu = this.view.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)this.openSearchViewSortingDialog);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openSearchViewPreference);
    }

    private void initAuthorizedPrefs() {
        this.authorizedPrefs = new ArrayList<String>();
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_DISPLAY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SCHEMA_LABEL_DISPLAY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_GROUPING);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SORTING_BY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SEARCH_VIEW_SORTING_ORDER);
    }

    private void initPreferencesListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (SearchViewController.this.authorizedPrefs.contains(event.getProperty())) {
                    SearchViewController.this.view.refresh();
                }
            }
        });
    }
}

