/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchCursorImpl
extends AbstractCursor<Response>
implements SearchCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private SearchFuture future;
    private long timeout;
    private TimeUnit timeUnit;
    private Response response;
    private boolean done;
    private SearchResultDone searchDoneResp;

    public SearchCursorImpl(SearchFuture future, long timeout, TimeUnit timeUnit) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SearchCursorImpl {}", (Object)this);
        }
        this.future = future;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public boolean next() throws LdapException, CursorException, IOException {
        if (this.done) {
            return false;
        }
        try {
            if (this.future.isCancelled()) {
                this.response = null;
                this.done = true;
                return false;
            }
            this.response = this.future.get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException("The response queue has been emptied, no response was found.", (Throwable)e);
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            this.close((Exception)((Object)ldapException));
            throw ldapException;
        }
        if (this.response == null) {
            this.future.cancel(true);
            throw new LdapException("TimeOut occurred");
        }
        this.done = this.response instanceof SearchResultDone;
        if (this.done) {
            this.searchDoneResp = (SearchResultDone)this.response;
            this.response = null;
        }
        return !this.done;
    }

    public Response get() throws InvalidCursorPositionException, IOException {
        if (!this.available()) {
            throw new InvalidCursorPositionException();
        }
        return this.response;
    }

    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    public boolean available() {
        return this.response != null;
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SearchCursorImpl {}", (Object)this);
        }
        this.close(null);
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SearchCursorImpl {}", (Object)this);
        }
        if (this.done) {
            super.close();
            return;
        }
        if (!this.future.isCancelled()) {
            this.future.cancel(true);
        }
        if (cause != null) {
            super.close(cause);
        } else {
            super.close();
        }
    }

    public void after(Response element) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("after( Response element )")}));
    }

    public void afterLast() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("afterLast()")}));
    }

    public void before(Response element) throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("before( Response element )")}));
    }

    public void beforeFirst() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("beforeFirst()")}));
    }

    public boolean first() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("first()")}));
    }

    public boolean last() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("last()")}));
    }

    public boolean previous() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{((Object)((Object)this)).getClass().getName().concat(".").concat("previous()")}));
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isReferral() {
        return this.response instanceof SearchResultReference;
    }

    public Referral getReferral() throws LdapException {
        if (this.isReferral()) {
            return ((SearchResultReference)this.response).getReferral();
        }
        throw new LdapException();
    }

    public boolean isEntry() {
        return this.response instanceof SearchResultEntry;
    }

    public Entry getEntry() throws LdapException {
        if (this.isEntry()) {
            return ((SearchResultEntry)this.response).getEntry();
        }
        throw new LdapException();
    }

    public boolean isIntermediate() {
        return this.response instanceof IntermediateResponse;
    }

    public IntermediateResponse getIntermediate() throws LdapException {
        if (this.isEntry()) {
            return (IntermediateResponse)this.response;
        }
        throw new LdapException();
    }
}

