/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAttributeDescFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAttributeDescFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAttributeDescFilter() {
        super("Initialize AttributeDesc filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        AttributeValueAssertion assertion = new AttributeValueAssertion();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04007, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        assertion.setAttributeDesc(type);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        terminalFilter.setAssertion(assertion);
        if (IS_DEBUG) {
            LOG.debug("Initialize AttributeDesc filter");
        }
    }
}

