/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaextractor.impl.ResourceMap;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifConfigExtractor {
    public static final String LDIF_CONFIG_FILE = "config.ldif";
    private static final String CONFIG_SUBDIR = "config";
    private static final Logger LOG = LoggerFactory.getLogger(LdifConfigExtractor.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile(".*config[/\\Q\\\\E]ou=config.*\\.ldif");

    public static void extract(File outputDirectory, boolean overwrite) throws IOException {
        File configDirectory;
        if (!outputDirectory.exists()) {
            LOG.debug("creating non existing output directory {}", (Object)outputDirectory.getAbsolutePath());
            if (!outputDirectory.mkdir()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{outputDirectory}));
            }
        }
        if (!(configDirectory = new File(outputDirectory, CONFIG_SUBDIR)).exists()) {
            LOG.debug("creating non existing config directory {}", (Object)configDirectory.getAbsolutePath());
            if (!configDirectory.mkdir()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{configDirectory}));
            }
        } else if (!overwrite) {
            throw new IOException(I18n.err((I18n)I18n.ERR_508, (Object[])new Object[]{configDirectory.getAbsolutePath()}));
        }
        LOG.debug("extracting the configuration to the directory at {}", (Object)configDirectory.getAbsolutePath());
        Map list = ResourceMap.getResources((Pattern)EXTRACT_PATTERN);
        for (Map.Entry entry : list.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) {
                LdifConfigExtractor.extractFromJar(outputDirectory, (String)entry.getKey());
                continue;
            }
            File resource = new File((String)entry.getKey());
            LdifConfigExtractor.copyFile(resource, LdifConfigExtractor.getDestinationFile(outputDirectory, resource));
        }
    }

    private static void copyFile(File source, File destination) throws IOException {
        String line;
        LOG.debug("copyFile(): source = {}, destination = {}", (Object)source, (Object)destination);
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{destination.getParentFile()}));
        }
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err((I18n)I18n.ERR_509, (Object[])new Object[]{source.getAbsolutePath()}));
        }
        FileWriter out = new FileWriter(destination);
        BufferedReader in = new BufferedReader(new FileReader(source));
        while (null != (line = in.readLine())) {
            out.write(line + "\n");
        }
        in.close();
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFromJar(File outputDirectory, String resource) throws IOException {
        byte[] buf = new byte[512];
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream((String)resource, (String)"LDIF file in config repository");
        try {
            File destination = new File(outputDirectory, resource);
            if (destination.exists()) {
                return;
            }
            if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{destination.getParentFile()}));
            }
            FileOutputStream out = new FileOutputStream(destination);
            try {
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static File getDestinationFile(File outputDirectory, File resource) {
        Stack<String> fileComponentStack = new Stack<String>();
        fileComponentStack.push(resource.getName());
        for (File parent = resource.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.getName().equals(CONFIG_SUBDIR)) {
                fileComponentStack.push(CONFIG_SUBDIR);
                return LdifConfigExtractor.assembleDestinationFile(outputDirectory, fileComponentStack);
            }
            fileComponentStack.push(parent.getName());
            if (!parent.equals(parent.getParentFile()) && parent.getParentFile() != null) continue;
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_510, (Object[])new Object[0]));
        }
        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_511, (Object[])new Object[0]));
    }

    private static File assembleDestinationFile(File outputDirectory, Stack<String> fileComponentStack) {
        File destinationFile = outputDirectory.getAbsoluteFile();
        while (!fileComponentStack.isEmpty()) {
            destinationFile = new File(destinationFile, fileComponentStack.pop());
        }
        return destinationFile;
    }

    public static String extractSingleFileConfig(File configDir, String file, boolean overwrite) {
        if (file == null) {
            file = LDIF_CONFIG_FILE;
        }
        File configFile = new File(configDir, file);
        if (!configDir.exists()) {
            LOG.debug("creating non existing config directory {}", (Object)configDir.getAbsolutePath());
            if (!configDir.mkdir()) {
                throw new RuntimeException(new IOException(I18n.err((I18n)I18n.ERR_112_COULD_NOT_CREATE_DIRECORY, (Object[])new Object[]{configDir})));
            }
        } else if (configFile.exists() && !overwrite) {
            LOG.warn("config file already exists, returning, cause overwrite flag was set to false");
            return configFile.getAbsolutePath();
        }
        try {
            int read;
            URL configUrl = LdifConfigExtractor.class.getClassLoader().getResource(file);
            LOG.debug("URL of the config ldif file {}", (Object)configUrl);
            InputStream in = configUrl.openStream();
            byte[] buf = new byte[0x100000];
            FileWriter fw = new FileWriter(configFile);
            while ((read = in.read(buf)) > 0) {
                String s = Strings.utf8ToString((byte[])buf, (int)0, (int)read);
                fw.write(s);
            }
            fw.close();
            in.close();
            LOG.info("successfully extracted the config file {}", (Object)configFile.getAbsoluteFile());
            return configFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

