/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.2";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.vimeo.com/";
	this.ID = "vimeo.com";
	this.caption = "Vimeo";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://vimeo.com/moogaloop/load/clip:%1/local?%2";
	const URL_GET_FLV = "http://vimeo.com/moogaloop/play/clip:%1/%2/%3/?q=sd";
	// init result
	var result = new VideoDefinition();
	// get videoId
	var videoId = getToken(url, ".com/", 1);
	// is a HD video?
	if (videoId.toString().indexOf("hd#") != -1)
	{
		videoId = getToken(url, "hd#", 1);
		result.extension = ".mp4";
	}
	// get the possible channel
	var channel_id = "";
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// has a channel id?
	if (html.toString().indexOf('id="channel_id"') != -1) 
		channel_id = copyBetween(html, 'id="channel_id" value="', '"');
	// found the channel id?
	var channel_params = channel_id != "" ? "context=channel&context_id=" + channel_id : "";
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, videoId, channel_params));
	// get video title
	result.title = copyBetween(xml, "<caption>", "</caption>");
	// get signature
	var signature = copyBetween(xml, "<request_signature>", "</request_signature>");
	// get signature expires
	var signature_expires = copyBetween(xml, "<request_signature_expires>", "</request_signature_expires>");
	// build the final flv url
	result.URL = strFormat(URL_GET_FLV, videoId, signature, signature_expires);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0xba,0x50,0x4c,0x54,0x45,0xf9,0xf9,0xfa,0xa1,0xdf,0xef,0x3d,
		0xbd,0xde,0x0d,0xad,0xd6,0x10,0xae,0xd6,0x40,0xbe,0xdf,0xaa,0xe2,0xf1,0xa4,0xe0,
		0xf0,0xb5,0xe6,0xf2,0x4c,0xc2,0xe1,0x29,0xb7,0xdb,0x3b,0xbc,0xde,0x2b,0xb7,0xdb,
		0x86,0xd6,0xea,0x77,0xd1,0xe8,0x1c,0xb2,0xd9,0x38,0xbb,0xdd,0x95,0xdb,0xed,0xff,
		0xff,0xff,0xf0,0xf9,0xfc,0x4a,0xc2,0xe0,0xa4,0xde,0xed,0x77,0xca,0xe0,0xb2,0xdd,
		0xe9,0xef,0xf4,0xf5,0xc1,0xdb,0xe3,0x49,0xbd,0xdb,0x83,0xb7,0xc6,0xd0,0xdd,0xe2,
		0x93,0xc8,0xd7,0x07,0x69,0x87,0x82,0xa7,0xb4,0xa1,0xc4,0xcf,0x0b,0x94,0xb9,0x09,
		0x7b,0x9d,0x35,0x7b,0x91,0xc1,0xdc,0xe4,0x0c,0xa7,0xcf,0xb2,0xd6,0xe0,0x45,0x93,
		0xaa,0x0b,0x9a,0xc0,0xe0,0xe8,0xeb,0xb0,0xc6,0xce,0xa1,0xbf,0xca,0xd1,0xeb,0xf2,
		0x17,0x72,0x8f,0x64,0xa5,0xb9,0x44,0x7c,0x8f,0x19,0x8f,0xb0,0x62,0x8e,0x9e,0x91,
		0xaf,0xba,0x0a,0x87,0xab,0x49,0xc1,0xe0,0x08,0x75,0x95,0x43,0x77,0x8a,0x15,0x5b,
		0x73,0x57,0xc6,0xe3,0xb2,0xe5,0xf2,0xbe,0xe9,0xf4,0xf0,0xef,0xf1,0x5a,0xc7,0xe3,
		0xc0,0xea,0xf4,0x66,0xd4,0x64,0xbf,0x00,0x00,0x00,0x9c,0x49,0x44,0x41,0x54,0x78,
		0xda,0x55,0xcf,0xd7,0x12,0x82,0x40,0x0c,0x05,0xd0,0x48,0x54,0x50,0x41,0xf4,0xda,
		0xb0,0xbb,0xea,0xda,0x1b,0x56,0x14,0xfd,0xff,0xdf,0x92,0x5d,0xca,0x0c,0xf7,0x21,
		0x99,0x7b,0x1e,0x32,0x13,0xa2,0x82,0xc1,0x69,0x8a,0xa5,0x32,0x91,0xc9,0xb9,0x58,
		0x64,0xe4,0xa1,0x42,0xd5,0x68,0xd6,0xec,0x68,0xd8,0x4e,0xdd,0x65,0x6e,0x28,0x68,
		0xa2,0x65,0x73,0x1b,0x40,0x47,0x83,0x6b,0x02,0xe8,0x72,0xcf,0x03,0xfa,0x1a,0x06,
		0xc3,0x11,0x30,0x76,0x27,0x53,0x60,0xa6,0x41,0xcc,0x17,0xc0,0x52,0xf2,0x0a,0x58,
		0x27,0x37,0x36,0x5b,0x40,0xdd,0xd8,0x89,0x04,0x78,0x0f,0x38,0x07,0x78,0x47,0x4e,
		0xe1,0x04,0x95,0xb3,0xcc,0xe0,0xa2,0xba,0x2f,0x38,0x03,0x79,0x85,0xe7,0xdf,0x38,
		0x86,0xbb,0x5a,0x8f,0xe7,0x2b,0xee,0x1c,0xd0,0x5b,0x6f,0x21,0x93,0x7f,0x3f,0x14,
		0x5a,0x81,0x91,0xe5,0xfb,0x0b,0xff,0x21,0xbe,0x0e,0x43,0x26,0xf9,0xad,0x43,0x00,
		0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
