/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://videolog.uol.com.br/";
	this.ID = "videolog.uol.com.br";
	this.caption = "Videolog (UOL)";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_XML = "http://videolog.uol.com.br/swfs/related/related-player-publicididade.php?id_video=%1";
	// init result
	var result = new VideoDefinition();
	// create http class
	var http = new Http();
	// get videoId
	var videoId = getUrlParam(url, "id");
	// download html
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, '<h1 class="titulo-video">', '</h1>');
	// download xml
	var xml = http.downloadWebpage(strFormat(URL_XML, videoId));
	// get video url
	result.URL = copyBetween(xml, "<video>", "</video>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0xae,0x50,0x4c,0x54,0x45,0x4d,0xc9,0xd2,0x57,0xcc,0xd5,0x58,
		0xcc,0xd5,0x62,0xcf,0xd7,0x63,0xd0,0xd8,0x64,0xd0,0xd7,0x6a,0xd2,0xd9,0x6f,0xd3,
		0xda,0x76,0xd5,0xdc,0x79,0xd6,0xdd,0x7a,0xd7,0xdd,0x7b,0xd7,0xdd,0x85,0xda,0xe0,
		0x87,0xdb,0xe0,0x88,0xdb,0xe1,0x8b,0xdb,0xe2,0x8c,0xdd,0xe2,0x8d,0xdc,0xe2,0x90,
		0xde,0xe3,0x92,0xde,0xe4,0x97,0xe0,0xe5,0x9a,0xe0,0xe5,0x9e,0xe2,0xe7,0xa1,0xe2,
		0xe7,0xa7,0xe4,0xe9,0xaa,0xe6,0xe9,0xaa,0xe6,0xea,0xaf,0xe6,0xeb,0xb1,0xe7,0xeb,
		0xb2,0xe7,0xeb,0xb3,0xe8,0xeb,0xb4,0xe9,0xec,0xb6,0xe9,0xed,0xb9,0xe9,0xed,0xb9,
		0xea,0xed,0xbc,0xeb,0xee,0xbd,0xeb,0xee,0xc7,0xee,0xf1,0xc8,0xee,0xf1,0xcc,0xef,
		0xf2,0xce,0xf0,0xf2,0xd3,0xf2,0xf4,0xd5,0xf2,0xf5,0xde,0xf5,0xf6,0xde,0xf5,0xf7,
		0xdf,0xf5,0xf7,0xdf,0xf6,0xf6,0xe8,0xf8,0xf9,0xe9,0xf8,0xf9,0xe9,0xf8,0xfa,0xea,
		0xf9,0xfa,0xeb,0xf9,0xfa,0xf0,0xfa,0xfb,0xf4,0xfc,0xfc,0xf5,0xfc,0xfc,0xf6,0xfc,
		0xfd,0xfc,0xfe,0xfe,0xff,0xff,0xff,0x30,0x2e,0xf3,0xd0,0x00,0x00,0x00,0x83,0x49,
		0x44,0x41,0x54,0x18,0x19,0x4d,0xc1,0x87,0x02,0x81,0x50,0x18,0x80,0xd1,0xaf,0x2b,
		0x91,0x99,0xbd,0xb3,0xb3,0x4a,0x46,0xb9,0xfe,0xf7,0x7f,0x31,0x24,0xea,0x1c,0x48,
		0xa9,0x6d,0x8d,0xbc,0x8a,0xa3,0x56,0xe4,0x34,0xcd,0xe9,0x80,0x4c,0xc1,0x9e,0xee,
		0xcb,0x40,0x97,0xaf,0xea,0xc2,0xeb,0x19,0x74,0x6e,0x76,0xcc,0x87,0x1a,0x6e,0x9c,
		0x16,0x5e,0xa8,0x76,0x45,0x99,0x03,0xa5,0x89,0xd9,0x1f,0x2f,0x4f,0x1c,0xdb,0x88,
		0x3c,0x81,0x75,0x7c,0x19,0xf9,0x9c,0x67,0x92,0x68,0x80,0xe1,0x5f,0x95,0x7f,0x90,
		0x94,0x06,0xee,0xf2,0x90,0x4c,0x03,0x2c,0xc9,0x8b,0x80,0x50,0x72,0x34,0x60,0xc9,
		0x5f,0x60,0xf1,0xa1,0x25,0xa1,0x5d,0x52,0x75,0x79,0x0b,0x2c,0x32,0x91,0x76,0xf9,
		0x79,0x01,0xb4,0x6a,0x19,0x56,0x70,0x86,0xd5,0x53,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
