/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.video.ca/";
	this.ID = "video.ca";
	this.caption = "Video.ca";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://www.video.ca/media/video/%1.flv";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>VIDEO.CA -", "</title>");
	// get the video id
	var videoID = getUrlParam(url, "id");
	// clear and get the final url
	result.URL = cleanUrl(strFormat(URL_GET_FLV, videoID));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0xad,0x49,0x44,0x41,0x54,0x78,0xda,0x95,0x93,0x4b,0x2b,0x84,
		0x51,0x18,0xc7,0xdf,0xe1,0xf5,0x4e,0x83,0x42,0xa8,0x71,0xff,0x04,0x56,0x6c,0x58,
		0x28,0x85,0x95,0x22,0x92,0xec,0x2c,0x5c,0x52,0xae,0x1b,0x2b,0x5b,0x9b,0xf9,0x04,
		0x16,0x4a,0x29,0x97,0x22,0xa5,0xd8,0x48,0xf8,0x00,0xee,0x1f,0x00,0x0b,0x8c,0x4b,
		0xb1,0x99,0x77,0xcc,0x30,0x7f,0x7f,0xcf,0x39,0xe7,0xd5,0xab,0x66,0xdc,0x16,0xff,
		0x7a,0x4e,0xcf,0xf3,0xfc,0x9e,0xcb,0x39,0xc7,0x22,0x89,0x5f,0x35,0x3d,0x09,0xc6,
		0x62,0x19,0x7d,0xdf,0x03,0x52,0x29,0x30,0x99,0x00,0xe7,0xe7,0x10,0xb3,0xca,0xc1,
		0xc7,0xc7,0x7f,0x02,0xce,0xcf,0x40,0xa7,0x48,0x92,0x03,0xa2,0x10,0xb8,0xb2,0xa4,
		0xa1,0xe9,0x80,0x9b,0x5b,0x30,0x12,0x01,0x4f,0x8f,0xc1,0xf1,0x51,0xa9,0xfa,0x6a,
		0x9c,0x9b,0x1b,0x92,0x58,0x00,0x37,0x68,0x29,0x69,0x9b,0x07,0xfb,0xe9,0x00,0x95,
		0x90,0xca,0xd1,0x01,0xa2,0x42,0xb0,0xb7,0x4b,0x2a,0xbd,0xc9,0xdc,0x13,0x72,0x0e,
		0x1a,0x80,0x6d,0x81,0x4e,0x36,0x18,0x8f,0x67,0x00,0x00,0x60,0x7d,0x2d,0x5c,0x2b,
		0xe0,0x55,0x92,0xc0,0xca,0x52,0xc4,0x43,0xa6,0xb2,0xc8,0x8c,0x30,0x33,0xed,0x27,
		0x0a,0xc8,0x07,0x3c,0x3f,0x83,0xc5,0x25,0x12,0xe4,0xc0,0xcd,0xf5,0x92,0xb2,0x45,
		0x8e,0x0f,0x50,0x70,0xb6,0x34,0x81,0xbb,0x3b,0x60,0x67,0x3b,0x18,0x2e,0x01,0x9f,
		0x9e,0xbe,0x2c,0xf1,0xe5,0x05,0x6c,0x6b,0xfd,0xec,0x22,0x4d,0x1a,0x6c,0xa9,0x4e,
		0xf2,0x44,0x36,0xdc,0x80,0x07,0xed,0xee,0xd0,0x00,0x73,0xc7,0x63,0xc3,0xba,0x0b,
		0x49,0xf8,0x5d,0x02,0x60,0x55,0x05,0x18,0x8d,0x7a,0x80,0xa9,0x11,0xbd,0x40,0x33,
		0xc2,0x8f,0x92,0xb8,0x5c,0x51,0x19,0x18,0x99,0xf5,0x46,0xb8,0x8b,0xaa,0x76,0x4c,
		0x75,0x5b,0xb5,0x66,0xab,0x56,0xcd,0x1e,0x6c,0x3f,0x51,0xed,0x24,0x21,0x67,0x6e,
		0xac,0x83,0x97,0x17,0xa0,0xeb,0x7a,0x80,0xab,0x4b,0x70,0x6b,0x1b,0x6c,0x6e,0x04,
		0x9d,0x20,0xd8,0xd3,0x01,0x2e,0xcc,0x83,0x35,0x61,0x39,0x67,0xa9,0x5b,0xf1,0x01,
		0x52,0x84,0x27,0x47,0xdf,0xbc,0xc4,0xd7,0x37,0x30,0x91,0xf4,0x9d,0x7d,0xdd,0x66,
		0x37,0x83,0xfd,0x02,0xc9,0x97,0xb9,0xcd,0x12,0xb9,0xb6,0xfa,0x87,0xa7,0x7c,0x7d,
		0xad,0x3e,0x90,0xb1,0xdf,0xdf,0xc1,0xa1,0x01,0xb0,0xaa,0x5a,0x3f,0x2c,0x1e,0x1f,
		0xfe,0x01,0xb0,0xbc,0x08,0xee,0xef,0x29,0xdb,0x87,0x00,0xe0,0xc3,0x3d,0x78,0x21,
		0x23,0x27,0x93,0xea,0x9c,0x11,0x60,0x1c,0x0d,0x75,0xfa,0x6d,0xfc,0xf8,0x53,0x3d,
		0xfb,0x03,0xa8,0xc8,0x1d,0x3c,0x0c,0x83,0x2a,0x03,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
