/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "BGDN.Net 2010";
	this.website = "http://www.vbox7.com/";
	this.ID = "vbox7.com";
	this.caption = "VBox7";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://vbox7.com/play/magare.do";
	const XML_PARAMS  = "onLoad=%5Btype%20Function%5D&vid=%1";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<span class=\"title\">", "</span></div>");
	// get the video ID
	var videoID = copyBetween(html, "var globalVideoMdkey = '", "';");
	// get the video xml
	var xml = http.downloadWebpagePost(URL_GET_XML, strFormat(XML_PARAMS, videoID));
	// get the host IP
	var hostIP = copyBetween(xml, "&videoFile=", "&");
	// get the FLV url
	//result.URL = strFormat("http://%1/%2/%3.flv", hostIP, strCopy(videoID, 0, 3), videoID);
	// add the referer header
	//result.headers = "Referer=" + url + "|Connection=keep-alive";
	// return the video information
	result.URL= hostIP;
	return result;

}

function getVideoServiceIcon()
{
	return new Array(
		0x00,0x00,0x01,0x00,0x01,0x00,0x10,0x10,0x00,0x00,0x01,0x00,0x20,0x00,0x68,0x04,
		0x00,0x00,0x16,0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x20,0x00,
		0x00,0x00,0x01,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x0b,
		0x00,0x00,0x13,0x0b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x4f,0x1d,0xd1,0xff,0x2f,0x04,0xb0,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,
		0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,
		0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,0xaf,0xff,0x2f,0x04,
		0xb0,0xff,0x2f,0x04,0xb0,0xff,0x4f,0x1d,0xd0,0xff,0x00,0x00,0x00,0x00,0x55,0x23,
		0xd5,0xff,0x33,0x05,0xb3,0xff,0x3b,0x06,0xca,0xff,0x3b,0x06,0xc9,0xff,0x3b,0x07,
		0xc9,0xff,0x50,0x21,0xcf,0xff,0xf6,0xf3,0xfd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0x65,0x3c,0xd4,0xff,0x3b,0x06,0xc9,0xff,0x3b,0x06,
		0xc9,0xff,0x3b,0x06,0xc9,0xff,0x33,0x05,0xb3,0xff,0x55,0x23,0xd5,0xff,0x38,0x06,
		0xb7,0xff,0x3f,0x07,0xcd,0xff,0x3f,0x08,0xce,0xff,0x3f,0x08,0xcd,0xff,0x3f,0x08,
		0xcd,0xff,0x3f,0x08,0xcd,0xff,0xa5,0x8b,0xe7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xcd,0xbf,0xf2,0xff,0x3f,0x08,0xcd,0xff,0x3f,0x08,
		0xcd,0xff,0x3f,0x08,0xce,0xff,0x3e,0x07,0xce,0xff,0x37,0x06,0xb7,0xff,0x3c,0x07,
		0xbb,0xff,0x45,0x08,0xd2,0xff,0x45,0x08,0xd2,0xff,0x45,0x08,0xd2,0xff,0x45,0x08,
		0xd2,0xff,0x45,0x08,0xd1,0xff,0x50,0x17,0xd5,0xff,0xf2,0xee,0xfc,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x77,0x4b,0xde,0xff,0x45,0x08,
		0xd2,0xff,0x45,0x08,0xd2,0xff,0x45,0x08,0xd2,0xff,0x3b,0x07,0xba,0xff,0x41,0x07,
		0xc0,0xff,0x4a,0x0a,0xd6,0xff,0x4a,0x0a,0xd7,0xff,0x4a,0x0a,0xd6,0xff,0x4a,0x0a,
		0xd6,0xff,0x4a,0x0a,0xd6,0xff,0x4a,0x0a,0xd6,0xff,0x9b,0x78,0xe8,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xdb,0xce,0xf7,0xff,0x4a,0x0a,
		0xd6,0xff,0x4a,0x0a,0xd6,0xff,0x4a,0x0a,0xd6,0xff,0x41,0x07,0xbf,0xff,0x45,0x08,
		0xc3,0xff,0x4f,0x0b,0xdb,0xff,0x50,0x0b,0xdb,0xff,0x50,0x0b,0xdb,0xff,0x50,0x0b,
		0xdb,0xff,0x50,0x0b,0xdb,0xff,0x50,0x0b,0xdc,0xff,0x54,0x11,0xdc,0xff,0xec,0xe5,
		0xfb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8c,0x5e,
		0xe7,0xff,0x50,0x0b,0xdb,0xff,0x50,0x0b,0xdc,0xff,0x45,0x08,0xc3,0xff,0x4a,0x09,
		0xc7,0xff,0x55,0x0c,0xdf,0xff,0x55,0x0c,0xdf,0xff,0x54,0x0c,0xe0,0xff,0x55,0x0c,
		0xdf,0xff,0x55,0x0c,0xe0,0xff,0x55,0x0c,0xe0,0xff,0x55,0x0c,0xdf,0xff,0x95,0x67,
		0xec,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe7,0xdd,
		0xfb,0xff,0x56,0x0f,0xdf,0xff,0x54,0x0c,0xe0,0xff,0x4a,0x09,0xc7,0xff,0x4e,0x0a,
		0xcb,0xff,0x5a,0x0d,0xe4,0xff,0x5a,0x0d,0xe4,0xff,0x5a,0x0d,0xe4,0xff,0x5a,0x0d,
		0xe4,0xff,0x5a,0x0d,0xe4,0xff,0x5a,0x0d,0xe4,0xff,0x5a,0x0d,0xe4,0xff,0x5c,0x10,
		0xe4,0xff,0xe2,0xd4,0xfa,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0x9c,0x6e,0xef,0xff,0x5a,0x0d,0xe4,0xff,0x4e,0x0a,0xca,0xff,0x51,0x0a,
		0xce,0xff,0x5d,0x0e,0xe8,0xff,0x5e,0x0e,0xe8,0xff,0x5d,0x0e,0xe8,0xff,0x5d,0x0e,
		0xe8,0xff,0x5e,0x0e,0xe8,0xff,0x5d,0x0e,0xe8,0xff,0x5e,0x0e,0xe8,0xff,0x5e,0x0e,
		0xe8,0xff,0x8f,0x58,0xef,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xee,0xe5,0xfd,0xff,0x64,0x17,0xe9,0xff,0x51,0x0a,0xce,0xff,0x55,0x0a,
		0xd2,0xff,0x61,0x0e,0xea,0xff,0x61,0x0e,0xeb,0xff,0x61,0x0e,0xeb,0xff,0x61,0x0e,
		0xeb,0xff,0x61,0x0e,0xeb,0xff,0x61,0x0e,0xeb,0xff,0x61,0x0e,0xeb,0xff,0x61,0x0e,
		0xeb,0xff,0x61,0x0e,0xeb,0xff,0xda,0xc6,0xfa,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xa9,0x7d,0xf4,0xff,0x55,0x0a,0xd2,0xff,0x57,0x0b,
		0xd3,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,
		0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,
		0xed,0xff,0x64,0x0f,0xed,0xff,0x88,0x47,0xf1,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xe9,0xdd,0xfc,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0xad,0x80,
		0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xed,0xe3,0xfd,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0xad,0x80,
		0xf5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
		0xff,0xff,0xff,0xff,0xff,0xff,0xed,0xe3,0xfd,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x63,0x0e,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x81,0x3c,
		0xf0,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,
		0xf4,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,0xf4,0xff,0xa2,0x6f,
		0xf4,0xff,0xa2,0x6f,0xf4,0xff,0x9a,0x63,0xf3,0xff,0x57,0x0b,0xd3,0xff,0x92,0x51,
		0xfb,0xff,0x57,0x0b,0xd3,0xff,0x64,0x0e,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,
		0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,
		0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,0xed,0xff,0x64,0x0f,
		0xed,0xff,0x64,0x0e,0xed,0xff,0x57,0x0b,0xd3,0xff,0x92,0x51,0xfb,0xff,0x00,0x00,
		0x00,0x00,0x92,0x51,0xfb,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,0xd3,0xff,0x57,0x0b,
		0xd3,0xff,0x57,0x0b,0xd3,0xff,0x92,0x51,0xfb,0xff,0x00,0x00,0x00,0x00,0x80,0x01,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x01,0x00,0x00);
}