/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://video.scientificblogging.com/";
	this.ID = "video.scientificblogging.com";
	this.caption = "Scientific Blogging";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_HOST = "http://video.scientificblogging.com";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>Scientific Blogging:", "</title>");
	// get video path
	var videoPath = copyBetween(html, "<video", "</video>");
	videoPath = copyBetween(videoPath, 'src="', '"');
	// build video url
	result.URL = URL_HOST + videoPath;
	// set video extension
	result.extension = ".mp4";
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x02,0x00,0x00,0x00,0x90,0x91,0x68,
		0x36,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,
		0x13,0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x02,0xfc,0x49,0x44,0x41,0x54,0x18,0x19,
		0x05,0xc1,0x7d,0x4c,0xcc,0x71,0x1c,0x07,0xf0,0xcf,0x92,0x50,0x2a,0x93,0xb4,0x66,
		0xa4,0x87,0xbb,0xae,0xf4,0x40,0xac,0x09,0x67,0x1e,0xb2,0x89,0xf9,0x43,0x1e,0x23,
		0x15,0x85,0x2b,0xcb,0x3a,0x4f,0xa5,0x2b,0xc6,0x85,0x1e,0xc9,0x43,0x21,0x16,0xe6,
		0x0f,0xcf,0xad,0x2c,0xf3,0x94,0xd8,0x8c,0x28,0xa2,0x58,0x5d,0x4d,0xa6,0xd1,0xb9,
		0x4b,0xa2,0xdc,0x5d,0x77,0xbf,0xef,0xef,0xfb,0x7d,0x7b,0xbd,0x08,0xe0,0x00,0x84,
		0x10,0x00,0xe7,0xc2,0x61,0xe8,0xe9,0xa8,0xbb,0x79,0x27,0x37,0x3f,0x63,0x9f,0x36,
		0xe5,0xce,0xad,0x73,0xad,0x1f,0x5b,0x00,0x30,0x30,0x80,0x09,0x00,0x82,0x11,0x00,
		0x01,0x70,0x88,0xbe,0xbe,0xef,0x3a,0xdd,0xc1,0x25,0x0b,0x16,0x6e,0x48,0x88,0x5d,
		0xaa,0x0e,0x0f,0x99,0x40,0xea,0x40,0xd7,0x05,0x4a,0x2a,0x3c,0x18,0xff,0xd3,0xd4,
		0x2d,0x09,0x40,0x60,0x04,0x8c,0x84,0x10,0x1c,0xe2,0xf1,0xd3,0x47,0x8d,0x8d,0x0d,
		0x65,0x65,0x25,0x2f,0xdb,0x9f,0xbf,0xc8,0xd6,0x6c,0x8e,0x0c,0x8a,0x5b,0x1c,0x7a,
		0xe9,0x8c,0xde,0x62,0xfd,0xd3,0xd1,0xfd,0xae,0xba,0x52,0xfb,0xbc,0xf1,0x16,0xb8,
		0x80,0x00,0x01,0xe8,0xef,0x37,0xcd,0x9b,0x1f,0xcd,0x98,0x63,0x4b,0xe2,0xa6,0xfd,
		0x7b,0x32,0x57,0x4d,0xf6,0x7a,0xf1,0xec,0x11,0x98,0xbd,0xbc,0x30,0x3f,0x24,0xc8,
		0xc5,0xcb,0x83,0x60,0x6c,0x89,0x0b,0x26,0xe3,0xef,0x1e,0x06,0x10,0xc0,0xcb,0x4f,
		0x97,0xa6,0x6c,0x4d,0xb4,0x59,0x87,0x4a,0x4b,0x8a,0x8e,0x15,0x17,0xe4,0xe6,0xe8,
		0x86,0x01,0xf3,0xdf,0x6f,0x33,0x42,0x26,0x64,0xa4,0x2c,0x4b,0xdd,0x1c,0xfe,0x64,
		0x8a,0x5f,0xb2,0x1b,0x1d,0xce,0x4b,0x07,0xec,0xd4,0xfc,0xb6,0x29,0x35,0x2d,0x29,
		0x4b,0x7b,0xe0,0x6b,0xaf,0x41,0x82,0x43,0x06,0x07,0x63,0x56,0x58,0x04,0x98,0xcd,
		0x6e,0x95,0xc1,0xdf,0xbe,0x79,0xad,0xdf,0xa3,0x99,0xed,0xef,0xb6,0x72,0xf1,0xf8,
		0xce,0x77,0x35,0x54,0x55,0x71,0xb9,0xea,0xca,0x05,0x26,0xa1,0xa2,0xe2,0xac,0xb1,
		0xb7,0xaf,0xff,0xef,0x80,0xee,0xf0,0xa1,0x98,0x45,0x31,0xd3,0x03,0x7c,0x34,0x39,
		0x99,0x2a,0xc5,0xb4,0xce,0xcf,0x1f,0xaa,0xab,0x2b,0x21,0xff,0x8a,0x53,0x7b,0xdd,
		0xbf,0xa6,0xa7,0x8d,0xdb,0x12,0x3a,0xdb,0xda,0x32,0x77,0x67,0x29,0x15,0xd3,0x07,
		0x7f,0x9b,0x0d,0x86,0x8e,0xc2,0xec,0xac,0x91,0xf3,0x45,0xf5,0xfe,0x33,0xa2,0x88,
		0x04,0x50,0xff,0xe0,0xde,0x28,0xa2,0x79,0x31,0xc1,0x80,0xa4,0x3f,0xb2,0x8f,0x92,
		0x13,0x76,0xe2,0xf5,0xc3,0x87,0xcb,0xd5,0x33,0x43,0x43,0x25,0x9b,0x15,0x82,0x25,
		0xad,0x5d,0x9e,0xe8,0x3e,0x36,0x70,0x8c,0xb3,0xab,0x13,0x01,0x52,0x43,0x43,0xbd,
		0xab,0x13,0x95,0x1c,0xd5,0x7d,0x31,0x7c,0x48,0xdb,0xb6,0x9e,0xca,0x2a,0x2b,0x4a,
		0x3c,0x3d,0x0b,0x88,0xac,0x92,0x45,0x93,0x9e,0xba,0x22,0x36,0xb6,0xae,0xe6,0x86,
		0xda,0xcf,0xcf,0x93,0x9c,0x20,0x73,0xef,0x49,0x9e,0x80,0xc4,0xed,0x96,0xfb,0x35,
		0xd7,0x23,0x54,0x13,0x2f,0x9c,0x2a,0xa6,0xa6,0x96,0x66,0x17,0xa2,0xf9,0x73,0x22,
		0x20,0x5b,0xbd,0xdd,0xc6,0xe5,0x67,0x67,0x9b,0x4d,0x46,0x19,0x8c,0x8d,0xd8,0x6a,
		0x6f,0xdf,0x8e,0x57,0xcf,0x4d,0x5b,0xbf,0xe6,0xec,0xe9,0x3c,0xad,0x76,0xd5,0xa6,
		0x0d,0xb1,0xed,0xad,0xef,0x49,0x06,0x12,0xd7,0xc6,0xcf,0x54,0x29,0xa4,0x91,0xe1,
		0x40,0x5f,0x1f,0x6f,0x1a,0xbd,0x68,0x4e,0xf4,0x4f,0xf3,0x8f,0xa8,0xb0,0x30,0x1f,
		0x37,0x77,0x1f,0x67,0x5a,0xbd,0x74,0x49,0x77,0x57,0xd3,0xf1,0x63,0x3b,0x6b,0xee,
		0x5e,0x81,0x00,0x09,0xc0,0xf4,0xa3,0x37,0x4c,0xa5,0xf8,0xf3,0xcb,0x14,0xaa,0x08,
		0x88,0x8e,0x8a,0xb4,0x5b,0x86,0xd2,0x93,0x93,0xc0,0xa4,0x1d,0x5b,0x93,0xdc,0x89,
		0x34,0x5b,0x12,0xda,0x3e,0xbd,0xca,0xcd,0xdd,0x3d,0x38,0x38,0x20,0x00,0x92,0x05,
		0x17,0x9c,0xd5,0xd5,0xde,0x3d,0x5f,0x79,0xa6,0xa7,0xab,0xe3,0xe4,0xa9,0x62,0x85,
		0xd2,0x7f,0x56,0xb0,0xd2,0x6b,0x94,0x73,0x4e,0xe6,0x2e,0xbb,0xd9,0x28,0xff,0x1b,
		0x38,0x51,0x94,0xd7,0xd6,0xde,0xcc,0x98,0x43,0x06,0x08,0x80,0x2c,0x38,0xc0,0x2d,
		0xff,0x86,0x0a,0xf4,0x47,0x22,0x02,0x02,0x54,0xd3,0xa6,0x46,0x2a,0x83,0x7d,0x47,
		0xbb,0x28,0x3d,0x3c,0xa2,0xc3,0x83,0x6a,0xef,0xdd,0x1c,0xb6,0x59,0x39,0x67,0x00,
		0x17,0x00,0x01,0x10,0x80,0x00,0x00,0x2e,0x33,0xc7,0xa7,0xd6,0x96,0xab,0x97,0x2f,
		0xee,0x4d,0xcf,0xd8,0xbe,0x6e,0x5d,0x55,0x69,0x51,0x67,0x6b,0x13,0x98,0x5d,0x06,
		0x00,0x00,0x5c,0x00,0xff,0x01,0xba,0xa2,0xd8,0xce,0x80,0x1d,0x85,0x13,0x00,0x00,
		0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
