/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.4a";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.keezmovies.com/";
	this.ID = "keezmovies.com";
	this.caption = "KeezMovies";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>", "</title>");
	result.title = strReplace(result.title, "- KeezMovies.com", "");
	// get the xml url
	var xmlUrl = copyBetween(html, ";video_url=", "&amp;postroll_url");
	// get url
	result.URL=cleanUrl(xmlUrl);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0xdb,0x50,0x4c,0x54,0x45,0xfe,0xfe,0xfe,0xff,0xff,0xff,0xf8,
		0xfb,0xfd,0xa2,0xd2,0xeb,0x5b,0xb0,0xdd,0x90,0xc9,0xe8,0xe3,0xf1,0xf9,0x23,0x95,
		0xd2,0x02,0x85,0xcb,0xba,0xdd,0xf0,0xc9,0xe4,0xf3,0x40,0xa3,0xd8,0xef,0xf7,0xfb,
		0xf6,0x95,0x95,0xf2,0x5e,0x5e,0xee,0x2f,0x2f,0xee,0x2a,0x2a,0xf0,0x43,0x43,0xf9,
		0xb1,0xb1,0x76,0xbd,0xe2,0x1d,0x92,0xd0,0xfb,0xfd,0xfd,0xab,0xd6,0xed,0x0b,0x89,
		0xcd,0xa5,0xd3,0xec,0xf3,0x66,0x66,0xee,0x2c,0x2c,0x64,0xb4,0xdf,0x87,0xc5,0xe6,
		0x2c,0x99,0xd3,0xd7,0xeb,0xf6,0xfa,0xca,0xca,0xf8,0xb1,0xb1,0xfb,0xd4,0xd4,0xf9,
		0xc2,0xc2,0x26,0x96,0xd2,0x5e,0xb1,0xde,0xf5,0xfa,0xfc,0xfb,0xdb,0xdb,0xe9,0xf4,
		0xfa,0x7f,0xc1,0xe4,0xfc,0xde,0xde,0xf6,0x98,0x98,0xef,0x34,0x34,0xf0,0x4a,0x4a,
		0x3d,0xa1,0xd7,0xf2,0x63,0x63,0xfd,0xed,0xed,0x8a,0xc6,0xe7,0x31,0x9c,0xd5,0x7c,
		0xbf,0xe4,0xfd,0xf7,0xf7,0xf2,0x59,0x59,0xfa,0xcf,0xcf,0x67,0xb5,0xdf,0x2e,0x9a,
		0xd4,0xef,0x36,0x36,0xf8,0xa9,0xa9,0x49,0xa7,0xd9,0xb4,0xda,0xef,0xfc,0xe3,0xe3,
		0xfd,0xf2,0xf2,0x29,0x98,0xd3,0x4c,0xa9,0xda,0xf3,0x72,0x72,0x14,0x8e,0xcf,0xc6,
		0xe3,0xf3,0xda,0xed,0xf7,0x08,0x88,0xcc,0xb7,0xdc,0xf0,0xf9,0xb6,0xb6,0xf8,0xae,
		0xae,0xfb,0xd6,0xd6,0x90,0x63,0x86,0x36,0x00,0x00,0x00,0xa6,0x49,0x44,0x41,0x54,
		0x78,0xda,0x5d,0xcd,0x45,0x16,0x02,0x41,0x14,0x43,0xd1,0x14,0x1a,0xbc,0x80,0xc6,
		0x1a,0x77,0x77,0x77,0x97,0xfd,0xaf,0x88,0x5f,0x3d,0xe2,0xf0,0x86,0x77,0x90,0xe0,
		0x27,0x65,0xc2,0xbf,0x00,0x2e,0xb7,0xc7,0xfb,0x23,0xf0,0xf9,0xc9,0x00,0x82,0xa1,
		0x70,0x24,0x1a,0xd3,0xf1,0x84,0x02,0x92,0xb4,0x52,0xe9,0x0c,0xb3,0x39,0x2d,0xd9,
		0x02,0x79,0xe6,0x0b,0x64,0xb1,0x54,0xae,0x54,0x6b,0xb6,0x16,0xa8,0xd3,0x22,0x1b,
		0x4d,0x48,0x2d,0x03,0x6d,0x4a,0x1d,0x48,0xdd,0x5e,0x5f,0x0f,0x14,0x02,0x06,0x86,
		0x29,0x60,0x20,0x13,0xa3,0xb1,0xc2,0x84,0x99,0x29,0x39,0xc3,0xdc,0xd6,0x8b,0x25,
		0xa0,0xb0,0xe2,0xda,0x67,0xc9,0xf3,0x32,0xb6,0xd9,0xc2,0xc0,0x8e,0x53,0xec,0xc9,
		0x3a,0x0e,0xdb,0xa3,0x03,0x27,0x9e,0x80,0x33,0x87,0x72,0x79,0x71,0xe0,0xda,0xb8,
		0x01,0xf7,0xc7,0xf3,0xa5,0xf5,0xdb,0x81,0x26,0x4c,0x82,0x9f,0x31,0x1c,0xf8,0x4b,
		0x7d,0x01,0x98,0xc7,0x0f,0x50,0x64,0xb8,0xea,0xdd,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
