/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.godofhumor.com/";
	this.ID = "godofhumor.com";
	this.caption = "GodOfHumor";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://media.godofhumor.com/videos/%1.flv";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get the video title
	result.title = copyBetween(html, "<title>", "- Videos from The GodOfHumor</title>");
	// get the video url
	result.URL = copyBetween(url, ".com/", ".html");
	result.URL = strFormat(URL_GET_FLV, result.URL);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x45,0x50,0x4c,0x54,0x45,0x45,0x60,0x7d,0x3c,0x54,0x6d,0x34,
		0x48,0x5e,0x20,0x1a,0x00,0x40,0x33,0x00,0x3f,0x58,0x72,0x23,0x30,0x3f,0x7f,0x66,
		0x00,0xff,0xcc,0x00,0x1c,0x28,0x33,0xbf,0x99,0x00,0x9f,0x7f,0x00,0x00,0x00,0x00,
		0x11,0x18,0x1f,0x41,0x5a,0x75,0x10,0x0d,0x00,0xcf,0xa6,0x00,0x2b,0x3c,0x4e,0x60,
		0x4d,0x00,0x70,0x5a,0x00,0xef,0xbf,0x00,0x30,0x26,0x00,0x2e,0x40,0x53,0x55,0xba,
		0xc3,0x11,0x00,0x00,0x00,0x6b,0x49,0x44,0x41,0x54,0x78,0xda,0x6d,0xcd,0x57,0x12,
		0x80,0x20,0x0c,0x45,0x51,0x4a,0xa4,0x44,0x40,0xac,0xfb,0x5f,0xaa,0xc6,0x87,0xcc,
		0x30,0xe3,0xf9,0xcb,0x0d,0x45,0xfd,0xd3,0x06,0xf4,0x37,0x5b,0x02,0x8b,0x32,0x39,
		0x1f,0xc0,0x3b,0x25,0xa2,0xe7,0x30,0x7b,0x41,0x46,0xf6,0x31,0x3d,0x3b,0x72,0x42,
		0x66,0x25,0xe7,0x39,0x45,0x3d,0x86,0xac,0x2d,0xae,0xf4,0x60,0x08,0x8f,0xf6,0x50,
		0x16,0xaa,0x2d,0xac,0x1b,0x87,0x4a,0x4b,0xc9,0x8c,0xf0,0x94,0xf7,0x97,0xdc,0x82,
		0x88,0xb4,0x87,0xca,0x7c,0x20,0x08,0x73,0x32,0x6c,0xab,0x82,0x2b,0x03,0xe6,0xd1,
		0x0d,0x66,0xc1,0x05,0x65,0x87,0x21,0x24,0xd9,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,
		0x44,0xae,0x42,0x60,0x82);
}
