/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.gametrailers.com/";
	this.ID = "gametrailers.com";
	this.caption = "GameTrailers";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://films.cinemavip.com/contenidos/cinemavip/%1";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "class=\"GameTitle\">", "</a>");
	// get flv url
	result.URL = copyBetween(html, "<span class=\"Downloads\">", "</span>");
	result.URL = copyBetween(result.URL, "href=\"", "\"");
	result.URL = strReplace(result.URL, ".mov", ".wmv");
	// clear and get the final url
	result.URL = cleanUrl(result.URL);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x54,0x50,0x4c,0x54,0x45,0x00,0x19,0x50,0x00,0x32,0x50,0x00,
		0x4a,0x73,0x00,0x62,0x96,0x00,0x7a,0xb9,0x1a,0x1a,0x1a,0x26,0x26,0x26,0x32,0x32,
		0x32,0x3e,0x3e,0x3e,0x48,0x73,0xff,0x4a,0x4a,0x4a,0x56,0x56,0x56,0x62,0x62,0x62,
		0x6b,0x8f,0xff,0x6e,0x6e,0x6e,0x7a,0x7a,0x7a,0x80,0x80,0x80,0x86,0x86,0x86,0x92,
		0x92,0x92,0xa0,0xa0,0xa4,0xaa,0xaa,0xaa,0xb6,0xb6,0xb6,0xc0,0xc0,0xc0,0xc2,0xc2,
		0xc2,0xce,0xce,0xce,0xda,0xda,0xda,0xf2,0xf2,0xf2,0xff,0xff,0xff,0x2f,0x9c,0x77,
		0x75,0x00,0x00,0x00,0x8d,0x49,0x44,0x41,0x54,0x18,0x19,0x05,0xc1,0xd1,0x4a,0xc3,
		0x40,0x14,0x05,0xc0,0x39,0x9b,0x6d,0x42,0x85,0x2a,0xda,0xff,0xff,0xc3,0x40,0x1e,
		0x2a,0x08,0x4d,0x76,0xaf,0x33,0x69,0x00,0x80,0x2e,0xab,0xf3,0x33,0xf0,0xbe,0xde,
		0x6a,0x49,0xc6,0xc7,0xd6,0x97,0xbe,0x44,0x9c,0x2c,0xd9,0xb6,0xac,0x4b,0x48,0xcb,
		0xec,0x19,0x9d,0xdc,0xcc,0xa0,0xdc,0x4e,0xba,0x75,0xbc,0x00,0x50,0x5d,0xad,0x5f,
		0x00,0xec,0xba,0xf1,0x70,0x80,0x6f,0x3b,0xd5,0x85,0xf9,0xe4,0x08,0x45,0x9a,0x9a,
		0xb3,0x8e,0x39,0x67,0xcd,0xc9,0xa5,0x1b,0xc7,0xcf,0x93,0x9d,0xa8,0x44,0x5a,0x7a,
		0x15,0x42,0xb9,0x1e,0xbf,0x69,0x31,0x37,0xb4,0xd4,0x9c,0x57,0x2a,0xad,0xdd,0xdb,
		0x99,0x34,0xc6,0xe8,0xfd,0x55,0x69,0xb1,0xba,0x8d,0xbf,0xf5,0x2d,0x94,0x34,0x00,
		0xc0,0x3f,0x64,0x3c,0x3c,0x39,0x44,0x12,0xd2,0x80,0x00,0x00,0x00,0x00,0x49,0x45,
		0x4e,0x44,0xae,0x42,0x60,0x82);
}
