/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://dumpalink.com/";
	this.ID = "dumpalink.com";
	this.caption = "Dumpalink";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://dumpalink.com/%1";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video xml ID
	var xml_id = cleanUrl(copyBetween(html, "'flashvars', 'xml=", "'"));
	// download xml
	var xml = http.downloadWebpage(strFormat(URL_GET_FLV, xml_id));
	// get video information
	result.title = copyBetween(xml, "<title><![CDATA[", "]");
	result.URL = copyBetween(xml, "<flv8>", "</flv8>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0xb1,0x50,0x4c,0x54,0x45,0x00,0x1f,0x3e,0x10,0x2d,0x41,0x40,
		0x57,0x48,0x18,0x39,0x36,0x61,0x85,0x20,0x28,0x4a,0x31,0xbf,0xc7,0x5c,0xef,0xf1,
		0x63,0xcf,0xd5,0x5e,0x28,0x44,0x40,0x79,0x9e,0x19,0x41,0x63,0x2a,0x30,0x49,0x46,
		0xff,0xff,0x66,0x60,0x73,0x4d,0x08,0x28,0x3b,0x9f,0xab,0x57,0xdf,0xe3,0x61,0x71,
		0x96,0x1b,0x81,0xa7,0x16,0x10,0x30,0x39,0x16,0x6b,0x7c,0x33,0xcc,0xcc,0x0a,0x40,
		0x59,0x50,0x74,0x25,0x59,0x7c,0x23,0x10,0x55,0x6b,0x9f,0x6b,0x17,0x8f,0x9d,0x54,
		0x20,0x3b,0x43,0x39,0x5b,0x2c,0x13,0x60,0x73,0x23,0x96,0x9f,0x06,0x35,0x50,0x70,
		0x55,0x23,0xaf,0x73,0x13,0x10,0x27,0x3a,0xef,0x91,0x04,0x80,0x8f,0x52,0x26,0xa1,
		0xa8,0x2a,0x4f,0x51,0xff,0x99,0x00,0x40,0x3e,0x2e,0xcf,0x82,0x0c,0x50,0x65,0x4b,
		0x2d,0xb6,0xba,0xaf,0xb9,0x59,0x20,0x41,0x34,0x20,0x8b,0x97,0x29,0xab,0xb1,0xdf,
		0x8a,0x08,0x70,0x81,0x50,0x30,0xc1,0xc3,0xbf,0x7a,0x10,0x20,0x2e,0x36,0x48,0x6b,
		0x28,0x03,0x2a,0x47,0x80,0x5c,0x1f,0x30,0x36,0x32,0xd9,0x68,0xc6,0x85,0x00,0x00,
		0x00,0xa4,0x49,0x44,0x41,0x54,0x18,0x19,0x05,0xc1,0x89,0x42,0xc1,0x00,0x00,0x00,
		0xd0,0xb7,0x1c,0xab,0x5d,0xcc,0x86,0x58,0x8e,0xca,0xd4,0x28,0x89,0x2c,0xfa,0xff,
		0x0f,0xeb,0x3d,0x10,0xdc,0x05,0x3a,0xdd,0x1e,0x00,0xfd,0xf0,0xfe,0x21,0xea,0xc6,
		0x00,0x92,0x34,0x13,0x47,0x03,0x00,0x86,0x39,0xa3,0x18,0x80,0x20,0xcc,0xf4,0x8a,
		0x72,0x3c,0x99,0x02,0xb2,0x34,0xf0,0x38,0x33,0x9e,0x43,0x45,0x96,0x87,0x4f,0x8b,
		0x68,0xb9,0x5a,0x3f,0xbf,0xbc,0xda,0xd4,0x24,0xe9,0x36,0xe9,0x14,0xe5,0xdb,0xe4,
		0xbd,0x6a,0x76,0xfb,0x8a,0x8f,0x34,0xb0,0x8c,0xcc,0x3f,0xa9,0x9b,0x0a,0xc3,0x03,
		0xb3,0xd1,0xd7,0xf1,0xdb,0xe6,0x74,0x82,0xfc,0xcc,0x28,0x1a,0xfc,0x1c,0x37,0xfb,
		0x4b,0xd3,0xb2,0x48,0x13,0x8a,0xdf,0xd5,0xe4,0x7a,0xd9,0x3b,0xd5,0xad,0x73,0x88,
		0x72,0x70,0x9d,0xee,0xea,0x56,0xdb,0x72,0xe8,0x03,0x6e,0x15,0x90,0x6f,0x01,0x7f,
		0x37,0x60,0x9b,0x01,0x00,0xff,0x32,0x01,0x0e,0x15,0x40,0x6c,0xd9,0x31,0x00,0x00,
		0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
