/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.collegehumor.com/";
	this.ID = "collegehumor.com";
	this.caption = "CollageHumor";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://www.collegehumor.com/moogaloop/video:%1";
	// init result
	var result = new VideoDefinition();
	// get video Id
	var videoId = getToken(url, "video:", 1);
	// download xml
	var http = new Http();
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, videoId));
	// get video information
	result.title = copyBetween(xml, "<caption>", "</caption>");
	result.URL = copyBetween(xml, "<file>", "</file>");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x02,0x00,0x00,0x00,0x90,0x91,0x68,
		0x36,0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,
		0x13,0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x01,0xf4,0x49,0x44,0x41,0x54,0x28,0x53,
		0x63,0x90,0x97,0x93,0xc1,0x83,0xe4,0x64,0xa5,0x1d,0x1d,0xec,0x66,0x4e,0x9f,0x76,
		0xe1,0xfc,0xb9,0xee,0xae,0x4e,0x63,0x43,0x7d,0x06,0xfc,0x1a,0xe0,0x48,0x55,0x45,
		0xa9,0xb0,0x20,0xef,0xf8,0xd1,0xa3,0x0c,0x72,0xb2,0x32,0xf2,0xb2,0xd2,0xea,0x2a,
		0x0a,0xf2,0xb2,0x32,0xfa,0x7a,0x3a,0x2a,0xca,0x8a,0x40,0x06,0x1e,0x0b,0x19,0x14,
		0xe4,0x64,0x16,0x75,0xe5,0xf7,0x56,0x26,0x01,0xd5,0xc5,0xc6,0x44,0xbd,0x7c,0xf9,
		0x72,0xe9,0x92,0xc5,0xe6,0xa6,0xc6,0xb8,0xf4,0x30,0x4c,0xac,0x49,0xfe,0x78,0x66,
		0xd1,0xf3,0x23,0x73,0x4c,0xf4,0x34,0xe4,0xe5,0xa4,0xf7,0xee,0xdd,0xfd,0xf9,0xf3,
		0xe7,0xac,0xcc,0x74,0xa0,0x61,0x60,0x23,0x31,0x34,0xbc,0x3f,0xbd,0x10,0xa8,0x01,
		0x88,0x36,0xcd,0xa8,0x04,0x2a,0x32,0x36,0x34,0xb8,0x71,0xfd,0xfa,0xa1,0x83,0x07,
		0x2c,0xcd,0xcd,0x2c,0xcc,0x4d,0xbb,0x3a,0xdb,0x81,0x9e,0x96,0x07,0x6b,0x86,0x6a,
		0x80,0xa8,0x86,0xa0,0xae,0xf2,0x04,0xa0,0xc3,0x4c,0x8d,0x0d,0xf7,0xed,0xdb,0x03,
		0xb4,0xe7,0xf3,0xa7,0x4f,0x40,0xe2,0xed,0xdb,0xb7,0xd6,0x96,0xe6,0x08,0x0d,0xd7,
		0xb6,0x4e,0x78,0x71,0x64,0x36,0x5c,0xcf,0xcc,0xe6,0x0c,0x65,0x45,0x39,0xa0,0xb6,
		0xd0,0xe0,0xe0,0x29,0x93,0x27,0xcd,0x9d,0x33,0x2b,0x31,0x21,0x5e,0x4e,0x06,0xc9,
		0x86,0x49,0xb5,0x29,0x7a,0x5a,0x6a,0xb3,0x5b,0xb2,0xde,0x9f,0x5a,0x00,0xd1,0x73,
		0x6a,0x4d,0x47,0xb4,0xbf,0x93,0x02,0x38,0x4c,0x60,0xde,0x90,0x2e,0x4c,0x0a,0xa8,
		0xc9,0x8e,0x00,0x85,0xd2,0x92,0xde,0x22,0x20,0x05,0x44,0x76,0xe6,0xfa,0x53,0x1b,
		0xd2,0xef,0xef,0x9d,0x06,0xd1,0x76,0x7f,0xef,0xf4,0xed,0x73,0x6a,0xe6,0x77,0xe6,
		0x2d,0xee,0xce,0xbf,0xbe,0x7d,0x22,0x44,0x30,0x3f,0xc1,0x8f,0xe1,0xe2,0xa6,0x5e,
		0xb0,0x06,0x19,0x30,0x92,0x56,0x56,0x90,0x8b,0x0d,0x70,0x9a,0xdd,0x9a,0x7d,0x7e,
		0x43,0xcf,0xeb,0xe3,0xf3,0x90,0x7d,0x08,0x44,0xaf,0x8e,0xcd,0x05,0x79,0x7a,0x76,
		0x6b,0x56,0x49,0x72,0x20,0x50,0xb5,0x8a,0x92,0x42,0x41,0xa2,0x7f,0x51,0x72,0x40,
		0x7d,0x7e,0x54,0x7b,0x49,0xec,0xdc,0xb6,0x9c,0x97,0xc7,0xe6,0xbe,0x3b,0xb9,0x00,
		0x59,0x0f,0x34,0x94,0x80,0x81,0x6b,0x6d,0xaa,0x0b,0x0c,0xbe,0x85,0x5d,0x79,0x68,
		0xa6,0xae,0x9f,0x5a,0x1e,0x1f,0xe4,0x72,0x7b,0xe7,0x64,0x14,0x0d,0x40,0x34,0xa3,
		0x29,0x03,0x6c,0x89,0xfc,0x86,0x69,0x15,0xc8,0x1a,0xe6,0x75,0xe4,0x01,0xc5,0xb5,
		0xd4,0x95,0xe7,0x77,0xe4,0x02,0xcd,0x45,0x68,0x78,0x71,0x64,0x8e,0xbe,0x96,0x1a,
		0x30,0x40,0x81,0x89,0x69,0x42,0x75,0xf2,0x07,0x58,0x84,0xde,0xde,0x3d,0xb5,0x34,
		0x35,0x48,0x4f,0x4b,0x55,0x4e,0x56,0xca,0xc7,0xd9,0x92,0xe1,0xd8,0x8a,0x36,0xb8,
		0x9e,0xfe,0xea,0x64,0xa0,0x06,0x7b,0x5b,0x6b,0x4d,0x0d,0xf5,0xf8,0x60,0x97,0x3b,
		0xbb,0xa7,0xc0,0xa5,0xde,0x9c,0x98,0x0f,0xb4,0xc1,0xdc,0x50,0x0b,0x00,0xbd,0xa1,
		0x46,0x0e,0xd4,0x05,0xb0,0xf7,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,
		0x60,0x82);
}
