/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.clip4e.com/";
	this.ID = "clip4e.com";
	this.caption = "Clip4e";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_XML = "http://clip4e.com/getflv.php?id=%1";
	const URL_CONFIRM = "http://clip4e.com/%1";
	const URL_GET_FLV = "%1?file=%1&start=0";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// check if we are into "adult confirmation"
	if (strIndexOf(html, "adult_confirm.php") != -1)
	{
		// get the ID and confirm ;)
		var confirm = copyBetween(html, "document.location.href='", "'");
		html = http.downloadWebpage(strFormat(URL_CONFIRM, confirm));
	}
	// get video title
	result.title = copyBetween(html, "<TITLE>", "</TITLE>");
	// get the video ID
	var videoID = copyBetween(html, "\"cl_id\", \"", "\"");
	// get the xml
	var xml = http.downloadWebpage(strFormat(URL_GET_XML, videoID));
	// get flv url
	result.URL = cleanUrl(copyBetween(xml, "<url>", "</url>"));
	// return the video information
	result.URL = strFormat(URL_GET_FLV, result.URL);
	// build the final url
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x60,0x50,0x4c,0x54,0x45,0x00,0x00,0x00,0x00,0x00,0x00,0x27,
		0x27,0x27,0x53,0x53,0x53,0x74,0x74,0x74,0x93,0x93,0x93,0xa4,0xa4,0xa4,0xac,0xad,
		0xb1,0xad,0xad,0xad,0xad,0xb3,0xbc,0xb7,0xbb,0xc3,0xbf,0xc4,0xca,0xd9,0xd8,0xd7,
		0xe3,0xe2,0xe0,0xf1,0xeb,0xe2,0xf7,0xe8,0xd2,0xfa,0xf2,0xe7,0xfb,0xec,0xd5,0xfb,
		0xee,0xdb,0xfb,0xf7,0xf3,0xfc,0xe7,0xc8,0xfc,0xfa,0xf7,0xfd,0xda,0xa9,0xfe,0xcd,
		0x87,0xfe,0xd4,0x98,0xfe,0xfe,0xfd,0xff,0xac,0x34,0xff,0xb3,0x46,0xff,0xb9,0x54,
		0xff,0xbf,0x62,0xff,0xc2,0x69,0xff,0xc8,0x79,0xa3,0xd8,0xfb,0x8a,0x00,0x00,0x00,
		0x01,0x74,0x52,0x4e,0x53,0x00,0x40,0xe6,0xd8,0x66,0x00,0x00,0x00,0xa3,0x49,0x44,
		0x41,0x54,0x78,0xda,0x45,0x8f,0x49,0x12,0xc3,0x20,0x0c,0x04,0x01,0x87,0x88,0xdd,
		0x38,0x5e,0xd8,0xed,0xff,0xff,0x32,0xa2,0xa0,0x92,0xbe,0x4d,0xab,0x34,0x02,0x32,
		0x89,0x35,0xe7,0x4a,0x7e,0x84,0x5c,0xe3,0x71,0x84,0x9c,0x67,0x2e,0x65,0x3b,0x9d,
		0xb5,0x7b,0xba,0x87,0xc9,0x21,0x59,0x05,0x00,0xd2,0xa4,0x12,0xfb,0x3c,0x9e,0x1a,
		0x44,0x07,0xec,0x51,0x70,0xbf,0x26,0x2d,0x26,0x7a,0x47,0x91,0xbd,0xe1,0x6c,0x79,
		0xbd,0xbb,0x90,0xbe,0x92,0xd8,0x76,0x29,0x16,0x4a,0x29,0x4a,0x2e,0x7d,0x23,0xed,
		0xb2,0x58,0xc0,0x28,0xb2,0xbc,0xf5,0xfa,0x90,0xf2,0x31,0x43,0x30,0x8e,0xa5,0x01,
		0x6f,0x6c,0x28,0x00,0xc7,0x58,0xa1,0xd6,0x9b,0x90,0x7a,0x39,0x10,0x9c,0xf5,0x4e,
		0xe9,0x30,0x93,0x58,0x92,0x86,0x1e,0x41,0xb9,0x30,0xde,0x19,0x93,0x91,0x52,0x2a,
		0x83,0x85,0x83,0xfc,0x78,0xef,0xdc,0x1a,0xdb,0xff,0xaf,0xb5,0x3d,0x21,0xcc,0xf0,
		0x05,0x1f,0x04,0x0b,0x29,0x6f,0x60,0x81,0x1d,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,
		0x44,0xae,0x42,0x60,0x82);
}
