/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.ceknito.sk/";
	this.ID = "ceknito.sk";
	this.caption = "Ceknito";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "http://ceknito.sk/d/vf/%1.flv";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// Get the video title
	result.title = copyBetween(html, "<title>", "-");
	// get the flv url
	var fid = copyBetween(html, "fid=", "&");
	// clear and get the final url
	result.URL = cleanUrl(strFormat(URL_GET_FLV, fid));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x01,0xcb,0x49,0x44,0x41,0x54,0x78,0xda,0x9d,0x93,0xcf,0x8b,0xa9,
		0x61,0x14,0xc7,0xe5,0x0f,0xb0,0xb5,0x64,0x46,0x99,0xbb,0x92,0x94,0x58,0x28,0x3f,
		0x13,0x56,0x72,0xef,0x24,0x94,0x92,0x8d,0x05,0x51,0x58,0x28,0x51,0x56,0xac,0xc5,
		0x82,0x85,0xb2,0x24,0x0b,0x0b,0x12,0x4b,0x49,0x28,0x0b,0xa5,0x6c,0x24,0xbf,0x57,
		0xc4,0x52,0xa9,0xef,0xf4,0x9c,0x32,0xb7,0xb9,0x33,0x0d,0x77,0xbe,0x9b,0xf7,0x7d,
		0xde,0xf7,0x7c,0x3f,0x9d,0x73,0x9e,0x73,0x38,0xdf,0xa9,0x5e,0xaf,0xa3,0xdf,0xef,
		0x63,0x32,0x99,0x80,0xf3,0x3f,0x9a,0x4e,0xa7,0x38,0x9f,0xcf,0x60,0x5a,0x2c,0x16,
		0xc8,0x64,0x32,0x18,0x0c,0x06,0x8f,0x41,0x98,0xd1,0xe3,0xf1,0xa0,0x54,0x2a,0x11,
		0xe0,0x7a,0xbd,0x22,0x1c,0x0e,0x63,0xbf,0xdf,0xe3,0x72,0xb9,0xdc,0x87,0x98,0x4c,
		0x26,0xc4,0xe3,0x71,0xac,0xd7,0x6b,0xa4,0xd3,0x69,0x82,0xac,0x56,0x2b,0x54,0x2a,
		0x15,0x3a,0x7f,0x6b,0x36,0x18,0x0c,0xf0,0xf9,0x7c,0xf0,0xfb,0xfd,0xd0,0xe9,0x74,
		0x94,0xfa,0x68,0x34,0x22,0x88,0xd3,0xe9,0xc4,0x78,0x3c,0xc6,0x66,0xb3,0xf9,0x1a,
		0xa2,0xd1,0x68,0x60,0xb7,0xdb,0xe1,0x72,0xb9,0x28,0xd8,0x66,0xb3,0x21,0x16,0x8b,
		0x21,0x91,0x48,0xa0,0x5c,0x2e,0x13,0xa4,0xdd,0x6e,0x43,0xaf,0xd7,0xc3,0x6c,0x36,
		0x7f,0x84,0xa8,0x54,0x2a,0x18,0x8d,0x46,0x68,0xb5,0x5a,0x0c,0x87,0x43,0xdc,0x64,
		0xb5,0x5a,0x21,0x95,0x4a,0xd1,0xe9,0x74,0x70,0x38,0x1c,0x90,0xcb,0xe5,0x70,0x3c,
		0x1e,0x21,0x97,0xcb,0x11,0x08,0x04,0xfe,0x42,0x84,0x42,0x21,0x05,0x4a,0x24,0x12,
		0x32,0x56,0xab,0x55,0x28,0x14,0x0a,0xea,0x85,0xc3,0xe1,0x80,0x4c,0x26,0xa3,0xec,
		0x98,0x6a,0xb5,0x1a,0xa2,0xd1,0x28,0xc4,0x2f,0xbf,0x3e,0x66,0x21,0x12,0x89,0xd8,
		0x07,0x34,0x1a,0x0d,0xa4,0x52,0x29,0x6c,0xb7,0x5b,0x32,0x9c,0x4e,0x27,0xf0,0x78,
		0x3c,0x78,0xbd,0x5e,0x04,0x83,0x41,0x14,0x8b,0x45,0x30,0x3d,0x3d,0x3d,0xe3,0xcf,
		0xeb,0xef,0x4f,0xa5,0x10,0x84,0xcf,0xe7,0x83,0x89,0x9d,0xd5,0x6a,0x35,0xd8,0x40,
		0x29,0x95,0x4a,0x6a,0x6c,0xb7,0xdb,0x45,0x28,0x14,0xc2,0x6c,0x36,0xa3,0xd8,0x4f,
		0xcd,0x74,0xbb,0xdd,0xf4,0x23,0x9f,0xcf,0x53,0x5f,0x98,0x76,0xbb,0x1d,0xe6,0xf3,
		0x39,0xb8,0x5c,0x2e,0x95,0x59,0x28,0x14,0x90,0x4c,0x26,0x11,0x89,0x44,0xbe,0xbe,
		0x91,0x6c,0x36,0x7b,0xa3,0x33,0xff,0xed,0x9d,0x95,0x42,0x4f,0x8b,0xc5,0x72,0x7f,
		0xa0,0x7a,0xbd,0x1e,0x0b,0xa2,0xa9,0x14,0x08,0x04,0xef,0x90,0x66,0xb3,0xf9,0xf8,
		0x5e,0x2c,0x97,0xcb,0x77,0xa3,0x58,0x2c,0x06,0xe7,0x27,0x6a,0xb5,0x5a,0x34,0x54,
		0x3f,0x32,0xb3,0xc6,0xb1,0x2d,0x64,0x1b,0xc9,0xa6,0x90,0x5d,0xe9,0xbf,0x31,0x6f,
		0x65,0x6a,0x63,0xf7,0x64,0x30,0x89,0x1b,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,
		0xae,0x42,0x60,0x82);
}
