/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.3";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.break.com/";
	this.ID = "break.com";
	this.caption = "Break";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_GET_FLV = "%1.flv?%2";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get title
	result.title = copyBetween(html, '<meta name="title" content="', '"');
	// get video pre-url
	var preUrl = copyBetween(html, 'var videoPath = "', '"');
	// get variable values
	var sGlobalFileName = copyBetween(html, "sGlobalFileName='", "'");
	var sGlobalToken = copyBetween(html, "sGlobalToken='", "'");
	// clear and get the final url
	result.URL = cleanUrl(strFormat(URL_GET_FLV, sGlobalFileName, sGlobalToken));
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0xba,0x49,0x44,0x41,0x54,0x18,0x19,0x05,0xc1,0x4b,0x88,0x95,
		0x65,0x18,0x00,0xe0,0xe7,0xfd,0xfe,0x7f,0xce,0x9c,0xb9,0x20,0xa3,0x56,0x4e,0x17,
		0x4b,0x52,0x8b,0x02,0x0d,0x2a,0x48,0x4a,0x1b,0x82,0x04,0x0b,0xc5,0xb4,0x91,0xa8,
		0x45,0x10,0x08,0xe5,0x42,0x68,0x1d,0x41,0x14,0x84,0x50,0x24,0xb8,0xc8,0x82,0x16,
		0xb5,0x29,0x08,0x6f,0x05,0xb5,0xa9,0xa0,0xa2,0x5a,0xb4,0x32,0x12,0x45,0xc1,0x46,
		0xec,0x82,0x90,0x39,0xde,0x8e,0x73,0x39,0xe7,0xff,0xbf,0xaf,0xe7,0x09,0x00,0x80,
		0x43,0x3a,0x75,0xad,0x6d,0x77,0x68,0x0b,0x1c,0x31,0x34,0x19,0x86,0xf7,0x64,0x0b,
		0xfb,0x2a,0x06,0xad,0x2a,0xa6,0x2d,0x36,0x00,0x01,0x00,0x47,0x0d,0x8d,0x24,0x9d,
		0x75,0xb5,0xf9,0xab,0x7d,0xe9,0x62,0x4b,0x19,0xd2,0x7d,0x2c,0x2b,0xab,0x07,0x16,
		0x3e,0x1e,0xd1,0xb9,0xb7,0x48,0xa3,0x45,0x33,0xd3,0x70,0x79,0xda,0x62,0x2f,0xe0,
		0x88,0x3a,0x55,0x62,0x79,0xa8,0xd7,0x37,0x62,0x4f,0x88,0x75,0xf8,0x39,0x29,0xbf,
		0x65,0x36,0x86,0x38,0x93,0xf4,0xbf,0x6f,0x75,0x3e,0x0a,0x56,0x60,0x36,0x78,0xa3,
		0xd5,0x7c,0x5a,0x43,0x88,0xe5,0x45,0xe7,0xbd,0xcc,0x96,0xba,0x1e,0xba,0xdc,0x99,
		0xbc,0xe5,0xee,0x88,0x58,0x85,0xe7,0x89,0x54,0x4a,0xbe,0x32,0x98,0x9d,0x7d,0x26,
		0xe6,0x16,0xee,0xa2,0x54,0xb8,0x51,0xc4,0x79,0xe4,0xfa,0xa8,0x3a,0x0d,0x19,0xba,
		0xb3,0x61,0xab,0x48,0x13,0xb1,0x66,0xf5,0xb2,0x4d,0xdf,0x7e,0x99,0xe6,0xda,0xb6,
		0xee,0xf5,0x7a,0x52,0x4a,0x65,0xa2,0xaa,0x6e,0x3e,0xf7,0xd6,0xbe,0x9b,0xfe,0xfc,
		0xfc,0x58,0x2a,0x4d,0x13,0x45,0x69,0x43,0x7b,0x21,0x29,0x39,0xed,0xd4,0xe4,0x81,
		0xf6,0x22,0xf2,0xf5,0x14,0x3e,0x5b,0xda,0xad,0xae,0x85,0xf8,0xf0,0x83,0x83,0xb6,
		0x4c,0x4d,0xd9,0xba,0x6d,0x6b,0xfc,0xf1,0xcf,0xdf,0xe9,0x8e,0x57,0x76,0x57,0xa9,
		0x3b,0x1c,0x80,0xa8,0x0d,0x86,0x11,0x09,0x0a,0x7d,0xca,0x4c,0x26,0xf7,0x22,0x8c,
		0x08,0x3b,0xba,0x63,0xde,0x9c,0x98,0xb4,0x69,0xc9,0x32,0x8b,0x11,0xae,0x5d,0xba,
		0xa4,0xe4,0x02,0xb0,0xac,0x6f,0xf8,0xed,0x2c,0xba,0x35,0x50,0xa2,0x30,0x87,0x52,
		0x90,0xc6,0xc7,0xdc,0xfa,0xf2,0x6e,0xa3,0xbb,0x9e,0xf5,0x50,0x4a,0x26,0x86,0x3b,
		0x4e,0xbd,0xb3,0x5f,0xc9,0x59,0xa1,0xa0,0x47,0x7c,0x17,0x72,0x93,0x0e,0xab,0xab,
		0x5a,0x75,0x7b,0x88,0xdb,0x90,0xa0,0xd7,0xeb,0x39,0x78,0xe0,0x80,0xa7,0xa6,0xa6,
		0x6c,0xdf,0xbc,0xd9,0x37,0xc7,0xbe,0xf0,0xc0,0xab,0x7b,0x4d,0xac,0x59,0x25,0x22,
		0x1a,0x9c,0xec,0x98,0x3b,0xbc,0xd3,0xa0,0x9f,0x48,0x51,0xa4,0x71,0xac,0x08,0x02,
		0x46,0x4a,0xb1,0x6d,0xbe,0xef,0xb5,0xeb,0x8d,0x47,0x67,0x7b,0x7e,0x3c,0xf1,0xbb,
		0x18,0x1b,0x35,0x7e,0xff,0x7d,0x54,0xd5,0x1c,0xf1,0xd5,0x82,0xea,0x22,0xd4,0xd3,
		0xfa,0xcd,0x31,0x31,0x43,0xdd,0x2f,0x28,0x25,0x8b,0x48,0x46,0x97,0x2e,0x35,0xb9,
		0x72,0xa5,0x27,0xbb,0x1d,0x0b,0x8f,0x6c,0xb0,0x70,0xf9,0x8a,0x1b,0x67,0xcf,0x92,
		0xdb,0xc5,0xc4,0xf1,0x56,0x6a,0xa0,0x86,0xac,0xcc,0x27,0xe5,0x78,0x29,0xf9,0x89,
		0x6b,0x57,0xaf,0xd5,0x17,0xae,0x5e,0x31,0xf2,0xc2,0x73,0xd6,0xee,0xda,0xa9,0x08,
		0xcd,0xc2,0xbc,0x1f,0xde,0xdd,0x6f,0xf8,0xe4,0x19,0x72,0x6e,0x83,0x4b,0x89,0x02,
		0x35,0x50,0x06,0x45,0x9c,0x96,0xf3,0xe3,0xb3,0xa7,0x4f,0x57,0x4f,0x6f,0xd8,0xd0,
		0x0e,0xc4,0x7c,0xcd,0x48,0x87,0x6a,0x6d,0x09,0x2f,0x2e,0x46,0x31,0x68,0x02,0x37,
		0xb2,0x66,0x66,0xa7,0xc5,0x0c,0x35,0x10,0xfd,0x50,0x4e,0x4d,0x88,0x7f,0x5f,0xcf,
		0xc3,0xcb,0xf3,0xf5,0x7c,0xa1,0xe1,0x70,0xad,0x6c,0x0b,0x71,0x4f,0xc5,0xf5,0x0e,
		0xff,0x15,0xc6,0x29,0x27,0x82,0x01,0x40,0x0d,0x85,0x41,0x88,0x5f,0x42,0xec,0xed,
		0xca,0x2f,0x15,0xce,0x33,0x78,0x3f,0xe9,0x0c,0x0a,0xdb,0x93,0xf8,0xa4,0x32,0xff,
		0x75,0x63,0x78,0x63,0xe1,0xe1,0xac,0x14,0x80,0x00,0x38,0x64,0x28,0x05,0x4b,0x2a,
		0x9d,0xe9,0x4a,0xfe,0x69,0xc1,0xe0,0xaf,0x8e,0xee,0x83,0x34,0x97,0xb2,0xf6,0x5c,
		0x56,0x16,0x89,0xb1,0x5a,0x77,0x7d,0x63,0xf1,0xd7,0x69,0xfd,0x16,0xfe,0x07,0x9f,
		0x45,0x31,0xda,0x78,0x21,0x56,0x73,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,
		0x42,0x60,0x82);
}
