/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     EXT_ASCII_CHAR = 258
   };
#endif
/* Tokens.  */
#define EXT_ASCII_CHAR 258




/* Copy the first part of user declarations.  */
#line 32 "lscp.y"


#include "lscpparser.h"
#include "lscpserver.h"
#include "lscpevent.h"
#include "lscpsymbols.h"

namespace LinuxSampler {

// to save us typing work in the rules action definitions
#define LSCPSERVER ((yyparse_param_t*) yyparse_param)->pServer
#define SESSION_PARAM ((yyparse_param_t*) yyparse_param)
#define INCREMENT_LINE { SESSION_PARAM->iLine++; SESSION_PARAM->iColumn = 0; }

// clears input buffer
void restart(yyparse_param_t* pparam, int& yychar);
#define RESTART restart((yyparse_param_t*) YYPARSE_PARAM, yychar)

static char buf[1024]; // input buffer to feed the parser with new characters
static int bytes = 0;  // current number of characters in the input buffer
static int ptr   = 0;  // current position in the input buffer
static String sLastError; // error message of the last error occured

// external reference to the function which actually reads from the socket
extern int GetLSCPCommand( void *buf, int max_size);

// external reference to the function in lscpserver.cpp which returns the
// current session (only works because the server runs as singleton)
extern yyparse_param_t* GetCurrentYaccSession();

// returns true if supplied characters has an ASCII code of 128 or higher
inline bool isExtendedAsciiChar(const char c) {
    return (c < 0);
}

// custom scanner function which reads from the socket
// (bison expects it to return the numerical ID of the next
// "recognized token" from the input stream)
int yylex(YYSTYPE* yylval) {
    // check if we have to read new characters
    if (ptr >= bytes) {
        bytes = GetLSCPCommand(buf, 1023);
        ptr   = 0;
        if (bytes < 0) {
            bytes = 0;
            return 0;
        }
    }
    // this is the next character in the input stream
    const char c = buf[ptr++];
    // increment current reading position (just for verbosity / messages)
    GetCurrentYaccSession()->iColumn++;
    // we have to handle "normal" and "extended" ASCII characters separately
    if (isExtendedAsciiChar(c)) {
        // workaround for characters with ASCII code higher than 127
        yylval->Char = c;
        return EXT_ASCII_CHAR;
    } else {
        // simply return the ASCII code as terminal symbol ID
        return (int) c;
    }
}

// parser helper functions

int octalsToNumber(char oct_digit0, char oct_digit1 = '0', char oct_digit2 = '0') {
    const char d0[] = { oct_digit0, '\0' };
    const char d1[] = { oct_digit1, '\0' };
    const char d2[] = { oct_digit2, '\0' };
    return atoi(d2)*8*8 + atoi(d1)*8 + atoi(d0);
}

}

// we provide our own version of yyerror() so we don't have to link against the yacc library
void yyerror(const char* s);

using namespace LinuxSampler;



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 193 "y.tab.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  58
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   4635

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  100
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  201
/* YYNRULES -- Number of rules.  */
#define YYNRULES  594
/* YYNRULES -- Number of states.  */
#define YYNSTATES  2246

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   258

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      98,     2,     2,    99,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    97,    77,    33,     4,    78,    79,    80,    32,
      81,    82,    83,     8,     6,     9,     7,    34,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    35,    84,
      85,     5,    86,    87,    88,    26,    27,    28,    29,    30,
      31,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    89,    36,    90,    91,    92,     2,    20,    21,    22,
      23,    24,    25,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    93,    94,    95,    96,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     6,    10,    11,    13,    15,    17,    19,
      22,    25,    28,    31,    35,    39,    43,    47,    51,    55,
      59,    63,    67,    71,    75,    79,    83,    87,    91,    95,
      99,   103,   107,   111,   113,   115,   117,   121,   131,   143,
     151,   161,   169,   179,   185,   193,   195,   199,   201,   203,
     205,   207,   209,   211,   213,   215,   217,   219,   221,   223,
     225,   227,   229,   231,   233,   235,   237,   239,   241,   243,
     245,   247,   249,   251,   253,   255,   257,   259,   261,   263,
     265,   267,   269,   271,   273,   275,   277,   279,   281,   283,
     285,   287,   289,   291,   293,   295,   297,   299,   301,   303,
     320,   339,   358,   379,   387,   391,   395,   399,   405,   409,
     413,   415,   417,   423,   431,   441,   443,   449,   457,   467,
     469,   471,   477,   483,   491,   501,   509,   519,   521,   527,
     535,   541,   547,   553,   557,   559,   561,   563,   567,   571,
     581,   583,   589,   593,   601,   607,   611,   617,   623,   627,
     633,   639,   641,   643,   645,   651,   661,   669,   679,   687,
     697,   707,   711,   719,   729,   741,   751,   761,   769,   777,
     785,   793,   801,   805,   809,   813,   817,   823,   827,   833,
     837,   843,   851,   855,   859,   863,   871,   877,   885,   891,
     895,   901,   907,   913,   919,   923,   927,   933,   937,   941,
     947,   955,   961,   971,   977,   983,   989,   995,  1001,  1007,
    1013,  1019,  1025,  1031,  1037,  1039,  1040,  1043,  1047,  1053,
    1055,  1057,  1059,  1061,  1063,  1065,  1067,  1069,  1073,  1077,
    1079,  1083,  1089,  1093,  1099,  1103,  1109,  1121,  1127,  1135,
    1139,  1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,
    1159,  1161,  1163,  1165,  1167,  1169,  1171,  1173,  1175,  1177,
    1179,  1181,  1183,  1185,  1187,  1189,  1191,  1195,  1197,  1199,
    1201,  1203,  1207,  1213,  1215,  1217,  1219,  1221,  1223,  1225,
    1227,  1231,  1236,  1241,  1243,  1246,  1248,  1250,  1252,  1254,
    1256,  1258,  1260,  1262,  1264,  1266,  1268,  1270,  1272,  1274,
    1276,  1278,  1280,  1282,  1284,  1286,  1288,  1290,  1292,  1294,
    1296,  1298,  1300,  1302,  1304,  1306,  1308,  1310,  1312,  1314,
    1316,  1318,  1320,  1322,  1324,  1326,  1328,  1331,  1334,  1337,
    1340,  1343,  1346,  1349,  1352,  1355,  1359,  1363,  1366,  1368,
    1372,  1373,  1376,  1379,  1383,  1387,  1391,  1395,  1397,  1399,
    1402,  1405,  1407,  1409,  1412,  1415,  1417,  1419,  1422,  1425,
    1427,  1430,  1432,  1434,  1437,  1440,  1442,  1444,  1446,  1448,
    1450,  1452,  1454,  1456,  1458,  1460,  1462,  1464,  1466,  1468,
    1470,  1472,  1474,  1476,  1478,  1480,  1482,  1484,  1486,  1488,
    1490,  1492,  1494,  1496,  1498,  1500,  1502,  1504,  1506,  1508,
    1510,  1512,  1514,  1516,  1518,  1520,  1522,  1524,  1526,  1528,
    1530,  1532,  1534,  1536,  1538,  1540,  1542,  1544,  1546,  1548,
    1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,  1568,
    1570,  1572,  1574,  1576,  1578,  1580,  1582,  1584,  1586,  1588,
    1590,  1592,  1594,  1596,  1598,  1600,  1602,  1604,  1606,  1608,
    1610,  1612,  1614,  1616,  1618,  1620,  1622,  1624,  1626,  1628,
    1631,  1634,  1637,  1640,  1643,  1646,  1649,  1652,  1655,  1657,
    1659,  1662,  1666,  1671,  1675,  1680,  1682,  1684,  1686,  1690,
    1694,  1698,  1704,  1710,  1715,  1727,  1732,  1737,  1744,  1752,
    1757,  1762,  1766,  1771,  1779,  1789,  1796,  1800,  1810,  1822,
    1830,  1848,  1879,  1888,  1893,  1919,  1944,  1968,  1991,  2017,
    2042,  2064,  2085,  2115,  2144,  2164,  2183,  2203,  2227,  2241,
    2254,  2266,  2279,  2293,  2306,  2318,  2331,  2343,  2362,  2380,
    2402,  2414,  2425,  2437,  2444,  2454,  2469,  2480,  2510,  2531,
    2551,  2581,  2601,  2632,  2653,  2671,  2700,  2728,  2754,  2773,
    2791,  2819,  2835,  2852,  2872,  2893,  2911,  2927,  2946,  2962,
    2973,  2989,  2994,  3002,  3011,  3035,  3061,  3076,  3090,  3109,
    3124,  3136,  3142,  3147,  3157,  3171,  3176,  3186,  3193,  3200,
    3206,  3211,  3216,  3223,  3231,  3237,  3248,  3253,  3258,  3265,
    3275,  3281,  3295,  3300,  3305
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     101,     0,    -1,   102,   182,    -1,   102,   183,   182,    -1,
      -1,   103,    -1,   104,    -1,     1,    -1,     4,    -1,   103,
       4,    -1,   103,   181,    -1,   103,   163,    -1,   103,   173,
      -1,   184,   181,   105,    -1,   186,   181,   108,    -1,   187,
     181,   109,    -1,   185,   181,   111,    -1,   193,   181,   113,
      -1,   194,   181,   119,    -1,   195,   181,   127,    -1,   196,
     181,   120,    -1,   201,   181,   110,    -1,   202,   181,   112,
      -1,   203,   181,   106,    -1,   204,   181,   107,    -1,   296,
     181,   114,    -1,   188,   181,   115,    -1,   189,   181,   116,
      -1,   191,   181,   117,    -1,   192,   181,   118,    -1,   293,
     181,   122,    -1,   294,   181,   123,    -1,   267,   181,   128,
      -1,   296,    -1,   300,    -1,   205,    -1,   270,   181,   148,
      -1,   272,   181,   200,   181,   156,   181,   148,   181,   147,
      -1,   272,   181,   200,   181,   156,   181,   190,   181,   148,
     181,   147,    -1,   272,   181,   156,   181,   148,   181,   147,
      -1,   272,   181,   156,   181,   190,   181,   148,   181,   147,
      -1,   272,   181,   200,   181,   148,   181,   147,    -1,   272,
     181,   200,   181,   148,   181,   147,   181,   144,    -1,   272,
     181,   148,   181,   147,    -1,   272,   181,   148,   181,   147,
     181,   144,    -1,   259,    -1,   259,   181,   149,    -1,   210,
      -1,   211,    -1,   212,    -1,   213,    -1,   224,    -1,   225,
      -1,   226,    -1,   232,    -1,   231,    -1,   230,    -1,   227,
      -1,   228,    -1,   229,    -1,   214,    -1,   215,    -1,   216,
      -1,   217,    -1,   218,    -1,   219,    -1,   220,    -1,   221,
      -1,   223,    -1,   297,    -1,   233,    -1,   234,    -1,   236,
      -1,   210,    -1,   211,    -1,   212,    -1,   213,    -1,   224,
      -1,   225,    -1,   226,    -1,   232,    -1,   231,    -1,   230,
      -1,   227,    -1,   228,    -1,   229,    -1,   214,    -1,   215,
      -1,   216,    -1,   217,    -1,   218,    -1,   219,    -1,   220,
      -1,   221,    -1,   223,    -1,   297,    -1,   233,    -1,   234,
      -1,   236,    -1,   257,   181,   124,   138,   181,   139,   181,
     140,   181,   146,   181,   147,   181,   144,   181,   142,    -1,
     257,   181,   124,   138,   181,   139,   181,   140,   181,   146,
     181,   147,   181,   144,   181,   142,   181,   131,    -1,   257,
     181,   124,   138,   181,   139,   181,   140,   181,   146,   181,
     147,   181,   144,   181,   142,   181,   150,    -1,   257,   181,
     124,   138,   181,   139,   181,   140,   181,   146,   181,   147,
     181,   144,   181,   142,   181,   131,   181,   150,    -1,   257,
     181,   138,   181,   139,   181,   140,    -1,   205,   181,   143,
      -1,   259,   181,   138,    -1,   259,   181,   197,    -1,   270,
     181,   277,   181,   148,    -1,   270,   181,   148,    -1,   273,
     181,   148,    -1,   206,    -1,   251,    -1,   261,   181,   209,
     181,   173,    -1,   256,   181,   209,   181,   173,   181,   173,
      -1,   256,   181,   209,   181,   173,   181,   173,   181,   125,
      -1,   207,    -1,   247,   181,   209,   181,   173,    -1,   246,
     181,   209,   181,   173,   181,   173,    -1,   246,   181,   209,
     181,   173,   181,   173,   181,   125,    -1,   244,    -1,   254,
      -1,   245,   181,   209,   181,   163,    -1,   255,   181,   209,
     181,   163,    -1,   262,   181,   209,   181,   163,   181,   163,
      -1,   253,   181,   209,   181,   163,   181,   163,   181,   173,
      -1,   249,   181,   209,   181,   163,   181,   163,    -1,   248,
     181,   209,   181,   163,   181,   163,   181,   173,    -1,   208,
      -1,   205,   181,   209,   181,   143,    -1,   205,   181,   230,
     181,   126,   181,   143,    -1,   205,   181,   231,   181,   143,
      -1,   205,   181,   232,   181,   143,    -1,   239,   181,   209,
     181,   146,    -1,   283,   181,   209,    -1,   233,    -1,   234,
      -1,   235,    -1,   258,   181,   138,    -1,   258,   181,   197,
      -1,   257,   181,   209,   181,   138,   181,   139,   181,   140,
      -1,   260,    -1,   259,   181,   209,   181,   138,    -1,   269,
     181,   143,    -1,   268,   181,   209,   181,   143,   181,   145,
      -1,   271,   181,   279,   181,   148,    -1,   271,   181,   148,
      -1,   270,   181,   209,   181,   148,    -1,   272,   181,   279,
     181,   148,    -1,   272,   181,   148,    -1,   273,   181,   209,
     181,   148,    -1,   274,   181,   209,   181,   163,    -1,   284,
      -1,   288,    -1,   289,    -1,   292,   181,   238,   181,   147,
      -1,   292,   181,   237,   181,   209,   181,   147,   181,   144,
      -1,   243,   181,   163,   181,   173,     5,   152,    -1,   248,
     181,   163,   181,   163,   181,   173,     5,   152,    -1,   252,
     181,   163,   181,   173,     5,   152,    -1,   253,   181,   163,
     181,   163,   181,   173,     5,   198,    -1,   253,   181,   163,
     181,   163,   181,   173,     5,   152,    -1,   205,   181,   121,
      -1,   259,   181,   298,   181,   138,   181,   149,    -1,   268,
     181,   298,   181,   143,   181,   145,   181,   151,    -1,   268,
     181,   249,   181,   143,   181,   145,   181,   133,   181,   133,
      -1,   268,   181,   266,   181,   143,   181,   145,   181,   141,
      -1,   268,   181,   285,   181,   143,   181,   145,   181,   142,
      -1,   270,   181,   298,   181,   148,   181,   169,    -1,   270,
     181,   276,   181,   148,   181,   169,    -1,   273,   181,   298,
     181,   148,   181,   169,    -1,   273,   181,   276,   181,   148,
     181,   169,    -1,   273,   181,   282,   181,   147,   181,   147,
      -1,   299,   181,   157,    -1,   284,   181,   142,    -1,   288,
     181,   163,    -1,   289,   181,   163,    -1,   245,   181,   173,
     181,   125,    -1,   245,   181,   173,    -1,   255,   181,   173,
     181,   125,    -1,   255,   181,   173,    -1,   268,   181,   143,
     181,   141,    -1,   268,   181,   143,   181,   141,   181,   151,
      -1,   205,   181,   143,    -1,   258,   181,   138,    -1,   258,
     181,   197,    -1,   272,   181,   280,   181,   148,   181,   154,
      -1,   272,   181,   148,   181,   154,    -1,   271,   181,   280,
     181,   148,   181,   154,    -1,   271,   181,   148,   181,   154,
      -1,   281,   181,   222,    -1,   270,   181,   148,   181,   148,
      -1,   273,   181,   148,   181,   148,    -1,   270,   181,   148,
     181,   148,    -1,   273,   181,   148,   181,   148,    -1,   245,
     181,   163,    -1,   255,   181,   163,    -1,   268,   181,   143,
     181,   145,    -1,   237,   181,   129,    -1,   239,   181,   130,
      -1,   245,   181,   143,   181,   132,    -1,   249,   181,   143,
     181,   133,   181,   133,    -1,   250,   181,   143,   181,   134,
      -1,   265,   181,   143,   181,   132,   181,   135,   181,   136,
      -1,   255,   181,   143,   181,   132,    -1,   262,   181,   143,
     181,   135,    -1,   263,   181,   143,   181,   136,    -1,   264,
     181,   143,   181,   137,    -1,   284,   181,   143,   181,   142,
      -1,   286,   181,   143,   181,   157,    -1,   287,   181,   143,
     181,   157,    -1,   259,   181,   143,   181,   138,    -1,   259,
     181,   143,   181,   198,    -1,   259,   181,   143,   181,   199,
      -1,   205,   181,   237,   181,   143,    -1,   275,    -1,    -1,
     200,   181,    -1,   173,     5,   152,    -1,   125,   181,   173,
       5,   152,    -1,   290,    -1,   291,    -1,   244,    -1,   254,
      -1,   208,    -1,   206,    -1,   251,    -1,   207,    -1,   258,
     181,   138,    -1,   258,   181,   197,    -1,   260,    -1,   269,
     181,   143,    -1,   271,   181,   279,   181,   148,    -1,   271,
     181,   148,    -1,   272,   181,   279,   181,   148,    -1,   272,
     181,   148,    -1,   292,   181,   238,   181,   147,    -1,   205,
     181,   295,   181,   173,   181,   143,   181,   163,   181,   163,
      -1,   147,   181,   144,   181,   143,    -1,   200,   181,   147,
     181,   144,   181,   143,    -1,   146,   181,   143,    -1,   240,
      -1,   241,    -1,   242,    -1,   163,    -1,   163,    -1,   173,
      -1,   163,    -1,   163,    -1,   197,    -1,   173,    -1,   163,
      -1,   163,    -1,   163,    -1,   163,    -1,   158,    -1,   163,
      -1,   163,    -1,   163,    -1,   163,    -1,   173,    -1,   164,
      -1,   164,    -1,   169,    -1,   169,    -1,   169,    -1,   153,
      -1,   152,     6,   153,    -1,   173,    -1,   168,    -1,   163,
      -1,   158,    -1,   173,     5,   155,    -1,   154,   181,   173,
       5,   155,    -1,   172,    -1,   169,    -1,   279,    -1,   280,
      -1,   278,    -1,   163,    -1,   173,    -1,   159,     7,   159,
      -1,     8,   159,     7,   159,    -1,     9,   159,     7,   159,
      -1,   160,    -1,   159,   160,    -1,    10,    -1,    11,    -1,
      12,    -1,    13,    -1,    14,    -1,    15,    -1,    16,    -1,
      17,    -1,    18,    -1,    19,    -1,    10,    -1,    11,    -1,
      12,    -1,    13,    -1,    14,    -1,    15,    -1,    16,    -1,
      17,    -1,    10,    -1,    11,    -1,    12,    -1,    13,    -1,
      14,    -1,    15,    -1,    16,    -1,    17,    -1,    18,    -1,
      19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,
      24,    -1,    25,    -1,    26,    -1,    27,    -1,    28,    -1,
      29,    -1,    30,    -1,    31,    -1,   160,    -1,    11,   159,
      -1,    12,   159,    -1,    13,   159,    -1,    14,   159,    -1,
      15,   159,    -1,    16,   159,    -1,    17,   159,    -1,    18,
     159,    -1,    19,   159,    -1,    32,   165,    32,    -1,    33,
     165,    33,    -1,   166,   167,    -1,    34,    -1,   176,    35,
      34,    -1,    -1,   167,    34,    -1,   167,   171,    -1,    32,
     170,    32,    -1,    33,   170,    33,    -1,    32,   172,    32,
      -1,    33,   172,    33,    -1,   181,    -1,   173,    -1,   170,
     181,    -1,   170,   173,    -1,   181,    -1,   174,    -1,   171,
     181,    -1,   171,   174,    -1,    34,    -1,   171,    -1,   172,
      34,    -1,   172,   171,    -1,   175,    -1,   173,   175,    -1,
     177,    -1,   178,    -1,   174,   177,    -1,   174,   178,    -1,
     177,    -1,    36,    -1,    34,    -1,    26,    -1,    27,    -1,
      28,    -1,    29,    -1,    30,    -1,    31,    -1,    37,    -1,
      38,    -1,    39,    -1,    40,    -1,    41,    -1,    42,    -1,
      43,    -1,    44,    -1,    45,    -1,    46,    -1,    47,    -1,
      48,    -1,    49,    -1,    50,    -1,    51,    -1,    52,    -1,
      53,    -1,    54,    -1,    55,    -1,    56,    -1,    20,    -1,
      21,    -1,    22,    -1,    23,    -1,    24,    -1,    25,    -1,
      57,    -1,    58,    -1,    59,    -1,    60,    -1,    61,    -1,
      62,    -1,    63,    -1,    64,    -1,    65,    -1,    66,    -1,
      67,    -1,    68,    -1,    69,    -1,    70,    -1,    71,    -1,
      72,    -1,    73,    -1,    74,    -1,    75,    -1,    76,    -1,
     176,    -1,    10,    -1,    11,    -1,    12,    -1,    13,    -1,
      14,    -1,    15,    -1,    16,    -1,    17,    -1,    18,    -1,
      19,    -1,    77,    -1,     4,    -1,    78,    -1,    79,    -1,
      80,    -1,    81,    -1,    82,    -1,    83,    -1,     8,    -1,
       9,    -1,     7,    -1,     6,    -1,    35,    -1,    84,    -1,
      85,    -1,     5,    -1,    86,    -1,    87,    -1,    88,    -1,
      89,    -1,    90,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,     3,    -1,    36,    32,
      -1,    36,    33,    -1,    36,    36,    -1,    36,    34,    -1,
      36,    64,    -1,    36,    68,    -1,    36,    25,    -1,    36,
      70,    -1,    36,    72,    -1,   179,    -1,   180,    -1,    36,
     161,    -1,    36,   161,   161,    -1,    36,   161,   161,   161,
      -1,    36,    74,   162,    -1,    36,    74,   162,   162,    -1,
      97,    -1,    98,    -1,    99,    -1,    26,    29,    29,    -1,
      37,    30,    50,    -1,    43,    26,    46,    -1,    51,    44,
      43,    26,    46,    -1,    28,    42,    30,    26,    48,    -1,
      31,    39,    44,    29,    -1,    31,    39,    42,    30,    92,
      26,    49,    92,    29,    39,    48,    -1,    43,    45,    52,
      30,    -1,    28,    45,    46,    55,    -1,    28,    48,    30,
      26,    50,    30,    -1,    29,    30,    49,    50,    48,    45,
      55,    -1,    42,    39,    49,    50,    -1,    42,    45,    26,
      29,    -1,    26,    42,    42,    -1,    44,    45,    44,    30,
      -1,    29,    30,    31,    26,    51,    42,    50,    -1,    44,
      45,    44,    92,    43,    45,    29,    26,    42,    -1,    48,
      30,    43,    45,    52,    30,    -1,    49,    30,    50,    -1,
      49,    51,    27,    49,    28,    48,    39,    27,    30,    -1,
      51,    44,    49,    51,    27,    49,    28,    48,    39,    27,
      30,    -1,    28,    38,    26,    44,    44,    30,    42,    -1,
      26,    52,    26,    39,    42,    26,    27,    42,    30,    92,
      30,    44,    37,    39,    44,    30,    49,    -1,    26,    52,
      26,    39,    42,    26,    27,    42,    30,    92,    26,    51,
      29,    39,    45,    92,    45,    51,    50,    46,    51,    50,
      92,    29,    48,    39,    52,    30,    48,    49,    -1,    28,
      38,    26,    44,    44,    30,    42,    49,    -1,    39,    44,
      31,    45,    -1,    26,    51,    29,    39,    45,    92,    45,
      51,    50,    46,    51,    50,    92,    29,    30,    52,    39,
      28,    30,    92,    28,    45,    51,    44,    50,    -1,    26,
      51,    29,    39,    45,    92,    45,    51,    50,    46,    51,
      50,    92,    29,    30,    52,    39,    28,    30,    92,    39,
      44,    31,    45,    -1,    43,    39,    29,    39,    92,    39,
      44,    46,    51,    50,    92,    29,    30,    52,    39,    28,
      30,    92,    28,    45,    51,    44,    50,    -1,    43,    39,
      29,    39,    92,    39,    44,    46,    51,    50,    92,    29,
      30,    52,    39,    28,    30,    92,    39,    44,    31,    45,
      -1,    43,    39,    29,    39,    92,    39,    44,    49,    50,
      48,    51,    43,    30,    44,    50,    92,    43,    26,    46,
      92,    28,    45,    51,    44,    50,    -1,    43,    39,    29,
      39,    92,    39,    44,    49,    50,    48,    51,    43,    30,
      44,    50,    92,    43,    26,    46,    92,    39,    44,    31,
      45,    -1,    43,    39,    29,    39,    92,    39,    44,    49,
      50,    48,    51,    43,    30,    44,    50,    92,    28,    45,
      51,    44,    50,    -1,    43,    39,    29,    39,    92,    39,
      44,    49,    50,    48,    51,    43,    30,    44,    50,    92,
      39,    44,    31,    45,    -1,    29,    27,    92,    39,    44,
      49,    50,    48,    51,    43,    30,    44,    50,    92,    29,
      39,    48,    30,    28,    50,    45,    48,    55,    92,    28,
      45,    51,    44,    50,    -1,    29,    27,    92,    39,    44,
      49,    50,    48,    51,    43,    30,    44,    50,    92,    29,
      39,    48,    30,    28,    50,    45,    48,    55,    92,    39,
      44,    31,    45,    -1,    29,    27,    92,    39,    44,    49,
      50,    48,    51,    43,    30,    44,    50,    92,    28,    45,
      51,    44,    50,    -1,    29,    27,    92,    39,    44,    49,
      50,    48,    51,    43,    30,    44,    50,    92,    39,    44,
      31,    45,    -1,    29,    27,    92,    39,    44,    49,    50,
      48,    51,    43,    30,    44,    50,    92,    31,    39,    42,
      30,    49,    -1,    29,    27,    92,    39,    44,    49,    50,
      48,    51,    43,    30,    44,    50,    49,    92,    40,    45,
      27,    92,    39,    44,    31,    45,    -1,    28,    38,    26,
      44,    44,    30,    42,    92,    28,    45,    51,    44,    50,
      -1,    28,    38,    26,    44,    44,    30,    42,    92,    43,
      39,    29,    39,    -1,    29,    30,    52,    39,    28,    30,
      92,    43,    39,    29,    39,    -1,    28,    38,    26,    44,
      44,    30,    42,    92,    39,    44,    31,    45,    -1,    31,
      54,    92,    49,    30,    44,    29,    92,    28,    45,    51,
      44,    50,    -1,    31,    54,    92,    49,    30,    44,    29,
      92,    39,    44,    31,    45,    -1,    27,    51,    31,    31,
      30,    48,    92,    31,    39,    42,    42,    -1,    49,    50,
      48,    30,    26,    43,    92,    28,    45,    51,    44,    50,
      -1,    52,    45,    39,    28,    30,    92,    28,    45,    51,
      44,    50,    -1,    50,    45,    50,    26,    42,    92,    49,
      50,    48,    30,    26,    43,    92,    28,    45,    51,    44,
      50,    -1,    50,    45,    50,    26,    42,    92,    52,    45,
      39,    28,    30,    92,    28,    45,    51,    44,    50,    -1,
      50,    45,    50,    26,    42,    92,    52,    45,    39,    28,
      30,    92,    28,    45,    51,    44,    50,    92,    43,    26,
      54,    -1,    37,    42,    45,    27,    26,    42,    92,    39,
      44,    31,    45,    -1,    39,    44,    49,    50,    48,    51,
      43,    30,    44,    50,    -1,    39,    44,    49,    50,    48,
      51,    43,    30,    44,    50,    49,    -1,    30,    44,    37,
      39,    44,    30,    -1,    45,    44,    92,    29,    30,    43,
      26,    44,    29,    -1,    45,    44,    92,    29,    30,    43,
      26,    44,    29,    92,    38,    45,    42,    29,    -1,    46,
      30,    48,    49,    39,    49,    50,    30,    44,    50,    -1,
      26,    51,    29,    39,    45,    92,    45,    51,    50,    46,
      51,    50,    92,    29,    30,    52,    39,    28,    30,    92,
      46,    26,    48,    26,    43,    30,    50,    30,    48,    -1,
      26,    51,    29,    39,    45,    92,    45,    51,    50,    46,
      51,    50,    92,    29,    30,    52,    39,    28,    30,    49,
      -1,    26,    51,    29,    39,    45,    92,    45,    51,    50,
      46,    51,    50,    92,    29,    30,    52,    39,    28,    30,
      -1,    26,    51,    29,    39,    45,    92,    45,    51,    50,
      46,    51,    50,    92,    29,    48,    39,    52,    30,    48,
      92,    46,    26,    48,    26,    43,    30,    50,    30,    48,
      -1,    26,    51,    29,    39,    45,    92,    45,    51,    50,
      46,    51,    50,    92,    29,    48,    39,    52,    30,    48,
      -1,    26,    51,    29,    39,    45,    92,    45,    51,    50,
      46,    51,    50,    92,    28,    38,    26,    44,    44,    30,
      42,    92,    46,    26,    48,    26,    43,    30,    50,    30,
      48,    -1,    26,    51,    29,    39,    45,    92,    45,    51,
      50,    46,    51,    50,    92,    28,    38,    26,    44,    44,
      30,    42,    -1,    26,    51,    29,    39,    45,    92,    45,
      51,    50,    46,    51,    50,    92,    50,    55,    46,    30,
      -1,    26,    52,    26,    39,    42,    26,    27,    42,    30,
      92,    43,    39,    29,    39,    92,    39,    44,    46,    51,
      50,    92,    29,    48,    39,    52,    30,    48,    49,    -1,
      43,    39,    29,    39,    92,    39,    44,    46,    51,    50,
      92,    29,    30,    52,    39,    28,    30,    92,    46,    26,
      48,    26,    43,    30,    50,    30,    48,    -1,    43,    39,
      29,    39,    92,    39,    44,    46,    51,    50,    92,    46,
      45,    48,    50,    92,    46,    26,    48,    26,    43,    30,
      50,    30,    48,    -1,    43,    39,    29,    39,    92,    39,
      44,    46,    51,    50,    92,    29,    30,    52,    39,    28,
      30,    49,    -1,    43,    39,    29,    39,    92,    39,    44,
      46,    51,    50,    92,    29,    30,    52,    39,    28,    30,
      -1,    43,    39,    29,    39,    92,    39,    44,    46,    51,
      50,    92,    29,    48,    39,    52,    30,    48,    92,    46,
      26,    48,    26,    43,    30,    50,    30,    48,    -1,    43,
      39,    29,    39,    92,    39,    44,    49,    50,    48,    51,
      43,    30,    44,    50,    -1,    43,    39,    29,    39,    92,
      39,    44,    49,    50,    48,    51,    43,    30,    44,    50,
      49,    -1,    43,    39,    29,    39,    92,    39,    44,    49,
      50,    48,    51,    43,    30,    44,    50,    92,    43,    26,
      46,    -1,    43,    39,    29,    39,    92,    39,    44,    49,
      50,    48,    51,    43,    30,    44,    50,    92,    43,    26,
      46,    49,    -1,    43,    39,    29,    39,    92,    39,    44,
      46,    51,    50,    92,    29,    48,    39,    52,    30,    48,
      -1,    43,    39,    29,    39,    92,    39,    44,    46,    51,
      50,    92,    46,    45,    48,    50,    -1,    43,    39,    29,
      39,    92,    39,    44,    46,    51,    50,    92,    28,    38,
      26,    44,    44,    30,    42,    -1,    43,    39,    29,    39,
      92,    39,    44,    46,    51,    50,    92,    50,    55,    46,
      30,    -1,    43,    39,    29,    39,    92,    39,    44,    46,
      51,    50,    -1,    43,    39,    29,    39,    92,    28,    45,
      44,    50,    48,    45,    42,    42,    30,    48,    -1,    49,
      30,    44,    29,    -1,    31,    54,    92,    49,    30,    44,
      29,    -1,    31,    54,    92,    49,    30,    44,    29,    49,
      -1,    29,    27,    92,    39,    44,    49,    50,    48,    51,
      43,    30,    44,    50,    92,    29,    39,    48,    30,    28,
      50,    45,    48,    55,    -1,    29,    27,    92,    39,    44,
      49,    50,    48,    51,    43,    30,    44,    50,    92,    29,
      39,    48,    30,    28,    50,    45,    48,    39,    30,    49,
      -1,    29,    27,    92,    39,    44,    49,    50,    48,    51,
      43,    30,    44,    50,    49,    -1,    29,    27,    92,    39,
      44,    49,    50,    48,    51,    43,    30,    44,    50,    -1,
      29,    27,    92,    39,    44,    49,    50,    48,    51,    43,
      30,    44,    50,    49,    92,    40,    45,    27,    -1,    39,
      44,    49,    50,    48,    51,    43,    30,    44,    50,    49,
      92,    29,    27,    -1,    29,    30,    49,    28,    48,    39,
      46,    50,    39,    45,    44,    -1,    31,    45,    48,    28,
      30,    -1,    31,    42,    26,    50,    -1,    48,    30,    28,
      51,    48,    49,    39,    52,    30,    -1,    44,    45,    44,
      92,    48,    30,    28,    51,    48,    49,    39,    52,    30,
      -1,    42,    45,    49,    50,    -1,    31,    39,    42,    30,
      92,    46,    26,    50,    38,    -1,    49,    30,    48,    52,
      30,    48,    -1,    52,    45,    42,    51,    43,    30,    -1,
      42,    30,    52,    30,    42,    -1,    43,    51,    50,    30,
      -1,    49,    45,    42,    45,    -1,    52,    45,    39,    28,
      30,    49,    -1,    49,    50,    48,    30,    26,    43,    49,
      -1,    27,    55,    50,    30,    49,    -1,    46,    30,    48,
      28,    30,    44,    50,    26,    37,    30,    -1,    31,    39,
      42,    30,    -1,    30,    29,    39,    50,    -1,    31,    45,
      48,    43,    26,    50,    -1,    43,    39,    29,    39,    92,
      29,    26,    50,    26,    -1,    48,    30,    49,    30,    50,
      -1,    43,    39,    49,    28,    30,    42,    42,    26,    44,
      30,    45,    51,    49,    -1,    44,    26,    43,    30,    -1,
      30,    28,    38,    45,    -1,    47,    51,    39,    50,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   146,   146,   147,   150,   151,   152,   153,   156,   157,
     158,   159,   160,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   187,   188,   189,   190,   191,
     192,   193,   194,   195,   196,   197,   198,   201,   202,   203,
     204,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   222,   223,
     224,   225,   226,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   257,
     258,   259,   260,   263,   266,   267,   268,   269,   270,   271,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   344,   345,   346,   347,
     348,   349,   352,   355,   356,   359,   360,   361,   362,   363,
     366,   367,   370,   371,   374,   375,   376,   379,   380,   383,
     384,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   399,   402,   405,   406,   409,   410,   413,
     414,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,   428,   429,   430,   431,   434,   437,   438,   441,
     444,   445,   446,   449,   452,   455,   458,   461,   462,   465,
     468,   471,   474,   477,   480,   481,   484,   487,   490,   493,
     496,   506,   509,   512,   515,   518,   519,   523,   524,   525,
     526,   529,   530,   533,   534,   537,   538,   539,   547,   548,
     551,   552,   553,   557,   558,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   573,   574,   575,   576,   577,
     578,   579,   580,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   597,   598,   599,
     600,   601,   602,   603,   604,   607,   608,   609,   610,   611,
     612,   613,   614,   615,   616,   619,   620,   623,   626,   627,
     630,   631,   632,   635,   636,   639,   640,   643,   644,   645,
     646,   650,   651,   652,   653,   656,   657,   658,   659,   662,
     663,   666,   667,   668,   669,   673,   674,   675,   679,   679,
     679,   679,   679,   679,   679,   679,   679,   679,   679,   679,
     679,   679,   679,   679,   679,   679,   679,   679,   679,   679,
     679,   679,   679,   679,   680,   680,   680,   680,   680,   680,
     680,   680,   680,   680,   680,   680,   680,   680,   680,   680,
     680,   680,   680,   680,   680,   680,   680,   680,   680,   680,
     684,   685,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   686,   686,   686,   686,   686,   686,   686,   686,   686,
     686,   686,   686,   687,   687,   687,   687,   687,   687,   687,
     688,   688,   688,   688,   689,   689,   689,   689,   690,   693,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   703,
     706,   707,   708,   711,   712,   717,   720,   723,   726,   729,
     732,   735,   738,   741,   744,   747,   750,   753,   756,   759,
     762,   765,   768,   771,   774,   777,   780,   783,   786,   789,
     792,   795,   798,   801,   804,   807,   810,   813,   816,   819,
     822,   825,   828,   831,   834,   837,   840,   843,   846,   849,
     852,   855,   858,   861,   864,   867,   870,   873,   876,   879,
     882,   885,   888,   891,   894,   897,   900,   903,   906,   909,
     912,   915,   918,   921,   924,   927,   930,   933,   936,   939,
     942,   945,   948,   951,   954,   957,   960,   963,   966,   969,
     972,   975,   978,   981,   984,   987,   990,   993,   996,   999,
    1002,  1005,  1008,  1011,  1014,  1017,  1020,  1023,  1026,  1029,
    1032,  1035,  1038,  1041,  1044,  1047,  1050,  1053,  1056,  1059,
    1062,  1065,  1068,  1071,  1074
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "EXT_ASCII_CHAR", "'#'", "'='", "','",
  "'.'", "'+'", "'-'", "'0'", "'1'", "'2'", "'3'", "'4'", "'5'", "'6'",
  "'7'", "'8'", "'9'", "'a'", "'b'", "'c'", "'d'", "'e'", "'f'", "'A'",
  "'B'", "'C'", "'D'", "'E'", "'F'", "'''", "'\"'", "'/'", "':'", "'\\\\'",
  "'G'", "'H'", "'I'", "'J'", "'K'", "'L'", "'M'", "'N'", "'O'", "'P'",
  "'Q'", "'R'", "'S'", "'T'", "'U'", "'V'", "'W'", "'X'", "'Y'", "'Z'",
  "'g'", "'h'", "'i'", "'j'", "'k'", "'l'", "'m'", "'n'", "'o'", "'p'",
  "'q'", "'r'", "'s'", "'t'", "'u'", "'v'", "'w'", "'x'", "'y'", "'z'",
  "'!'", "'$'", "'%'", "'&'", "'('", "')'", "'*'", "';'", "'<'", "'>'",
  "'?'", "'@'", "'['", "']'", "'^'", "'_'", "'{'", "'|'", "'}'", "'~'",
  "' '", "'\\n'", "'\\r'", "$accept", "input", "line", "comment",
  "command", "add_instruction", "subscribe_event", "unsubscribe_event",
  "map_instruction", "unmap_instruction", "remove_instruction",
  "get_instruction", "set_instruction", "create_instruction",
  "reset_instruction", "clear_instruction", "find_instruction",
  "move_instruction", "copy_instruction", "destroy_instruction",
  "load_instruction", "set_chan_instruction", "edit_instruction",
  "format_instruction", "modal_arg", "key_val_list", "buffer_size_type",
  "list_instruction", "send_instruction", "load_instr_args",
  "load_engine_args", "instr_load_mode", "device_index",
  "audio_channel_index", "audio_output_type_name", "midi_input_port_index",
  "midi_input_channel_index", "midi_input_type_name", "midi_map",
  "midi_bank", "midi_prog", "midi_ctrl", "volume_value", "sampler_channel",
  "instrument_index", "fx_send_id", "engine_name", "filename", "db_path",
  "map_name", "entry_name", "fx_send_name", "param_val_list", "param_val",
  "query_val_list", "query_val", "scan_mode", "boolean", "dotnum",
  "digits", "digit", "digit_oct", "digit_hex", "number", "path",
  "path_base", "path_prefix", "path_body", "stringval",
  "stringval_escaped", "text", "text_escaped_base", "text_escaped",
  "string", "string_escaped", "char", "alpha_char", "char_base",
  "escape_seq", "escape_seq_octal", "escape_seq_hex", "SP", "LF", "CR",
  "ADD", "GET", "MAP", "UNMAP", "CLEAR", "FIND", "FILE_AS_DIR", "MOVE",
  "COPY", "CREATE", "DESTROY", "LIST", "LOAD", "ALL", "NONE", "DEFAULT",
  "NON_MODAL", "REMOVE", "SET", "SUBSCRIBE", "UNSUBSCRIBE", "CHANNEL",
  "AVAILABLE_ENGINES", "AVAILABLE_AUDIO_OUTPUT_DRIVERS", "CHANNELS",
  "INFO", "AUDIO_OUTPUT_DEVICE_COUNT", "AUDIO_OUTPUT_DEVICE_INFO",
  "MIDI_INPUT_DEVICE_COUNT", "MIDI_INPUT_DEVICE_INFO",
  "MIDI_INSTRUMENT_MAP_COUNT", "MIDI_INSTRUMENT_MAP_INFO",
  "MIDI_INSTRUMENT_COUNT", "MIDI_INSTRUMENT_INFO",
  "DB_INSTRUMENT_DIRECTORY_COUNT", "DB_INSTRUMENT_DIRECTORY_INFO",
  "DB_INSTRUMENT_COUNT", "DB_INSTRUMENT_INFO", "DB_INSTRUMENT_FILES",
  "DB_INSTRUMENTS_JOB_INFO", "CHANNEL_COUNT", "CHANNEL_MIDI",
  "DEVICE_MIDI", "CHANNEL_INFO", "FX_SEND_COUNT", "FX_SEND_INFO",
  "BUFFER_FILL", "STREAM_COUNT", "VOICE_COUNT", "TOTAL_STREAM_COUNT",
  "TOTAL_VOICE_COUNT", "TOTAL_VOICE_COUNT_MAX", "GLOBAL_INFO",
  "INSTRUMENT", "INSTRUMENTS", "ENGINE", "ON_DEMAND", "ON_DEMAND_HOLD",
  "PERSISTENT", "AUDIO_OUTPUT_DEVICE_PARAMETER", "AUDIO_OUTPUT_DEVICES",
  "AUDIO_OUTPUT_DEVICE", "AUDIO_OUTPUT_DRIVER_PARAMETER",
  "AUDIO_OUTPUT_DRIVER", "AUDIO_OUTPUT_CHANNEL_PARAMETER",
  "AUDIO_OUTPUT_CHANNEL", "AUDIO_OUTPUT_TYPE",
  "AVAILABLE_MIDI_INPUT_DRIVERS", "MIDI_INPUT_DEVICE_PARAMETER",
  "MIDI_INPUT_PORT_PARAMETER", "MIDI_INPUT_DEVICES", "MIDI_INPUT_DEVICE",
  "MIDI_INPUT_DRIVER_PARAMETER", "MIDI_INSTRUMENT", "MIDI_INSTRUMENTS",
  "MIDI_INSTRUMENT_MAP", "MIDI_INSTRUMENT_MAPS", "MIDI_INPUT_DRIVER",
  "MIDI_INPUT_PORT", "MIDI_INPUT_CHANNEL", "MIDI_INPUT_TYPE", "MIDI_INPUT",
  "MIDI_CONTROLLER", "SEND", "FX_SEND", "FX_SENDS",
  "DB_INSTRUMENT_DIRECTORY", "DB_INSTRUMENT_DIRECTORIES", "DB_INSTRUMENTS",
  "DB_INSTRUMENT", "DB_INSTRUMENTS_JOB", "INSTRUMENTS_DB", "DESCRIPTION",
  "FORCE", "FLAT", "RECURSIVE", "NON_RECURSIVE", "LOST", "FILE_PATH",
  "SERVER", "VOLUME", "LEVEL", "MUTE", "SOLO", "VOICES", "STREAMS",
  "BYTES", "PERCENTAGE", "FILE", "EDIT", "FORMAT", "MIDI_DATA", "RESET",
  "MISCELLANEOUS", "NAME", "ECHO", "QUIT", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,    35,    61,    44,    46,    43,    45,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      97,    98,    99,   100,   101,   102,    65,    66,    67,    68,
      69,    70,    39,    34,    47,    58,    92,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,    33,    36,    37,
      38,    40,    41,    42,    59,    60,    62,    63,    64,    91,
      93,    94,    95,   123,   124,   125,   126,    32,    10,    13
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   100,   101,   101,   102,   102,   102,   102,   103,   103,
     103,   103,   103,   104,   104,   104,   104,   104,   104,   104,
     104,   104,   104,   104,   104,   104,   104,   104,   104,   104,
     104,   104,   104,   104,   104,   105,   105,   105,   105,   105,
     105,   105,   105,   105,   105,   105,   105,   106,   106,   106,
     106,   106,   106,   106,   106,   106,   106,   106,   106,   106,
     106,   106,   106,   106,   106,   106,   106,   106,   106,   106,
     106,   106,   106,   107,   107,   107,   107,   107,   107,   107,
     107,   107,   107,   107,   107,   107,   107,   107,   107,   107,
     107,   107,   107,   107,   107,   107,   107,   107,   107,   108,
     108,   108,   108,   109,   110,   110,   110,   110,   110,   110,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   111,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   111,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   111,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   111,
     111,   111,   111,   111,   111,   111,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   112,   112,   112,   112,
     112,   112,   112,   112,   112,   112,   113,   113,   113,   113,
     113,   113,   114,   115,   115,   116,   116,   116,   116,   116,
     117,   117,   118,   118,   119,   119,   119,   120,   120,   121,
     121,   121,   121,   121,   121,   121,   121,   121,   121,   121,
     121,   121,   121,   122,   123,   124,   124,   125,   125,   126,
     126,   127,   127,   127,   127,   127,   127,   127,   127,   127,
     127,   127,   127,   127,   127,   127,   128,   129,   129,   130,
     131,   131,   131,   132,   133,   134,   135,   136,   136,   137,
     138,   139,   140,   141,   142,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   152,   153,   153,   153,
     153,   154,   154,   155,   155,   156,   156,   156,   157,   157,
     158,   158,   158,   159,   159,   160,   160,   160,   160,   160,
     160,   160,   160,   160,   160,   161,   161,   161,   161,   161,
     161,   161,   161,   162,   162,   162,   162,   162,   162,   162,
     162,   162,   162,   162,   162,   162,   162,   162,   162,   162,
     162,   162,   162,   162,   162,   163,   163,   163,   163,   163,
     163,   163,   163,   163,   163,   164,   164,   165,   166,   166,
     167,   167,   167,   168,   168,   169,   169,   170,   170,   170,
     170,   171,   171,   171,   171,   172,   172,   172,   172,   173,
     173,   174,   174,   174,   174,   175,   175,   175,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   176,   176,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     179,   179,   179,   180,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     2,     3,     0,     1,     1,     1,     1,     2,
       2,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     3,     9,    11,     7,
       9,     7,     9,     5,     7,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,    16,
      18,    18,    20,     7,     3,     3,     3,     5,     3,     3,
       1,     1,     5,     7,     9,     1,     5,     7,     9,     1,
       1,     5,     5,     7,     9,     7,     9,     1,     5,     7,
       5,     5,     5,     3,     1,     1,     1,     3,     3,     9,
       1,     5,     3,     7,     5,     3,     5,     5,     3,     5,
       5,     1,     1,     1,     5,     9,     7,     9,     7,     9,
       9,     3,     7,     9,    11,     9,     9,     7,     7,     7,
       7,     7,     3,     3,     3,     3,     5,     3,     5,     3,
       5,     7,     3,     3,     3,     7,     5,     7,     5,     3,
       5,     5,     5,     5,     3,     3,     5,     3,     3,     5,
       7,     5,     9,     5,     5,     5,     5,     5,     5,     5,
       5,     5,     5,     5,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     1,
       3,     5,     3,     5,     3,     5,    11,     5,     7,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     1,
       1,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       3,     4,     4,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     3,     3,     2,     1,     3,
       0,     2,     2,     3,     3,     3,     3,     1,     1,     2,
       2,     1,     1,     2,     2,     1,     1,     2,     2,     1,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       2,     3,     4,     3,     4,     1,     1,     1,     3,     3,
       3,     5,     5,     4,    11,     4,     4,     6,     7,     4,
       4,     3,     4,     7,     9,     6,     3,     9,    11,     7,
      17,    30,     8,     4,    25,    24,    23,    22,    25,    24,
      21,    20,    29,    28,    19,    18,    19,    23,    13,    12,
      11,    12,    13,    12,    11,    12,    11,    18,    17,    21,
      11,    10,    11,     6,     9,    14,    10,    29,    20,    19,
      29,    19,    30,    20,    17,    28,    27,    25,    18,    17,
      27,    15,    16,    19,    20,    17,    15,    18,    15,    10,
      15,     4,     7,     8,    23,    25,    14,    13,    18,    14,
      11,     5,     4,     9,    13,     4,     9,     6,     6,     5,
       4,     4,     6,     7,     5,    10,     4,     4,     6,     9,
       5,    13,     4,     4,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     7,     8,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    33,    34,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     1,   476,
     477,     2,     0,   458,     9,   446,   442,   441,   439,   440,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     394,   395,   396,   397,   398,   399,   368,   369,   370,   371,
     372,   373,   367,   443,   366,   374,   375,   376,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   431,   433,   434,   435,   436,
     437,   438,   444,   445,   447,   448,   449,   450,   451,   452,
     453,   454,   455,   456,   457,   475,   325,    11,    12,   359,
     420,   365,    10,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   478,     0,     0,     0,     0,     0,     0,
       0,   479,     0,     0,   480,     0,     0,     0,     0,     0,
     496,     0,     0,     0,     3,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   326,   283,   327,   328,   329,
     330,   331,   332,   333,   334,   432,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   360,     0,     0,     0,
      13,    35,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    16,     0,   110,   115,   127,   134,
     135,   136,     0,   119,     0,     0,     0,     0,     0,   111,
       0,   120,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,   152,
     153,     0,     0,    14,     0,    15,     0,     0,    26,     0,
       0,     0,    27,     0,     0,     0,     0,    28,     0,     0,
      29,     0,     0,     0,     0,     0,    17,     0,     0,     0,
      18,     0,     0,     0,     0,     0,     0,     0,    19,   224,
     226,   223,   221,   225,   222,     0,   229,     0,     0,     0,
       0,     0,    20,     0,     0,    21,     0,     0,     0,     0,
       0,     0,     0,     0,    22,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    23,    47,
      48,    49,    50,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    51,    52,    53,    57,    58,    59,    56,    55,
      54,    70,    71,    72,    69,    24,    73,    74,    75,    76,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    77,
      78,    79,    83,    84,    85,    82,    81,    80,    96,    97,
      98,    95,    32,     0,    30,     0,     0,    31,   214,    25,
       0,     0,   486,     0,     0,   587,   483,     0,   489,   490,
     485,   594,     0,     0,   561,     0,     0,     0,   284,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   482,     0,     0,     0,     0,   590,     0,   481,
       0,     0,     0,     0,     0,     0,    46,   262,     0,     0,
      36,   261,     0,     0,     0,     0,     0,     0,   277,   275,
     276,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   286,
     287,   288,   289,   290,   291,   292,   293,   294,     0,   137,
     250,   138,     0,     0,     0,     0,   142,   256,     0,   145,
       0,   148,     0,     0,     0,   133,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,     0,     0,     0,
       0,     0,     0,     0,     0,   189,     0,     0,     0,     0,
       0,     0,     0,     0,   177,   179,     0,   194,   195,     0,
       0,     0,     0,     0,   227,   228,   230,   232,     0,   234,
       0,     0,     0,     0,   197,     0,   260,     0,   198,     0,
     259,   104,   105,   106,     0,   108,     0,   109,     0,     0,
       0,     0,     0,     0,     0,   161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     173,   254,     0,   283,   255,   174,   175,   172,   278,   279,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   182,   487,     0,   588,
     495,     0,     0,     0,     0,     0,   355,     0,   356,     0,
     352,   361,   362,   468,   469,   351,     0,   338,     0,   340,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   586,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,     0,     0,     0,   575,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     593,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   488,     0,
       0,     0,     0,     0,   295,   296,   297,   298,   299,   300,
     301,   302,   465,   459,   460,   462,   461,   463,   464,   466,
     467,     0,   470,   354,   353,   345,   357,   358,   363,   364,
     346,   335,   337,     0,   336,     0,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   128,     0,     0,
       0,   219,   220,   130,   131,   132,   121,     0,   116,     0,
       0,     0,   122,     0,     0,   491,   141,   112,     0,     0,
     146,   144,   147,   149,   150,     0,     0,   154,     0,     0,
       0,     0,   251,     0,     0,     0,   188,     0,     0,   186,
       0,     0,     0,   190,   191,   192,   193,     0,     0,     0,
     176,     0,   178,   180,   253,   196,   258,     0,     0,     0,
       0,   231,   233,     0,   235,     0,     0,   257,     0,   239,
       0,   107,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   280,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   213,     0,     0,
       0,     0,     0,     0,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   473,   471,   341,   342,
     339,   572,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   533,     0,     0,   577,     0,     0,
     582,   578,   503,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   580,   581,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   281,   282,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   497,
       0,   499,     0,     0,   474,   472,     0,     0,     0,    44,
       0,    39,     0,    41,     0,     0,     0,     0,   499,     0,
     562,     0,   583,     0,     0,     0,     0,   129,   117,     0,
     125,     0,   113,     0,   123,   143,     0,     0,     0,     0,
     103,   252,     0,     0,     0,   271,   274,   273,   187,   185,
       0,     0,     0,   562,     0,     0,   439,   440,     0,     0,
     217,   265,   270,   269,   268,   267,   181,   264,     0,     0,
       0,     0,     0,     0,   237,     0,   571,     0,     0,     0,
       0,   199,   243,     0,   244,   201,   245,   203,     0,     0,
     210,   211,   212,   204,   246,   205,   247,   248,   206,   249,
       0,   207,   208,   209,   156,     0,   158,     0,   162,     0,
     579,     0,     0,     0,     0,     0,     0,   168,   167,     0,
     170,   171,   169,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   502,     0,   563,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   348,   347,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   498,     0,     0,     0,     0,     0,     0,    40,
      42,    37,     0,     0,     0,     0,     0,     0,     0,     0,
     584,     0,   118,   126,   124,   114,   139,     0,   155,     0,
       0,     0,     0,   272,     0,     0,     0,     0,   218,   343,
     350,   349,   344,   266,     0,     0,     0,     0,     0,   238,
       0,     0,     0,     0,   200,     0,     0,     0,   157,   381,
     160,   159,     0,     0,     0,   165,   166,   163,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   531,     0,     0,
       0,     0,     0,   492,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   494,     0,   573,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,     0,   164,     0,   576,
       0,   524,     0,     0,     0,     0,   520,     0,     0,   530,
       0,     0,     0,     0,     0,   526,   589,   236,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   531,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   559,     0,     0,     0,     0,     0,     0,   521,   519,
       0,     0,   523,     0,     0,     0,   525,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   567,     0,     0,
       0,     0,     0,     0,     0,   532,     0,     0,     0,     0,
       0,   567,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   493,     0,     0,   570,     0,   518,     0,   522,
       0,     0,   591,     0,     0,   566,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   566,     0,     0,     0,     0,
       0,     0,     0,   585,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     569,     0,     0,   574,   484,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   556,   551,     0,     0,   551,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     552,     0,     0,     0,    99,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   500,     0,     0,     0,   549,
     555,     0,     0,     0,   528,     0,     0,     0,     0,   549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   556,
     558,   560,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   528,     0,     0,     0,     0,     0,     0,     0,   568,
       0,   548,     0,     0,     0,   527,     0,     0,     0,   100,
     101,   263,   240,   241,   242,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     515,     0,     0,     0,     0,     0,   553,     0,   539,   541,
       0,     0,     0,     0,     0,   553,     0,     0,     0,     0,
       0,     0,   539,     0,     0,     0,     0,     0,     0,   544,
       0,     0,     0,   514,     0,     0,     0,     0,     0,     0,
       0,   543,   538,     0,     0,     0,     0,     0,     0,   554,
       0,     0,     0,   102,     0,     0,     0,     0,     0,     0,
     557,     0,     0,     0,     0,     0,     0,   511,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   529,     0,     0,
       0,   516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   510,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   543,     0,     0,
       0,     0,     0,   507,     0,     0,   564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     517,     0,   506,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   505,     0,     0,
     509,     0,     0,     0,     0,   565,     0,   547,     0,     0,
       0,     0,   504,     0,     0,   508,     0,     0,     0,     0,
       0,   534,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   550,     0,   536,     0,   546,     0,     0,     0,     0,
       0,   545,     0,     0,     0,   513,     0,   540,     0,     0,
     537,   512,   542,   501,     0,   535
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    15,    16,    17,    18,   240,   378,   405,   293,   295,
     345,   254,   354,   316,   439,   298,   302,   307,   310,   320,
     342,   725,   434,   437,   661,  1070,  1020,   328,   432,   704,
     708,  2019,  1381,  1383,  1385,  1393,  1395,  1398,   639,  1051,
    1340,  1073,   760,   646,  1086,  1075,   709,   705,   590,   586,
    2020,  1366,  1360,  1361,  1056,  1345,   596,   767,  1362,   762,
     156,   982,  1176,   647,   591,   808,   809,   992,  1364,   587,
    1477,   798,  1347,  1365,   800,   159,   160,   161,   802,   803,
     804,   805,    61,    62,    19,    20,    21,    22,    23,    24,
    1001,    25,    26,    27,    28,    29,    30,  1397,  1391,  1392,
     597,    31,    32,    33,    34,   241,   256,   257,   258,   615,
     379,   380,   381,   382,   383,   384,   385,   386,   387,   388,
     389,   390,   675,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   259,   260,   261,   403,   343,   658,   262,
    2022,  2023,  2024,   356,   263,   264,   265,   266,   267,   268,
     728,   269,   358,   270,   271,   272,   273,   274,   275,   242,
     277,   278,   279,   732,   733,   734,   748,    35,   280,   281,
     243,   283,   244,   285,   286,   438,   752,   716,   598,   599,
     600,   305,   756,   287,   288,   749,   736,   737,   289,   290,
    1021,  1022,   291,    36,    37,   783,    38,   404,   743,   367,
      39
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -1411
static const yytype_int16 yypact[] =
{
     133, -1411, -1411,    28,   380,    37,    68,   239,   216,   381,
     188,    20,   241,   102,   264,   312,   461,  2554, -1411,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257, -1411,
     363,   326,   392,   342,   393,   414,   435,   443,   470,   462,
     503,   490,   515,   506,   108,   347,   549,   402, -1411, -1411,
   -1411, -1411,   498, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411,   894,   894,   894,   894,   894,   894,   894,   894,   894,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,  3312, -1411,
   -1411, -1411, -1411,   211,   172,   591,   591,   615,   123,   635,
     635,   343,   343,   378,   348,   351,   426,   726,   726,   643,
     643,   645,   643, -1411,   656,   636,   667,   647,   652,   698,
     685, -1411,   684,   708, -1411,   711,   692,   699,   718,   721,
   -1411,   702,   730,   707, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411,   894, -1411,   894,   894,   894,
     894,   894,   894,   894,   894, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411,   722,   732,   725,
   -1411, -1411,   257,   257,   257,   543,   723,   738,   724,   270,
     731,    76,   727,   728, -1411,   257, -1411, -1411, -1411, -1411,
   -1411, -1411,   257, -1411,   257,   257,   257,   257,   257, -1411,
     257, -1411,   257,   257,   257,   257,   257, -1411,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257, -1411, -1411,
   -1411,   257,   735, -1411,   257, -1411,   257,   741, -1411,   257,
     744,   737, -1411,   257,   257,   257,   750, -1411,   257,   257,
   -1411,   257,   257,   733,   729,   746, -1411,   257,   257,   257,
   -1411,   257,   257,   257,   562,   748,   298,   762, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411,   257, -1411,   257,   257,   257,
     257,   743, -1411,   257,   257, -1411,   257,   257,   257,   257,
     752,   761,   765,   756, -1411,   257,   257,   257,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   767,   768,
     782,   440,   769,   779,   783,   774,   793,   795, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411,   257, -1411,   257,   797, -1411, -1411, -1411,
     257,   778, -1411,   792,   799, -1411, -1411,   817, -1411, -1411,
   -1411, -1411,   796,   803, -1411,   827,   811,   832, -1411,   819,
     770,   831,   597,   606,   493,   836,   835,   840,   775,   833,
     826,   777,   842,   837,   838,   839,   429,   158,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   571,   848,
     848,   848,   848,   924,   848,   248,   248,   848,   848,   848,
     849,   861,   847,   924,   866,   571,   802,   850,   284,   284,
     867,   805,   606,   606,   606,   606,   869,   809,   873,  3312,
    3312,   924,   924,   924,   924,   885,   898,   834,   896,   571,
     924,   248,   248,   888,   883,   352,  3312,   924,   571,   302,
     606,   915,   907,   917,    53,   924,   924,   924,   924,   903,
     186,   346,   386,   865,   924,   924,  3406,   919,   918,   926,
     862,   901,   864,   913,   150,   911,   910,   922,   920,   923,
     916,   924, -1411,   934,   921,   925,   937, -1411,   929, -1411,
     930,   927,   935,   939,  2649,  2649, -1411, -1411,  1885,  1885,
   -1411, -1411,   931,   942,   938,   257,   257,   257, -1411, -1411,
   -1411,   941,   943,   944,   950,   951,   961,   945,   953,   946,
     963,   969,   968,   948,   956,   257,   257,   257,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257,   894,
     894,   894,   894,   894,   894,   894,   894,   894,   955, -1411,
   -1411, -1411,   257,   257,   257,   257, -1411, -1411,   257, -1411,
     257, -1411,   257,   257,   257, -1411,   957,   257,   257,   965,
     960,   924,   257,   257,   967, -1411, -1411,   970,   952,   962,
     257,   257,   257,   257,   984, -1411,   976,   257,   257,   257,
     257,   979,   971,   980,  2744,  2744,   257, -1411, -1411,   257,
     985,   981,   974,   987, -1411, -1411, -1411, -1411,   257, -1411,
     257,   983,   257,   978, -1411,   257, -1411,   257, -1411,   257,
    3312, -1411, -1411, -1411,   988, -1411,   257, -1411,   993,   991,
     998,   989,   234,  1001,  1004, -1411,   257,   257,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
     257,   257,  1012,   257,   999,  1021,  1013,   257,   257,   257,
     257,  1027,   257,   257,  1019,   257,   257,   257,   894,   894,
   -1411, -1411,   781,    42, -1411, -1411, -1411, -1411, -1411,  3312,
    1022,  1029,  1018,  1024,  1025,  1016,  1039,  1031,  1040,  1042,
    1047,  1046,  1036,   257,   257,  1026, -1411, -1411,   914, -1411,
   -1411,  1038,  1050,  1035,  1049,  1003, -1411,   449,  3029,  2078,
    4252, -1411, -1411, -1411, -1411, -1411,  2269, -1411,  1048, -1411,
    1062,  1066,  1074,  1057,  1078,   606,   520,   502,  1064,  1071,
    1070,  1072,  1075, -1411,  1085,  1028,  1091,  1096,  1081,  1094,
    1083,  1097,   924,   189,   924,   924,  3312,   924,  3312,  3312,
     924,   924,   924,   924,  3312,   924,  1088,   924,  3312,   924,
     924,   606,   606,   606,   606,   924,  1082,   848,   606,  1041,
    1090,   257, -1411,   924,  1043,  1092, -1411,  1093,  3312,   606,
    3312,   606,  1051,  1095,   606,   606,   606,   606,  1087,  1108,
    1052,  3312,  3312,   924,   924,  1101,  1098,  1110,  1055,   606,
     606,  1100,   606,  1079,   924,   606,   924,  1102,   606,  1106,
   -1411,  1060,  1112,  1124,  1105,  1114,  1115,   924,   924,   924,
     924,   924,   924,   924,   924,   924,   924,   924,   924,  3312,
     924,  3312,   924,  1116,   924,  1129,  1133,  1131,   924,   924,
     924,   924,  1137,   606,   606,  1145,   606,   606,   606,   798,
     818,   894,  1143,  1159,  1146,  1147,  1164,  1166,  1168,  1107,
    1167,  1174,  1160,  1173,  1175,  3312,   924,  1157, -1411,  1179,
    1161,  1177,  1162,  1169, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411,  1153,   663,  4252, -1411, -1411, -1411,  3029, -1411, -1411,
   -1411, -1411,  2839,  1176, -1411,  1163,  1120,  1172,   257,  1180,
     257,   257,   257,   257,  1122,  1189,  1194,  1181,  1199,  1187,
    1193,  1185,  1191,  1144,  1186,  1207,  1195, -1411,  1183,  1209,
     257, -1411, -1411, -1411, -1411, -1411, -1411,  2744,  3312,   257,
     257,   257, -1411,  2744,   257, -1411, -1411,  3312,   257,   257,
   -1411, -1411, -1411, -1411, -1411,  1196,   257, -1411,  1202,  1151,
     924,   257, -1411,  1205,  1198,  1156,   257,  3500,   257,   257,
     257,  1206,  1200, -1411, -1411, -1411, -1411,  1158,  1208,  1214,
     257,  3594,   257,   257, -1411, -1411, -1411,  1165,  1224,  1211,
    1217, -1411, -1411,  1216, -1411,  1210,   257, -1411,   257, -1411,
    1230, -1411,  1182,  1233,  1236,  1237,  1247,  1234,   257,   257,
     257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
    3688,   257,  3782,   257,  1248,   257,  1245,  1255,  1249,   257,
     257,   257,   257,  1258,   257,   257,  1257,   257,   257,   257,
     894,   894,   894,  1197,  1242,  1261,  1243,  1270,  1260,  1259,
    1263,  1264,  1262,  1215,  1218,  1269,  2744, -1411,  1266,  1279,
    1274,  1276,  1271,  1275, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411,  1153,   663, -1411,  3029,
   -1411, -1411,   165,  1277,   924,  1280,   606,   606,   606,   520,
    1281,  1297,  1285,  1278, -1411,  1300,  1286, -1411,  1284,   450,
   -1411, -1411, -1411,  1288,  1287,   924,  3312,   924,   924,   924,
    3312,   924,   924,   924,  1291,   606,  1290,  1293,   257,   924,
    1296,  1295,  1298,  3312,  2174,  3312,  3312,  1307,  1302,  1308,
    1325,  1312,  3312,  3124,   597,  1316,  1315,  1333,  1319,  1317,
    1321,   924,   924,  1337,  1323,  1326,  1324,  1282, -1411, -1411,
     924,   924,  3312,   924,   176,   924,   571,  3312,   924,   865,
    3406,  3406,  3124,  3312,  3124,  3312, -1411,   597,  1327,  1329,
    1283,   924,   924,   924,   924,  1332,   597,   597,  1292,   597,
     606,   597,   894,   894,  1328,  1294,  1335,  1338,  1299,  1353,
    1309,  1341,  1345,  1310,   466,  1361,  1311,   924,  1347, -1411,
    1367, -1411,  1351,  1355, -1411, -1411,  1360,  1370,  1357, -1411,
    1377, -1411,   257,   257,   257,   257,  1358,  1366,  1362,  1365,
    1371,   481, -1411,  1364,  1376,  1380,  1387, -1411,  2744,   257,
   -1411,   257,  2744,   257, -1411, -1411,  1372,   257,  1373,   924,
   -1411, -1411,  1375,  1378,  3876, -1411, -1411,  2934,   257,   257,
    1379,  1381,  1374, -1411,  1385,  3970,   894,   894,  2744,  2744,
    1421, -1411, -1411, -1411, -1411,  3312, -1411, -1411,  1382,  1362,
    1371,   512,  1383,  1405, -1411,   257, -1411,  1386,   522,  1344,
    1399, -1411, -1411,   257, -1411, -1411,  3312, -1411,  1409,  1395,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,  3312,
     257, -1411, -1411, -1411,  1421,  4064,  1421,  4158, -1411,  1349,
   -1411,  1414,   257,   257,   257,   257,  1404, -1411, -1411,  1398,
   -1411, -1411, -1411,  1394,  1415,  1356,  1401,  1407,  1369,  1408,
     523,  1426,  1425,  1412,  1417,  1435,   257,  1424,  1437,  1418,
    1420,  1436,  1440,  1432,  1384,   606,   924,   606,   606,  1422,
    1447, -1411,  1427, -1411,  1428,  1430,  1433,  1443,  1434,  1454,
    3312,  3312,  3312,  3312,   924,  1444,   924,  1438,   257,  1439,
    1441,  2174,  1445,  1442,  1446,  1448,  3124,  2364,  3312, -1411,
    2459,  3124,  1450,  1451,  1453,  1455,  1463,   924,  1458,  1461,
    1449,  1469,   924,  1460,  1470,   924,  3124,  3218,  1452,  1471,
     924,   924,   865,   597,  1472,  1491,  1473,  1482,   405,  1475,
    1483,   115,  1480,  1476,  1493,  1486,  1499,  1507,  1496,  1523,
     924,  1512, -1411,  1508,  1509,  1532,  1510,  1511,  1533, -1411,
   -1411, -1411,   257,  1516,  1474,  1521,  1515,  1522,  1456,  1543,
   -1411,  1528,   257,  3312,  3312,   257, -1411,  1544, -1411,  1525,
    3312,  1527,  1534, -1411,  1530,  1536,  1535,  1526,  1421, -1411,
    3312, -1411, -1411, -1411,  1537,  1538,  1539,  1552,  1541, -1411,
    1540,  1542,  1545,   528, -1411,  1558,  1555,   257,  1421,  1395,
    1421, -1411,  1546,  1549,   257, -1411, -1411, -1411,  1550,  1551,
    1553,  1547,  1557,  1559,  1556,  1561,  1576,  1562,  1564,  1575,
    1563,  1566,  1581,  1565,  1584,  1571,  1567,   257,  1568,  1589,
    1569,  1580,  1577,  1593,  1578,   606,  1573,   246,  1596,  1548,
    1579,  1602,  1599,  1582,  1590,  1585,   257,  1586,  1603,  1587,
    1605,  1588,  1554,  1594,  1570,  1597,  1600, -1411,  1598,  1572,
    1591,  1604,  1606, -1411,   571,  1601,  1608,   924,  1611,  1609,
    1610,  1612,  1615,  1628,  1631,  1633,  1629,  1616,  1638,  1625,
    1583,  1621,  1632,  1630,  1648,  1634,  1653,   924,  1636,  1637,
    1639, -1411,  1640, -1411,  1595, -1411,  1641,  1635,  1644,  1651,
    1649,   190,  1652,  1654,  1607,  1657,  1642,  1655,   606,  1658,
    1650,  1659,  1656,  1646,  1674,  1660,  1675,  1662,  1661,  1663,
     214,  1666,  1664,  1665, -1411,  1669,  1668, -1411,  1673, -1411,
    1670, -1411,  1678,  1679,  1667,  1681, -1411,  1682,  1683, -1411,
    1680,  1676,  1672,  1677,  1643, -1411, -1411, -1411,  1647,  1688,
    1700,  1692,  1703,  1685,  1704,  1671,  1711,  1691,   112,  1697,
    1715,  1686,  1718,  1710,  1699,  1719,   257,  1720,  1701,  1722,
    1705,  1687,  1723,  1689,  1724,  1726,  1699,  1693,  1727,  1713,
    1708,  1694,  1714,  1709,  1716,  1721,  1695,  1725, -1411, -1411,
    1730,  1734, -1411,  1736,  1739,  1740, -1411,  1742,  1744,     1,
    1746,  1741,  1752,   614,  1753,  1755,  1756,    39,  1745,  1757,
    1750,  1758,  1771,  1759,  1770, -1411,  1761,   924,  1763,    46,
    1764,  1728,  1772,  1751,  1782,  1760,  1769,   619,  1762,  1767,
    1766,   269, -1411,  1768,  1775, -1411,  1790, -1411,    52, -1411,
    1773,  1777, -1411,  1778,  1795, -1411,  1798,  1774,  1800,  1783,
    1794,   148,  1788,  1791,  1747,  1748,  1805,  1797,  1785,  1792,
    1793,  1796,  1787, -1411,  1799,   257,  1801,  1815,  1802,  1816,
    1806,  1817,  1809,  1803,  1812,  1824,  1818,  1808,  1776,  1821,
    1810,  1807,  1779,  1814,  1830,  1780,   213,  1822,  1813,  1823,
   -1411,  1825,  1781, -1411, -1411,  1840,  1826,  1828,  1784,  1845,
    1838,  1839,  1841,  1853,  1852,  1804,    74,  1832,  1842, -1411,
     865,  1835,  1846,  1811,  1836,  1859,  1837,  1862,    81,  1865,
    1843,  1864,  1804,   127,  1867,  1849,  1848,  1870,  1871,  1850,
    1860,  1873,  1881,  1918,  1876,  1872,  1919,  1917,  1923,  1924,
    1928,  1925,  1930,  1920,  1926,  1931,  1932,  1948,  1933,  1936,
   -1411,  1940,  1935,  1934,   257,  1937,  1955,  1950,  1957,  1951,
    1962,  1952,  1949,  1958,  1964,  1960,  1941,  1956,  1953,  1969,
    1959,  1965,  1961,  1954,  1963,  1970,  1978,   445,  1966,  1979,
    1984,  1968,  1985,  1987,  1967, -1411,  1973,  1988,  1990,  1972,
    1922,  1996,  1997,  1974,  1938,   444,  1995,  1989,  1998, -1411,
    1999,  1972,  2003,  1991,  2004,  1939,  2007,  1992,  1993, -1411,
   -1411, -1411,  2006,  2009,  2000,  2010,  1994,  1971,  2001,  2005,
    2015, -1411,  2014,  2002,  2013,  2017,  2008,  2012,  2016, -1411,
    2022, -1411,  2011,  2018,  2019, -1411,  2021,  2024,  2023,   257,
   -1411, -1411, -1411, -1411, -1411,  2026,  2027,  2025,  2028,  2029,
    2030,  2040,  2031,  2032,  2041,  2042,  2043,  1982,  2251,  2050,
   -1411,   178,  2346,  2020,  2033,  2441, -1411,  2038,  2537,  2495,
    2635,  2632,  2726,  2751,  2845,  2823,  2940,  2875,  3013,   597,
    3012,  3033, -1411,  2537,  2823,  3302,  3253,  3412,  3395, -1411,
    3490,  3441,  3587, -1411,  3577,  3675,  3677,  3770,  3863,  3723,
    3864,  3910, -1411,  3957,  4045,  4005,  4145,  4143,  4241, -1411,
    1626,  4256,  4237, -1411,  4304,  4301,  3910,  4305,  4306,  4322,
   -1411,   275,  4309,  4310,  4307,  4325,  4311, -1411,   360,  4312,
    4313,  4331,  4314,  4333,  4315,  4339,  4336, -1411,  4337,  4329,
    4321, -1411,  4344,  4345,  4330,  4328,  4332,  4343,  4327,  4334,
    4335, -1411,  4338,  4340,  4324,  4351,  4341,  4289,  4342,   244,
    4348,  4346,  4349,  4350,  4347,  4352,  4354, -1411,  4353,  4356,
    4357,  4355,  4358, -1411,  4360,  4362, -1411,  4359,  4368,  4366,
    4364,  4371,  4375,  4376,  4372,  4363,  4383,  4382,  4370,  4373,
   -1411,  4290, -1411,  4377,  4374,  4389,  4379,  4369,  4378,  4367,
    4381,  4380,  4385,  4390,  4384,  4386,  4387, -1411,   404,  4388,
   -1411,  4391,  4393,  4394,  4395, -1411,  4396, -1411,  4403,  4397,
    4405,  4409, -1411,  4398,  4400, -1411,  4410,  4392,  4399,  4401,
    4402,  4293,  4404,  4406,  4407,  4408,  4414,  4411,  4416,  4417,
    4413, -1411,  4415, -1411,  4418, -1411,  4419,  4412,  4422,  4420,
    4421, -1411,  4425,  4423,  4424, -1411,  4427, -1411,  4428,  4430,
   -1411, -1411, -1411, -1411,  4429, -1411
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
   -1411, -1411, -1411, -1411, -1411,  -848, -1411, -1411, -1411, -1411,
   -1411, -1411,  -812, -1410, -1411,   550,   408, -1411,  -452, -1007,
   -1295,   558, -1258,   624, -1153, -1126,  -807,  -788,  -440,  3121,
    2365,  2957, -1186,  2983,  -786,  2994,  3649,  -611,  -530,   -13,
     286,  -943,  3291,     9,  -490,  3884, -1411, -1411, -1411, -1196,
    3117,  -774,    67,   511,  -776,   266,    77,  -417,  -760, -1411,
   -1411,   -17,  4426, -1411, -1411, -1411, -1411, -1411, -1411, -1411,
    3289, -1411, -1411, -1411, -1411, -1411, -1411,  -355,  2982, -1411,
    -377, -1411, -1411, -1411, -1411,   191,  4308,  4316,  4317,  -370,
    4302,  4318,  4319,  4320,  4323,  4326,  4361,  4365,  4431,  4432,
    4433,  4434, -1411,  4435,  4436,  4437,  4438,  4439,  4440,  4441,
    -141,  -126,  -124,   509,   526, -1411,  4442,  -451,  3949,  4447,
   -1411, -1411, -1411, -1411,  4449,  -136, -1411, -1411,  4448,   -64,
   -1411,  4450, -1411,  4451,  4452,  -125, -1411,   540,   349,  -134,
    4453, -1411,  3939, -1411, -1411, -1411, -1411, -1411,   368,  4455,
     525,   327,   -70,   373, -1411, -1411,  3932, -1411, -1411,  -360,
     199, -1411, -1411, -1411,  -143, -1411, -1411, -1411,  4454,  4456,
   -1411, -1411,  4458, -1411, -1411, -1411, -1411,  4457,    41, -1411,
   -1411
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -326
static const yytype_int16 yytable[] =
{
     162,  1401,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   983,   761,   595,   987,   157,   998,  1346,  1025,
     276,  1309,   987,   364,  1072,   317,   321,   425,  1367,  1177,
     989,   347,   360,  1218,  1468,   706,   318,   322,  -325,   657,
    1825,   663,   426,   665,   427,   649,   651,    40,   215,   217,
     218,   219,   220,   221,   222,   223,   224,    44,   670,   672,
    1047,    53,   677,   678,   679,   680,  1404,   694,  1406,   721,
    1417,  1418,  1574,  1420,  1059,  1422,   712,  1335,  1835,  1375,
    1584,   697,   699,  1826,   284,  1825,   722,    45,   304,   715,
     717,  1865,   723,   339,  1084,   724,   473,  1088,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   628,   784,   642,
     643,   644,   645,  1930,   648,   662,   474,   653,   654,   655,
    1930,  1836,    55,   641,     1,   650,   652,     2,  1847,  -325,
    -325,  -325,  1788,  1597,  1866,  1412,  1413,  1414,  1415,  1128,
     666,   197,   300,    56,  1598,  1945,  1849,   198,   707,     3,
    1789,     4,     5,     6,     7,   301,  1931,   801,   801,  1546,
       8,   698,   700,  1941,   695,     9,    10,  1946,  1876,   777,
      11,    12,    13,   713,    14,   369,   205,   629,   630,   631,
     632,   633,   634,   635,   636,   637,  1877,   614,   245,   778,
     246,   247,   248,   249,  1333,  1388,  2075,   375,  1306,   861,
     377,   983,   744,  1307,    51,   250,  1018,  2076,  1179,  1738,
    1389,   251,   252,   989,   253,   462,   463,   464,   745,   746,
     742,    -4,    -4,    52,  1305,  1019,  1739,  1707,   477,   237,
     238,  1911,  1912,  1758,  1586,   478,    48,   479,   480,   481,
     482,   483,  1913,   484,   239,   485,   486,   487,   488,   489,
    1759,   490,   491,   492,   493,   494,   495,   496,   497,   498,
     499,    54,  1677,   903,   500,  1346,  1678,   502,    46,   503,
     588,   589,   505,  2161,    47,   904,   508,   509,   510,  1679,
    1558,   512,   513,  1530,   514,   515,   594,  1859,  1752,  2156,
     519,   520,   521,  2125,   522,   523,   524,  1367,    57,   470,
    1578,  1580,    58,  1548,  2126,  1860,   588,   589,   529,  1861,
     530,   531,   532,   533,   471,   706,   535,   536,   669,   537,
     538,   539,   540,   714,   588,   589,   616,   470,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,   555,
     556,   617,   527,   618,   155,   255,   184,   216,   216,   216,
     216,   216,   216,   216,   216,   216,   346,   355,   706,   313,
     433,   435,   186,   440,   314,   751,  1000,  1002,   248,   237,
     306,   801,   801,   988,   588,   589,   315,   341,  2132,   801,
     742,   199,   183,  1034,   239,  1036,   660,   200,  1311,  2133,
    1313,   735,   706,   983,   324,   706,   325,   300,   726,   326,
     730,  1040,  1041,  1042,  1043,   751,   568,   754,   569,   729,
      49,   327,    41,   571,   236,    42,    50,  1337,    43,  1058,
     742,  1060,  2203,  1592,  1063,  1064,  1065,  1066,   185,  1348,
    1349,  1387,   187,  2204,  1593,   202,  1400,   706,  1594,  1081,
    1082,   203,   350,   188,   237,   306,   351,   314,  1091,   964,
     965,   966,   967,   968,   969,   970,   971,   560,   612,   352,
     561,   613,  1115,  1998,   972,   353,   584,   585,   253,   189,
     727,   973,   974,   975,  1999,   976,   747,  1046,  2000,  2017,
    2018,   190,  1421,  1124,  1125,   303,  1127,   640,  1129,  1323,
     338,   458,  1324,   458,   458,   458,   458,   458,   458,   458,
     458,   192,   640,   977,   640,  1323,   299,   978,  1433,   979,
     191,   980,   335,   981,   592,   588,   589,  1454,   158,   193,
    1455,   687,   688,   592,   588,   589,   194,   593,   640,   319,
     323,   594,   309,   312,   361,   196,   669,   640,   349,   363,
     594,   999,   588,   589,   738,   739,   740,   741,  1483,    59,
      60,  1484,   764,   765,   766,   768,   988,   195,  1489,  1513,
     801,  1440,  1514,   987,  1641,   801,   201,  1440,   815,   816,
     817,   205,   629,   630,   631,   632,   633,   634,   635,   636,
     637,   750,   753,   757,   465,   466,    59,   638,   832,   833,
     834,   835,   836,   837,   838,   839,   840,   841,   842,   843,
     844,   845,  1542,   525,   466,  1545,   215,   217,   218,   219,
     220,   221,   222,   223,   224,   847,   848,   849,   850,   584,
     585,   851,  1934,   852,   292,   853,   854,   855,   588,   589,
     857,   858,  1830,  1831,  1845,   862,   863,  1854,  1855,  1402,
    1403,   799,   806,   868,   869,   870,   871,  1529,   297,  1531,
     874,   875,   876,   877,   306,   810,   810,   881,   882,   883,
     640,   237,   884,   964,   965,   966,   967,   968,   969,   970,
     971,   889,   441,   890,   436,   892,   401,   428,   894,   282,
     895,   442,   896,   443,   308,   311,   706,   444,   706,   898,
     348,   362,   445,   402,   429,   294,   296,   671,   673,   907,
     908,   909,   910,   911,   912,   913,   914,   915,   916,   917,
     918,   919,   920,   921,   922,   706,   924,   446,   447,   761,
     928,   929,   930,   931,   448,   933,   934,   449,   936,   937,
     938,   450,   451,  1626,   452,   939,   940,  1312,   453,  1314,
     454,   455,   368,   369,   370,   371,   456,   372,   457,   460,
     459,   467,   801,   373,   461,   468,   955,   956,   469,   374,
     472,   506,   475,   476,   501,   375,   376,   511,   377,  2021,
     504,   984,   507,   517,   516,   518,   526,   534,   941,   542,
     706,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,   528,  1390,   541,   543,  1130,   474,   801,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   557,   558,
     559,   563,   564,   562,   565,  1131,   572,  1675,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   566,   763,
     567,   570,   573,   575,  1050,   581,  1026,   574,   576,  1029,
    1030,  1031,  1032,   577,   640,   578,   640,   579,  1038,   580,
     583,   602,   582,  2021,  1044,   601,   603,   604,   606,   607,
     605,   608,  1052,   758,   759,   205,   629,   630,   631,   632,
     633,   634,   635,   636,   637,   609,   610,   614,   656,   611,
     659,   660,  1074,  1076,   667,   664,   674,   676,   681,   668,
    1746,   682,   683,  1087,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   690,   216,   216,   216,   216,   216,
     216,   216,   216,   216,   691,   693,   692,   701,  1132,  1111,
     801,  1113,   703,   640,   205,   629,   630,   631,   632,   633,
     634,   635,   636,   637,   718,   719,   720,   742,   770,   771,
     236,   236,   772,   774,   773,   706,   775,   706,   776,   779,
     780,   781,   341,   782,   787,   785,   788,   790,   814,   958,
     984,   793,   761,   812,   794,   789,   236,   791,   795,   792,
     818,  1184,   819,  1186,  1187,  1188,  1189,   813,   820,   821,
     822,   823,   825,   827,   824,   828,   829,   846,   826,   830,
     831,   856,   866,  1205,   859,   860,   864,   867,  1532,   865,
    1206,   872,  1207,  1208,  1209,   873,  1210,  1211,   878,   880,
     879,  1212,  1213,   887,   885,   886,   888,   891,   893,  1215,
     684,   685,   899,   897,  1219,   236,   900,   901,   923,  1223,
     902,  1225,  1223,  1226,   216,   216,   905,   710,   458,   906,
     925,   926,   927,  1232,   801,  1232,  1234,   932,   935,  1052,
     943,   942,   944,   945,   946,   947,   948,   769,   950,  1241,
     949,  1242,   951,   952,   953,   954,   957,   959,   960,   961,
     991,  1250,  1251,  1252,  1253,  1254,  1255,  1256,  1257,  1258,
    1259,  1260,  1261,   962,  1263,   963,  1265,   993,  1267,   994,
     995,   996,  1271,  1272,  1273,  1274,   997,  1276,  1277,  1004,
    1279,  1280,  1281,  1005,  1006,  1009,  1007,  1282,  1283,  1008,
    1010,  1011,  1012,  1013,  1014,   706,  1015,  1085,  1016,  1297,
    1035,  1045,  1067,  1048,  1049,  1053,  1054,  1055,  1068,  1062,
    1079,  1094,  1078,  1061,  1069,   686,  1077,  1080,   689,  1083,
    1090,  1092,  1093,  1095,   696,  1096,  1097,   613,  1116,  1114,
    1118,   711,   984,  1154,  1155,  1156,  1157,  1158,  1159,  1160,
    1161,  1162,  1163,  1164,  1165,  1166,  1167,  1168,  1169,  1170,
    1171,  1172,  1173,  1174,  1175,  1117,  1123,  1126,  1133,  1134,
    1135,  1136,  1137,  1087,  1139,   786,  1138,  1141,   706,  1140,
    1142,  1339,  1143,  1144,  1145,  1148,  1149,  1151,  1153,  1150,
    1180,  1152,  1182,  1181,  1190,  1191,  1329,  1330,  1331,  1185,
    1052,  1334,  1076,  1183,  1192,   458,   458,   216,  1341,  1194,
    1193,  1195,  1196,  1197,  1198,  1200,  1199,  1201,  1203,  1204,
    1202,  1216,  1363,  1217,  1220,  1227,  1214,  1221,  1222,  1228,
    1229,  1087,  1230,  1231,  1236,  1237,  1238,  1235,  1243,  1382,
    1384,  1240,  1382,   640,  1394,  1396,  1239,  1382,   764,   768,
     768,  1363,  1245,  1363,  1244,  1246,  1247,  1248,  1266,  1249,
    1076,  1076,  1076,  1076,  1268,  1269,  1275,  1278,  1270,  1284,
    1285,  1286,  1287,   236,   236,  1445,  1446,  1447,  1448,   236,
    1288,  1290,  1291,   236,  1289,  1293,  1292,  1294,  1296,  1299,
    1295,  1460,  1461,  1300,  1462,  1463,  1464,  1298,  1301,  1303,
    1466,  1302,  1310,   236,  1317,  1308,  1316,  1318,  1319,  1320,
    1321,  1223,  1223,  1322,  1338,  1326,  1306,   236,  1325,  1336,
    1342,  1479,  1479,   939,   940,  1343,  1307,   710,  1341,  1027,
    1028,  1350,  1351,  1352,  1353,  1033,  1354,  1369,  1487,  1037,
     761,  1368,  1370,  1371,  1373,  1372,  1492,  1376,  1377,  1379,
    1378,  1410,  1409,  1423,  1380,  1411,   236,  1425,   236,  1057,
    1416,  1057,  1428,  1495,  1419,  1430,  1424,  1431,  1426,  1434,
    1437,  1427,  1071,  1071,  1438,  1500,  1501,  1502,  1503,  1439,
    1442,  1429,  1432,  1435,  1440,  1441,  1443,  1444,  1450,  1449,
    1458,  1451,   236,  1452,  1456,  1459,   216,   216,   458,  1520,
    1453,  1457,  1467,  1465,  1469,  1474,  1470,  1481,  1472,  1473,
    1110,  1475,  1112,  1482,  1485,  1486,  1490,  1488,  1491,  1493,
    1494,  1498,  1499,  1504,  1505,  1506,  1507,  1512,  1508,  1509,
    1510,  1550,  1515,  1516,  1521,  1087,  1017,  1517,  1023,  1024,
    1561,  1511,  1518,  1561,  1519,  1525,  1146,  1522,  1526,  1523,
    1524,  1527,  1533,  1341,  1039,  1087,  1528,  1534,  1535,  1536,
    1537,  1538,  1539,  1540,  1541,  1363,  1621,  1547,  1549,  1551,
    1363,  1575,  1552,  1555,  1572,  1554,  1556,  1582,  1567,  1557,
    1564,  1384,  1565,  1566,  1394,  1363,  1363,  1568,  1570,  1384,
    1074,   764,  1571,  1573,  1576,  1615,  1583,  1589,  1588,   763,
    1089,  1591,  1596,  1590,  1599,  1232,  1595,  1600,  1232,  1607,
    1602,  1098,  1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,
    1107,  1108,  1109,  1601,  1603,   763,  1604,  1605,   763,  1606,
     763,  1609,  1119,  1120,  1121,  1122,  1608,  1610,  1611,  1614,
    1644,  1612,  1616,  1613,  1618,  1619,  1617,  1647,   458,   458,
    1620,  1622,  1623,  1625,  1624,  1627,  1632,  1628,  1629,  1630,
    1147,  1631,  1636,  1633,  1642,  1643,  1638,  1635,  1634,  1651,
    1667,  1637,  1639,  1646,   236,  1654,  1640,  1645,   236,  1650,
    1648,  1649,  1652,  1653,  1655,  1656,  1659,  1657,  1658,  1688,
     236,  1662,  1664,  1660,  1661,  1665,  1663,  1666,  1668,  1669,
    1670,   236,  1671,  1673,  1676,  1672,  1680,  1674,  1683,  1684,
    1682,   236,  1685,  1690,  1686,  1692,  1687,  1689,  1691,  1693,
    1681,  1701,   216,   216,  1698,  1695,  1694,  1709,  1697,  1699,
    1708,  1705,   236,  1396,  1711,  1702,  1384,  1703,  1706,  1713,
    1714,  1710,  1696,  1715,  1700,   236,  1712,  1717,  1716,  1718,
    1719,   236,  1721,   236,  1723,  1720,  1727,  1722,  1724,  1726,
    2117,  1729,  1730,  1743,  1725,  1728,  1734,  1732,  1735,  1731,
    1736,  1733,  1744,  1737,  1748,  1740,  1751,  1741,  1745,  1742,
    1750,  1747,  1749,  1752,  1754,  1755,  1769,  1762,  1785,  1773,
    1753,  1756,  1760,  1757,  1761,  1763,  1764,  1328,  1765,  1774,
    1766,  1332,  1767,  1775,  1768,  1770,  1771,  1776,  1772,  1797,
    1780,  1781,  1782,  1784,  1344,  1777,  1057,  1057,  1779,  1778,
    1786,  1787,  1790,  1355,   236,  1791,  1793,  1794,  1795,  1796,
    1798,  1799,  1800,  1803,  1805,  1801,  1806,  1808,  1809,  1810,
    1813,  1814,   763,  1386,  1812,  1815,  1820,   763,  1399,  1821,
    1823,   769,   769,  1824,  1405,  1817,  1407,  1783,  1792,  1802,
    1818,  1804,   763,   763,  1819,  1807,  1811,  1816,   763,  1822,
    1827,  1829,  1832,  1828,  1833,  1834,  1838,  1837,  1839,  1841,
    1843,  1849,  1840,  1850,  1842,  1844,  1087,  1846,  1848,   236,
     236,  1851,  1852,  1853,  1856,  1857,  1858,  1863,  1862,  1864,
    1826,  1868,  1870,  1869,  1872,  1867,   236,  1871,  1890,  1327,
    1873,  1874,  1875,  1878,  1882,  1879,  1883,  1884,  1888,  1880,
    1881,  1887,  1885,  1886,  1892,  1895,  1894,  1896,  1897,  1889,
    1899,  1891,  1893,  1898,  1900,  1905,  1908,  1901,  1902,  1904,
    1909,  1914,  1906,  1915,  1917,  1374,  1919,  1921,  1903,  1478,
    1478,  1907,  1910,  1918,  1916,  1923,  1922,  1924,  1920,  1925,
    1926,  1927,  1928,  1932,  1930,  1935,  1933,  1938,  1937,  1939,
    1940,  1942,  1944,  1947,  1949,  1943,  1929,  1948,  1945,   764,
    1952,  1950,  1951,  1936,  1956,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,  1975,  1953,   807,
    1954,  1436,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,  1955,  1958,  1957,  1959,  1960,  1962,  1961,  1965,
    1966,  1071,  1543,  1544,  1071,  1964,  1967,  1963,  1969,  1973,
    1968,  1970,  1971,  1972,  1974,  1976,  1977,  1979,  1560,  1978,
    1980,  1560,  1981,  1983,  1985,  1982,  1987,  1984,  1986,  1990,
    1988,  1996,  2059,  1989,  1992,  1994,  1993,  1991,  1997,  2002,
    2003,  1995,  2004,  2005,  2012,  2009,  2001,  2006,  2007,  2008,
    2010,  2011,  2013,  2014,  2015,  2025,  2027,  2028,  2026,  2029,
    2016,  2032,  2031,  2033,  2036,  2030,  2037,  2035,  2034,  2040,
    2039,  2044,  2045,  2047,  2038,  1577,  2042,  2048,  2046,  2043,
    2052,  2078,  1704,  2058,  2060,  2062,  2049,  2053,  2063,  1585,
    2065,   710,  2050,  2041,  2056,  2055,  2054,  2051,  2057,  2061,
    2066,  2069,  2070,  2071,  2072,  2064,  2068,  2067,  2074,  2079,
    2081,    63,   225,    65,    66,    67,    68,    69,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
     985,  1569,   986,    93,   797,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   763,    63,   225,    65,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,   584,   585,   796,    93,
     797,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    63,   225,    65,    66,    67,    68,    69,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,  2073,   990,   986,    93,   797,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    63,   225,    65,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  1559,  2077,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    63,   225,    65,    66,    67,    68,    69,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,  2080,  1562,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  2082,  2083,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    63,   225,    65,    66,    67,    68,    69,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,  2084,  2085,   796,    93,   797,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    63,   225,    65,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  2086,  2087,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    63,   225,    65,    66,    67,    68,    69,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,  2088,  2089,  1178,    93,   797,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    63,   225,    65,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  2090,  2091,   986,    93,
     797,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    63,   225,    65,    66,    67,    68,    69,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,  2092,  2094,  2095,    93,   797,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    63,   225,    65,
      66,    67,  1356,  1357,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  1358,  1359,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    63,   225,    65,    66,    67,  1356,  1357,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
    1358,  1359,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,  1579,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    63,   225,    65,    66,    67,
      68,    69,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,  2096,  2097,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    63,
     225,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,  2098,  2099,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    63,   225,  1224,    66,    67,    68,    69,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,  2100,  2101,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    63,   225,  1233,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  2102,  2103,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    63,   225,  1262,    66,    67,    68,    69,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
    2104,  2105,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    63,   225,  1264,    66,    67,
      68,    69,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,  2106,  2108,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    63,
     225,  1471,    66,    67,    68,    69,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,  2107,  2109,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,    63,   225,  1476,    66,    67,    68,    69,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,  2110,  2111,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,    63,   225,  1496,
      66,    67,    68,    69,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   235,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,  2112,  2113,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,    63,   225,  1497,    66,    67,    68,    69,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
    2114,  2115,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,   108,   109,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    63,   225,    65,    66,    67,
      68,    69,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,  2116,  2118,  2119,    93,   797,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,  2120,
    2121,  2122,  2124,  2127,  2123,  2128,  2130,  2136,  2129,  2135,
    2134,  2131,  2138,  2139,  2137,  2140,  2141,  2142,  2143,  2144,
    2145,  2146,  2147,  2148,  2150,  2151,  2149,  2157,  2152,  2156,
    2153,  2159,  2188,  2154,  2155,  2222,  2161,  2169,  1408,  2158,
    2160,  2162,  2164,  2174,  2176,  2177,  2163,  2167,  2182,  2165,
    2166,  2179,  2170,  2178,  2168,  2180,  2181,  2175,  2172,  2184,
    2171,  2173,  2185,  2183,  2186,  2191,  2195,  2193,  2187,  2190,
    2199,  2189,  2192,  2207,  2093,  2209,  2210,  2200,  2197,  2198,
    2194,  2196,  2211,  2208,  2206,  2213,  2201,  2202,  2205,  2214,
    2217,  2212,  2218,  2215,  2216,  2227,  2229,  2230,  2233,  2220,
    2221,  2219,  2236,  2232,  2223,  2225,  2224,  2235,  2245,  2226,
    1587,  2228,  2231,  2234,  1563,  1553,  1003,  1304,  2237,  2238,
    2239,  2240,  2244,   811,  2241,  2242,  1480,  2243,  1315,  1581,
     406,   329,   702,   731,   755,     0,     0,     0,   204,   330,
     331,     0,     0,     0,     0,     0,   407,   408,   409,     0,
       0,   410,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,     0,     0,   413,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     430,   344,   332,   333,   357,   334,   336,   359,   337,     0,
     365,   340,   366,     0,     0,   431
};

static const yytype_int16 yycheck[] =
{
      17,  1259,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,   798,   553,   464,   799,    17,   815,  1224,   836,
     164,  1184,   806,   176,   882,   171,   172,   178,  1234,   982,
     800,   175,   176,  1050,  1339,   535,   171,   172,     6,   500,
      49,   503,   178,   505,   178,   495,   496,    29,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    30,   508,   509,
     858,    51,   512,   513,   514,   515,  1262,   529,  1264,    26,
    1276,  1277,  1492,  1279,   870,  1281,   538,  1213,    49,  1242,
    1500,   531,   532,    92,   164,    49,    43,    29,   168,   539,
     540,    49,    49,   173,   892,    52,    30,   895,   478,   479,
     480,   481,   482,   483,   484,   485,   486,   487,   569,   489,
     490,   491,   492,    49,   494,   502,    50,   497,   498,   499,
      49,    92,    30,   488,     1,   495,   496,     4,    92,    97,
      98,    99,    30,    28,    92,  1271,  1272,  1273,  1274,   937,
     505,    43,    29,    51,    39,    28,    29,    49,   535,    26,
      48,    28,    29,    30,    31,    42,    92,   584,   585,  1464,
      37,   531,   532,    92,   529,    42,    43,    50,    30,    29,
      47,    48,    49,   538,    51,    27,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    48,    39,    26,    49,
      28,    29,    30,    31,  1211,    29,    28,    49,    43,   661,
      52,   987,    26,    48,    26,    43,    27,    39,   992,    29,
      44,    49,    50,   983,    52,   242,   243,   244,    42,    43,
      44,    98,    99,    45,  1177,    46,    46,  1647,   255,    28,
      29,    28,    29,    29,  1502,   262,    30,   264,   265,   266,
     267,   268,    39,   270,    43,   272,   273,   274,   275,   276,
      46,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,    30,    26,    39,   291,  1471,    30,   294,    39,   296,
      32,    33,   299,    39,    45,    51,   303,   304,   305,    43,
    1476,   308,   309,  1446,   311,   312,    48,    28,    29,    55,
     317,   318,   319,    28,   321,   322,   323,  1503,    44,    39,
    1496,  1497,     0,  1466,    39,    46,    32,    33,   335,    50,
     337,   338,   339,   340,    54,   815,   343,   344,    44,   346,
     347,   348,   349,    31,    32,    33,   477,    39,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   477,    54,   477,    97,   164,    30,    71,    72,    73,
      74,    75,    76,    77,    78,    79,   175,   176,   858,    26,
     179,   180,    30,   182,    31,    29,   816,   817,    30,    28,
      29,   798,   799,   800,    32,    33,    43,    39,    28,   806,
      44,    44,    29,   845,    43,   847,    44,    50,  1186,    39,
    1188,   544,   892,  1179,    26,   895,    28,    29,   544,    31,
     544,   851,   852,   853,   854,    29,   433,    31,   435,   544,
      39,    43,    42,   440,   158,    45,    45,  1215,    48,   869,
      44,   871,    28,    28,   874,   875,   876,   877,    46,  1225,
    1226,  1253,    49,    39,    39,    43,  1258,   937,    43,   889,
     890,    49,    26,    39,    28,    29,    30,    31,   898,    10,
      11,    12,    13,    14,    15,    16,    17,    27,    39,    43,
      30,    42,   924,    28,    25,    49,    32,    33,    52,    44,
     544,    32,    33,    34,    39,    36,   550,   857,    43,    45,
      46,    48,  1280,   933,   934,   168,   936,   488,   938,    49,
     173,   215,    52,   217,   218,   219,   220,   221,   222,   223,
     224,    49,   503,    64,   505,    49,   167,    68,    52,    70,
      50,    72,   173,    74,    31,    32,    33,    46,    17,    26,
      49,   522,   523,    31,    32,    33,    46,    44,   529,   171,
     172,    48,   169,   170,   176,    39,    44,   538,   175,   176,
      48,    31,    32,    33,   545,   546,   547,   548,    46,    98,
      99,    49,   553,   554,   555,   556,   983,    52,    46,    46,
     987,    49,    49,  1347,    46,   992,    27,    49,   595,   596,
     597,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,   550,   551,   552,    51,    52,    98,    26,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,  1460,    51,    52,  1463,   629,   630,   631,   632,
     633,   634,   635,   636,   637,   642,   643,   644,   645,    32,
      33,   648,  1890,   650,    43,   652,   653,   654,    32,    33,
     657,   658,    28,    29,  1797,   662,   663,    28,    29,  1260,
    1261,   584,   585,   670,   671,   672,   673,  1445,    43,  1447,
     677,   678,   679,   680,    29,   588,   589,   684,   685,   686,
     661,    28,   689,    10,    11,    12,    13,    14,    15,    16,
      17,   698,    26,   700,    39,   702,   177,   178,   705,   164,
     707,    55,   709,    26,   169,   170,  1186,    50,  1188,   716,
     175,   176,    50,   177,   178,   165,   166,   508,   509,   726,
     727,   728,   729,   730,   731,   732,   733,   734,   735,   736,
     737,   738,   739,   740,   741,  1215,   743,    29,    43,  1259,
     747,   748,   749,   750,    50,   752,   753,    29,   755,   756,
     757,    30,    50,  1550,    45,   758,   759,  1187,    30,  1189,
      29,    49,    26,    27,    28,    29,    26,    31,    51,    27,
      38,    38,  1179,    37,    39,    27,   783,   784,    44,    43,
      39,    27,    45,    45,    39,    49,    50,    27,    52,  1975,
      39,   798,    45,    54,    51,    39,    38,    44,     7,    28,
    1280,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    39,  1254,    51,    39,     7,    50,  1224,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    51,    51,
      38,    42,    39,    54,    50,     7,    48,  1615,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    45,   553,
      45,    44,    50,    26,   861,    26,   837,    48,    52,   840,
     841,   842,   843,    50,   845,    28,   847,    46,   849,    27,
      29,    26,    92,  2059,   855,    29,    26,    92,    42,    92,
      37,    29,   863,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    48,    48,    39,    39,    50,
      29,    44,   883,   884,    92,    29,    29,    92,    29,    49,
    1688,    92,    29,   894,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    29,   629,   630,   631,   632,   633,
     634,   635,   636,   637,    26,    29,    92,    39,   941,   920,
    1347,   922,    49,   924,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    29,    38,    29,    44,    29,    31,
     684,   685,    26,    52,    92,  1445,    92,  1447,    45,    48,
      50,    39,    39,    43,    30,    49,    45,    30,    30,    55,
     987,    44,  1502,    42,    39,    50,   710,    48,    39,    49,
      39,   998,    39,  1000,  1001,  1002,  1003,    45,    44,    39,
      39,    30,    39,    30,    49,    26,    28,    42,    52,    51,
      44,    44,    50,  1020,    39,    45,    39,    45,  1448,    39,
    1027,    27,  1029,  1030,  1031,    39,  1033,  1034,    39,    39,
      49,  1038,  1039,    49,    39,    44,    39,    44,    50,  1046,
     519,   520,    39,    45,  1051,   769,    45,    39,    26,  1056,
      51,  1058,  1059,  1060,   758,   759,    45,   536,   762,    45,
      51,    30,    39,  1070,  1471,  1072,  1073,    30,    39,  1050,
      31,    39,    44,    39,    39,    49,    27,   556,    28,  1086,
      39,  1088,    30,    26,    28,    39,    50,    39,    28,    44,
      32,  1098,  1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,
    1107,  1108,  1109,    44,  1111,    92,  1113,    35,  1115,    33,
      26,    44,  1119,  1120,  1121,  1122,    28,  1124,  1125,    45,
    1127,  1128,  1129,    42,    44,    30,    44,  1130,  1131,    44,
      92,    30,    26,    42,    30,  1615,    43,    48,    31,  1146,
      42,    49,    45,    92,    44,    92,    44,    44,    30,    44,
      30,    29,    44,    92,    92,   521,    45,    92,   524,    49,
      48,    45,    92,    29,   530,    50,    42,    42,    29,    43,
      29,   537,  1179,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    52,    49,    42,    45,    30,
      44,    44,    28,  1184,    26,   571,    30,    30,  1688,    92,
      26,  1218,    42,    30,    29,    48,    27,    30,    39,    48,
      34,    49,    92,    50,    92,    26,  1207,  1208,  1209,    39,
    1211,  1212,  1213,    51,    30,   939,   940,   941,  1219,    30,
      49,    44,    39,    48,    43,    49,    92,    30,    55,    30,
      45,    39,  1233,    92,    39,    39,    50,    49,    92,    49,
      92,  1242,    44,    39,    30,    44,    39,    92,    28,  1250,
    1251,    51,  1253,  1254,  1255,  1256,    50,  1258,  1259,  1260,
    1261,  1262,    39,  1264,    92,    39,    39,    30,    30,    45,
    1271,  1272,  1273,  1274,    39,    30,    28,    30,    39,    92,
      48,    30,    49,  1027,  1028,  1312,  1313,  1314,  1315,  1033,
      30,    42,    39,  1037,    44,    43,    42,    92,    39,    30,
      92,  1328,  1329,    39,  1331,  1332,  1333,    51,    42,    44,
    1337,    50,    42,  1057,    27,    48,    45,    42,    50,    29,
      44,  1348,  1349,    49,    44,    48,    43,  1071,    50,    48,
      44,  1358,  1359,  1356,  1357,    50,    48,   836,  1339,   838,
     839,    44,    50,    45,    29,   844,    44,    42,  1375,   848,
    1890,    45,    29,    44,    43,    48,  1383,    30,    45,    45,
      44,    42,    45,    45,    92,    92,  1110,    42,  1112,   868,
      48,   870,    29,  1400,    92,    44,    92,    42,    50,    28,
      43,    92,   881,   882,    27,  1412,  1413,  1414,  1415,    48,
      30,    92,    92,    92,    49,    45,    49,    30,    42,    51,
      30,    49,  1146,    48,    50,    28,  1130,  1131,  1132,  1436,
      49,    45,    49,    51,    49,    51,    48,     6,    49,    48,
     919,    46,   921,    51,    51,    30,    92,    51,    39,    30,
      45,    92,    28,    39,    46,    51,    31,    39,    92,    48,
      43,  1468,    26,    28,    30,  1446,   832,    45,   834,   835,
    1477,    92,    45,  1480,    29,    29,   955,    30,    28,    51,
      50,    39,    50,  1464,   850,  1466,    92,    30,    51,    51,
      50,    48,    39,    49,    30,  1476,    30,    43,    50,    50,
    1481,    31,    51,    51,    45,    50,    50,    45,    43,    51,
      50,  1492,    51,    50,  1495,  1496,  1497,    44,    50,  1500,
    1501,  1502,    51,    44,    44,  1532,    45,    26,    46,  1233,
     896,    39,    39,    50,    44,  1542,    51,    51,  1545,  1520,
      44,   907,   908,   909,   910,   911,   912,   913,   914,   915,
     916,   917,   918,    50,    45,  1259,    39,    51,  1262,    26,
    1264,    43,   928,   929,   930,   931,    44,    48,    26,    26,
    1577,    51,    46,    52,    43,    50,    92,  1584,  1282,  1283,
      48,    28,    44,    48,    30,    48,    50,    43,    48,    43,
     956,    46,    30,    46,    26,    30,    46,    48,    50,    42,
    1607,    50,    50,    44,  1328,    39,    51,    51,  1332,    46,
      50,    50,    45,    44,    43,    29,    31,    45,    44,  1626,
    1344,    30,    28,    50,    48,    44,    51,    50,    50,    30,
      51,  1355,    42,    30,    51,    48,    30,    49,    26,    30,
      51,  1365,    50,    30,    44,    30,    51,    51,    51,    51,
      92,    50,  1356,  1357,    44,    51,    92,    38,    51,    51,
      39,    50,  1386,  1644,    42,    51,  1647,    51,    50,    31,
      29,    51,    92,    30,    92,  1399,    51,    51,    39,    31,
      45,  1405,    51,  1407,    44,    92,  1667,    45,    30,    26,
      54,    44,    43,    26,    50,    49,    51,    92,    44,    49,
      39,    50,    50,    44,    44,    43,    50,    43,    43,    92,
      44,    43,    43,    29,    29,    43,    39,    42,    37,    29,
      50,    50,    46,    50,    50,    46,    48,  1206,    45,    43,
      50,  1210,    44,    51,    45,    44,    44,    50,    45,  1746,
      30,    39,    29,    29,  1223,    92,  1225,  1226,    50,    92,
      29,    50,    45,  1232,  1478,    30,    28,    37,    49,    30,
      30,    50,    30,    30,    30,    50,    30,    30,    45,    51,
      51,    45,  1476,  1252,    50,    44,    30,  1481,  1257,    30,
      28,  1260,  1261,    29,  1263,    50,  1265,    92,    92,    92,
      50,    92,  1496,  1497,    50,    92,    92,    92,  1502,    49,
      44,    39,    39,    52,    39,    39,    39,    52,    48,    28,
      30,    29,    44,    52,    45,    44,  1797,    44,    44,  1543,
    1544,    29,    52,    44,    52,    48,    50,    42,    50,    29,
      92,    44,    27,    45,    50,    52,  1560,    29,  1845,  1205,
      30,    48,    38,    45,    29,    44,    39,    52,    51,    92,
      92,    45,    50,    50,    29,    39,    30,    30,    39,    50,
      38,    50,    50,    50,    30,    45,    42,    39,    50,    38,
      30,    39,    55,    50,    39,  1241,    26,    39,    92,  1358,
    1359,    92,    92,    92,    51,    30,    92,    39,    52,    40,
      39,    28,    30,    51,    49,    39,    44,    28,    52,    52,
      28,    26,    28,    26,    46,    52,    92,    48,    28,  1890,
      40,    30,    52,    92,    28,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,  1934,    45,    34,
      39,  1297,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    44,    44,    92,    48,    43,    39,    44,    49,
      44,  1460,  1461,  1462,  1463,    45,    45,    52,    30,    44,
      48,    48,    46,    43,    50,    48,    31,    30,  1477,    39,
      39,  1480,    30,    44,    30,    43,    55,    39,    38,    30,
      44,    31,  2019,    50,    39,    51,    45,    48,    30,    30,
      26,    48,    44,    28,    92,    27,    50,    30,    51,    46,
      30,    49,    26,    26,    50,    30,    28,    28,    39,    26,
      92,    92,    28,    26,    28,    44,    27,    44,    46,    45,
      30,    26,    28,    30,    44,  1495,    45,    30,    46,    44,
      28,    31,  1644,    30,    28,    30,    48,    46,    30,  1501,
      30,  1550,    50,    92,    43,    46,    48,    51,    44,    42,
      30,    30,    30,    30,    92,    46,    44,    46,    28,    46,
      42,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,  1487,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,  1890,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    50,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    51,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    50,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    49,    92,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    46,    50,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    50,    26,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    26,    49,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    26,    92,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    48,    50,    30,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    42,    92,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    26,    44,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    42,    92,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    39,    50,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      45,    44,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    44,    92,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    45,    45,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      94,    95,    96,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    92,    46,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    51,    92,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      45,    48,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    43,    29,    49,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    45,
      49,    46,    30,    44,    48,    45,    31,    26,    51,    46,
      48,    50,    29,    48,    50,    26,    30,    30,    39,    48,
      26,    26,    42,    45,    31,    48,    44,    26,    44,    55,
      45,    92,    92,    45,    44,    92,    39,    31,  1267,    48,
      48,    43,    43,    31,    26,    29,    50,    43,    26,    49,
      48,    30,    45,    39,    51,    30,    30,    48,    50,    26,
      55,    51,    30,    50,    44,    26,    49,    48,    45,    45,
      30,    44,    43,    30,  2059,    30,    30,    43,    48,    44,
      52,    50,    29,    39,    43,    30,    50,    50,    50,    30,
      30,    44,    50,    45,    44,    31,    30,    30,    30,    48,
      48,    52,    30,    38,    50,    48,    50,    45,    29,    51,
    1503,    50,    49,    44,  1481,  1471,   817,  1176,    48,    48,
      45,    48,    42,   589,    50,    48,  1359,    49,  1189,  1497,
     178,   173,   533,   544,   552,    -1,    -1,    -1,    62,   173,
     173,    -1,    -1,    -1,    -1,    -1,   178,   178,   178,    -1,
      -1,   178,    -1,    -1,   178,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   178,
      -1,    -1,    -1,   178,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     178,   174,   173,   173,   176,   173,   173,   176,   173,    -1,
     176,   173,   176,    -1,    -1,   178
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     1,     4,    26,    28,    29,    30,    31,    37,    42,
      43,    47,    48,    49,    51,   101,   102,   103,   104,   184,
     185,   186,   187,   188,   189,   191,   192,   193,   194,   195,
     196,   201,   202,   203,   204,   267,   293,   294,   296,   300,
      29,    42,    45,    48,    30,    29,    39,    45,    30,    39,
      45,    26,    45,    51,    30,    30,    51,    44,     0,    98,
      99,   182,   183,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,   160,   163,   173,   175,
     176,   177,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,    29,    30,    46,    30,    49,    39,    44,
      48,    50,    49,    26,    46,    52,    39,    43,    49,    44,
      50,    27,    43,    49,   182,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,   159,   160,   159,   159,   159,
     159,   159,   159,   159,   159,     4,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,   175,    28,    29,    43,
     105,   205,   259,   270,   272,    26,    28,    29,    30,    31,
      43,    49,    50,    52,   111,   205,   206,   207,   208,   233,
     234,   235,   239,   244,   245,   246,   247,   248,   249,   251,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     268,   269,   270,   271,   272,   273,   274,   283,   284,   288,
     289,   292,    43,   108,   257,   109,   257,    43,   115,   258,
      29,    42,   116,   271,   272,   281,    29,   117,   270,   273,
     118,   270,   273,    26,    31,    43,   113,   245,   255,   268,
     119,   245,   255,   268,    26,    28,    31,    43,   127,   206,
     207,   208,   244,   251,   254,   258,   260,   269,   271,   272,
     292,    39,   120,   237,   239,   110,   205,   259,   270,   273,
      26,    30,    43,    49,   112,   205,   243,   248,   252,   253,
     259,   268,   270,   273,   284,   288,   289,   299,    26,    27,
      28,    29,    31,    37,    43,    49,    50,    52,   106,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   223,   224,   225,   226,   227,   228,   229,   230,   231,
     232,   233,   234,   236,   297,   107,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     236,   297,   128,   205,   122,   205,    39,   123,   275,   114,
     205,    26,    55,    26,    50,    50,    29,    43,    50,    29,
      30,    50,    45,    30,    29,    49,    26,    51,   160,    38,
      27,    39,   181,   181,   181,    51,    52,    38,    27,    44,
      39,    54,    39,    30,    50,    45,    45,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,    39,   181,   181,    39,   181,    27,    45,   181,   181,
     181,    27,   181,   181,   181,   181,    51,    54,    39,   181,
     181,   181,   181,   181,   181,    51,    38,    54,    39,   181,
     181,   181,   181,   181,    44,   181,   181,   181,   181,   181,
     181,    51,    28,    39,   181,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,    51,    51,    38,
      27,    30,    54,    42,    39,    50,    45,    45,   181,   181,
      44,   181,    48,    50,    48,    26,    52,    50,    28,    46,
      27,    26,    92,    29,    32,    33,   149,   169,    32,    33,
     148,   164,    31,    44,    48,   148,   156,   200,   278,   279,
     280,    29,    26,    26,    92,    37,    42,    92,    29,    48,
      48,    50,    39,    42,    39,   209,   230,   231,   232,   209,
     209,   209,   209,   209,   209,   209,   209,   209,   209,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    26,   138,
     163,   197,   209,   209,   209,   209,   143,   163,   209,   148,
     279,   148,   279,   209,   209,   209,    39,   237,   238,    29,
      44,   124,   200,   138,    29,   138,   197,    92,    49,    44,
     148,   280,   148,   280,    29,   222,    92,   148,   148,   148,
     148,    29,    92,    29,   173,   173,   143,   163,   163,   143,
      29,    26,    92,    29,   138,   197,   143,   148,   279,   148,
     279,    39,   238,    49,   129,   147,   164,   200,   130,   146,
     173,   143,   138,   197,    31,   148,   277,   148,    29,    38,
      29,    26,    43,    49,    52,   121,   245,   249,   250,   255,
     259,   262,   263,   264,   265,   284,   286,   287,   163,   163,
     163,   163,    44,   298,    26,    42,    43,   249,   266,   285,
     298,    29,   276,   298,    31,   276,   282,   298,     8,     9,
     142,   158,   159,   160,   163,   163,   163,   157,   163,   173,
      29,    31,    26,    92,    52,    92,    45,    29,    49,    48,
      50,    39,    43,   295,   237,    49,   143,    30,    45,    50,
      30,    48,    49,    44,    39,    39,    34,    36,   171,   172,
     174,   177,   178,   179,   180,   181,   172,    34,   165,   166,
     176,   165,    42,    45,    30,   181,   181,   181,    39,    39,
      44,    39,    39,    30,    49,    39,    52,    30,    26,    28,
      51,    44,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,   181,   181,   181,    42,   181,   181,   181,
     181,   181,   181,   181,   181,   181,    44,   181,   181,    39,
      45,   138,   181,   181,    39,    39,    50,    45,   181,   181,
     181,   181,    27,    39,   181,   181,   181,   181,    39,    49,
      39,   181,   181,   181,   181,    39,    44,    49,    39,   181,
     181,    44,   181,    50,   181,   181,   181,    45,   181,    39,
      45,    39,    51,    39,    51,    45,    45,   181,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,   181,    26,   181,    51,    30,    39,   181,   181,
     181,   181,    30,   181,   181,    39,   181,   181,   181,   159,
     159,     7,    39,    31,    44,    39,    39,    49,    27,    39,
      28,    30,    26,    28,    39,   181,   181,    50,    55,    39,
      28,    44,    44,    92,    10,    11,    12,    13,    14,    15,
      16,    17,    25,    32,    33,    34,    36,    64,    68,    70,
      72,    74,   161,   174,   181,    32,    34,   171,   177,   178,
      33,    32,   167,    35,    33,    26,    44,    28,   147,    31,
     148,   190,   148,   156,    45,    42,    44,    44,    44,    30,
      92,    30,    26,    42,    30,    43,    31,   143,    27,    46,
     126,   290,   291,   143,   143,   146,   163,   173,   173,   163,
     163,   163,   163,   173,   138,    42,   138,   173,   163,   143,
     148,   148,   148,   148,   163,    49,   209,   147,    92,    44,
     181,   139,   163,    92,    44,    44,   154,   173,   148,   154,
     148,    92,    44,   148,   148,   148,   148,    45,    30,    92,
     125,   173,   125,   141,   163,   145,   163,    45,    44,    30,
      92,   148,   148,    49,   147,    48,   144,   163,   147,   143,
      48,   148,    45,    92,    29,    29,    50,    42,   143,   143,
     143,   143,   143,   143,   143,   143,   143,   143,   143,   143,
     173,   163,   173,   163,    43,   138,    29,    52,    29,   143,
     143,   143,   143,    49,   148,   148,    42,   148,   147,   148,
       7,     7,   159,    45,    30,    44,    44,    28,    30,    26,
      92,    30,    26,    42,    30,    29,   173,   143,    48,    27,
      48,    30,    49,    39,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,   162,   161,    34,   171,
      34,    50,    92,    51,   181,    39,   181,   181,   181,   181,
      92,    26,    30,    49,    30,    44,    39,    48,    43,    92,
      49,    30,    45,    55,    30,   181,   181,   181,   181,   181,
     181,   181,   181,   181,    50,   181,    39,    92,   139,   181,
      39,    49,    92,   181,     5,   181,   181,    39,    49,    92,
      44,    39,   181,     5,   181,    92,    30,    44,    39,    50,
      51,   181,   181,    28,    92,    39,    39,    39,    30,    45,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     181,   181,     5,   181,     5,   181,    30,   181,    39,    30,
      39,   181,   181,   181,   181,    28,   181,   181,    30,   181,
     181,   181,   159,   159,    92,    48,    30,    49,    30,    44,
      42,    39,    42,    43,    92,    92,    39,   181,    51,    30,
      39,    42,    50,    44,   162,   161,    43,    48,    48,   144,
      42,   147,   148,   147,   148,   190,    45,    27,    42,    50,
      29,    44,    49,    49,    52,    50,    48,   143,   173,   163,
     163,   163,   173,   139,   163,   145,    48,   147,    44,   181,
     140,   163,    44,    50,   173,   155,   169,   172,   154,   154,
      44,    50,    45,    29,    44,   173,     8,     9,    32,    33,
     152,   153,   158,   163,   168,   173,   151,   169,    45,    42,
      29,    44,    48,    43,   143,   144,    30,    45,    44,    45,
      92,   132,   163,   133,   163,   134,   173,   132,    29,    44,
     138,   198,   199,   135,   163,   136,   163,   197,   137,   173,
     132,   142,   157,   157,   152,   173,   152,   173,   149,    45,
      42,    92,   145,   145,   145,   145,    48,   169,   169,    92,
     169,   147,   169,    45,    92,    42,    50,    92,    29,    92,
      44,    42,    92,    52,    28,    92,   143,    43,    27,    48,
      49,    45,    30,    49,    30,   181,   181,   181,   181,    51,
      42,    49,    48,    49,    46,    49,    50,    45,    30,    28,
     181,   181,   181,   181,   181,    51,   181,    49,   140,    49,
      48,     5,    49,    48,    51,    46,     5,   170,   173,   181,
     170,     6,    51,    46,    49,    51,    30,   181,    51,    46,
      92,    39,   181,    30,    45,   181,     5,     5,    92,    28,
     181,   181,   181,   181,    39,    46,    51,    31,    92,    48,
      43,    92,    39,    46,    49,    26,    28,    45,    45,    29,
     181,    30,    30,    51,    50,    29,    28,    39,    92,   147,
     144,   147,   148,    50,    30,    51,    51,    50,    48,    39,
      49,    30,   125,   173,   173,   125,   140,    43,   144,    50,
     181,    50,    51,   155,    50,    51,    50,    51,   152,    32,
     173,   181,    33,   153,    50,    51,    50,    43,    44,   143,
      50,    51,    45,    44,   133,    31,    44,   135,   152,    44,
     152,   198,    45,    45,   133,   141,   142,   151,    46,    26,
      50,    39,    28,    39,    43,    51,    39,    28,    39,    44,
      51,    50,    44,    45,    39,    51,    26,   163,    44,    43,
      48,    26,    51,    52,    26,   181,    46,    92,    43,    50,
      48,    30,    28,    44,    30,    48,   146,    48,    43,    48,
      43,    46,    50,    46,    50,    48,    30,    50,    46,    50,
      51,    46,    26,    30,   181,    51,    44,   181,    50,    50,
      46,    42,    45,    44,    39,    43,    29,    45,    44,    31,
      50,    48,    30,    51,    28,    44,    50,   181,    50,    30,
      51,    42,    48,    30,    49,   147,    51,    26,    30,    43,
      30,    92,    51,    26,    30,    50,    44,    51,   181,    51,
      30,    51,    30,    51,    92,    51,    92,    51,    44,    51,
      92,    50,    51,    51,   136,    50,    50,   133,    39,    38,
      51,    42,    51,    31,    29,    30,    39,    51,    31,    45,
      92,    51,    45,    44,    30,    50,    26,   163,    49,    44,
      43,    49,    92,    50,    51,    44,    39,    44,    29,    46,
      43,    43,    92,    26,    50,    43,   147,    43,    44,    43,
      44,    50,    29,    50,    29,    43,    50,    50,    29,    46,
      46,    50,    42,    46,    48,    45,    50,    44,    45,    39,
      44,    44,    45,    29,    43,    51,    50,    92,    92,    50,
      30,    39,    29,    92,    29,    37,    29,    50,    30,    48,
      45,    30,    92,    28,    37,    49,    30,   181,    30,    50,
      30,    50,    92,    30,    92,    30,    30,    92,    30,    45,
      51,    92,    50,    51,    45,    44,    92,    50,    50,    50,
      30,    30,    49,    28,    29,    49,    92,    44,    52,    39,
      28,    29,    39,    39,    39,    49,    92,    52,    39,    48,
      44,    28,    45,    30,    44,   144,    44,    92,    44,    29,
      52,    29,    52,    44,    28,    29,    52,    48,    50,    28,
      46,    50,    50,    42,    29,    49,    92,    52,    44,    45,
      27,    29,    50,    30,    48,    38,    30,    48,    45,    44,
      92,    92,    29,    39,    52,    50,    50,    45,    51,    50,
     181,    50,    29,    50,    30,    39,    30,    39,    50,    38,
      30,    39,    50,    92,    38,    45,    55,    92,    42,    30,
      92,    28,    29,    39,    39,    50,    51,    39,    92,    26,
      52,    39,    92,    30,    39,    40,    39,    28,    30,    92,
      49,    92,    51,    44,   142,    39,    92,    52,    28,    52,
      28,    92,    26,    52,    28,    28,    50,    26,    48,    46,
      30,    52,    40,    45,    39,    44,    28,    92,    44,    48,
      43,    44,    39,    52,    45,    49,    44,    45,    48,    30,
      48,    46,    43,    44,    50,   181,    48,    31,    39,    30,
      39,    30,    43,    44,    39,    30,    38,    55,    44,    50,
      30,    48,    39,    45,    51,    48,    31,    30,    28,    39,
      43,    50,    30,    26,    44,    28,    30,    51,    46,    27,
      30,    49,    92,    26,    26,    50,    92,    45,    46,   131,
     150,   169,   240,   241,   242,    30,    39,    28,    28,    26,
      44,    28,    92,    26,    46,    44,    28,    27,    44,    30,
      45,    92,    45,    44,    26,    28,    46,    30,    30,    48,
      50,    51,    28,    46,    48,    46,    43,    44,    30,   181,
      28,    42,    30,    30,    46,    30,    30,    46,    44,    30,
      30,    30,    92,    50,    28,    28,    39,    51,    31,    46,
      50,    42,    49,    92,    46,    50,    50,    26,    26,    49,
      26,    92,    48,   150,    50,    30,    42,    92,    26,    44,
      42,    92,    39,    50,    45,    44,    44,    45,    92,    45,
      92,    46,    51,    92,    45,    48,    43,    54,    29,    49,
      45,    49,    46,    48,    30,    28,    39,    44,    45,    51,
      31,    50,    28,    39,    48,    46,    26,    50,    29,    48,
      26,    30,    30,    39,    48,    26,    26,    42,    45,    44,
      31,    48,    44,    45,    45,    44,    55,    26,    48,    92,
      48,    39,    43,    50,    43,    49,    48,    43,    51,    31,
      45,    55,    50,    51,    31,    48,    26,    29,    39,    30,
      30,    30,    26,    50,    26,    30,    44,    45,    92,    44,
      45,    26,    43,    48,    52,    49,    50,    48,    44,    30,
      43,    50,    50,    28,    39,    50,    43,    30,    39,    30,
      30,    29,    44,    30,    30,    45,    44,    30,    50,    52,
      48,    48,    92,    50,    50,    48,    51,    31,    50,    30,
      30,    49,    38,    30,    44,    45,    30,    48,    48,    45,
      48,    50,    48,    49,    42,    29
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 4:
#line 150 "lscp.y"
    { INCREMENT_LINE; return LSCP_DONE; }
    break;

  case 5:
#line 151 "lscp.y"
    { INCREMENT_LINE; return LSCP_DONE; }
    break;

  case 6:
#line 152 "lscp.y"
    { INCREMENT_LINE; LSCPSERVER->AnswerClient((yyvsp[(1) - (1)].String)); return LSCP_DONE; }
    break;

  case 7:
#line 153 "lscp.y"
    { INCREMENT_LINE; LSCPSERVER->AnswerClient("ERR:0:" + sLastError + "\r\n"); RESTART; return LSCP_SYNTAX_ERROR; }
    break;

  case 13:
#line 163 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 14:
#line 164 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 15:
#line 165 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 16:
#line 166 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 17:
#line 167 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 18:
#line 168 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 19:
#line 169 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 20:
#line 170 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 21:
#line 171 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 22:
#line 172 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 23:
#line 173 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 24:
#line 174 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 25:
#line 175 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 26:
#line 176 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 27:
#line 177 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 28:
#line 178 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 29:
#line 179 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 30:
#line 180 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 31:
#line 181 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 32:
#line 182 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                }
    break;

  case 33:
#line 183 "lscp.y"
    { (yyval.String) = LSCPSERVER->ResetSampler();                        }
    break;

  case 34:
#line 184 "lscp.y"
    { LSCPSERVER->AnswerClient("Bye!\r\n"); return LSCP_QUIT; }
    break;

  case 35:
#line 187 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddChannel();                  }
    break;

  case 36:
#line 188 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstrumentDirectory((yyvsp[(3) - (3)].String));  }
    break;

  case 37:
#line 189 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(5) - (9)].String),(yyvsp[(7) - (9)].String),(yyvsp[(9) - (9)].String), true);        }
    break;

  case 38:
#line 190 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(5) - (11)].String),(yyvsp[(9) - (11)].String),(yyvsp[(11) - (11)].String), true, true); }
    break;

  case 39:
#line 191 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(3) - (7)].String),(yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));              }
    break;

  case 40:
#line 192 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(3) - (9)].String),(yyvsp[(7) - (9)].String),(yyvsp[(9) - (9)].String), false, true); }
    break;

  case 41:
#line 193 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String), -1, true);       }
    break;

  case 42:
#line 194 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(5) - (9)].String),(yyvsp[(7) - (9)].String),(yyvsp[(9) - (9)].Number), true);        }
    break;

  case 43:
#line 195 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].String));                 }
    break;

  case 44:
#line 196 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddDbInstruments((yyvsp[(3) - (7)].String),(yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].Number));              }
    break;

  case 45:
#line 197 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddMidiInstrumentMap();                }
    break;

  case 46:
#line 198 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddMidiInstrumentMap((yyvsp[(3) - (3)].String));              }
    break;

  case 47:
#line 201 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_audio_device_count);   }
    break;

  case 48:
#line 202 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_audio_device_info);    }
    break;

  case 49:
#line 203 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_device_count);    }
    break;

  case 50:
#line 204 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_device_info);     }
    break;

  case 51:
#line 205 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_channel_count);        }
    break;

  case 52:
#line 206 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_channel_midi);         }
    break;

  case 53:
#line 207 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_device_midi);          }
    break;

  case 54:
#line 208 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_voice_count);          }
    break;

  case 55:
#line 209 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_stream_count);         }
    break;

  case 56:
#line 210 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_buffer_fill);          }
    break;

  case 57:
#line 211 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_channel_info);         }
    break;

  case 58:
#line 212 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_fx_send_count);        }
    break;

  case 59:
#line 213 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_fx_send_info);         }
    break;

  case 60:
#line 214 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_instr_map_count); }
    break;

  case 61:
#line 215 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_instr_map_info);  }
    break;

  case 62:
#line 216 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_instr_count);     }
    break;

  case 63:
#line 217 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_midi_instr_info);      }
    break;

  case 64:
#line 218 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_db_instr_dir_count);   }
    break;

  case 65:
#line 219 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_db_instr_dir_info);    }
    break;

  case 66:
#line 220 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_db_instr_count);       }
    break;

  case 67:
#line 221 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_db_instr_info);        }
    break;

  case 68:
#line 222 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_db_instrs_job_info);   }
    break;

  case 69:
#line 223 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_misc);                 }
    break;

  case 70:
#line 224 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_total_stream_count);   }
    break;

  case 71:
#line 225 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_total_voice_count);    }
    break;

  case 72:
#line 226 "lscp.y"
    { (yyval.String) = LSCPSERVER->SubscribeNotification(LSCPEvent::event_global_info);          }
    break;

  case 73:
#line 229 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_audio_device_count);   }
    break;

  case 74:
#line 230 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_audio_device_info);    }
    break;

  case 75:
#line 231 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_device_count);    }
    break;

  case 76:
#line 232 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_device_info);     }
    break;

  case 77:
#line 233 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_channel_count);        }
    break;

  case 78:
#line 234 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_channel_midi);         }
    break;

  case 79:
#line 235 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_device_midi);          }
    break;

  case 80:
#line 236 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_voice_count);          }
    break;

  case 81:
#line 237 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_stream_count);         }
    break;

  case 82:
#line 238 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_buffer_fill);          }
    break;

  case 83:
#line 239 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_channel_info);         }
    break;

  case 84:
#line 240 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_fx_send_count);        }
    break;

  case 85:
#line 241 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_fx_send_info);         }
    break;

  case 86:
#line 242 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_instr_map_count); }
    break;

  case 87:
#line 243 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_instr_map_info);  }
    break;

  case 88:
#line 244 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_instr_count);     }
    break;

  case 89:
#line 245 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_midi_instr_info);      }
    break;

  case 90:
#line 246 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_db_instr_dir_count);   }
    break;

  case 91:
#line 247 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_db_instr_dir_info);    }
    break;

  case 92:
#line 248 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_db_instr_count);       }
    break;

  case 93:
#line 249 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_db_instr_info);        }
    break;

  case 94:
#line 250 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_db_instrs_job_info);   }
    break;

  case 95:
#line 251 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_misc);                 }
    break;

  case 96:
#line 252 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_total_stream_count);   }
    break;

  case 97:
#line 253 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_total_voice_count);    }
    break;

  case 98:
#line 254 "lscp.y"
    { (yyval.String) = LSCPSERVER->UnsubscribeNotification(LSCPEvent::event_global_info);          }
    break;

  case 99:
#line 257 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddOrReplaceMIDIInstrumentMapping((yyvsp[(4) - (16)].Number),(yyvsp[(6) - (16)].Number),(yyvsp[(8) - (16)].Number),(yyvsp[(10) - (16)].String),(yyvsp[(12) - (16)].String),(yyvsp[(14) - (16)].Number),(yyvsp[(16) - (16)].Dotnum),MidiInstrumentMapper::DONTCARE,"",(yyvsp[(3) - (16)].Bool)); }
    break;

  case 100:
#line 258 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddOrReplaceMIDIInstrumentMapping((yyvsp[(4) - (18)].Number),(yyvsp[(6) - (18)].Number),(yyvsp[(8) - (18)].Number),(yyvsp[(10) - (18)].String),(yyvsp[(12) - (18)].String),(yyvsp[(14) - (18)].Number),(yyvsp[(16) - (18)].Dotnum),(yyvsp[(18) - (18)].LoadMode),"",(yyvsp[(3) - (18)].Bool)); }
    break;

  case 101:
#line 259 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddOrReplaceMIDIInstrumentMapping((yyvsp[(4) - (18)].Number),(yyvsp[(6) - (18)].Number),(yyvsp[(8) - (18)].Number),(yyvsp[(10) - (18)].String),(yyvsp[(12) - (18)].String),(yyvsp[(14) - (18)].Number),(yyvsp[(16) - (18)].Dotnum),MidiInstrumentMapper::DONTCARE,(yyvsp[(18) - (18)].String),(yyvsp[(3) - (18)].Bool)); }
    break;

  case 102:
#line 260 "lscp.y"
    { (yyval.String) = LSCPSERVER->AddOrReplaceMIDIInstrumentMapping((yyvsp[(4) - (20)].Number),(yyvsp[(6) - (20)].Number),(yyvsp[(8) - (20)].Number),(yyvsp[(10) - (20)].String),(yyvsp[(12) - (20)].String),(yyvsp[(14) - (20)].Number),(yyvsp[(16) - (20)].Dotnum),(yyvsp[(18) - (20)].LoadMode),(yyvsp[(20) - (20)].String),(yyvsp[(3) - (20)].Bool)); }
    break;

  case 103:
#line 263 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveMIDIInstrumentMapping((yyvsp[(3) - (7)].Number),(yyvsp[(5) - (7)].Number),(yyvsp[(7) - (7)].Number)); }
    break;

  case 104:
#line 266 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveChannel((yyvsp[(3) - (3)].Number));                      }
    break;

  case 105:
#line 267 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveMidiInstrumentMap((yyvsp[(3) - (3)].Number));            }
    break;

  case 106:
#line 268 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveAllMidiInstrumentMaps();          }
    break;

  case 107:
#line 269 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveDbInstrumentDirectory((yyvsp[(5) - (5)].String), true);  }
    break;

  case 108:
#line 270 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveDbInstrumentDirectory((yyvsp[(3) - (3)].String));        }
    break;

  case 109:
#line 271 "lscp.y"
    { (yyval.String) = LSCPSERVER->RemoveDbInstrument((yyvsp[(3) - (3)].String));                 }
    break;

  case 110:
#line 274 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAvailableEngines();                          }
    break;

  case 111:
#line 275 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAvailableMidiInputDrivers();                 }
    break;

  case 112:
#line 276 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDriverInfo((yyvsp[(5) - (5)].String));                     }
    break;

  case 113:
#line 277 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDriverParameterInfo((yyvsp[(5) - (7)].String), (yyvsp[(7) - (7)].String));        }
    break;

  case 114:
#line 278 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDriverParameterInfo((yyvsp[(5) - (9)].String), (yyvsp[(7) - (9)].String), (yyvsp[(9) - (9)].KeyValList));    }
    break;

  case 115:
#line 279 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAvailableAudioOutputDrivers();               }
    break;

  case 116:
#line 280 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDriverInfo((yyvsp[(5) - (5)].String));                   }
    break;

  case 117:
#line 281 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDriverParameterInfo((yyvsp[(5) - (7)].String), (yyvsp[(7) - (7)].String));      }
    break;

  case 118:
#line 282 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDriverParameterInfo((yyvsp[(5) - (9)].String), (yyvsp[(7) - (9)].String), (yyvsp[(9) - (9)].KeyValList));  }
    break;

  case 119:
#line 283 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDeviceCount();                    }
    break;

  case 120:
#line 284 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDeviceCount();                      }
    break;

  case 121:
#line 285 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDeviceInfo((yyvsp[(5) - (5)].Number));                   }
    break;

  case 122:
#line 286 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDeviceInfo((yyvsp[(5) - (5)].Number));                     }
    break;

  case 123:
#line 287 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputPortInfo((yyvsp[(5) - (7)].Number), (yyvsp[(7) - (7)].Number));                   }
    break;

  case 124:
#line 288 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputPortParameterInfo((yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].Number), (yyvsp[(9) - (9)].String));      }
    break;

  case 125:
#line 289 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputChannelInfo((yyvsp[(5) - (7)].Number), (yyvsp[(7) - (7)].Number));              }
    break;

  case 126:
#line 290 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputChannelParameterInfo((yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].Number), (yyvsp[(9) - (9)].String)); }
    break;

  case 127:
#line 291 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetChannels();                                  }
    break;

  case 128:
#line 292 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetChannelInfo((yyvsp[(5) - (5)].Number));                             }
    break;

  case 129:
#line 293 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetBufferFill((yyvsp[(5) - (7)].FillResponse), (yyvsp[(7) - (7)].Number));                          }
    break;

  case 130:
#line 294 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetStreamCount((yyvsp[(5) - (5)].Number));                             }
    break;

  case 131:
#line 295 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetVoiceCount((yyvsp[(5) - (5)].Number));                              }
    break;

  case 132:
#line 296 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetEngineInfo((yyvsp[(5) - (5)].String));                              }
    break;

  case 133:
#line 297 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetServerInfo();                                }
    break;

  case 134:
#line 298 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetTotalStreamCount();                           }
    break;

  case 135:
#line 299 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetTotalVoiceCount();                           }
    break;

  case 136:
#line 300 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetTotalVoiceCountMax();                        }
    break;

  case 137:
#line 301 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInstrumentMappings((yyvsp[(3) - (3)].Number));                  }
    break;

  case 138:
#line 302 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAllMidiInstrumentMappings();                 }
    break;

  case 139:
#line 303 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInstrumentMapping((yyvsp[(5) - (9)].Number),(yyvsp[(7) - (9)].Number),(yyvsp[(9) - (9)].Number));             }
    break;

  case 140:
#line 304 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInstrumentMaps();                        }
    break;

  case 141:
#line 305 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInstrumentMap((yyvsp[(5) - (5)].Number));                       }
    break;

  case 142:
#line 306 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetFxSends((yyvsp[(3) - (3)].Number));                                 }
    break;

  case 143:
#line 307 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetFxSendInfo((yyvsp[(5) - (7)].Number),(yyvsp[(7) - (7)].Number));                           }
    break;

  case 144:
#line 308 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentDirectoryCount((yyvsp[(5) - (5)].String), true);        }
    break;

  case 145:
#line 309 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentDirectoryCount((yyvsp[(3) - (3)].String), false);       }
    break;

  case 146:
#line 310 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentDirectoryInfo((yyvsp[(5) - (5)].String));               }
    break;

  case 147:
#line 311 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentCount((yyvsp[(5) - (5)].String), true);                 }
    break;

  case 148:
#line 312 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentCount((yyvsp[(3) - (3)].String), false);                }
    break;

  case 149:
#line 313 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentInfo((yyvsp[(5) - (5)].String));                        }
    break;

  case 150:
#line 314 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentsJobInfo((yyvsp[(5) - (5)].Number));                    }
    break;

  case 151:
#line 315 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetGlobalVolume();                              }
    break;

  case 152:
#line 316 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetGlobalMaxVoices();                           }
    break;

  case 153:
#line 317 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetGlobalMaxStreams();                          }
    break;

  case 154:
#line 318 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetFileInstruments((yyvsp[(5) - (5)].String));                         }
    break;

  case 155:
#line 319 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetFileInstrumentInfo((yyvsp[(7) - (9)].String),(yyvsp[(9) - (9)].Number));                   }
    break;

  case 156:
#line 322 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetAudioOutputDeviceParameter((yyvsp[(3) - (7)].Number), (yyvsp[(5) - (7)].String), (yyvsp[(7) - (7)].String));      }
    break;

  case 157:
#line 323 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetAudioOutputChannelParameter((yyvsp[(3) - (9)].Number), (yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].String), (yyvsp[(9) - (9)].String)); }
    break;

  case 158:
#line 324 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMidiInputDeviceParameter((yyvsp[(3) - (7)].Number), (yyvsp[(5) - (7)].String), (yyvsp[(7) - (7)].String));        }
    break;

  case 159:
#line 325 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMidiInputPortParameter((yyvsp[(3) - (9)].Number), (yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].String), "");      }
    break;

  case 160:
#line 326 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMidiInputPortParameter((yyvsp[(3) - (9)].Number), (yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].String), (yyvsp[(9) - (9)].String));      }
    break;

  case 161:
#line 327 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String);                                                         }
    break;

  case 162:
#line 328 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMidiInstrumentMapName((yyvsp[(5) - (7)].Number), (yyvsp[(7) - (7)].String));               }
    break;

  case 163:
#line 329 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetFxSendName((yyvsp[(5) - (9)].Number),(yyvsp[(7) - (9)].Number),(yyvsp[(9) - (9)].String));                        }
    break;

  case 164:
#line 330 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetFxSendAudioOutputChannel((yyvsp[(5) - (11)].Number),(yyvsp[(7) - (11)].Number),(yyvsp[(9) - (11)].Number),(yyvsp[(11) - (11)].Number)); }
    break;

  case 165:
#line 331 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetFxSendMidiController((yyvsp[(5) - (9)].Number),(yyvsp[(7) - (9)].Number),(yyvsp[(9) - (9)].Number));              }
    break;

  case 166:
#line 332 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetFxSendLevel((yyvsp[(5) - (9)].Number),(yyvsp[(7) - (9)].Number),(yyvsp[(9) - (9)].Dotnum));                       }
    break;

  case 167:
#line 333 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetDbInstrumentDirectoryName((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));            }
    break;

  case 168:
#line 334 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetDbInstrumentDirectoryDescription((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));     }
    break;

  case 169:
#line 335 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetDbInstrumentName((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));                     }
    break;

  case 170:
#line 336 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetDbInstrumentDescription((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));              }
    break;

  case 171:
#line 337 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetDbInstrumentFilePath((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].String));                 }
    break;

  case 172:
#line 338 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetEcho((yyparse_param_t*) yyparse_param, (yyvsp[(3) - (3)].Dotnum));  }
    break;

  case 173:
#line 339 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetGlobalVolume((yyvsp[(3) - (3)].Dotnum));                            }
    break;

  case 174:
#line 340 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetGlobalMaxVoices((yyvsp[(3) - (3)].Number));                         }
    break;

  case 175:
#line 341 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetGlobalMaxStreams((yyvsp[(3) - (3)].Number));                        }
    break;

  case 176:
#line 344 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateAudioOutputDevice((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].KeyValList)); }
    break;

  case 177:
#line 345 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateAudioOutputDevice((yyvsp[(3) - (3)].String));    }
    break;

  case 178:
#line 346 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateMidiInputDevice((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].KeyValList));   }
    break;

  case 179:
#line 347 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateMidiInputDevice((yyvsp[(3) - (3)].String));      }
    break;

  case 180:
#line 348 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateFxSend((yyvsp[(3) - (5)].Number),(yyvsp[(5) - (5)].Number));            }
    break;

  case 181:
#line 349 "lscp.y"
    { (yyval.String) = LSCPSERVER->CreateFxSend((yyvsp[(3) - (7)].Number),(yyvsp[(5) - (7)].Number),(yyvsp[(7) - (7)].String)); }
    break;

  case 182:
#line 352 "lscp.y"
    { (yyval.String) = LSCPSERVER->ResetChannel((yyvsp[(3) - (3)].Number)); }
    break;

  case 183:
#line 355 "lscp.y"
    { (yyval.String) = LSCPSERVER->ClearMidiInstrumentMappings((yyvsp[(3) - (3)].Number));  }
    break;

  case 184:
#line 356 "lscp.y"
    { (yyval.String) = LSCPSERVER->ClearAllMidiInstrumentMappings(); }
    break;

  case 185:
#line 359 "lscp.y"
    { (yyval.String) = LSCPSERVER->FindDbInstruments((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].KeyValList), false);           }
    break;

  case 186:
#line 360 "lscp.y"
    { (yyval.String) = LSCPSERVER->FindDbInstruments((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].KeyValList), true);            }
    break;

  case 187:
#line 361 "lscp.y"
    { (yyval.String) = LSCPSERVER->FindDbInstrumentDirectories((yyvsp[(5) - (7)].String),(yyvsp[(7) - (7)].KeyValList), false); }
    break;

  case 188:
#line 362 "lscp.y"
    { (yyval.String) = LSCPSERVER->FindDbInstrumentDirectories((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].KeyValList), true);  }
    break;

  case 189:
#line 363 "lscp.y"
    { (yyval.String) = LSCPSERVER->FindLostDbInstrumentFiles();                 }
    break;

  case 190:
#line 366 "lscp.y"
    { (yyval.String) = LSCPSERVER->MoveDbInstrumentDirectory((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].String)); }
    break;

  case 191:
#line 367 "lscp.y"
    { (yyval.String) = LSCPSERVER->MoveDbInstrument((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].String));          }
    break;

  case 192:
#line 370 "lscp.y"
    { (yyval.String) = LSCPSERVER->CopyDbInstrumentDirectory((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].String)); }
    break;

  case 193:
#line 371 "lscp.y"
    { (yyval.String) = LSCPSERVER->CopyDbInstrument((yyvsp[(3) - (5)].String),(yyvsp[(5) - (5)].String));          }
    break;

  case 194:
#line 374 "lscp.y"
    { (yyval.String) = LSCPSERVER->DestroyAudioOutputDevice((yyvsp[(3) - (3)].Number)); }
    break;

  case 195:
#line 375 "lscp.y"
    { (yyval.String) = LSCPSERVER->DestroyMidiInputDevice((yyvsp[(3) - (3)].Number));   }
    break;

  case 196:
#line 376 "lscp.y"
    { (yyval.String) = LSCPSERVER->DestroyFxSend((yyvsp[(3) - (5)].Number),(yyvsp[(5) - (5)].Number)); }
    break;

  case 197:
#line 379 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String); }
    break;

  case 198:
#line 380 "lscp.y"
    { (yyval.String) = (yyvsp[(3) - (3)].String); }
    break;

  case 199:
#line 383 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetAudioOutputDevice((yyvsp[(5) - (5)].Number), (yyvsp[(3) - (5)].Number));      }
    break;

  case 200:
#line 384 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetAudioOutputChannel((yyvsp[(5) - (7)].Number), (yyvsp[(7) - (7)].Number), (yyvsp[(3) - (7)].Number)); }
    break;

  case 201:
#line 385 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetAudioOutputType((yyvsp[(5) - (5)].String), (yyvsp[(3) - (5)].Number));        }
    break;

  case 202:
#line 386 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMIDIInput((yyvsp[(5) - (9)].Number), (yyvsp[(7) - (9)].Number), (yyvsp[(9) - (9)].Number), (yyvsp[(3) - (9)].Number));      }
    break;

  case 203:
#line 387 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMIDIInputDevice((yyvsp[(5) - (5)].Number), (yyvsp[(3) - (5)].Number));        }
    break;

  case 204:
#line 388 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMIDIInputPort((yyvsp[(5) - (5)].Number), (yyvsp[(3) - (5)].Number));          }
    break;

  case 205:
#line 389 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMIDIInputChannel((yyvsp[(5) - (5)].Number), (yyvsp[(3) - (5)].Number));       }
    break;

  case 206:
#line 390 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetMIDIInputType((yyvsp[(5) - (5)].String), (yyvsp[(3) - (5)].Number));          }
    break;

  case 207:
#line 391 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetVolume((yyvsp[(5) - (5)].Dotnum), (yyvsp[(3) - (5)].Number));                 }
    break;

  case 208:
#line 392 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetChannelMute((yyvsp[(5) - (5)].Dotnum), (yyvsp[(3) - (5)].Number));            }
    break;

  case 209:
#line 393 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetChannelSolo((yyvsp[(5) - (5)].Dotnum), (yyvsp[(3) - (5)].Number));            }
    break;

  case 210:
#line 394 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetChannelMap((yyvsp[(3) - (5)].Number), (yyvsp[(5) - (5)].Number));             }
    break;

  case 211:
#line 395 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetChannelMap((yyvsp[(3) - (5)].Number), -1);             }
    break;

  case 212:
#line 396 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetChannelMap((yyvsp[(3) - (5)].Number), -2);             }
    break;

  case 213:
#line 399 "lscp.y"
    { (yyval.String) = LSCPSERVER->EditSamplerChannelInstrument((yyvsp[(5) - (5)].Number)); }
    break;

  case 214:
#line 402 "lscp.y"
    { (yyval.String) = LSCPSERVER->FormatInstrumentsDb(); }
    break;

  case 215:
#line 405 "lscp.y"
    { (yyval.Bool) = true;  }
    break;

  case 216:
#line 406 "lscp.y"
    { (yyval.Bool) = false; }
    break;

  case 217:
#line 409 "lscp.y"
    { (yyval.KeyValList)[(yyvsp[(1) - (3)].String)] = (yyvsp[(3) - (3)].String);          }
    break;

  case 218:
#line 410 "lscp.y"
    { (yyval.KeyValList) = (yyvsp[(1) - (5)].KeyValList); (yyval.KeyValList)[(yyvsp[(3) - (5)].String)] = (yyvsp[(5) - (5)].String); }
    break;

  case 219:
#line 413 "lscp.y"
    { (yyval.FillResponse) = fill_response_bytes;      }
    break;

  case 220:
#line 414 "lscp.y"
    { (yyval.FillResponse) = fill_response_percentage; }
    break;

  case 221:
#line 417 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetAudioOutputDevices();              }
    break;

  case 222:
#line 418 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetMidiInputDevices();                }
    break;

  case 223:
#line 419 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListChannels();                       }
    break;

  case 224:
#line 420 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListAvailableEngines();               }
    break;

  case 225:
#line 421 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListAvailableMidiInputDrivers();      }
    break;

  case 226:
#line 422 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListAvailableAudioOutputDrivers();    }
    break;

  case 227:
#line 423 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListMidiInstrumentMappings((yyvsp[(3) - (3)].Number));       }
    break;

  case 228:
#line 424 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListAllMidiInstrumentMappings();      }
    break;

  case 229:
#line 425 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListMidiInstrumentMaps();             }
    break;

  case 230:
#line 426 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListFxSends((yyvsp[(3) - (3)].Number));                      }
    break;

  case 231:
#line 427 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentDirectories((yyvsp[(5) - (5)].String), true); }
    break;

  case 232:
#line 428 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstrumentDirectories((yyvsp[(3) - (3)].String));       }
    break;

  case 233:
#line 429 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstruments((yyvsp[(5) - (5)].String), true);           }
    break;

  case 234:
#line 430 "lscp.y"
    { (yyval.String) = LSCPSERVER->GetDbInstruments((yyvsp[(3) - (3)].String));                 }
    break;

  case 235:
#line 431 "lscp.y"
    { (yyval.String) = LSCPSERVER->ListFileInstruments((yyvsp[(5) - (5)].String));              }
    break;

  case 236:
#line 434 "lscp.y"
    { (yyval.String) = LSCPSERVER->SendChannelMidiData((yyvsp[(5) - (11)].String), (yyvsp[(7) - (11)].Number), (yyvsp[(9) - (11)].Number), (yyvsp[(11) - (11)].Number)); }
    break;

  case 237:
#line 437 "lscp.y"
    { (yyval.String) = LSCPSERVER->LoadInstrument((yyvsp[(1) - (5)].String), (yyvsp[(3) - (5)].Number), (yyvsp[(5) - (5)].Number));       }
    break;

  case 238:
#line 438 "lscp.y"
    { (yyval.String) = LSCPSERVER->LoadInstrument((yyvsp[(3) - (7)].String), (yyvsp[(5) - (7)].Number), (yyvsp[(7) - (7)].Number), true); }
    break;

  case 239:
#line 441 "lscp.y"
    { (yyval.String) = LSCPSERVER->SetEngineType((yyvsp[(1) - (3)].String), (yyvsp[(3) - (3)].Number)); }
    break;

  case 240:
#line 444 "lscp.y"
    { (yyval.LoadMode) = MidiInstrumentMapper::ON_DEMAND;      }
    break;

  case 241:
#line 445 "lscp.y"
    { (yyval.LoadMode) = MidiInstrumentMapper::ON_DEMAND_HOLD; }
    break;

  case 242:
#line 446 "lscp.y"
    { (yyval.LoadMode) = MidiInstrumentMapper::PERSISTENT;     }
    break;

  case 248:
#line 462 "lscp.y"
    { (yyval.Number) = 16; }
    break;

  case 255:
#line 481 "lscp.y"
    { (yyval.Dotnum) = (yyvsp[(1) - (1)].Number); }
    break;

  case 260:
#line 496 "lscp.y"
    {
                                 #if WIN32
                                 (yyval.String) = (yyvsp[(1) - (1)].UniversalPath).toWindows();
                                 #else
                                 // assuming POSIX
                                 (yyval.String) = (yyvsp[(1) - (1)].UniversalPath).toPosix();
                                 #endif
                             }
    break;

  case 261:
#line 506 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (1)].UniversalPath).toDbPath(); }
    break;

  case 266:
#line 519 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (3)].String) + "," + (yyvsp[(3) - (3)].String); }
    break;

  case 267:
#line 523 "lscp.y"
    { (yyval.String) = "\'" + (yyvsp[(1) - (1)].String) + "\'"; }
    break;

  case 268:
#line 524 "lscp.y"
    { (yyval.String) = "\'" + (yyvsp[(1) - (1)].String) + "\'"; }
    break;

  case 269:
#line 525 "lscp.y"
    { std::stringstream ss; ss << "\'" << (yyvsp[(1) - (1)].Number) << "\'"; (yyval.String) = ss.str(); }
    break;

  case 270:
#line 526 "lscp.y"
    { std::stringstream ss; ss << "\'" << (yyvsp[(1) - (1)].Dotnum) << "\'"; (yyval.String) = ss.str(); }
    break;

  case 271:
#line 529 "lscp.y"
    { (yyval.KeyValList)[(yyvsp[(1) - (3)].String)] = (yyvsp[(3) - (3)].String);          }
    break;

  case 272:
#line 530 "lscp.y"
    { (yyval.KeyValList) = (yyvsp[(1) - (5)].KeyValList); (yyval.KeyValList)[(yyvsp[(3) - (5)].String)] = (yyvsp[(5) - (5)].String); }
    break;

  case 275:
#line 537 "lscp.y"
    { (yyval.String) = "RECURSIVE"; }
    break;

  case 276:
#line 538 "lscp.y"
    { (yyval.String) = "NON_RECURSIVE"; }
    break;

  case 277:
#line 539 "lscp.y"
    { (yyval.String) = "FLAT"; }
    break;

  case 278:
#line 547 "lscp.y"
    { (yyval.Dotnum) = (yyvsp[(1) - (1)].Number); }
    break;

  case 279:
#line 548 "lscp.y"
    { (yyval.Dotnum) = -1; }
    break;

  case 280:
#line 551 "lscp.y"
    { std::stringstream ss((yyvsp[(1) - (3)].String) + "." + (yyvsp[(3) - (3)].String)); ss.imbue(std::locale::classic()); ss >> (yyval.Dotnum); }
    break;

  case 281:
#line 552 "lscp.y"
    { std::stringstream ss((yyvsp[(2) - (4)].String) + "." + (yyvsp[(4) - (4)].String)); ss.imbue(std::locale::classic()); ss >> (yyval.Dotnum); }
    break;

  case 282:
#line 553 "lscp.y"
    { std::stringstream ss("-" + (yyvsp[(2) - (4)].String) + "." + (yyvsp[(4) - (4)].String)); ss.imbue(std::locale::classic()); ss >> (yyval.Dotnum); }
    break;

  case 283:
#line 557 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (1)].Char);      }
    break;

  case 284:
#line 558 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].Char); }
    break;

  case 285:
#line 561 "lscp.y"
    { (yyval.Char) = '0'; }
    break;

  case 286:
#line 562 "lscp.y"
    { (yyval.Char) = '1'; }
    break;

  case 287:
#line 563 "lscp.y"
    { (yyval.Char) = '2'; }
    break;

  case 288:
#line 564 "lscp.y"
    { (yyval.Char) = '3'; }
    break;

  case 289:
#line 565 "lscp.y"
    { (yyval.Char) = '4'; }
    break;

  case 290:
#line 566 "lscp.y"
    { (yyval.Char) = '5'; }
    break;

  case 291:
#line 567 "lscp.y"
    { (yyval.Char) = '6'; }
    break;

  case 292:
#line 568 "lscp.y"
    { (yyval.Char) = '7'; }
    break;

  case 293:
#line 569 "lscp.y"
    { (yyval.Char) = '8'; }
    break;

  case 294:
#line 570 "lscp.y"
    { (yyval.Char) = '9'; }
    break;

  case 295:
#line 573 "lscp.y"
    { (yyval.Char) = '0'; }
    break;

  case 296:
#line 574 "lscp.y"
    { (yyval.Char) = '1'; }
    break;

  case 297:
#line 575 "lscp.y"
    { (yyval.Char) = '2'; }
    break;

  case 298:
#line 576 "lscp.y"
    { (yyval.Char) = '3'; }
    break;

  case 299:
#line 577 "lscp.y"
    { (yyval.Char) = '4'; }
    break;

  case 300:
#line 578 "lscp.y"
    { (yyval.Char) = '5'; }
    break;

  case 301:
#line 579 "lscp.y"
    { (yyval.Char) = '6'; }
    break;

  case 302:
#line 580 "lscp.y"
    { (yyval.Char) = '7'; }
    break;

  case 303:
#line 583 "lscp.y"
    { (yyval.Char) = '0'; }
    break;

  case 304:
#line 584 "lscp.y"
    { (yyval.Char) = '1'; }
    break;

  case 305:
#line 585 "lscp.y"
    { (yyval.Char) = '2'; }
    break;

  case 306:
#line 586 "lscp.y"
    { (yyval.Char) = '3'; }
    break;

  case 307:
#line 587 "lscp.y"
    { (yyval.Char) = '4'; }
    break;

  case 308:
#line 588 "lscp.y"
    { (yyval.Char) = '5'; }
    break;

  case 309:
#line 589 "lscp.y"
    { (yyval.Char) = '6'; }
    break;

  case 310:
#line 590 "lscp.y"
    { (yyval.Char) = '7'; }
    break;

  case 311:
#line 591 "lscp.y"
    { (yyval.Char) = '8'; }
    break;

  case 312:
#line 592 "lscp.y"
    { (yyval.Char) = '9'; }
    break;

  case 313:
#line 593 "lscp.y"
    { (yyval.Char) = 'a'; }
    break;

  case 314:
#line 594 "lscp.y"
    { (yyval.Char) = 'b'; }
    break;

  case 315:
#line 595 "lscp.y"
    { (yyval.Char) = 'c'; }
    break;

  case 316:
#line 596 "lscp.y"
    { (yyval.Char) = 'd'; }
    break;

  case 317:
#line 597 "lscp.y"
    { (yyval.Char) = 'e'; }
    break;

  case 318:
#line 598 "lscp.y"
    { (yyval.Char) = 'f'; }
    break;

  case 319:
#line 599 "lscp.y"
    { (yyval.Char) = 'a'; }
    break;

  case 320:
#line 600 "lscp.y"
    { (yyval.Char) = 'b'; }
    break;

  case 321:
#line 601 "lscp.y"
    { (yyval.Char) = 'c'; }
    break;

  case 322:
#line 602 "lscp.y"
    { (yyval.Char) = 'd'; }
    break;

  case 323:
#line 603 "lscp.y"
    { (yyval.Char) = 'e'; }
    break;

  case 324:
#line 604 "lscp.y"
    { (yyval.Char) = 'f'; }
    break;

  case 325:
#line 607 "lscp.y"
    { (yyval.Number) = atoi(String(1, (yyvsp[(1) - (1)].Char)).c_str());      }
    break;

  case 326:
#line 608 "lscp.y"
    { (yyval.Number) = atoi(String(String("1") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 327:
#line 609 "lscp.y"
    { (yyval.Number) = atoi(String(String("2") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 328:
#line 610 "lscp.y"
    { (yyval.Number) = atoi(String(String("3") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 329:
#line 611 "lscp.y"
    { (yyval.Number) = atoi(String(String("4") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 330:
#line 612 "lscp.y"
    { (yyval.Number) = atoi(String(String("5") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 331:
#line 613 "lscp.y"
    { (yyval.Number) = atoi(String(String("6") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 332:
#line 614 "lscp.y"
    { (yyval.Number) = atoi(String(String("7") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 333:
#line 615 "lscp.y"
    { (yyval.Number) = atoi(String(String("8") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 334:
#line 616 "lscp.y"
    { (yyval.Number) = atoi(String(String("9") + (yyvsp[(2) - (2)].String)).c_str()); }
    break;

  case 335:
#line 619 "lscp.y"
    { (yyval.UniversalPath) = (yyvsp[(2) - (3)].UniversalPath); }
    break;

  case 336:
#line 620 "lscp.y"
    { (yyval.UniversalPath) = (yyvsp[(2) - (3)].UniversalPath); }
    break;

  case 337:
#line 623 "lscp.y"
    { (yyval.UniversalPath) = (yyvsp[(1) - (2)].UniversalPath) + (yyvsp[(2) - (2)].UniversalPath); }
    break;

  case 338:
#line 626 "lscp.y"
    { (yyval.UniversalPath) = Path();                    }
    break;

  case 339:
#line 627 "lscp.y"
    { Path p; p.setDrive((yyvsp[(1) - (3)].Char)); (yyval.UniversalPath) = p; }
    break;

  case 340:
#line 630 "lscp.y"
    { (yyval.UniversalPath) = Path();                           }
    break;

  case 341:
#line 631 "lscp.y"
    { (yyval.UniversalPath) = (yyvsp[(1) - (2)].UniversalPath);                               }
    break;

  case 342:
#line 632 "lscp.y"
    { Path p; p.appendNode((yyvsp[(2) - (2)].String)); (yyval.UniversalPath) = (yyvsp[(1) - (2)].UniversalPath) + p; }
    break;

  case 343:
#line 635 "lscp.y"
    { (yyval.String) = (yyvsp[(2) - (3)].String); }
    break;

  case 344:
#line 636 "lscp.y"
    { (yyval.String) = (yyvsp[(2) - (3)].String); }
    break;

  case 345:
#line 639 "lscp.y"
    { (yyval.String) = (yyvsp[(2) - (3)].String); }
    break;

  case 346:
#line 640 "lscp.y"
    { (yyval.String) = (yyvsp[(2) - (3)].String); }
    break;

  case 347:
#line 643 "lscp.y"
    { (yyval.String) = " ";      }
    break;

  case 349:
#line 645 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + " "; }
    break;

  case 350:
#line 646 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].String);  }
    break;

  case 351:
#line 650 "lscp.y"
    { (yyval.String) = " ";      }
    break;

  case 353:
#line 652 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + " "; }
    break;

  case 354:
#line 653 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].String);  }
    break;

  case 355:
#line 656 "lscp.y"
    { (yyval.String) = "/";      }
    break;

  case 357:
#line 658 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + "/"; }
    break;

  case 358:
#line 659 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].String);  }
    break;

  case 359:
#line 662 "lscp.y"
    { std::string s; s = (yyvsp[(1) - (1)].Char); (yyval.String) = s; }
    break;

  case 360:
#line 663 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].Char);                  }
    break;

  case 361:
#line 666 "lscp.y"
    { std::string s; s = (yyvsp[(1) - (1)].Char); (yyval.String) = s; }
    break;

  case 362:
#line 667 "lscp.y"
    { std::string s; s = (yyvsp[(1) - (1)].Char); (yyval.String) = s; }
    break;

  case 363:
#line 668 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].Char);                  }
    break;

  case 364:
#line 669 "lscp.y"
    { (yyval.String) = (yyvsp[(1) - (2)].String) + (yyvsp[(2) - (2)].Char);                  }
    break;

  case 366:
#line 674 "lscp.y"
    { (yyval.Char) = '\\'; }
    break;

  case 367:
#line 675 "lscp.y"
    { (yyval.Char) = '/';  }
    break;

  case 368:
#line 679 "lscp.y"
    { (yyval.Char) = 'A'; }
    break;

  case 369:
#line 679 "lscp.y"
    { (yyval.Char) = 'B'; }
    break;

  case 370:
#line 679 "lscp.y"
    { (yyval.Char) = 'C'; }
    break;

  case 371:
#line 679 "lscp.y"
    { (yyval.Char) = 'D'; }
    break;

  case 372:
#line 679 "lscp.y"
    { (yyval.Char) = 'E'; }
    break;

  case 373:
#line 679 "lscp.y"
    { (yyval.Char) = 'F'; }
    break;

  case 374:
#line 679 "lscp.y"
    { (yyval.Char) = 'G'; }
    break;

  case 375:
#line 679 "lscp.y"
    { (yyval.Char) = 'H'; }
    break;

  case 376:
#line 679 "lscp.y"
    { (yyval.Char) = 'I'; }
    break;

  case 377:
#line 679 "lscp.y"
    { (yyval.Char) = 'J'; }
    break;

  case 378:
#line 679 "lscp.y"
    { (yyval.Char) = 'K'; }
    break;

  case 379:
#line 679 "lscp.y"
    { (yyval.Char) = 'L'; }
    break;

  case 380:
#line 679 "lscp.y"
    { (yyval.Char) = 'M'; }
    break;

  case 381:
#line 679 "lscp.y"
    { (yyval.Char) = 'N'; }
    break;

  case 382:
#line 679 "lscp.y"
    { (yyval.Char) = 'O'; }
    break;

  case 383:
#line 679 "lscp.y"
    { (yyval.Char) = 'P'; }
    break;

  case 384:
#line 679 "lscp.y"
    { (yyval.Char) = 'Q'; }
    break;

  case 385:
#line 679 "lscp.y"
    { (yyval.Char) = 'R'; }
    break;

  case 386:
#line 679 "lscp.y"
    { (yyval.Char) = 'S'; }
    break;

  case 387:
#line 679 "lscp.y"
    { (yyval.Char) = 'T'; }
    break;

  case 388:
#line 679 "lscp.y"
    { (yyval.Char) = 'U'; }
    break;

  case 389:
#line 679 "lscp.y"
    { (yyval.Char) = 'V'; }
    break;

  case 390:
#line 679 "lscp.y"
    { (yyval.Char) = 'W'; }
    break;

  case 391:
#line 679 "lscp.y"
    { (yyval.Char) = 'X'; }
    break;

  case 392:
#line 679 "lscp.y"
    { (yyval.Char) = 'Y'; }
    break;

  case 393:
#line 679 "lscp.y"
    { (yyval.Char) = 'Z'; }
    break;

  case 394:
#line 680 "lscp.y"
    { (yyval.Char) = 'a'; }
    break;

  case 395:
#line 680 "lscp.y"
    { (yyval.Char) = 'b'; }
    break;

  case 396:
#line 680 "lscp.y"
    { (yyval.Char) = 'c'; }
    break;

  case 397:
#line 680 "lscp.y"
    { (yyval.Char) = 'd'; }
    break;

  case 398:
#line 680 "lscp.y"
    { (yyval.Char) = 'e'; }
    break;

  case 399:
#line 680 "lscp.y"
    { (yyval.Char) = 'f'; }
    break;

  case 400:
#line 680 "lscp.y"
    { (yyval.Char) = 'g'; }
    break;

  case 401:
#line 680 "lscp.y"
    { (yyval.Char) = 'h'; }
    break;

  case 402:
#line 680 "lscp.y"
    { (yyval.Char) = 'i'; }
    break;

  case 403:
#line 680 "lscp.y"
    { (yyval.Char) = 'j'; }
    break;

  case 404:
#line 680 "lscp.y"
    { (yyval.Char) = 'k'; }
    break;

  case 405:
#line 680 "lscp.y"
    { (yyval.Char) = 'l'; }
    break;

  case 406:
#line 680 "lscp.y"
    { (yyval.Char) = 'm'; }
    break;

  case 407:
#line 680 "lscp.y"
    { (yyval.Char) = 'n'; }
    break;

  case 408:
#line 680 "lscp.y"
    { (yyval.Char) = 'o'; }
    break;

  case 409:
#line 680 "lscp.y"
    { (yyval.Char) = 'p'; }
    break;

  case 410:
#line 680 "lscp.y"
    { (yyval.Char) = 'q'; }
    break;

  case 411:
#line 680 "lscp.y"
    { (yyval.Char) = 'r'; }
    break;

  case 412:
#line 680 "lscp.y"
    { (yyval.Char) = 's'; }
    break;

  case 413:
#line 680 "lscp.y"
    { (yyval.Char) = 't'; }
    break;

  case 414:
#line 680 "lscp.y"
    { (yyval.Char) = 'u'; }
    break;

  case 415:
#line 680 "lscp.y"
    { (yyval.Char) = 'v'; }
    break;

  case 416:
#line 680 "lscp.y"
    { (yyval.Char) = 'w'; }
    break;

  case 417:
#line 680 "lscp.y"
    { (yyval.Char) = 'x'; }
    break;

  case 418:
#line 680 "lscp.y"
    { (yyval.Char) = 'y'; }
    break;

  case 419:
#line 680 "lscp.y"
    { (yyval.Char) = 'z'; }
    break;

  case 421:
#line 685 "lscp.y"
    { (yyval.Char) = '0'; }
    break;

  case 422:
#line 685 "lscp.y"
    { (yyval.Char) = '1'; }
    break;

  case 423:
#line 685 "lscp.y"
    { (yyval.Char) = '2'; }
    break;

  case 424:
#line 685 "lscp.y"
    { (yyval.Char) = '3'; }
    break;

  case 425:
#line 685 "lscp.y"
    { (yyval.Char) = '4'; }
    break;

  case 426:
#line 685 "lscp.y"
    { (yyval.Char) = '5'; }
    break;

  case 427:
#line 685 "lscp.y"
    { (yyval.Char) = '6'; }
    break;

  case 428:
#line 685 "lscp.y"
    { (yyval.Char) = '7'; }
    break;

  case 429:
#line 685 "lscp.y"
    { (yyval.Char) = '8'; }
    break;

  case 430:
#line 685 "lscp.y"
    { (yyval.Char) = '9'; }
    break;

  case 431:
#line 686 "lscp.y"
    { (yyval.Char) = '!'; }
    break;

  case 432:
#line 686 "lscp.y"
    { (yyval.Char) = '#'; }
    break;

  case 433:
#line 686 "lscp.y"
    { (yyval.Char) = '$'; }
    break;

  case 434:
#line 686 "lscp.y"
    { (yyval.Char) = '%'; }
    break;

  case 435:
#line 686 "lscp.y"
    { (yyval.Char) = '&'; }
    break;

  case 436:
#line 686 "lscp.y"
    { (yyval.Char) = '('; }
    break;

  case 437:
#line 686 "lscp.y"
    { (yyval.Char) = ')'; }
    break;

  case 438:
#line 686 "lscp.y"
    { (yyval.Char) = '*'; }
    break;

  case 439:
#line 686 "lscp.y"
    { (yyval.Char) = '+'; }
    break;

  case 440:
#line 686 "lscp.y"
    { (yyval.Char) = '-'; }
    break;

  case 441:
#line 686 "lscp.y"
    { (yyval.Char) = '.'; }
    break;

  case 442:
#line 686 "lscp.y"
    { (yyval.Char) = ','; }
    break;

  case 443:
#line 687 "lscp.y"
    { (yyval.Char) = ':'; }
    break;

  case 444:
#line 687 "lscp.y"
    { (yyval.Char) = ';'; }
    break;

  case 445:
#line 687 "lscp.y"
    { (yyval.Char) = '<'; }
    break;

  case 446:
#line 687 "lscp.y"
    { (yyval.Char) = '='; }
    break;

  case 447:
#line 687 "lscp.y"
    { (yyval.Char) = '>'; }
    break;

  case 448:
#line 687 "lscp.y"
    { (yyval.Char) = '?'; }
    break;

  case 449:
#line 687 "lscp.y"
    { (yyval.Char) = '@'; }
    break;

  case 450:
#line 688 "lscp.y"
    { (yyval.Char) = '['; }
    break;

  case 451:
#line 688 "lscp.y"
    { (yyval.Char) = ']'; }
    break;

  case 452:
#line 688 "lscp.y"
    { (yyval.Char) = '^'; }
    break;

  case 453:
#line 688 "lscp.y"
    { (yyval.Char) = '_'; }
    break;

  case 454:
#line 689 "lscp.y"
    { (yyval.Char) = '{'; }
    break;

  case 455:
#line 689 "lscp.y"
    { (yyval.Char) = '|'; }
    break;

  case 456:
#line 689 "lscp.y"
    { (yyval.Char) = '}'; }
    break;

  case 457:
#line 689 "lscp.y"
    { (yyval.Char) = '~'; }
    break;

  case 459:
#line 693 "lscp.y"
    { (yyval.Char) = '\''; }
    break;

  case 460:
#line 694 "lscp.y"
    { (yyval.Char) = '\"'; }
    break;

  case 461:
#line 695 "lscp.y"
    { (yyval.Char) = '\\'; }
    break;

  case 462:
#line 696 "lscp.y"
    { (yyval.Char) = '/';  }
    break;

  case 463:
#line 697 "lscp.y"
    { (yyval.Char) = '\n'; }
    break;

  case 464:
#line 698 "lscp.y"
    { (yyval.Char) = '\r'; }
    break;

  case 465:
#line 699 "lscp.y"
    { (yyval.Char) = '\f'; }
    break;

  case 466:
#line 700 "lscp.y"
    { (yyval.Char) = '\t'; }
    break;

  case 467:
#line 701 "lscp.y"
    { (yyval.Char) = '\v'; }
    break;

  case 470:
#line 706 "lscp.y"
    { (yyval.Char) = (char) octalsToNumber((yyvsp[(2) - (2)].Char));       }
    break;

  case 471:
#line 707 "lscp.y"
    { (yyval.Char) = (char) octalsToNumber((yyvsp[(3) - (3)].Char),(yyvsp[(2) - (3)].Char));    }
    break;

  case 472:
#line 708 "lscp.y"
    { (yyval.Char) = (char) octalsToNumber((yyvsp[(4) - (4)].Char),(yyvsp[(3) - (4)].Char),(yyvsp[(2) - (4)].Char)); }
    break;

  case 473:
#line 711 "lscp.y"
    { (yyval.Char) = (char) hexsToNumber((yyvsp[(3) - (3)].Char));    }
    break;

  case 474:
#line 712 "lscp.y"
    { (yyval.Char) = (char) hexsToNumber((yyvsp[(4) - (4)].Char),(yyvsp[(3) - (4)].Char)); }
    break;


/* Line 1267 of yacc.c.  */
#line 5837 "y.tab.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 1077 "lscp.y"


/**
 * Will be called when an error occured (usually syntax error).
 */
void yyerror(const char* s) {
    yyparse_param_t* param = GetCurrentYaccSession();
    String msg = s
        + (" (line:"   + ToString(param->iLine+1))
        + ( ",column:" + ToString(param->iColumn))
        + ")";
    dmsg(2,("LSCPParser: %s\n", msg.c_str()));
    sLastError = msg;
}

namespace LinuxSampler {

/**
 * Clears input buffer.
 */
void restart(yyparse_param_t* pparam, int& yychar) {
    bytes = 0;
    ptr   = 0;
    sLastError = "";
}

}

