/*
 *      Copyright (C) 2005-2012 Team XBMC
 *      http://www.xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#include "VideoThumbLoader.h"
#include "TextureCache.h"
#include "guilib/GUIListItem.h"

using namespace XFILE;
using namespace std;


CVideoThumbLoader::CVideoThumbLoader() :
  CThumbLoader(1)
{
}

CVideoThumbLoader::~CVideoThumbLoader()
{
  StopThread();
}

void CVideoThumbLoader::Initialize()
{
}

void CVideoThumbLoader::OnLoaderStart()
{
  Initialize();
}

void CVideoThumbLoader::OnLoaderFinish()
{
}

/**
 * Look for a thumbnail for pItem.  If one does not exist, look for an autogenerated
 * thumbnail.  If that does not exist, attempt to autogenerate one.  Finally, check
 * for the existance of fanart and set properties accordingly.
 * @return: true if pItem has been modified
 */
bool CVideoThumbLoader::LoadItem(CFileItem* pItem)
{
  if (!pItem->IsPlexMediaServer())
    return false;
  
  /*
  const CGUIListItem::ArtMap artMap = pItem->GetArt();
  pair<string, string> stringPair;
  BOOST_FOREACH(stringPair, artMap)
  {
    if (!CTextureCache::Get().HasCachedImage(stringPair.second))
      CTextureCache::Get().BackgroundCacheImage(stringPair.second);
  }*/

  if (pItem->HasArt("thumb") &&
      !CTextureCache::Get().HasCachedImage(pItem->GetArt("thumb")))
    CTextureCache::Get().BackgroundCacheImage(pItem->GetArt("thumb"));
  
  if (pItem->HasArt("fanart") &&
      !CTextureCache::Get().HasCachedImage(pItem->GetArt("fanart")))
    CTextureCache::Get().BackgroundCacheImage(pItem->GetArt("fanart"));

  if (pItem->HasArt("grandParentThumb") &&
      !CTextureCache::Get().HasCachedImage(pItem->GetArt("grandParentThumb")))
    CTextureCache::Get().BackgroundCacheImage(pItem->GetArt("grandParentThumb"));

  if (pItem->HasArt("bigPoster") &&
      !CTextureCache::Get().HasCachedImage(pItem->GetArt("bigPoster")))
    CTextureCache::Get().BackgroundCacheImage(pItem->GetArt("bigPoster"));
  
  return true;
}

bool CVideoThumbLoader::FillThumb(CFileItem &item)
{
  return true;
}

vector<string> CVideoThumbLoader::GetArtTypes(const string &type)
{
  vector<string> ret;
  if (type == "episode")
    ret.push_back("thumb");
  else if (type == "tvshow" || type == "season")
  {
    ret.push_back("banner");
    ret.push_back("poster");
    ret.push_back("fanart");
  }
  else if (type == "movie" || type == "musicvideo" || type == "set")
  {
    ret.push_back("poster");
    ret.push_back("fanart");
  }
  else if (type.empty()) // unknown - just throw everything in
  {
    ret.push_back("poster");
    ret.push_back("banner");
    ret.push_back("thumb");
    ret.push_back("fanart");
  }
  return ret;
}

std::string CVideoThumbLoader::GetLocalArt(const CFileItem &item, const std::string &type, bool checkFolder)
{
  return "";
}
