/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.explodingpixels.macwidgets.HudWidgetFactory;
import com.explodingpixels.macwidgets.HudWindow;
import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import mediathek.daten.Daten;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.res.GetIcon;
import mediathek.tool.BeobMausUrl;
import mediathek.tool.EscBeenden;
import mediathek.tool.UrlHyperlinkAction;
import msearch.daten.DatenFilm;
import org.jdesktop.swingx.JXHyperlink;

public class MVFilmInformation
implements MVFilmInfo {
    private HudWindow hud = null;
    private JDialog dialog = null;
    private JXHyperlink lblUrlThemaField;
    private JXHyperlink lblUrlSubtitle;
    private JTextArea textAreaBeschreibung;
    private JLabel jLabelFilmNeu;
    private final JLabel[] labelArrNames = new JLabel[26];
    private final JTextField[] txtArrCont = new JTextField[26];
    private final Color foreground;
    private final Color background;
    private DatenFilm aktFilm = new DatenFilm();
    private final JFrame parent;
    private static ImageIcon ja_sw_16 = null;

    public MVFilmInformation(JFrame owner, JTabbedPane tabbedPane, Daten ddaten) {
        this.parent = owner;
        this.foreground = Color.WHITE;
        this.background = Color.BLACK;
        ja_sw_16 = GetIcon.getProgramIcon("ja_sw_16.png");
        this.hud = new HudWindow("Filminformation", owner);
        this.hud.makeResizeable();
        for (int i = 0; i < 26; ++i) {
            this.labelArrNames[i] = HudWidgetFactory.createHudLabel(DatenFilm.COLUMN_NAMES[i] + ":");
            this.labelArrNames[i].setHorizontalAlignment(4);
            this.labelArrNames[i].setDoubleBuffered(true);
            this.txtArrCont[i] = HudWidgetFactory.createHudTextField("");
            this.txtArrCont[i].setEditable(false);
            this.txtArrCont[i].setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.txtArrCont[i].setDoubleBuffered(true);
        }
        JComponent content = this.setLable();
        content.setDoubleBuffered(true);
        content.setOpaque(false);
        this.hud.setContentPane(content);
        this.dialog = this.hud.getJDialog();
        Dimension size = this.dialog.getSize();
        size.width = 600;
        size.height = 450;
        this.dialog.setSize(size);
        this.calculateHudPosition();
        tabbedPane.addChangeListener(this);
        new EscBeenden(this.dialog){

            @Override
            public void beenden_(JDialog d) {
                d.dispose();
            }
        };
    }

    private JComponent setLable() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.lblUrlThemaField = new JXHyperlink();
        this.lblUrlThemaField.setDoubleBuffered(true);
        this.lblUrlThemaField.setForeground(this.foreground);
        try {
            this.lblUrlThemaField.setAction((Action)new UrlHyperlinkAction(this.parent, ""));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.lblUrlThemaField.addMouseListener((MouseListener)new BeobMausUrl((JButton)this.lblUrlThemaField));
        this.lblUrlThemaField.setFont(HudPaintingUtils.getHudFont());
        this.lblUrlSubtitle = new JXHyperlink();
        this.lblUrlSubtitle.setDoubleBuffered(true);
        this.lblUrlSubtitle.setForeground(this.foreground);
        try {
            this.lblUrlSubtitle.setAction((Action)new UrlHyperlinkAction(this.parent, ""));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.lblUrlSubtitle.addMouseListener((MouseListener)new BeobMausUrl((JButton)this.lblUrlSubtitle));
        this.lblUrlSubtitle.setFont(HudPaintingUtils.getHudFont());
        this.textAreaBeschreibung = new JTextArea();
        this.textAreaBeschreibung.setDoubleBuffered(true);
        this.textAreaBeschreibung.setLineWrap(true);
        this.textAreaBeschreibung.setWrapStyleWord(true);
        this.textAreaBeschreibung.setBackground(this.background);
        this.textAreaBeschreibung.setForeground(this.foreground);
        this.textAreaBeschreibung.setOpaque(false);
        this.textAreaBeschreibung.setRows(4);
        this.jLabelFilmNeu = new JLabel();
        this.jLabelFilmNeu.setOpaque(false);
        this.jLabelFilmNeu.setVisible(false);
        this.jLabelFilmNeu.setIcon(ja_sw_16);
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        c.weighty = 0.0;
        panel.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < this.labelArrNames.length; ++i) {
            if (i == 16 || i == 17 || i == 20 || i == 21 || i == 18 || i == 19 || i == 4 || i == 5 || i == 24 || i == 22 || i == 25) continue;
            c.gridy = zeile++;
            this.addLable(i, gridbag, c, panel);
        }
        c.weightx = 0.0;
        c.gridx = 0;
        c.weighty = 2.0;
        c.gridy = zeile;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        panel.add(label);
        return panel;
    }

    private void addLable(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        c.gridx = 0;
        c.weightx = 0.0;
        gridbag.setConstraints(this.labelArrNames[i], c);
        panel.add(this.labelArrNames[i]);
        c.gridx = 1;
        c.weightx = 10.0;
        if (i == 13) {
            gridbag.setConstraints((Component)this.lblUrlThemaField, c);
            panel.add((Component)this.lblUrlThemaField);
        } else if (i == 15) {
            gridbag.setConstraints((Component)this.lblUrlSubtitle, c);
            panel.add((Component)this.lblUrlSubtitle);
        } else if (i == 10) {
            gridbag.setConstraints(this.textAreaBeschreibung, c);
            panel.add(this.textAreaBeschreibung);
        } else if (i == 23) {
            gridbag.setConstraints(this.jLabelFilmNeu, c);
            panel.add(this.jLabelFilmNeu);
        } else {
            gridbag.setConstraints(this.txtArrCont[i], c);
            panel.add(this.txtArrCont[i]);
        }
    }

    private void calculateHudPosition() {
    }

    @Override
    public void showInfo() {
        this.setAktFilm();
        this.dialog.setVisible(true);
    }

    @Override
    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    @Override
    public void updateCurrentFilm(DatenFilm film) {
        this.aktFilm = film;
        if (this.isVisible()) {
            this.setAktFilm();
        }
    }

    private void setAktFilm() {
        this.lblUrlThemaField.setForeground(this.foreground);
        this.lblUrlSubtitle.setForeground(this.foreground);
        if (this.aktFilm == null) {
            for (JTextField aTxtArrCont : this.txtArrCont) {
                aTxtArrCont.setText("");
            }
            this.textAreaBeschreibung.setText(" ");
            this.lblUrlThemaField.setText("");
            this.lblUrlSubtitle.setText("");
            this.jLabelFilmNeu.setVisible(false);
        } else {
            for (int i = 0; i < this.txtArrCont.length; ++i) {
                this.txtArrCont[i].setText(this.aktFilm.arr[i]);
            }
            if (this.aktFilm.arr[10].equals("")) {
                this.textAreaBeschreibung.setText(" ");
            } else {
                this.textAreaBeschreibung.setText(this.aktFilm.arr[10]);
            }
            this.lblUrlThemaField.setText(this.aktFilm.arr[13]);
            this.lblUrlSubtitle.setText(this.aktFilm.arr[15]);
            this.jLabelFilmNeu.setVisible(this.aktFilm.neuerFilm);
        }
        this.dialog.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        DatenFilm emptyFilm = new DatenFilm();
        this.updateCurrentFilm(emptyFilm);
    }
}

