/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;

public class MediathekMdr
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "MDR";
    private final LinkedList<String> listeTage = new LinkedList();
    private final LinkedList<String[]> listeGesucht = new LinkedList();

    public MediathekMdr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 3, 500, startPrio);
    }

    @Override
    public void addToList() {
        int pos2;
        int pos1;
        String URL_SENDUNGEN = "http://www.mdr.de/mediathek/fernsehen/a-z/index.html";
        String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter";
        String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter";
        String URL_TAGE = "http://www.mdr.de/mediathek/fernsehen/index.html";
        String MUSTER_TAGE = "<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-";
        String MUSTER_ADD_TAGE = "http://www.mdr.de/mediathek/fernsehen/sendung-verpasst--100_date-";
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeGesucht.clear();
        this.meldungStart();
        seite = this.getUrlIo.getUri_Utf(SENDERNAME, "http://www.mdr.de/mediathek/fernsehen/a-z/index.html", seite, "");
        int pos = 0;
        String url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(889216307, "keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/a-z/sendungenabisz100_inheritancecontext-header_letter" + url;
            if (url.contains("#")) {
                url = url.substring(0, url.indexOf("#"));
            }
            this.listeThemen.addUrl(new String[]{url});
        }
        seite = this.getUrlIo.getUri_Utf(SENDERNAME, "http://www.mdr.de/mediathek/fernsehen/index.html", seite, "");
        pos = 0;
        url = "";
        while ((pos = seite.indexOf("<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-", pos)) != -1) {
            pos1 = pos += "<a href=\"/mediathek/fernsehen/sendung-verpasst--100_date-".length();
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(461225808, "keine URL");
                continue;
            }
            url = "http://www.mdr.de/mediathek/fernsehen/sendung-verpasst--100_date-" + url;
            if (this.istInListe(this.listeTage, url)) continue;
            this.listeTage.add(url);
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0 && this.listeTage.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size() + this.listeTage.size());
            MediathekMdr.listeSort(this.listeThemen, 0);
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    @Override
    public void clear() {
        this.listeThemen.clear();
        this.listeTage.clear();
        this.listeGesucht.clear();
    }

    private String convertDatumXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(435209987, ex);
        }
        return datum;
    }

    private String convertZeitXml(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(102658736, ex);
        }
        return datum;
    }

    private synchronized String getListeTage() {
        return this.listeTage.pollFirst();
    }

    private synchronized boolean existiertSchon(String thema, String titel, String datum, String zeit) {
        boolean gefunden = false;
        for (String[] k : this.listeGesucht) {
            if (!k[0].equalsIgnoreCase(thema) || !k[1].equalsIgnoreCase(titel) || !k[2].equalsIgnoreCase(datum) || !k[3].equalsIgnoreCase(zeit)) continue;
            gefunden = true;
        }
        if (!gefunden) {
            this.listeGesucht.add(new String[]{thema, titel, datum, zeit});
        }
        return gefunden;
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seiteTage;
        private MSStringBuilder seite2;
        private MSStringBuilder seite3;
        private MSStringBuilder seite4;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekMdr.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seiteTage = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.seite3 = new MSStringBuilder(65536);
            this.seite4 = new MSStringBuilder(65536);
        }

        @Override
        public void run() {
            try {
                String url;
                String[] link;
                MediathekMdr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekMdr.this.listeThemen.getListeThemen()) != null) {
                    MediathekMdr.this.meldungProgress(link[0]);
                    this.addThema(link[0]);
                }
                while (!MSConfig.getStop() && (url = MediathekMdr.this.getListeTage()) != null) {
                    MediathekMdr.this.meldungProgress(url);
                    this.addTage(url);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(115896304, ex);
            }
            MediathekMdr.this.meldungThreadUndFertig();
        }

        void addThema(String strUrlFeed) {
            String MUSTER = "<div class=\"media mediaA \">";
            int pos = 0;
            String url = "";
            try {
                this.seite1 = this.getUrl.getUri(MediathekMdr.SENDERNAME, strUrlFeed, "UTF-8", 2, this.seite1, "");
                while (!MSConfig.getStop() && (pos = this.seite1.indexOf("<div class=\"media mediaA \">", pos)) != -1) {
                    url = this.seite1.extract("<a href=\"/mediathek/fernsehen/", "\"", pos += "<div class=\"media mediaA \">".length());
                    String thema = this.seite1.extract(" class=\"headline\" title=\"\">", "<", pos);
                    if (url.equals("")) {
                        MSLog.fehlerMeldung(952136547, "keine URL: " + strUrlFeed);
                        continue;
                    }
                    MediathekMdr.this.meldung(url);
                    url = "http://www.mdr.de/mediathek/fernsehen/" + url;
                    this.addSendugen(strUrlFeed, thema, url);
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(766250249, "keine URL: " + strUrlFeed);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(316874602, ex);
            }
        }

        void addTage(String urlSeite) {
            String MUSTER = "<div class=\"media mediaA \">";
            int pos = 0;
            String url = "";
            try {
                this.seiteTage = this.getUrl.getUri(MediathekMdr.SENDERNAME, urlSeite, "UTF-8", 2, this.seiteTage, "");
                while (!MSConfig.getStop() && (pos = this.seiteTage.indexOf("<div class=\"media mediaA \">", pos)) != -1) {
                    url = this.seiteTage.extract("<a href=\"/mediathek/", "\"", pos += "<div class=\"media mediaA \">".length());
                    String thema = this.seiteTage.extract(" class=\"headline\" title=\"\">", "<", pos);
                    if (url.equals("")) {
                        MSLog.fehlerMeldung(975401478, "keine URL: " + urlSeite);
                        continue;
                    }
                    MediathekMdr.this.meldung(url);
                    url = "http://www.mdr.de/mediathek/" + url;
                    this.addSendug(urlSeite, thema, url);
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(930215470, "keine URL: " + urlSeite);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(102540897, ex);
            }
        }

        private void addSendugen(String strUrlFeed, String thema, String urlThema) {
            this.seite2 = this.getUrl.getUri(MediathekMdr.SENDERNAME, urlThema, "UTF-8", 2, this.seite2, "Thema: " + thema);
            String muster = this.seite2.indexOf("div class=\"media mediaA \">") != -1 ? "div class=\"media mediaA \">" : "<span class=\"broadcastSeriesTitle\">";
            int pos = 0;
            int count = 0;
            String url = "";
            while ((pos = this.seite2.indexOf(muster, pos)) != -1) {
                if (!MSConfig.loadLongMax() && ++count > 5) {
                    return;
                }
                url = this.seite2.extract("<a href=\"/mediathek/fernsehen/a-z", "\"", pos += muster.length());
                if (url.equals("")) {
                    MSLog.fehlerMeldung(915263421, new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                    continue;
                }
                url = "http://www.mdr.de/mediathek/fernsehen/a-z" + url;
                this.addSendug(strUrlFeed, thema, url);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(765213014, new String[]{"keine URL: " + urlThema, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
            }
        }

        private void addSendug(String strUrlFeed, String thema, String urlSendung) {
            String MUSTER_XML = "'playerXml':'";
            String MUSTER_ADD = "http://www.mdr.de";
            this.seite3 = this.getUrl.getUri_Utf(MediathekMdr.SENDERNAME, urlSendung, this.seite3, "Thema: " + thema);
            int pos = 0;
            String url = "";
            int stop = this.seite3.indexOf("Meistgeklickt");
            while ((pos = this.seite3.indexOf("'playerXml':'", pos)) != -1 && (stop <= 0 || pos <= stop)) {
                int pos1 = pos += "'playerXml':'".length();
                int pos2 = this.seite3.indexOf("'", pos);
                if (pos2 != -1) {
                    url = this.seite3.substring(pos1, pos2);
                }
                if (url.equals("")) {
                    MSLog.fehlerMeldung(256987304, new String[]{"keine URL: " + urlSendung, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
                    continue;
                }
                url = url.replace("\\", "");
                url = "http://www.mdr.de" + url;
                this.addXml(strUrlFeed, thema, url, urlSendung);
            }
            if (url.equals("")) {
                MSLog.fehlerMeldung(256987304, new String[]{"keine URL: " + urlSendung, "Thema: " + thema, "UrlFeed: " + strUrlFeed});
            }
        }

        void addXml(String strUrlFeed, String thema, String xmlSite, String filmSite) {
            String MUSTER_URL_MP4 = "<progressiveDownloadUrl>";
            try {
                this.seite4 = this.getUrl.getUri_Utf(MediathekMdr.SENDERNAME, xmlSite, this.seite4, "Thema: " + thema);
                if (this.seite4.length() == 0) {
                    MSLog.fehlerMeldung(903656532, xmlSite);
                    return;
                }
                long duration = 0L;
                try {
                    String d = this.seite4.extract("<duration>", "<");
                    if (!d.equals("")) {
                        String[] parts = d.split(":");
                        duration = 0L;
                        long power = 1L;
                        for (int i = parts.length - 1; i >= 0; --i) {
                            duration += Long.parseLong(parts[i]) * power;
                            power *= 60L;
                        }
                    }
                }
                catch (Exception ex) {
                    MSLog.fehlerMeldung(313698749, ex, xmlSite);
                }
                String titel = this.seite4.extract("<title>", "<");
                String description = this.seite4.extract("<teaserText>", "<");
                String subtitle = this.seite4.extract("<videoSubtitleUrl>", "<");
                String datum = this.seite4.extract("<broadcastStartDate>", "<");
                if (datum.isEmpty()) {
                    datum = this.seite4.extract("<datetimeOfBroadcasting>", "<");
                }
                if (datum.isEmpty()) {
                    datum = this.seite4.extract("<webTime>", "<");
                }
                String zeit = MediathekMdr.this.convertZeitXml(datum);
                datum = MediathekMdr.this.convertDatumXml(datum);
                String urlSendung = this.seite4.extract("<htmlUrl>", "<");
                if (urlSendung.isEmpty()) {
                    urlSendung = filmSite;
                }
                String urlHD = this.seite4.extract("| MP4 Web XL |", "<progressiveDownloadUrl>", "<");
                String urlMp4 = this.seite4.extract("| MP4 Web L |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = this.seite4.extract("| MP4 Web L+ |", "<progressiveDownloadUrl>", "<");
                }
                String urlMp4_klein = this.seite4.extract("| MP4 Web M |", "<progressiveDownloadUrl>", "<");
                if (urlMp4.isEmpty()) {
                    urlMp4 = urlMp4_klein;
                    urlMp4_klein = "";
                }
                if (urlMp4.equals("")) {
                    MSLog.fehlerMeldung(326541230, new String[]{"keine URL: " + xmlSite, "Thema: " + thema, " UrlFeed: " + strUrlFeed});
                } else if (!MediathekMdr.this.existiertSchon(thema, titel, datum, zeit)) {
                    MediathekMdr.this.meldung(urlMp4);
                    DatenFilm film = new DatenFilm(MediathekMdr.SENDERNAME, thema, urlSendung, titel, urlMp4, "", datum, zeit, duration, description);
                    film.addUrlKlein(urlMp4_klein, "");
                    film.addUrlHd(urlHD, "");
                    film.addUrlSubtitle(subtitle);
                    MediathekMdr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(446286970, ex);
            }
        }
    }
}

