/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSListeRunSender;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.filmeSuchen.MSRunSender;
import msearch.filmeSuchen.sender.Mediathek3Sat;
import msearch.filmeSuchen.sender.MediathekArd;
import msearch.filmeSuchen.sender.MediathekArte_de;
import msearch.filmeSuchen.sender.MediathekArte_fr;
import msearch.filmeSuchen.sender.MediathekBr;
import msearch.filmeSuchen.sender.MediathekDw;
import msearch.filmeSuchen.sender.MediathekHr;
import msearch.filmeSuchen.sender.MediathekKika;
import msearch.filmeSuchen.sender.MediathekMdr;
import msearch.filmeSuchen.sender.MediathekNdr;
import msearch.filmeSuchen.sender.MediathekOrf;
import msearch.filmeSuchen.sender.MediathekPhoenix;
import msearch.filmeSuchen.sender.MediathekRbb;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.filmeSuchen.sender.MediathekSr;
import msearch.filmeSuchen.sender.MediathekSrf;
import msearch.filmeSuchen.sender.MediathekSrfPod;
import msearch.filmeSuchen.sender.MediathekSwr;
import msearch.filmeSuchen.sender.MediathekWdr;
import msearch.filmeSuchen.sender.MediathekZdf;
import msearch.filmeSuchen.sender.MediathekZdfTivi;
import msearch.tool.GermanStringSorter;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;

public class MSFilmeSuchen {
    public ListeFilme listeFilmeNeu;
    public ListeFilme listeFilmeAlt;
    private final LinkedList<MediathekReader> mediathekListe = new LinkedList();
    private final EventListenerList listeners = new EventListenerList();
    public static final MSListeRunSender listeSenderLaufen = new MSListeRunSender();
    private Date startZeit = new Date();
    private Date stopZeit = new Date();
    private static final String TRENNER = " | ";
    private boolean allStarted = false;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public MSFilmeSuchen() {
        this.mediathekListe.add(new MediathekArd(this, 0));
        this.mediathekListe.add(new MediathekZdf(this, 0));
        this.mediathekListe.add(new MediathekZdfTivi(this, 0));
        this.mediathekListe.add(new MediathekArte_de(this, 0));
        this.mediathekListe.add(new MediathekArte_fr(this, 0));
        this.mediathekListe.add(new Mediathek3Sat(this, 1));
        this.mediathekListe.add(new MediathekSwr(this, 0));
        this.mediathekListe.add(new MediathekNdr(this, 1));
        this.mediathekListe.add(new MediathekKika(this, 0));
        this.mediathekListe.add(new MediathekDw(this, 0));
        this.mediathekListe.add(new MediathekMdr(this, 0));
        this.mediathekListe.add(new MediathekWdr(this, 1));
        this.mediathekListe.add(new MediathekHr(this, 0));
        this.mediathekListe.add(new MediathekRbb(this, 1));
        this.mediathekListe.add(new MediathekSr(this, 1));
        this.mediathekListe.add(new MediathekBr(this, 0));
        this.mediathekListe.add(new MediathekSrf(this, 1));
        this.mediathekListe.add(new MediathekSrfPod(this, 0));
        this.mediathekListe.add(new MediathekOrf(this, 1));
        this.mediathekListe.add(new MediathekPhoenix(this, 1));
    }

    public static String[] getNamenSender() {
        LinkedList<String> liste = new LinkedList<String>();
        liste.add("ARD");
        liste.add("ZDF");
        liste.add("ZDF-tivi");
        liste.add("ARTE.DE");
        liste.add("ARTE.FR");
        liste.add("3Sat");
        liste.add("SWR");
        liste.add("NDR");
        liste.add("KiKA");
        liste.add("DW");
        liste.add("MDR");
        liste.add("WDR");
        liste.add("HR");
        liste.add("RBB");
        liste.add("SR");
        liste.add("BR");
        liste.add("SRF");
        liste.add("SRF.Podcast");
        liste.add("ORF");
        liste.add("PHOENIX");
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        Collections.sort(liste, sorter);
        return liste.toArray(new String[liste.size()]);
    }

    public void addAdListener(MSListenerFilmeLaden listener) {
        this.listeners.add(MSListenerFilmeLaden.class, listener);
    }

    public synchronized void filmeBeimSenderLaden(ListeFilme listeFilme) {
        this.initStart(listeFilme);
        this.mrStarten(0);
        if (!MSConfig.getStop()) {
            this.mrWarten();
            this.mrStarten(1);
            this.allStarted = true;
        }
    }

    public void updateSender(String[] nameSender, ListeFilme listeFilme) {
        boolean starten = false;
        this.initStart(listeFilme);
        for (MediathekReader reader : this.mediathekListe) {
            for (String s : nameSender) {
                if (!reader.checkNameSenderFilmliste(s)) continue;
                starten = true;
                new Thread(reader).start();
            }
        }
        this.allStarted = true;
        if (!starten) {
            this.meldenFertig("");
        }
    }

    public synchronized MSRunSender melden(String sender, int max, int progress, String text) {
        MSRunSender runSender = listeSenderLaufen.getSender(sender);
        if (runSender != null) {
            runSender.max = max;
            runSender.progress = progress;
        } else {
            runSender = new MSRunSender(sender, max, progress);
            listeSenderLaufen.add(runSender);
            if (listeSenderLaufen.size() <= 1) {
                this.notifyStart(new MSListenerFilmeLadenEvent(sender, text, listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
            }
        }
        this.notifyProgress(new MSListenerFilmeLadenEvent(sender, text, listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
        this.progressBar();
        return runSender;
    }

    public synchronized void meldenFertig(String sender) {
        MSRunSender run = listeSenderLaufen.senderFertig(sender);
        if (run != null) {
            String zeile = "\n";
            zeile = zeile + "-------------------------------------------------------------------------------------\n";
            zeile = zeile + "Fertig " + sender + ": " + new SimpleDateFormat("HH:mm:ss").format(new Date()) + " Uhr, Filme: " + listeSenderLaufen.get(sender, MSRunSender.Count.FILME) + "\n";
            int sekunden = run.getLaufzeitSekunden();
            zeile = zeile + "     -> Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)) + "\n";
            zeile = zeile + "     ->       Rest: " + listeSenderLaufen.getSenderRun() + "\n";
            zeile = zeile + "-------------------------------------------------------------------------------------\n";
            MSLog.systemMeldung(zeile);
        }
        if (!this.allStarted || !listeSenderLaufen.listeFertig()) {
            this.notifyProgress(new MSListenerFilmeLadenEvent(sender, "", listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), this.listeFilmeNeu.size(), false));
        } else {
            MSLog.progress("");
            if (MSConfig.getStop()) {
                MSLog.systemMeldung("                                                                                     ");
                MSLog.systemMeldung("                                                                                     ");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("     ----- Abbruch -----                                                             ");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("*************************************************************************************");
                MSLog.systemMeldung("                                                                                     ");
                MSLog.systemMeldung("                                                                                     ");
            }
            this.mrClear();
            if (MSConfig.updateFilmliste) {
                this.listeFilmeNeu.updateListe(this.listeFilmeAlt, true, false);
            }
            this.listeFilmeNeu.sort();
            this.stopZeit = new Date(System.currentTimeMillis());
            this.listeFilmeNeu.writeMetaData();
            ArrayList<String> ret = this.endeMeldung();
            for (String s : ret) {
                MSLog.systemMeldung(s);
            }
            this.notifyFertig(new MSListenerFilmeLadenEvent(sender, "", listeSenderLaufen.getMax(), listeSenderLaufen.getProgress(), (int)listeSenderLaufen.get(MSRunSender.Count.FILME), false));
        }
    }

    public ArrayList<String> endeMeldung() {
        ArrayList<String> retArray = new ArrayList<String>();
        retArray.add("");
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("==  Sender  =====================================================================");
        retArray.add("");
        listeSenderLaufen.getTextSum(retArray);
        listeSenderLaufen.getTextCount(retArray);
        int sekunden = this.getDauerSekunden();
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("=================================================================================");
        retArray.add("");
        retArray.add("       Filme geladen: " + listeSenderLaufen.get(MSRunSender.Count.FILME));
        retArray.add("      Seiten geladen: " + listeSenderLaufen.get(MSRunSender.Count.ANZAHL));
        retArray.add("   Summe geladen[MB]: " + MSRunSender.getStringZaehler(listeSenderLaufen.get(MSRunSender.Count.SUM_DATA_BYTE)));
        retArray.add("        Traffic [MB]: " + MSRunSender.getStringZaehler(listeSenderLaufen.get(MSRunSender.Count.SUM_TRAFFIC_BYTE)));
        double doub = 1.0 * (double)listeSenderLaufen.get(MSRunSender.Count.SUM_TRAFFIC_BYTE) / (double)(sekunden == 0 ? 1 : sekunden) / 1000.0;
        String rate = doub < 1.0 ? "<1" : String.format("%.1f", doub);
        retArray.add("    ->    Rate[kB/s]: " + rate);
        retArray.add("    ->    Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)));
        retArray.add("           ->  Start: " + this.sdf.format(this.startZeit));
        retArray.add("           ->   Ende: " + this.sdf.format(this.stopZeit));
        retArray.add("");
        retArray.add("=================================================================================");
        retArray.add("=================================================================================");
        return retArray;
    }

    private synchronized void mrStarten(int prio) {
        for (MediathekReader mr : this.mediathekListe) {
            if (mr.getStartPrio() != prio) continue;
            new Thread(mr).start();
        }
    }

    private synchronized void mrClear() {
        for (MediathekReader mr : this.mediathekListe) {
            mr.clear();
        }
    }

    private synchronized void mrWarten() {
        try {
            for (int i = 0; i < 240 && !MSConfig.getStop(); ++i) {
                this.wait(1000L);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(978754213, ex);
        }
    }

    private int getDauerSekunden() {
        int sekunden;
        try {
            sekunden = Math.round((this.stopZeit.getTime() - this.startZeit.getTime()) / 1000L);
        }
        catch (Exception ex) {
            sekunden = 1;
        }
        if (sekunden <= 0) {
            sekunden = 1;
        }
        return sekunden;
    }

    private void initStart(ListeFilme listeFilme) {
        listeSenderLaufen.clear();
        this.allStarted = false;
        this.listeFilmeAlt = listeFilme;
        MSConfig.setStop(false);
        this.startZeit = new Date(System.currentTimeMillis());
        this.listeFilmeNeu = new ListeFilme();
        this.listeFilmeNeu.liveStreamEintragen();
        MSLog.systemMeldung("");
        MSLog.systemMeldung("=======================================");
        MSLog.systemMeldung("Start Filme laden:");
        if (MSConfig.loadMax()) {
            MSLog.systemMeldung("Filme laden: max");
        } else if (MSConfig.loadLongMax()) {
            MSLog.systemMeldung("Filme laden: long");
        } else {
            MSLog.systemMeldung("Filme laden: short");
        }
        if (MSConfig.updateFilmliste) {
            MSLog.systemMeldung("Filmliste: aktualisieren");
        } else {
            MSLog.systemMeldung("Filmliste: neue erstellen");
        }
        MSLog.systemMeldung("=======================================");
        MSLog.systemMeldung("");
    }

    private void progressBar() {
        int max = listeSenderLaufen.getMax();
        int progress = listeSenderLaufen.getProgress();
        int proz = 0;
        int sekunden = 0;
        try {
            sekunden = Math.round((new Date(System.currentTimeMillis()).getTime() - this.startZeit.getTime()) / 1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (max > 0 && proz == 100) {
                proz = 99;
            }
            String text = "  [ ";
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                text = text + "#";
            }
            for (i = 0; i < 10 - a; ++i) {
                text = text + "-";
            }
            text = text + " ]  " + listeSenderLaufen.get(MSRunSender.Count.ANZAHL) + " Seiten / " + proz + "% von " + max + " Themen / Filme: " + listeSenderLaufen.get(MSRunSender.Count.FILME) + " / Dauer[Min]: " + (sekunden / 60 == 0 ? "<1" : Integer.valueOf(sekunden / 60)) + " / R-Sender: " + listeSenderLaufen.getAnzSenderRun();
            MSLog.progress(text);
        }
    }

    private void notifyStart(MSListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof MSListenerFilmeLaden)) continue;
            ((MSListenerFilmeLaden)l).start(event);
        }
    }

    private void notifyProgress(MSListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof MSListenerFilmeLaden)) continue;
            ((MSListenerFilmeLaden)l).progress(event);
        }
    }

    private void notifyFertig(MSListenerFilmeLadenEvent event) {
        for (Object l : this.listeners.getListenerList()) {
            if (!(l instanceof MSListenerFilmeLaden)) continue;
            ((MSListenerFilmeLaden)l).fertig(event);
        }
    }
}

