/*
 *   vga.h
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef VGA_H
#define VGA_H

#include "defs.h"
#include <sys/io.h>

/* VGA registers */
#define VGA_GFX_INDEX	0x3ce   /* Graphics Controller index register */
#define VGA_GFX_DATA	0x3cf   /* Graphics Controller data register */

/* Graphics controller registers */
#define VGA_GFX_READ_MAP    4   /* Sets the VGA plane in read mode 0 */
#define VGA_GFX_MODE        5   /* Graphics mode register */

/* Macros for writing to a graphics controller register */
#ifdef WORDS_BIGENDIAN
#define WRITE_GFX_REG( reg, value ) \
        outb( (reg), VGA_GFX_INDEX ), outb( (value), VGA_GFX_DATA )
#else
#define WRITE_GFX_REG( reg, value ) \
        outw( (value) << 8 | (reg), VGA_GFX_INDEX )
#endif

int VGA_init( void );

/* Ensure the graphics controller is set to Read mode 0 */
static inline void VGA_setReadMode0( void ) { WRITE_GFX_REG( VGA_GFX_MODE, 0 ); }

/* Choose the plane to read from in mode 0 */
static inline void VGA_setReadPlane( __u8 plane ) { WRITE_GFX_REG( VGA_GFX_READ_MAP, plane ); }

#endif /* VGA_H */
