/*
 *   fb.h
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef FB_H
#define FB_H

#include "defs.h"
#include "cmap.h"
#include "surface.h"

typedef struct
{
  int                       fd;   // This fb's file descriptor
  struct fb_fix_screeninfo  fix;  // Fixed FB properties
  struct fb_var_screeninfo  var;  // Variable FB properties
  ColorMap                 *cmap; // This FB's colormap
  __u8                     *mem;  // Pointer to mapped framebuffer mem
  __u32                     len;  // Length of mapped region
} FBHandle;

int  FB_open( const char *device, FBHandle *fb );
void FB_close( FBHandle *fb );
ColorMap *FB_getColorMap( FBHandle *fb );
int FB_getVisibleSurface( FBHandle *fb, Surface *s );

#endif /* FB_H*/
