#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#The MIT License (MIT)
#
#Copyright (c) <2013-2014> <Colin Duquesnoy and others, see AUTHORS.txt>
#
#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:
#
#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#THE SOFTWARE.
#
"""
This file contains all the pyqode-widgets QtDesigner plugins.
"""
# This only works with PyQt, PySide does not support the QtDesigner module
import os
if not 'QT_API' in os.environ:
    os.environ.setdefault("QT_API", "PyQt")
from pyqode.qt.QtGui import QIcon
import pyqode.widgets

PLUGINS_TYPES = {'QHomeWidget': pyqode.widgets.QHomeWidget,
                 'QInteractiveConsole': pyqode.widgets.QInteractiveConsole,
                 "QCodeEditTabWidget": pyqode.widgets.QCodeEditTabWidget,
                 "QPropertyGrid": pyqode.widgets.QPropertyGrid,
                 "QColorButton": pyqode.widgets.QColorButton,
                 "QTextStyleWidget": pyqode.widgets.QTextStyleWidget,
                 "QErrorsTable": pyqode.widgets.QErrorsTable}

try:
    from pyqode.core.plugins.pyqode_core_plugin import QCodeEditPlugin

    class QPythonCodeEditPlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QHomeWidget'    # name of the widget class
        _name = "QHomeWidget"

        def createWidget(self, parent):
            return pyqode.widgets.QHomeWidget(parent=parent)

    class QInteractiveConsolePlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QInteractiveConsole'    # name of the widget class
        _name = "QInteractiveConsole"

        def createWidget(self, parent):
            return pyqode.widgets.QInteractiveConsole(parent=parent)

    class QCodeEditTabWidgetPlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QCodeEditTabWidget'    # name of the widget class
        _name = "QCodeEditTabWidget"

        def createWidget(self, parent):
            return pyqode.widgets.QCodeEditTabWidget(parent=parent)

    class QErrorsTablePlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QErrorsTable'    # name of the widget class
        _name = "QErrorsTable"

        def createWidget(self, parent):
            return pyqode.widgets.QErrorsTable(parent=parent)

    class QPropertyGridPlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QPropertyGrid'    # name of the widget class
        _name = "QPropertyGrid"

        def createWidget(self, parent):
            return pyqode.widgets.QPropertyGrid(parent=parent)

    class QColorButtonPlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QColorButton'    # name of the widget class
        _name = "QColorButton"

        def createWidget(self, parent):
            return pyqode.widgets.QColorButton(parent=parent)

    class QTextStyleWidgetPlugin(QCodeEditPlugin):
        _module = 'pyqode.widgets'        # path to the widget's module
        _class = 'QTextStyleWidget'    # name of the widget class
        _name = "QTextStyleWidget"

        def createWidget(self, parent):
            return pyqode.widgets.QTextStyleWidget(parent=parent)


except ImportError:
    print("Cannot use pyQode plugins without PyQt4")
