//
//
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent.h"
#include "rfm_modules.h"

typedef struct deskview_geometry_t {
    int x;
    int y;
} deskview_geometry_t;


void 
rodent_erase_deskview_geometries (void) {
    gchar *f = g_build_filename (DESK_GEOMETRY_FILE, NULL);
    if(rfm_g_file_test (f, G_FILE_TEST_EXISTS)) {
	unlink(f);
    }
    g_free (f);
    return;
}

void
rodent_save_deskview_geometry (const gchar * fullpath, int x, int y) {
    DBHashTable *preferences;
    GString *gs;
    gchar *f;
    deskview_geometry_t deskview_geometry;

    if(!fullpath || !strlen (fullpath))
        return;
    static GMutex *mutex=NULL;
    if (mutex==NULL) rfm_mutex_init(mutex);

    f = g_build_filename (DESK_GEOMETRY_FILE, NULL);
    g_mutex_lock(mutex);
    TRACE("opening %s...\n",f); 
    preferences = dbh_new (f, NULL, DBH_PARALLEL_SAFE);
    TRACE("opened %s.\n",f); 
    
    if(!preferences) {
        NOOP ("Creating preferences file: %s", f);
	unsigned char keylength=11;
        gchar *directory = g_path_get_dirname(f);
        if (!g_file_test(directory, G_FILE_TEST_IS_DIR)){
            g_mkdir_with_parents(directory, 0700);
        }
        g_free(directory);
        TRACE("opening %s...\n",f); 
        preferences = dbh_new (f, &keylength, DBH_CREATE|DBH_PARALLEL_SAFE);
        TRACE("opened %s.\n",f); 
    } 

    if(!preferences) {
        DBG ("Cannot open deskview geometry preferences table: %s\n", f);
        g_free (f);
        return;
    }
    dbh_set_parallel_lock_timeout(preferences, 3);
    g_free (f);

    gs = g_string_new (fullpath);
    sprintf ((char *)DBH_KEY (preferences), "%10u", g_string_hash (gs));
    g_string_free (gs, TRUE);

    deskview_geometry.x = x;
    deskview_geometry.y = y;

    memcpy (DBH_DATA (preferences), &deskview_geometry, sizeof (deskview_geometry_t));
    dbh_set_recordsize (preferences, sizeof (deskview_geometry_t));

    if(!dbh_update (preferences)) {
        DBG ("!dbh_update(deskview_geometry preferences)\n");
    }
    dbh_close (preferences);
    g_mutex_unlock(mutex);
    NOOP ("saved deskview_geometry preferences with key=%s\n", fullpath);
    return;
}


