#ifndef RODENT_EXPOSE_H
#define RODENT_EXPOSE_H
gboolean
rodent_valid_population_p(view_t *view_p, const population_t *population_p);

void 
rodent_set_expose_hold(view_t * view_p, gboolean expose_condition);

void
rfm_do_layout (view_t * view_p, population_t * population_p);

void 
rodent_threaded_clean_paper(widgets_t *widgets_p);

void * 
rodent_clean_paper(gpointer data);

gint 
rodent_columns(view_t * view_p, gint width);

gint
rodent_rows(view_t * view_p,  gint width);

const 
population_t *
  rodent_find_in_population (view_t * view_p, gdouble x, gdouble y);

const 
population_t *
  rodent_find_in_labels (view_t * view_p, gdouble x, gdouble y);

GSList *
rodent_find_icons_in_rectangle(view_t * view_p, GdkRectangle *rect);

GSList *
rodent_find_items_in_rectangle(view_t * view_p, GdkRectangle *rect);

GdkColor *
get_gdk_color (view_t *view_p, int p);

const GdkColor *
rodent_select_pen (view_t * view_p, int p);
  
void 
  rodent_erase_deskview_geometries (void);

void
  rodent_save_deskview_geometry (const gchar * fullpath, int x, int y);

void
  rodent_recalc_population_geometry (view_t * view_p);

#if GTK_MAJOR_VERSION==2
void
  rodent_expose (GtkWidget * widget, GdkEventExpose * event, gpointer data);
#else
gboolean 
  rodent_draw (GtkWidget * widget, cairo_t *cr, gpointer data);
#endif
void 
rodent_redraw_items(view_t *view_p);
void 
rodent_redraw_item(view_t *view_p, population_t *population_p);
void 
rodent_redraw_label(view_t *view_p, population_t *population_p);
void 
rodent_redraw_icon(view_t *view_p, population_t *population_p);

void
  rodent_expose_all (view_t * view_p);
void
rodent_clean_rectangle (view_t * view_p, int x, int y, int w, int h, cairo_t *gdk_context);
void
rodent_clean_rect(view_t * view_p, GdkRectangle *rect);

#endif
  




