/*
 * Integer functions
 *
 * Copyright (c) 2008-2013, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _PYPFF_INTEGER_H )
#define _PYPFF_INTEGER_H

#include <common.h>
#include <types.h>

#include "pypff_python.h"

#if defined( __cplusplus )
extern "C" {
#endif

PyObject *pypff_integer_signed_new_from_64bit(
           int64_t value_64bit );

PyObject *pypff_integer_unsigned_new_from_64bit(
           uint64_t value_64bit );

#if defined( __cplusplus )
}
#endif

#endif

