#!/bin/sh
# Run this to generate all the initial makefiles, etc.

L_LIBTOOLIZE=${LIBTOOLIZE:-libtoolize}
L_AUTOMAKE=${AUTOMAKE:-automake}
L_ACLOCAL=${ACLOCAL:-aclocal}
L_AUTOCONF=${AUTOCONF:-autoconf}


DIE=0

echo "Generating configuration files for libDockApp, please wait...."

($L_AUTOCONF --version) < /dev/null > /dev/null 2>&1 || {
        echo
        echo "You must have autoconf installed to compile libdockapp."
	echo "If you have but it's not found by this script, specify"
	echo "the executable in the environment variable AUTOCONF."
        echo "Download the appropriate package for your distribution,"
        echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
        DIE=1
}

($L_LIBTOOLIZE --version) < /dev/null > /dev/null 2>&1 || {
        echo
        echo "You must have libtool installed to compile libdockapp."
	echo "If you have but it's not found by this script, specify"
	echo "the executable in the environment variable LIBTOOLIZE."
        echo "Download the appropriate package for your distribution,"
        echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
        DIE=1
}

($L_AUTOMAKE --version) < /dev/null > /dev/null 2>&1 || {
        echo
        echo "You must have automake installed to compile libdockapp."
	echo "If you have but it's not found by this script, specify"
	echo "the executable in the environment variables AUTOMAKE"
	echo "and ACLOCAL."
        echo "Download the appropriate package for your distribution,"
        echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
        DIE=1
}

if test "$DIE" -eq 1; then
        exit 1
fi

echo
echo CLEANUP...

rm -f Makefile Makefile.in src/Makefile src/Makefile.in aclocal.m4 \
    config.cache config.guess config.log config.status config.sub \
    configure \
    install.sh ltconfig ltmain.sh missing mkinstalldirs
rm -rf autom4te.cache

echo
echo "LIBTOOLIZE... (${L_LIBTOOLIZE})"

$L_LIBTOOLIZE --automake --copy || exit 1

echo
echo "ACLOCAL...    (${L_ACLOCAL})"

$L_ACLOCAL -I . || exit 1

echo
echo "AUTOCONF...   (${L_AUTOCONF})"

$L_AUTOCONF || exit 1

echo
echo "AUTOMAKE...   (${L_AUTOMAKE})"

$L_AUTOMAKE --add-missing --include-deps --copy || exit 1

echo
echo "---------------------------------------------------------"
echo "Fixing configure: removing --no-verify from ltconfig call"
echo "---------------------------------------------------------"
echo
./do_verify.sh

echo
echo CONFIGURE

if [ -z "$*" ]; then

    echo
    echo "--------------------------------------------------------------"
    echo "I am going to run ./configure with no arguments - if you wish "
    echo "to pass any to it, please specify them on the $0 command line."
    echo "If you do not wish to run ./configure, press Ctrl-C now."
    echo "--------------------------------------------------------------"
    echo

    trap 'echo "configure aborted" ; exit 0' 1 2 15
    sleep 2
fi

./configure "$@"

