/*

  Structs.h: generated by VRMLC.pm. DO NOT MODIFY, MODIFY VRMLC.pm INSTEAD.

  Code here comes almost verbatim from VRMLC.pm

*/

/****************************************************************************
    This file is part of the FreeWRL/FreeX3D Distribution.

    Copyright 2009 CRC Canada. (http://www.crc.gc.ca)

    FreeWRL/FreeX3D is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FreeWRL/FreeX3D is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FreeWRL/FreeX3D.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/



#ifndef __FREEWRL_STRUCTS_H__
#define __FREEWRL_STRUCTS_H__

#include <system_threads.h>
struct point_XYZ {GLDOUBLE x,y,z;};
struct orient_XYZA {GLDOUBLE x,y,z,a;};

struct X3D_Virt {
	void (*prep)(void *);
	void (*rend)(void *);
	void (*children)(void *);
	void (*fin)(void *);
	void (*rendray)(void *);
	void (*mkpolyrep)(void *);
	void (*proximity)(void *);
	void (*other)(void *);
	void (*collision)(void *);
	void (*compile)(void *, void *, void *, void *, void *);
};

/* a string is stored as a pointer, and a length of that mallocd pointer */
struct Uni_String {
	int len;
	char * strptr;
	int touched;
};

/* Internal representation of IndexedFaceSet, Text, Extrusion & ElevationGrid:
 * set of triangles.
 * done so that we get rid of concave polygons etc.
 */
struct X3D_PolyRep { /* Currently a bit wasteful, because copying */
	int irep_change;
	int ccw;	/* ccw field for single faced structures */
	int ntri; /* number of triangles */
	int streamed;	/* is this done the streaming pass? */

	/* indicies for arrays. OpenGL ES 2.0 - unsigned short for the DrawArrays call */
	GLuint *cindex;   /* triples (per triangle) */
	GLuint *colindex;   /* triples (per triangle) */
	GLuint *norindex;
        GLuint *tcindex; /* triples or null */

	float *actualCoord; /* triples (per point) */
	float *color; /* triples or null */
	float *normal; /* triples or null */
        float *GeneratedTexCoords;	/* triples (per triangle) of texture coords if there is no texCoord node */
	int tcoordtype; /* type of texture coord node - is this a NODE_TextureCoordGenerator... */
	int texgentype; /* if we do have a TextureCoordinateGenerator, what "TCGT_XXX" type is it? */
	GLfloat minVals[3];		/* for collision and default texture coord generation */
	GLfloat maxVals[3];		/* for collision and default texture coord generation */
	GLfloat transparency;		/* what the transparency value was during compile, put in color array if RGBA colors */
	int isRGBAcolorNode;		/* color was originally an RGBA, DO NOT re-write if transparency changes */
	GLuint VBO_buffers[VBO_COUNT];		/* VBO indexen */
};

/* viewer dimentions (for collision detection) */
struct sNaviInfo {
        double width;
        double height;
        double step;
};

/* definitions to help scanning values in from a string */ 
#define SCANTONUMBER(value) while (isspace(*value) || (*value==',')) value++; 
#define SCANTOSTRING(value) while (isspace(*value) || (*value==',')) value++; 
#define OLDSCANTOSTRING(value) while ((*value==' ') || (*value==',')) value++; 
#define ISSTARTNUMBER(value) (isdigit(*value) \
		|| (*value == '+') || (*value == '-')) 
#define SCANPASTFLOATNUMBER(value) while (isdigit(*value) \
		|| (*value == '.') || \
		(*value == 'E') || (*value == 'e') || (*value == '+') || (*value == '-')) value++; 
#define SCANPASTINTNUMBER(value) if (isdigit(*value) || (*value == '-') || (*value == '+')) value++; \
		while (isdigit(*value) || \
		(*value == 'x') || (*value == 'X') ||\
		((*value >='a') && (*value <='f')) || \
		((*value >='A') && (*value <='F')) || \
		(*value == '-') || (*value == '+')) value++; 
/* Data type for index into ID-table. */
typedef int indexT;

#define NODE_Anchor	0
#define NODE_Appearance	1
#define NODE_Arc2D	2
#define NODE_ArcClose2D	3
#define NODE_AudioClip	4
#define NODE_Background	5
#define NODE_Billboard	6
#define NODE_BooleanFilter	7
#define NODE_BooleanSequencer	8
#define NODE_BooleanToggle	9
#define NODE_BooleanTrigger	10
#define NODE_Box	11
#define NODE_CADAssembly	12
#define NODE_CADFace	13
#define NODE_CADLayer	14
#define NODE_CADPart	15
#define NODE_Circle2D	16
#define NODE_ClipPlane	17
#define NODE_Collision	18
#define NODE_Color	19
#define NODE_ColorInterpolator	20
#define NODE_ColorRGBA	21
#define NODE_ComposedCubeMapTexture	22
#define NODE_ComposedShader	23
#define NODE_Cone	24
#define NODE_Contour2D	25
#define NODE_ContourPolyLine2D	26
#define NODE_Coordinate	27
#define NODE_CoordinateDouble	28
#define NODE_CoordinateInterpolator	29
#define NODE_CoordinateInterpolator2D	30
#define NODE_Cylinder	31
#define NODE_CylinderSensor	32
#define NODE_DISEntityManager	33
#define NODE_DISEntityTypeMapping	34
#define NODE_DirectionalLight	35
#define NODE_Disk2D	36
#define NODE_EaseInEaseOut	37
#define NODE_ElevationGrid	38
#define NODE_EspduTransform	39
#define NODE_Extrusion	40
#define NODE_FillProperties	41
#define NODE_FloatVertexAttribute	42
#define NODE_Fog	43
#define NODE_FogCoordinate	44
#define NODE_FontStyle	45
#define NODE_GeneratedCubeMapTexture	46
#define NODE_GeoCoordinate	47
#define NODE_GeoElevationGrid	48
#define NODE_GeoLOD	49
#define NODE_GeoLocation	50
#define NODE_GeoMetadata	51
#define NODE_GeoOrigin	52
#define NODE_GeoPositionInterpolator	53
#define NODE_GeoProximitySensor	54
#define NODE_GeoTouchSensor	55
#define NODE_GeoTransform	56
#define NODE_GeoViewpoint	57
#define NODE_Group	58
#define NODE_HAnimDisplacer	59
#define NODE_HAnimHumanoid	60
#define NODE_HAnimJoint	61
#define NODE_HAnimSegment	62
#define NODE_HAnimSite	63
#define NODE_ImageCubeMapTexture	64
#define NODE_ImageTexture	65
#define NODE_IndexedFaceSet	66
#define NODE_IndexedLineSet	67
#define NODE_IndexedQuadSet	68
#define NODE_IndexedTriangleFanSet	69
#define NODE_IndexedTriangleSet	70
#define NODE_IndexedTriangleStripSet	71
#define NODE_Inline	72
#define NODE_IntegerSequencer	73
#define NODE_IntegerTrigger	74
#define NODE_KeySensor	75
#define NODE_LOD	76
#define NODE_LineProperties	77
#define NODE_LineSensor	78
#define NODE_LineSet	79
#define NODE_LoadSensor	80
#define NODE_LocalFog	81
#define NODE_Material	82
#define NODE_Matrix3VertexAttribute	83
#define NODE_Matrix4VertexAttribute	84
#define NODE_MetadataDouble	85
#define NODE_MetadataFloat	86
#define NODE_MetadataInteger	87
#define NODE_MetadataMFBool	88
#define NODE_MetadataMFColor	89
#define NODE_MetadataMFColorRGBA	90
#define NODE_MetadataMFDouble	91
#define NODE_MetadataMFFloat	92
#define NODE_MetadataMFInt32	93
#define NODE_MetadataMFMatrix3d	94
#define NODE_MetadataMFMatrix3f	95
#define NODE_MetadataMFMatrix4d	96
#define NODE_MetadataMFMatrix4f	97
#define NODE_MetadataMFNode	98
#define NODE_MetadataMFRotation	99
#define NODE_MetadataMFString	100
#define NODE_MetadataMFTime	101
#define NODE_MetadataMFVec2d	102
#define NODE_MetadataMFVec2f	103
#define NODE_MetadataMFVec3d	104
#define NODE_MetadataMFVec3f	105
#define NODE_MetadataMFVec4d	106
#define NODE_MetadataMFVec4f	107
#define NODE_MetadataSFBool	108
#define NODE_MetadataSFColor	109
#define NODE_MetadataSFColorRGBA	110
#define NODE_MetadataSFDouble	111
#define NODE_MetadataSFFloat	112
#define NODE_MetadataSFImage	113
#define NODE_MetadataSFInt32	114
#define NODE_MetadataSFMatrix3d	115
#define NODE_MetadataSFMatrix3f	116
#define NODE_MetadataSFMatrix4d	117
#define NODE_MetadataSFMatrix4f	118
#define NODE_MetadataSFNode	119
#define NODE_MetadataSFRotation	120
#define NODE_MetadataSFString	121
#define NODE_MetadataSFTime	122
#define NODE_MetadataSFVec2d	123
#define NODE_MetadataSFVec2f	124
#define NODE_MetadataSFVec3d	125
#define NODE_MetadataSFVec3f	126
#define NODE_MetadataSFVec4d	127
#define NODE_MetadataSFVec4f	128
#define NODE_MetadataSet	129
#define NODE_MetadataString	130
#define NODE_MovieTexture	131
#define NODE_MultiTexture	132
#define NODE_MultiTextureCoordinate	133
#define NODE_MultiTextureTransform	134
#define NODE_NavigationInfo	135
#define NODE_Normal	136
#define NODE_NormalInterpolator	137
#define NODE_NurbsCurve	138
#define NODE_NurbsCurve2D	139
#define NODE_NurbsOrientationInterpolator	140
#define NODE_NurbsPatchSurface	141
#define NODE_NurbsPositionInterpolator	142
#define NODE_NurbsSet	143
#define NODE_NurbsSurfaceInterpolator	144
#define NODE_NurbsSweptSurface	145
#define NODE_NurbsSwungSurface	146
#define NODE_NurbsTextureCoordinate	147
#define NODE_NurbsTrimmedSurface	148
#define NODE_OSC_Sensor	149
#define NODE_OrientationInterpolator	150
#define NODE_OrthoViewpoint	151
#define NODE_PackagedShader	152
#define NODE_PickableGroup	153
#define NODE_PixelTexture	154
#define NODE_PlaneSensor	155
#define NODE_PointLight	156
#define NODE_PointPickSensor	157
#define NODE_PointSet	158
#define NODE_Polyline2D	159
#define NODE_Polypoint2D	160
#define NODE_PositionInterpolator	161
#define NODE_PositionInterpolator2D	162
#define NODE_ProgramShader	163
#define NODE_Proto	164
#define NODE_ProximitySensor	165
#define NODE_QuadSet	166
#define NODE_ReceiverPdu	167
#define NODE_Rectangle2D	168
#define NODE_ScalarInterpolator	169
#define NODE_Script	170
#define NODE_ShaderPart	171
#define NODE_ShaderProgram	172
#define NODE_Shape	173
#define NODE_SignalPdu	174
#define NODE_Sound	175
#define NODE_Sphere	176
#define NODE_SphereSensor	177
#define NODE_SplinePositionInterpolator	178
#define NODE_SplinePositionInterpolator2D	179
#define NODE_SplineScalarInterpolator	180
#define NODE_SpotLight	181
#define NODE_SquadOrientationInterpolator	182
#define NODE_StaticGroup	183
#define NODE_StringSensor	184
#define NODE_Switch	185
#define NODE_Text	186
#define NODE_TextureBackground	187
#define NODE_TextureCoordinate	188
#define NODE_TextureCoordinateGenerator	189
#define NODE_TextureProperties	190
#define NODE_TextureTransform	191
#define NODE_TimeSensor	192
#define NODE_TimeTrigger	193
#define NODE_TouchSensor	194
#define NODE_Transform	195
#define NODE_TransmitterPdu	196
#define NODE_TriangleFanSet	197
#define NODE_TriangleSet	198
#define NODE_TriangleSet2D	199
#define NODE_TriangleStripSet	200
#define NODE_TwoSidedMaterial	201
#define NODE_Viewpoint	202
#define NODE_ViewpointGroup	203
#define NODE_VisibilitySensor	204
#define NODE_WorldInfo	205


/* Table of built-in fieldIds */
extern const char *FIELDNAMES[];
extern const int FIELDNAMES_COUNT;
#define FIELDNAMES_FIFOsize	0
#define FIELDNAMES_FreeWRL_PROTOInterfaceNodes	1
#define FIELDNAMES_FreeWRL__protoDef	2
#define FIELDNAMES__CPU_Routes_out	3
#define FIELDNAMES__GPU_Routes_out	4
#define FIELDNAMES___DEFnames	5
#define FIELDNAMES___EXPORTS	6
#define FIELDNAMES___GC	7
#define FIELDNAMES___IMPORTS	8
#define FIELDNAMES___IS	9
#define FIELDNAMES___ROUTES	10
#define FIELDNAMES___Samples	11
#define FIELDNAMES___SphereIndxVBO	12
#define FIELDNAMES___StartLoadTime	13
#define FIELDNAMES___VBO	14
#define FIELDNAMES___afterPound	15
#define FIELDNAMES___backTexture	16
#define FIELDNAMES___botpoints	17
#define FIELDNAMES___bottomTexture	18
#define FIELDNAMES___child1Node	19
#define FIELDNAMES___child2Node	20
#define FIELDNAMES___child3Node	21
#define FIELDNAMES___child4Node	22
#define FIELDNAMES___childloadstatus	23
#define FIELDNAMES___children	24
#define FIELDNAMES___colours	25
#define FIELDNAMES___coneTriangles	26
#define FIELDNAMES___coneVBO	27
#define FIELDNAMES___ctflag	28
#define FIELDNAMES___cylinderTriangles	29
#define FIELDNAMES___cylinderVBO	30
#define FIELDNAMES___do_anything	31
#define FIELDNAMES___do_center	32
#define FIELDNAMES___do_rotation	33
#define FIELDNAMES___do_scale	34
#define FIELDNAMES___do_scaleO	35
#define FIELDNAMES___do_trans	36
#define FIELDNAMES___externProtoDeclares	37
#define FIELDNAMES___finishedloading	38
#define FIELDNAMES___frontTexture	39
#define FIELDNAMES___geoSystem	40
#define FIELDNAMES___hit	41
#define FIELDNAMES___inRange	42
#define FIELDNAMES___inittime	43
#define FIELDNAMES___isX3D	44
#define FIELDNAMES___lastlocation	45
#define FIELDNAMES___lasttime	46
#define FIELDNAMES___leftTexture	47
#define FIELDNAMES___level	48
#define FIELDNAMES___loadResource	49
#define FIELDNAMES___loading	50
#define FIELDNAMES___loadstatus	51
#define FIELDNAMES___localFileName	52
#define FIELDNAMES___localOrient	53
#define FIELDNAMES___movedCoords	54
#define FIELDNAMES___movedOrientation	55
#define FIELDNAMES___movedPosition	56
#define FIELDNAMES___movedValue	57
#define FIELDNAMES___nodes	58
#define FIELDNAMES___normals	59
#define FIELDNAMES___numPoints	60
#define FIELDNAMES___occludeCheckCount	61
#define FIELDNAMES___oldChildren	62
#define FIELDNAMES___oldEnabled	63
#define FIELDNAMES___oldFieldOfView	64
#define FIELDNAMES___oldGeoCenter	65
#define FIELDNAMES___oldHeadlight	66
#define FIELDNAMES___oldJump	67
#define FIELDNAMES___oldKeyPtr	68
#define FIELDNAMES___oldKeyValuePtr	69
#define FIELDNAMES___oldMFString	70
#define FIELDNAMES___oldSFString	71
#define FIELDNAMES___oldSize	72
#define FIELDNAMES___oldgeoCoords	73
#define FIELDNAMES___oldload	74
#define FIELDNAMES___oldmetadata	75
#define FIELDNAMES___oldurl	76
#define FIELDNAMES___parentProto	77
#define FIELDNAMES___points	78
#define FIELDNAMES___protoDeclares	79
#define FIELDNAMES___protoDef	80
#define FIELDNAMES___protoFlags	81
#define FIELDNAMES___prototype	82
#define FIELDNAMES___proxNode	83
#define FIELDNAMES___quadcount	84
#define FIELDNAMES___regenSubTextures	85
#define FIELDNAMES___rendersub	86
#define FIELDNAMES___rightTexture	87
#define FIELDNAMES___rootUrl	88
#define FIELDNAMES___rooturlloadstatus	89
#define FIELDNAMES___rotyup	90
#define FIELDNAMES___scriptObj	91
#define FIELDNAMES___scripts	92
#define FIELDNAMES___segCount	93
#define FIELDNAMES___sidepoints	94
#define FIELDNAMES___simpleDisk	95
#define FIELDNAMES___solid	96
#define FIELDNAMES___sourceNumber	97
#define FIELDNAMES___subTextures	98
#define FIELDNAMES___subcontexts	99
#define FIELDNAMES___t1	100
#define FIELDNAMES___t2	101
#define FIELDNAMES___texCoords	102
#define FIELDNAMES___textureTableIndex	103
#define FIELDNAMES___textureright	104
#define FIELDNAMES___topTexture	105
#define FIELDNAMES___transparency	106
#define FIELDNAMES___typename	107
#define FIELDNAMES___vertArr	108
#define FIELDNAMES___vertIndx	109
#define FIELDNAMES___vertexCount	110
#define FIELDNAMES___vertices	111
#define FIELDNAMES___visible	112
#define FIELDNAMES___xcolours	113
#define FIELDNAMES___xparams	114
#define FIELDNAMES__amb	115
#define FIELDNAMES__bboxCenter	116
#define FIELDNAMES__bboxSize	117
#define FIELDNAMES__col	118
#define FIELDNAMES__colourSize	119
#define FIELDNAMES__coloursVBO	120
#define FIELDNAMES__coordIndex	121
#define FIELDNAMES__dir	122
#define FIELDNAMES__dlchange	123
#define FIELDNAMES__enabled	124
#define FIELDNAMES__floatInpFIFO	125
#define FIELDNAMES__floatOutFIFO	126
#define FIELDNAMES__hatchScale	127
#define FIELDNAMES__initialized	128
#define FIELDNAMES__int32InpFIFO	129
#define FIELDNAMES__int32OutFIFO	130
#define FIELDNAMES__keyVBO	131
#define FIELDNAMES__keyValueVBO	132
#define FIELDNAMES__loc	133
#define FIELDNAMES__npoints	134
#define FIELDNAMES__oldhitNormal	135
#define FIELDNAMES__oldhitPoint	136
#define FIELDNAMES__oldhitTexCoord	137
#define FIELDNAMES__oldisActive	138
#define FIELDNAMES__oldpickTarget	139
#define FIELDNAMES__oldpickedGeometry	140
#define FIELDNAMES__oldpickedPoint	141
#define FIELDNAMES__oldrotation	142
#define FIELDNAMES__oldtrackPoint	143
#define FIELDNAMES__oldtranslation	144
#define FIELDNAMES__origNormalizedPoint	145
#define FIELDNAMES__origPoint	146
#define FIELDNAMES__parentResource	147
#define FIELDNAMES__pointsVBO	148
#define FIELDNAMES__radius	149
#define FIELDNAMES__retrievedURLData	150
#define FIELDNAMES__rotationAngle	151
#define FIELDNAMES__selected	152
#define FIELDNAMES__shaderLoadThread	153
#define FIELDNAMES__shaderTableEntry	154
#define FIELDNAMES__shaderUserDefinedFields	155
#define FIELDNAMES__shaderUserNumber	156
#define FIELDNAMES__sideVBO	157
#define FIELDNAMES__sortedChildren	158
#define FIELDNAMES__status	159
#define FIELDNAMES__stringInpFIFO	160
#define FIELDNAMES__stringOutFIFO	161
#define FIELDNAMES__talkToNodes	162
#define FIELDNAMES__verifiedBackColor	163
#define FIELDNAMES__verifiedColor	164
#define FIELDNAMES__verifiedFrontColor	165
#define FIELDNAMES_actionKeyPress	166
#define FIELDNAMES_actionKeyRelease	167
#define FIELDNAMES_activate	168
#define FIELDNAMES_addChildren	169
#define FIELDNAMES_addGeometry	170
#define FIELDNAMES_addTrimmingContour	171
#define FIELDNAMES_addedEntities	172
#define FIELDNAMES_address	173
#define FIELDNAMES_alpha	174
#define FIELDNAMES_altKey	175
#define FIELDNAMES_ambientIntensity	176
#define FIELDNAMES_anisotropicDegree	177
#define FIELDNAMES_antennaLocation	178
#define FIELDNAMES_antennaPatternLength	179
#define FIELDNAMES_antennaPatternType	180
#define FIELDNAMES_appearance	181
#define FIELDNAMES_applicationID	182
#define FIELDNAMES_applied	183
#define FIELDNAMES_articulationParameterArray	184
#define FIELDNAMES_articulationParameterChangeIndicatorArr	185
#define FIELDNAMES_articulationParameterCount	186
#define FIELDNAMES_articulationParameterDesignatorArray	187
#define FIELDNAMES_articulationParameterIdPartAttachedToAr	188
#define FIELDNAMES_articulationParameterTypeArray	189
#define FIELDNAMES_articulationParameterValue0_changed	190
#define FIELDNAMES_articulationParameterValue1_changed	191
#define FIELDNAMES_articulationParameterValue2_changed	192
#define FIELDNAMES_articulationParameterValue3_changed	193
#define FIELDNAMES_articulationParameterValue4_changed	194
#define FIELDNAMES_articulationParameterValue5_changed	195
#define FIELDNAMES_articulationParameterValue6_changed	196
#define FIELDNAMES_articulationParameterValue7_changed	197
#define FIELDNAMES_attenuation	198
#define FIELDNAMES_attrib	199
#define FIELDNAMES_autoOffset	200
#define FIELDNAMES_avatarSize	201
#define FIELDNAMES_axisOfRotation	202
#define FIELDNAMES_axisRotation	203
#define FIELDNAMES_back	204
#define FIELDNAMES_backAmbientIntensity	205
#define FIELDNAMES_backDiffuseColor	206
#define FIELDNAMES_backEmissiveColor	207
#define FIELDNAMES_backShininess	208
#define FIELDNAMES_backSpecularColor	209
#define FIELDNAMES_backTexture	210
#define FIELDNAMES_backTransparency	211
#define FIELDNAMES_backUrl	212
#define FIELDNAMES_bboxCenter	213
#define FIELDNAMES_bboxSize	214
#define FIELDNAMES_beamWidth	215
#define FIELDNAMES_beginCap	216
#define FIELDNAMES_bindTime	217
#define FIELDNAMES_borderColor	218
#define FIELDNAMES_borderWidth	219
#define FIELDNAMES_bottom	220
#define FIELDNAMES_bottomRadius	221
#define FIELDNAMES_bottomTexture	222
#define FIELDNAMES_bottomUrl	223
#define FIELDNAMES_boundaryModeR	224
#define FIELDNAMES_boundaryModeS	225
#define FIELDNAMES_boundaryModeT	226
#define FIELDNAMES_category	227
#define FIELDNAMES_ccw	228
#define FIELDNAMES_center	229
#define FIELDNAMES_centerOfMass	230
#define FIELDNAMES_centerOfRotation	231
#define FIELDNAMES_centerOfRotation_changed	232
#define FIELDNAMES_child1Url	233
#define FIELDNAMES_child2Url	234
#define FIELDNAMES_child3Url	235
#define FIELDNAMES_child4Url	236
#define FIELDNAMES_children	237
#define FIELDNAMES_choice	238
#define FIELDNAMES_closed	239
#define FIELDNAMES_closureType	240
#define FIELDNAMES_collide	241
#define FIELDNAMES_collideTime	242
#define FIELDNAMES_collisionType	243
#define FIELDNAMES_color	244
#define FIELDNAMES_colorIndex	245
#define FIELDNAMES_colorPerVertex	246
#define FIELDNAMES_controlKey	247
#define FIELDNAMES_controlPoint	248
#define FIELDNAMES_convex	249
#define FIELDNAMES_coord	250
#define FIELDNAMES_coordIndex	251
#define FIELDNAMES_country	252
#define FIELDNAMES_creaseAngle	253
#define FIELDNAMES_crossSection	254
#define FIELDNAMES_crossSectionCurve	255
#define FIELDNAMES_cryptoKeyID	256
#define FIELDNAMES_cryptoSystem	257
#define FIELDNAMES_cutOffAngle	258
#define FIELDNAMES_cycleInterval	259
#define FIELDNAMES_cycleTime	260
#define FIELDNAMES_data	261
#define FIELDNAMES_dataLength	262
#define FIELDNAMES_deadReckoning	263
#define FIELDNAMES_deletionAllowed	264
#define FIELDNAMES_depth	265
#define FIELDNAMES_description	266
#define FIELDNAMES_detonateTime	267
#define FIELDNAMES_detonationLocation	268
#define FIELDNAMES_detonationRelativeLocation	269
#define FIELDNAMES_detonationResult	270
#define FIELDNAMES_diffuseColor	271
#define FIELDNAMES_directOutput	272
#define FIELDNAMES_direction	273
#define FIELDNAMES_diskAngle	274
#define FIELDNAMES_displacements	275
#define FIELDNAMES_displacers	276
#define FIELDNAMES_displayed	277
#define FIELDNAMES_domain	278
#define FIELDNAMES_duration_changed	279
#define FIELDNAMES_easeInEaseOut	280
#define FIELDNAMES_elapsedTime	281
#define FIELDNAMES_emissiveColor	282
#define FIELDNAMES_enabled	283
#define FIELDNAMES_encodingScheme	284
#define FIELDNAMES_endAngle	285
#define FIELDNAMES_endCap	286
#define FIELDNAMES_enterTime	287
#define FIELDNAMES_enteredText	288
#define FIELDNAMES_entityCategory	289
#define FIELDNAMES_entityCountry	290
#define FIELDNAMES_entityDomain	291
#define FIELDNAMES_entityExtra	292
#define FIELDNAMES_entityID	293
#define FIELDNAMES_entityKind	294
#define FIELDNAMES_entitySpecific	295
#define FIELDNAMES_entitySubCategory	296
#define FIELDNAMES_eventApplicationID	297
#define FIELDNAMES_eventEntityID	298
#define FIELDNAMES_eventNumber	299
#define FIELDNAMES_eventSiteID	300
#define FIELDNAMES_exitTime	301
#define FIELDNAMES_extra	302
#define FIELDNAMES_family	303
#define FIELDNAMES_fanCount	304
#define FIELDNAMES_fieldOfView	305
#define FIELDNAMES_fillProperties	306
#define FIELDNAMES_filled	307
#define FIELDNAMES_filter	308
#define FIELDNAMES_finalText	309
#define FIELDNAMES_fireMissionIndex	310
#define FIELDNAMES_fired1	311
#define FIELDNAMES_fired2	312
#define FIELDNAMES_firedTime	313
#define FIELDNAMES_firingRange	314
#define FIELDNAMES_firingRate	315
#define FIELDNAMES_floatInp	316
#define FIELDNAMES_fogCoord	317
#define FIELDNAMES_fogType	318
#define FIELDNAMES_fontStyle	319
#define FIELDNAMES_forceID	320
#define FIELDNAMES_forceTransitions	321
#define FIELDNAMES_fraction_changed	322
#define FIELDNAMES_frequency	323
#define FIELDNAMES_front	324
#define FIELDNAMES_frontTexture	325
#define FIELDNAMES_frontUrl	326
#define FIELDNAMES_function	327
#define FIELDNAMES_fuse	328
#define FIELDNAMES_generateMipMaps	329
#define FIELDNAMES_geoCenter	330
#define FIELDNAMES_geoCoord_changed	331
#define FIELDNAMES_geoCoords	332
#define FIELDNAMES_geoGridOrigin	333
#define FIELDNAMES_geoOrigin	334
#define FIELDNAMES_geoSystem	335
#define FIELDNAMES_geometry	336
#define FIELDNAMES_geovalue_changed	337
#define FIELDNAMES_global	338
#define FIELDNAMES_gotEvents	339
#define FIELDNAMES_groundAngle	340
#define FIELDNAMES_groundColor	341
#define FIELDNAMES_handler	342
#define FIELDNAMES_hatchColor	343
#define FIELDNAMES_hatchStyle	344
#define FIELDNAMES_hatched	345
#define FIELDNAMES_headlight	346
#define FIELDNAMES_height	347
#define FIELDNAMES_hitGeoCoord_changed	348
#define FIELDNAMES_hitNormal_changed	349
#define FIELDNAMES_hitPoint_changed	350
#define FIELDNAMES_hitTexCoord_changed	351
#define FIELDNAMES_horizontal	352
#define FIELDNAMES_image	353
#define FIELDNAMES_index	354
#define FIELDNAMES_info	355
#define FIELDNAMES_innerRadius	356
#define FIELDNAMES_inputFalse	357
#define FIELDNAMES_inputNegate	358
#define FIELDNAMES_inputSource	359
#define FIELDNAMES_inputTrue	360
#define FIELDNAMES_int32Inp	361
#define FIELDNAMES_integerKey	362
#define FIELDNAMES_intensity	363
#define FIELDNAMES_intersectionType	364
#define FIELDNAMES_isActive	365
#define FIELDNAMES_isBound	366
#define FIELDNAMES_isCollided	367
#define FIELDNAMES_isDetonated	368
#define FIELDNAMES_isLoaded	369
#define FIELDNAMES_isNetworkReader	370
#define FIELDNAMES_isNetworkWriter	371
#define FIELDNAMES_isOver	372
#define FIELDNAMES_isPaused	373
#define FIELDNAMES_isRtpHeaderHeard	374
#define FIELDNAMES_isSelected	375
#define FIELDNAMES_isStandAlone	376
#define FIELDNAMES_isValid	377
#define FIELDNAMES_joints	378
#define FIELDNAMES_jump	379
#define FIELDNAMES_justify	380
#define FIELDNAMES_key	381
#define FIELDNAMES_keyPress	382
#define FIELDNAMES_keyRelease	383
#define FIELDNAMES_keyValue	384
#define FIELDNAMES_keyVelocity	385
#define FIELDNAMES_kind	386
#define FIELDNAMES_knot	387
#define FIELDNAMES_language	388
#define FIELDNAMES_left	389
#define FIELDNAMES_leftTexture	390
#define FIELDNAMES_leftToRight	391
#define FIELDNAMES_leftUrl	392
#define FIELDNAMES_length	393
#define FIELDNAMES_lengthOfModulationParameters	394
#define FIELDNAMES_level	395
#define FIELDNAMES_levelChanged	396
#define FIELDNAMES_level_changed	397
#define FIELDNAMES_limitOrientation	398
#define FIELDNAMES_lineBounds	399
#define FIELDNAMES_lineProperties	400
#define FIELDNAMES_lineSegments	401
#define FIELDNAMES_linearAcceleration	402
#define FIELDNAMES_linearVelocity	403
#define FIELDNAMES_linetype	404
#define FIELDNAMES_linewidthScaleFactor	405
#define FIELDNAMES_listenfor	406
#define FIELDNAMES_llimit	407
#define FIELDNAMES_load	408
#define FIELDNAMES_loadTime	409
#define FIELDNAMES_location	410
#define FIELDNAMES_loop	411
#define FIELDNAMES_magnificationFilter	412
#define FIELDNAMES_mapping	413
#define FIELDNAMES_marking	414
#define FIELDNAMES_mass	415
#define FIELDNAMES_material	416
#define FIELDNAMES_maxAngle	417
#define FIELDNAMES_maxBack	418
#define FIELDNAMES_maxExtent	419
#define FIELDNAMES_maxFront	420
#define FIELDNAMES_maxPosition	421
#define FIELDNAMES_metadata	422
#define FIELDNAMES_minAngle	423
#define FIELDNAMES_minBack	424
#define FIELDNAMES_minFront	425
#define FIELDNAMES_minPosition	426
#define FIELDNAMES_minificationFilter	427
#define FIELDNAMES_mode	428
#define FIELDNAMES_modifiedFraction_changed	429
#define FIELDNAMES_modulationTypeDetail	430
#define FIELDNAMES_modulationTypeMajor	431
#define FIELDNAMES_modulationTypeSpreadSpectrum	432
#define FIELDNAMES_modulationTypeSystem	433
#define FIELDNAMES_momentsOfInertia	434
#define FIELDNAMES_multicastRelayHost	435
#define FIELDNAMES_multicastRelayPort	436
#define FIELDNAMES_munitionApplicationID	437
#define FIELDNAMES_munitionEndPoint	438
#define FIELDNAMES_munitionEntityID	439
#define FIELDNAMES_munitionQuantity	440
#define FIELDNAMES_munitionSiteID	441
#define FIELDNAMES_munitionStartPoint	442
#define FIELDNAMES_mustEvaluate	443
#define FIELDNAMES_name	444
#define FIELDNAMES_navType	445
#define FIELDNAMES_networkMode	446
#define FIELDNAMES_next	447
#define FIELDNAMES_normal	448
#define FIELDNAMES_normalIndex	449
#define FIELDNAMES_normalPerVertex	450
#define FIELDNAMES_normal_changed	451
#define FIELDNAMES_normalizeVelocity	452
#define FIELDNAMES_numComponents	453
#define FIELDNAMES_objectType	454
#define FIELDNAMES_offset	455
#define FIELDNAMES_on	456
#define FIELDNAMES_order	457
#define FIELDNAMES_orientation	458
#define FIELDNAMES_orientation_changed	459
#define FIELDNAMES_origin	460
#define FIELDNAMES_outerRadius	461
#define FIELDNAMES_parameter	462
#define FIELDNAMES_parts	463
#define FIELDNAMES_pauseTime	464
#define FIELDNAMES_pickTarget	465
#define FIELDNAMES_pickable	466
#define FIELDNAMES_pickedGeometry	467
#define FIELDNAMES_pickedPoint	468
#define FIELDNAMES_pickingGeometry	469
#define FIELDNAMES_pitch	470
#define FIELDNAMES_plane	471
#define FIELDNAMES_point	472
#define FIELDNAMES_port	473
#define FIELDNAMES_position	474
#define FIELDNAMES_position_changed	475
#define FIELDNAMES_power	476
#define FIELDNAMES_previous	477
#define FIELDNAMES_priority	478
#define FIELDNAMES_profileCurve	479
#define FIELDNAMES_programs	480
#define FIELDNAMES_progress	481
#define FIELDNAMES_protocol	482
#define FIELDNAMES_proxy	483
#define FIELDNAMES_radioEntityTypeCategory	484
#define FIELDNAMES_radioEntityTypeCountry	485
#define FIELDNAMES_radioEntityTypeDomain	486
#define FIELDNAMES_radioEntityTypeKind	487
#define FIELDNAMES_radioEntityTypeNomenclature	488
#define FIELDNAMES_radioEntityTypeNomenclatureVersion	489
#define FIELDNAMES_radioID	490
#define FIELDNAMES_radius	491
#define FIELDNAMES_range	492
#define FIELDNAMES_readInterval	493
#define FIELDNAMES_receivedPower	494
#define FIELDNAMES_receiverState	495
#define FIELDNAMES_reference	496
#define FIELDNAMES_relativeAntennaLocation	497
#define FIELDNAMES_removeChildren	498
#define FIELDNAMES_removeGeometry	499
#define FIELDNAMES_removeTrimmingContour	500
#define FIELDNAMES_removedEntities	501
#define FIELDNAMES_repeatS	502
#define FIELDNAMES_repeatT	503
#define FIELDNAMES_resumeTime	504
#define FIELDNAMES_retainUserOffsets	505
#define FIELDNAMES_right	506
#define FIELDNAMES_rightTexture	507
#define FIELDNAMES_rightUrl	508
#define FIELDNAMES_rootNode	509
#define FIELDNAMES_rootUrl	510
#define FIELDNAMES_rotateYUp	511
#define FIELDNAMES_rotation	512
#define FIELDNAMES_rotation_changed	513
#define FIELDNAMES_rtpHeaderExpected	514
#define FIELDNAMES_sampleRate	515
#define FIELDNAMES_samples	516
#define FIELDNAMES_scale	517
#define FIELDNAMES_scaleOrientation	518
#define FIELDNAMES_segments	519
#define FIELDNAMES_separateBackColor	520
#define FIELDNAMES_setValue	521
#define FIELDNAMES_set_articulationParameterValue0	522
#define FIELDNAMES_set_articulationParameterValue1	523
#define FIELDNAMES_set_articulationParameterValue2	524
#define FIELDNAMES_set_articulationParameterValue3	525
#define FIELDNAMES_set_articulationParameterValue4	526
#define FIELDNAMES_set_articulationParameterValue5	527
#define FIELDNAMES_set_articulationParameterValue6	528
#define FIELDNAMES_set_articulationParameterValue7	529
#define FIELDNAMES_set_bind	530
#define FIELDNAMES_set_boolean	531
#define FIELDNAMES_set_colorIndex	532
#define FIELDNAMES_set_coordIndex	533
#define FIELDNAMES_set_crossSection	534
#define FIELDNAMES_set_fraction	535
#define FIELDNAMES_set_height	536
#define FIELDNAMES_set_index	537
#define FIELDNAMES_set_intersectionType	538
#define FIELDNAMES_set_normalIndex	539
#define FIELDNAMES_set_orientation	540
#define FIELDNAMES_set_position	541
#define FIELDNAMES_set_scale	542
#define FIELDNAMES_set_sortOrder	543
#define FIELDNAMES_set_spine	544
#define FIELDNAMES_set_texCoordIndex	545
#define FIELDNAMES_set_triggerTime	546
#define FIELDNAMES_shaders	547
#define FIELDNAMES_shape	548
#define FIELDNAMES_shiftKey	549
#define FIELDNAMES_shininess	550
#define FIELDNAMES_side	551
#define FIELDNAMES_siteID	552
#define FIELDNAMES_sites	553
#define FIELDNAMES_size	554
#define FIELDNAMES_skeleton	555
#define FIELDNAMES_skin	556
#define FIELDNAMES_skinCoord	557
#define FIELDNAMES_skinCoordIndex	558
#define FIELDNAMES_skinCoordWeight	559
#define FIELDNAMES_skinNormal	560
#define FIELDNAMES_skyAngle	561
#define FIELDNAMES_skyColor	562
#define FIELDNAMES_solid	563
#define FIELDNAMES_sortOrder	564
#define FIELDNAMES_source	565
#define FIELDNAMES_spacing	566
#define FIELDNAMES_spatialize	567
#define FIELDNAMES_specific	568
#define FIELDNAMES_specularColor	569
#define FIELDNAMES_speed	570
#define FIELDNAMES_speedFactor	571
#define FIELDNAMES_spine	572
#define FIELDNAMES_startAngle	573
#define FIELDNAMES_startTime	574
#define FIELDNAMES_stiffness	575
#define FIELDNAMES_stopTime	576
#define FIELDNAMES_string	577
#define FIELDNAMES_stringInp	578
#define FIELDNAMES_stripCount	579
#define FIELDNAMES_style	580
#define FIELDNAMES_subcategory	581
#define FIELDNAMES_summary	582
#define FIELDNAMES_talksTo	583
#define FIELDNAMES_tdlType	584
#define FIELDNAMES_tessellation	585
#define FIELDNAMES_tessellationScale	586
#define FIELDNAMES_texCoord	587
#define FIELDNAMES_texCoordIndex	588
#define FIELDNAMES_textBounds	589
#define FIELDNAMES_texture	590
#define FIELDNAMES_textureCompression	591
#define FIELDNAMES_texturePriority	592
#define FIELDNAMES_textureProperties	593
#define FIELDNAMES_textureTransform	594
#define FIELDNAMES_tickTime	595
#define FIELDNAMES_time	596
#define FIELDNAMES_timeOut	597
#define FIELDNAMES_timestamp	598
#define FIELDNAMES_title	599
#define FIELDNAMES_toggle	600
#define FIELDNAMES_top	601
#define FIELDNAMES_topTexture	602
#define FIELDNAMES_topToBottom	603
#define FIELDNAMES_topUrl	604
#define FIELDNAMES_touchTime	605
#define FIELDNAMES_trackPoint_changed	606
#define FIELDNAMES_trajectoryCurve	607
#define FIELDNAMES_transitionComplete	608
#define FIELDNAMES_transitionTime	609
#define FIELDNAMES_transitionType	610
#define FIELDNAMES_translation	611
#define FIELDNAMES_translation_changed	612
#define FIELDNAMES_transmitFrequencyBandwidth	613
#define FIELDNAMES_transmitState	614
#define FIELDNAMES_transmitterApplicationID	615
#define FIELDNAMES_transmitterEntityID	616
#define FIELDNAMES_transmitterRadioID	617
#define FIELDNAMES_transmitterSiteID	618
#define FIELDNAMES_transparency	619
#define FIELDNAMES_triggerTime	620
#define FIELDNAMES_triggerTrue	621
#define FIELDNAMES_triggerValue	622
#define FIELDNAMES_trimmingContour	623
#define FIELDNAMES_type	624
#define FIELDNAMES_uClosed	625
#define FIELDNAMES_uDimension	626
#define FIELDNAMES_uKnot	627
#define FIELDNAMES_uOrder	628
#define FIELDNAMES_uTessellation	629
#define FIELDNAMES_ulimit	630
#define FIELDNAMES_update	631
#define FIELDNAMES_url	632
#define FIELDNAMES_vClosed	633
#define FIELDNAMES_vDimension	634
#define FIELDNAMES_vKnot	635
#define FIELDNAMES_vOrder	636
#define FIELDNAMES_vTessellation	637
#define FIELDNAMES_value	638
#define FIELDNAMES_valueChanged	639
#define FIELDNAMES_value_changed	640
#define FIELDNAMES_vector	641
#define FIELDNAMES_version	642
#define FIELDNAMES_vertexCount	643
#define FIELDNAMES_vertices	644
#define FIELDNAMES_viewpoints	645
#define FIELDNAMES_visibilityLimit	646
#define FIELDNAMES_visibilityRange	647
#define FIELDNAMES_visible	648
#define FIELDNAMES_warhead	649
#define FIELDNAMES_watchList	650
#define FIELDNAMES_weight	651
#define FIELDNAMES_whichChoice	652
#define FIELDNAMES_whichGeometry	653
#define FIELDNAMES_writeInterval	654
#define FIELDNAMES_xDimension	655
#define FIELDNAMES_xSpacing	656
#define FIELDNAMES_yScale	657
#define FIELDNAMES_zDimension	658
#define FIELDNAMES_zSpacing	659

const char *stringFieldType(int st);

/* Table of built-in fieldIds */
extern const char *EVENT_OUT[];
extern const int EVENT_OUT_COUNT;
#define EVENT_OUT_actionKeyPress	0
#define EVENT_OUT_actionKeyRelease	1
#define EVENT_OUT_addedEntities	2
#define EVENT_OUT_altKey	3
#define EVENT_OUT_articulationParameterValue0_changed	4
#define EVENT_OUT_articulationParameterValue1_changed	5
#define EVENT_OUT_articulationParameterValue2_changed	6
#define EVENT_OUT_articulationParameterValue3_changed	7
#define EVENT_OUT_articulationParameterValue4_changed	8
#define EVENT_OUT_articulationParameterValue5_changed	9
#define EVENT_OUT_articulationParameterValue6_changed	10
#define EVENT_OUT_articulationParameterValue7_changed	11
#define EVENT_OUT_bindTime	12
#define EVENT_OUT_centerOfRotation_changed	13
#define EVENT_OUT_children	14
#define EVENT_OUT_collideTime	15
#define EVENT_OUT_controlKey	16
#define EVENT_OUT_cycleTime	17
#define EVENT_OUT_detonateTime	18
#define EVENT_OUT_duration_changed	19
#define EVENT_OUT_elapsedTime	20
#define EVENT_OUT_enterTime	21
#define EVENT_OUT_enteredText	22
#define EVENT_OUT_exitTime	23
#define EVENT_OUT_finalText	24
#define EVENT_OUT_firedTime	25
#define EVENT_OUT_fraction_changed	26
#define EVENT_OUT_geoCoord_changed	27
#define EVENT_OUT_geovalue_changed	28
#define EVENT_OUT_hitGeoCoord_changed	29
#define EVENT_OUT_hitNormal_changed	30
#define EVENT_OUT_hitPoint_changed	31
#define EVENT_OUT_hitTexCoord_changed	32
#define EVENT_OUT_inputFalse	33
#define EVENT_OUT_inputNegate	34
#define EVENT_OUT_inputTrue	35
#define EVENT_OUT_isActive	36
#define EVENT_OUT_isBound	37
#define EVENT_OUT_isCollided	38
#define EVENT_OUT_isDetonated	39
#define EVENT_OUT_isLoaded	40
#define EVENT_OUT_isNetworkReader	41
#define EVENT_OUT_isNetworkWriter	42
#define EVENT_OUT_isOver	43
#define EVENT_OUT_isPaused	44
#define EVENT_OUT_isRtpHeaderHeard	45
#define EVENT_OUT_isSelected	46
#define EVENT_OUT_isStandAlone	47
#define EVENT_OUT_isValid	48
#define EVENT_OUT_keyPress	49
#define EVENT_OUT_keyRelease	50
#define EVENT_OUT_levelChanged	51
#define EVENT_OUT_level_changed	52
#define EVENT_OUT_lineBounds	53
#define EVENT_OUT_loadTime	54
#define EVENT_OUT_modifiedFraction_changed	55
#define EVENT_OUT_normal_changed	56
#define EVENT_OUT_orientation_changed	57
#define EVENT_OUT_origin	58
#define EVENT_OUT_pickedGeometry	59
#define EVENT_OUT_pickedPoint	60
#define EVENT_OUT_position_changed	61
#define EVENT_OUT_progress	62
#define EVENT_OUT_removedEntities	63
#define EVENT_OUT_rotation_changed	64
#define EVENT_OUT_shiftKey	65
#define EVENT_OUT_textBounds	66
#define EVENT_OUT_time	67
#define EVENT_OUT_timestamp	68
#define EVENT_OUT_toggle	69
#define EVENT_OUT_touchTime	70
#define EVENT_OUT_trackPoint_changed	71
#define EVENT_OUT_transitionComplete	72
#define EVENT_OUT_translation_changed	73
#define EVENT_OUT_triggerTime	74
#define EVENT_OUT_triggerTrue	75
#define EVENT_OUT_triggerValue	76
#define EVENT_OUT_valueChanged	77
#define EVENT_OUT_value_changed	78


/* Table of built-in fieldIds */
extern const char *EVENT_IN[];
extern const int EVENT_IN_COUNT;
#define EVENT_IN_activate	0
#define EVENT_IN_addChildren	1
#define EVENT_IN_addGeometry	2
#define EVENT_IN_addTrimmingContour	3
#define EVENT_IN_coordIndex	4
#define EVENT_IN_next	5
#define EVENT_IN_previous	6
#define EVENT_IN_removeChildren	7
#define EVENT_IN_removeGeometry	8
#define EVENT_IN_removeTrimmingContour	9
#define EVENT_IN_setValue	10
#define EVENT_IN_set_articulationParameterValue0	11
#define EVENT_IN_set_articulationParameterValue1	12
#define EVENT_IN_set_articulationParameterValue2	13
#define EVENT_IN_set_articulationParameterValue3	14
#define EVENT_IN_set_articulationParameterValue4	15
#define EVENT_IN_set_articulationParameterValue5	16
#define EVENT_IN_set_articulationParameterValue6	17
#define EVENT_IN_set_articulationParameterValue7	18
#define EVENT_IN_set_bind	19
#define EVENT_IN_set_boolean	20
#define EVENT_IN_set_colorIndex	21
#define EVENT_IN_set_coordIndex	22
#define EVENT_IN_set_crossSection	23
#define EVENT_IN_set_fraction	24
#define EVENT_IN_set_height	25
#define EVENT_IN_set_index	26
#define EVENT_IN_set_intersectionType	27
#define EVENT_IN_set_normalIndex	28
#define EVENT_IN_set_orientation	29
#define EVENT_IN_set_position	30
#define EVENT_IN_set_scale	31
#define EVENT_IN_set_sortOrder	32
#define EVENT_IN_set_spine	33
#define EVENT_IN_set_texCoordIndex	34
#define EVENT_IN_set_triggerTime	35
#define EVENT_IN_tickTime	36


/* Table of built-in fieldIds */
extern const char *EXPOSED_FIELD[];
extern const int EXPOSED_FIELD_COUNT;
#define EXPOSED_FIELD_FIFOsize	0
#define EXPOSED_FIELD_FreeWRL_PROTOInterfaceNodes	1
#define EXPOSED_FIELD_address	2
#define EXPOSED_FIELD_alpha	3
#define EXPOSED_FIELD_ambientIntensity	4
#define EXPOSED_FIELD_anisotropicDegree	5
#define EXPOSED_FIELD_antennaLocation	6
#define EXPOSED_FIELD_antennaPatternLength	7
#define EXPOSED_FIELD_antennaPatternType	8
#define EXPOSED_FIELD_appearance	9
#define EXPOSED_FIELD_applicationID	10
#define EXPOSED_FIELD_applied	11
#define EXPOSED_FIELD_articulationParameterArray	12
#define EXPOSED_FIELD_articulationParameterChangeIndicatorArr	13
#define EXPOSED_FIELD_articulationParameterCount	14
#define EXPOSED_FIELD_articulationParameterDesignatorArray	15
#define EXPOSED_FIELD_articulationParameterIdPartAttachedToAr	16
#define EXPOSED_FIELD_articulationParameterTypeArray	17
#define EXPOSED_FIELD_attenuation	18
#define EXPOSED_FIELD_attrib	19
#define EXPOSED_FIELD_autoOffset	20
#define EXPOSED_FIELD_avatarSize	21
#define EXPOSED_FIELD_axisOfRotation	22
#define EXPOSED_FIELD_axisRotation	23
#define EXPOSED_FIELD_back	24
#define EXPOSED_FIELD_backAmbientIntensity	25
#define EXPOSED_FIELD_backDiffuseColor	26
#define EXPOSED_FIELD_backEmissiveColor	27
#define EXPOSED_FIELD_backShininess	28
#define EXPOSED_FIELD_backSpecularColor	29
#define EXPOSED_FIELD_backTexture	30
#define EXPOSED_FIELD_backTransparency	31
#define EXPOSED_FIELD_backUrl	32
#define EXPOSED_FIELD_beamWidth	33
#define EXPOSED_FIELD_borderColor	34
#define EXPOSED_FIELD_borderWidth	35
#define EXPOSED_FIELD_bottom	36
#define EXPOSED_FIELD_bottomTexture	37
#define EXPOSED_FIELD_bottomUrl	38
#define EXPOSED_FIELD_boundaryModeR	39
#define EXPOSED_FIELD_boundaryModeS	40
#define EXPOSED_FIELD_boundaryModeT	41
#define EXPOSED_FIELD_center	42
#define EXPOSED_FIELD_centerOfMass	43
#define EXPOSED_FIELD_centerOfRotation	44
#define EXPOSED_FIELD_children	45
#define EXPOSED_FIELD_choice	46
#define EXPOSED_FIELD_closed	47
#define EXPOSED_FIELD_collide	48
#define EXPOSED_FIELD_collisionType	49
#define EXPOSED_FIELD_color	50
#define EXPOSED_FIELD_controlPoint	51
#define EXPOSED_FIELD_coord	52
#define EXPOSED_FIELD_crossSectionCurve	53
#define EXPOSED_FIELD_cryptoKeyID	54
#define EXPOSED_FIELD_cryptoSystem	55
#define EXPOSED_FIELD_cutOffAngle	56
#define EXPOSED_FIELD_cycleInterval	57
#define EXPOSED_FIELD_data	58
#define EXPOSED_FIELD_dataLength	59
#define EXPOSED_FIELD_deadReckoning	60
#define EXPOSED_FIELD_deletionAllowed	61
#define EXPOSED_FIELD_depth	62
#define EXPOSED_FIELD_description	63
#define EXPOSED_FIELD_detonationLocation	64
#define EXPOSED_FIELD_detonationRelativeLocation	65
#define EXPOSED_FIELD_detonationResult	66
#define EXPOSED_FIELD_diffuseColor	67
#define EXPOSED_FIELD_direction	68
#define EXPOSED_FIELD_diskAngle	69
#define EXPOSED_FIELD_displacements	70
#define EXPOSED_FIELD_displacers	71
#define EXPOSED_FIELD_displayed	72
#define EXPOSED_FIELD_easeInEaseOut	73
#define EXPOSED_FIELD_emissiveColor	74
#define EXPOSED_FIELD_enabled	75
#define EXPOSED_FIELD_encodingScheme	76
#define EXPOSED_FIELD_entityCategory	77
#define EXPOSED_FIELD_entityCountry	78
#define EXPOSED_FIELD_entityDomain	79
#define EXPOSED_FIELD_entityExtra	80
#define EXPOSED_FIELD_entityID	81
#define EXPOSED_FIELD_entityKind	82
#define EXPOSED_FIELD_entitySpecific	83
#define EXPOSED_FIELD_entitySubCategory	84
#define EXPOSED_FIELD_eventApplicationID	85
#define EXPOSED_FIELD_eventEntityID	86
#define EXPOSED_FIELD_eventNumber	87
#define EXPOSED_FIELD_eventSiteID	88
#define EXPOSED_FIELD_fieldOfView	89
#define EXPOSED_FIELD_fillProperties	90
#define EXPOSED_FIELD_filled	91
#define EXPOSED_FIELD_filter	92
#define EXPOSED_FIELD_fireMissionIndex	93
#define EXPOSED_FIELD_fired1	94
#define EXPOSED_FIELD_fired2	95
#define EXPOSED_FIELD_firingRange	96
#define EXPOSED_FIELD_firingRate	97
#define EXPOSED_FIELD_floatInp	98
#define EXPOSED_FIELD_fogCoord	99
#define EXPOSED_FIELD_fogType	100
#define EXPOSED_FIELD_fontStyle	101
#define EXPOSED_FIELD_forceID	102
#define EXPOSED_FIELD_frequency	103
#define EXPOSED_FIELD_front	104
#define EXPOSED_FIELD_frontTexture	105
#define EXPOSED_FIELD_frontUrl	106
#define EXPOSED_FIELD_function	107
#define EXPOSED_FIELD_fuse	108
#define EXPOSED_FIELD_geoCenter	109
#define EXPOSED_FIELD_geoCoords	110
#define EXPOSED_FIELD_geometry	111
#define EXPOSED_FIELD_global	112
#define EXPOSED_FIELD_gotEvents	113
#define EXPOSED_FIELD_groundAngle	114
#define EXPOSED_FIELD_groundColor	115
#define EXPOSED_FIELD_handler	116
#define EXPOSED_FIELD_hatchColor	117
#define EXPOSED_FIELD_hatchStyle	118
#define EXPOSED_FIELD_hatched	119
#define EXPOSED_FIELD_headlight	120
#define EXPOSED_FIELD_image	121
#define EXPOSED_FIELD_index	122
#define EXPOSED_FIELD_inputSource	123
#define EXPOSED_FIELD_int32Inp	124
#define EXPOSED_FIELD_integerKey	125
#define EXPOSED_FIELD_intensity	126
#define EXPOSED_FIELD_joints	127
#define EXPOSED_FIELD_jump	128
#define EXPOSED_FIELD_key	129
#define EXPOSED_FIELD_keyValue	130
#define EXPOSED_FIELD_keyVelocity	131
#define EXPOSED_FIELD_knot	132
#define EXPOSED_FIELD_left	133
#define EXPOSED_FIELD_leftTexture	134
#define EXPOSED_FIELD_leftUrl	135
#define EXPOSED_FIELD_length	136
#define EXPOSED_FIELD_lengthOfModulationParameters	137
#define EXPOSED_FIELD_level	138
#define EXPOSED_FIELD_limitOrientation	139
#define EXPOSED_FIELD_lineProperties	140
#define EXPOSED_FIELD_linearAcceleration	141
#define EXPOSED_FIELD_linearVelocity	142
#define EXPOSED_FIELD_linetype	143
#define EXPOSED_FIELD_linewidthScaleFactor	144
#define EXPOSED_FIELD_listenfor	145
#define EXPOSED_FIELD_llimit	146
#define EXPOSED_FIELD_load	147
#define EXPOSED_FIELD_location	148
#define EXPOSED_FIELD_loop	149
#define EXPOSED_FIELD_magnificationFilter	150
#define EXPOSED_FIELD_mapping	151
#define EXPOSED_FIELD_marking	152
#define EXPOSED_FIELD_mass	153
#define EXPOSED_FIELD_material	154
#define EXPOSED_FIELD_maxAngle	155
#define EXPOSED_FIELD_maxBack	156
#define EXPOSED_FIELD_maxExtent	157
#define EXPOSED_FIELD_maxFront	158
#define EXPOSED_FIELD_maxPosition	159
#define EXPOSED_FIELD_metadata	160
#define EXPOSED_FIELD_minAngle	161
#define EXPOSED_FIELD_minBack	162
#define EXPOSED_FIELD_minFront	163
#define EXPOSED_FIELD_minPosition	164
#define EXPOSED_FIELD_minificationFilter	165
#define EXPOSED_FIELD_mode	166
#define EXPOSED_FIELD_modulationTypeDetail	167
#define EXPOSED_FIELD_modulationTypeMajor	168
#define EXPOSED_FIELD_modulationTypeSpreadSpectrum	169
#define EXPOSED_FIELD_modulationTypeSystem	170
#define EXPOSED_FIELD_momentsOfInertia	171
#define EXPOSED_FIELD_multicastRelayHost	172
#define EXPOSED_FIELD_multicastRelayPort	173
#define EXPOSED_FIELD_munitionApplicationID	174
#define EXPOSED_FIELD_munitionEndPoint	175
#define EXPOSED_FIELD_munitionEntityID	176
#define EXPOSED_FIELD_munitionQuantity	177
#define EXPOSED_FIELD_munitionSiteID	178
#define EXPOSED_FIELD_munitionStartPoint	179
#define EXPOSED_FIELD_name	180
#define EXPOSED_FIELD_navType	181
#define EXPOSED_FIELD_networkMode	182
#define EXPOSED_FIELD_normal	183
#define EXPOSED_FIELD_normalizeVelocity	184
#define EXPOSED_FIELD_objectType	185
#define EXPOSED_FIELD_offset	186
#define EXPOSED_FIELD_on	187
#define EXPOSED_FIELD_order	188
#define EXPOSED_FIELD_orientation	189
#define EXPOSED_FIELD_parameter	190
#define EXPOSED_FIELD_parts	191
#define EXPOSED_FIELD_pauseTime	192
#define EXPOSED_FIELD_pickTarget	193
#define EXPOSED_FIELD_pickable	194
#define EXPOSED_FIELD_pickingGeometry	195
#define EXPOSED_FIELD_pitch	196
#define EXPOSED_FIELD_plane	197
#define EXPOSED_FIELD_point	198
#define EXPOSED_FIELD_port	199
#define EXPOSED_FIELD_position	200
#define EXPOSED_FIELD_power	201
#define EXPOSED_FIELD_priority	202
#define EXPOSED_FIELD_profileCurve	203
#define EXPOSED_FIELD_programs	204
#define EXPOSED_FIELD_protocol	205
#define EXPOSED_FIELD_radioEntityTypeCategory	206
#define EXPOSED_FIELD_radioEntityTypeCountry	207
#define EXPOSED_FIELD_radioEntityTypeDomain	208
#define EXPOSED_FIELD_radioEntityTypeKind	209
#define EXPOSED_FIELD_radioEntityTypeNomenclature	210
#define EXPOSED_FIELD_radioEntityTypeNomenclatureVersion	211
#define EXPOSED_FIELD_radioID	212
#define EXPOSED_FIELD_radius	213
#define EXPOSED_FIELD_readInterval	214
#define EXPOSED_FIELD_receivedPower	215
#define EXPOSED_FIELD_receiverState	216
#define EXPOSED_FIELD_relativeAntennaLocation	217
#define EXPOSED_FIELD_resumeTime	218
#define EXPOSED_FIELD_retainUserOffsets	219
#define EXPOSED_FIELD_right	220
#define EXPOSED_FIELD_rightTexture	221
#define EXPOSED_FIELD_rightUrl	222
#define EXPOSED_FIELD_rotation	223
#define EXPOSED_FIELD_rtpHeaderExpected	224
#define EXPOSED_FIELD_sampleRate	225
#define EXPOSED_FIELD_samples	226
#define EXPOSED_FIELD_scale	227
#define EXPOSED_FIELD_scaleOrientation	228
#define EXPOSED_FIELD_segments	229
#define EXPOSED_FIELD_separateBackColor	230
#define EXPOSED_FIELD_shaders	231
#define EXPOSED_FIELD_shape	232
#define EXPOSED_FIELD_shininess	233
#define EXPOSED_FIELD_siteID	234
#define EXPOSED_FIELD_sites	235
#define EXPOSED_FIELD_size	236
#define EXPOSED_FIELD_skeleton	237
#define EXPOSED_FIELD_skin	238
#define EXPOSED_FIELD_skinCoord	239
#define EXPOSED_FIELD_skinCoordIndex	240
#define EXPOSED_FIELD_skinCoordWeight	241
#define EXPOSED_FIELD_skinNormal	242
#define EXPOSED_FIELD_skyAngle	243
#define EXPOSED_FIELD_skyColor	244
#define EXPOSED_FIELD_source	245
#define EXPOSED_FIELD_specularColor	246
#define EXPOSED_FIELD_speed	247
#define EXPOSED_FIELD_startTime	248
#define EXPOSED_FIELD_stiffness	249
#define EXPOSED_FIELD_stopTime	250
#define EXPOSED_FIELD_string	251
#define EXPOSED_FIELD_stringInp	252
#define EXPOSED_FIELD_summary	253
#define EXPOSED_FIELD_talksTo	254
#define EXPOSED_FIELD_tdlType	255
#define EXPOSED_FIELD_tessellation	256
#define EXPOSED_FIELD_tessellationScale	257
#define EXPOSED_FIELD_texCoord	258
#define EXPOSED_FIELD_texture	259
#define EXPOSED_FIELD_textureCompression	260
#define EXPOSED_FIELD_texturePriority	261
#define EXPOSED_FIELD_textureTransform	262
#define EXPOSED_FIELD_timeOut	263
#define EXPOSED_FIELD_top	264
#define EXPOSED_FIELD_topTexture	265
#define EXPOSED_FIELD_topUrl	266
#define EXPOSED_FIELD_trajectoryCurve	267
#define EXPOSED_FIELD_transitionTime	268
#define EXPOSED_FIELD_transitionType	269
#define EXPOSED_FIELD_translation	270
#define EXPOSED_FIELD_transmitFrequencyBandwidth	271
#define EXPOSED_FIELD_transmitState	272
#define EXPOSED_FIELD_transmitterApplicationID	273
#define EXPOSED_FIELD_transmitterEntityID	274
#define EXPOSED_FIELD_transmitterRadioID	275
#define EXPOSED_FIELD_transmitterSiteID	276
#define EXPOSED_FIELD_transparency	277
#define EXPOSED_FIELD_trimmingContour	278
#define EXPOSED_FIELD_type	279
#define EXPOSED_FIELD_uDimension	280
#define EXPOSED_FIELD_uOrder	281
#define EXPOSED_FIELD_uTessellation	282
#define EXPOSED_FIELD_ulimit	283
#define EXPOSED_FIELD_update	284
#define EXPOSED_FIELD_url	285
#define EXPOSED_FIELD_vDimension	286
#define EXPOSED_FIELD_vOrder	287
#define EXPOSED_FIELD_vTessellation	288
#define EXPOSED_FIELD_value	289
#define EXPOSED_FIELD_vector	290
#define EXPOSED_FIELD_version	291
#define EXPOSED_FIELD_vertexCount	292
#define EXPOSED_FIELD_vertices	293
#define EXPOSED_FIELD_viewpoints	294
#define EXPOSED_FIELD_visibilityLimit	295
#define EXPOSED_FIELD_visibilityRange	296
#define EXPOSED_FIELD_visible	297
#define EXPOSED_FIELD_warhead	298
#define EXPOSED_FIELD_watchList	299
#define EXPOSED_FIELD_weight	300
#define EXPOSED_FIELD_whichChoice	301
#define EXPOSED_FIELD_whichGeometry	302
#define EXPOSED_FIELD_writeInterval	303


/* Table of built-in fieldIds */
extern const char *FIELD[];
extern const int FIELD_COUNT;
#define FIELD_FreeWRL__protoDef	0
#define FIELD_bboxCenter	1
#define FIELD_bboxSize	2
#define FIELD_beginCap	3
#define FIELD_bottomRadius	4
#define FIELD_category	5
#define FIELD_ccw	6
#define FIELD_child1Url	7
#define FIELD_child2Url	8
#define FIELD_child3Url	9
#define FIELD_child4Url	10
#define FIELD_closureType	11
#define FIELD_colorIndex	12
#define FIELD_colorPerVertex	13
#define FIELD_convex	14
#define FIELD_coordIndex	15
#define FIELD_country	16
#define FIELD_creaseAngle	17
#define FIELD_crossSection	18
#define FIELD_directOutput	19
#define FIELD_domain	20
#define FIELD_endAngle	21
#define FIELD_endCap	22
#define FIELD_extra	23
#define FIELD_family	24
#define FIELD_fanCount	25
#define FIELD_forceTransitions	26
#define FIELD_generateMipMaps	27
#define FIELD_geoGridOrigin	28
#define FIELD_geoOrigin	29
#define FIELD_geoSystem	30
#define FIELD_height	31
#define FIELD_horizontal	32
#define FIELD_index	33
#define FIELD_info	34
#define FIELD_innerRadius	35
#define FIELD_intersectionType	36
#define FIELD_justify	37
#define FIELD_kind	38
#define FIELD_knot	39
#define FIELD_language	40
#define FIELD_leftToRight	41
#define FIELD_lineSegments	42
#define FIELD_mustEvaluate	43
#define FIELD_normalIndex	44
#define FIELD_normalPerVertex	45
#define FIELD_numComponents	46
#define FIELD_outerRadius	47
#define FIELD_proxy	48
#define FIELD_range	49
#define FIELD_reference	50
#define FIELD_repeatS	51
#define FIELD_repeatT	52
#define FIELD_rootNode	53
#define FIELD_rootUrl	54
#define FIELD_rotateYUp	55
#define FIELD_rtpHeaderExpected	56
#define FIELD_side	57
#define FIELD_solid	58
#define FIELD_sortOrder	59
#define FIELD_spacing	60
#define FIELD_spatialize	61
#define FIELD_specific	62
#define FIELD_speedFactor	63
#define FIELD_spine	64
#define FIELD_startAngle	65
#define FIELD_stripCount	66
#define FIELD_style	67
#define FIELD_subcategory	68
#define FIELD_texCoordIndex	69
#define FIELD_textureProperties	70
#define FIELD_title	71
#define FIELD_topToBottom	72
#define FIELD_uClosed	73
#define FIELD_uKnot	74
#define FIELD_vClosed	75
#define FIELD_vKnot	76
#define FIELD_xDimension	77
#define FIELD_xSpacing	78
#define FIELD_yScale	79
#define FIELD_zDimension	80
#define FIELD_zSpacing	81


/* Table of built-in keywords */
extern const char *KEYWORDS[];
extern const int KEYWORDS_COUNT;
#define KW_BROTO	0
#define KW_COMPONENT	1
#define KW_DEF	2
#define KW_EXPORT	3
#define KW_EXTERNBROTO	4
#define KW_EXTERNPROTO	5
#define KW_FALSE	6
#define KW_IMPORT	7
#define KW_IS	8
#define KW_META	9
#define KW_NULL	10
#define KW_PROFILE	11
#define KW_PROTO	12
#define KW_ROUTE	13
#define KW_TO	14
#define KW_TRUE	15
#define KW_USE	16
#define KW_eventIn	17
#define KW_eventOut	18
#define KW_exposedField	19
#define KW_field	20
#define KW_initializeOnly	21
#define KW_inputOnly	22
#define KW_inputOutput	23
#define KW_outputOnly	24

const char *stringKeywordType(int st);

/* Table of built-in profiles */
extern const char *PROFILES[];
extern const int PROFILES_COUNT;
#define PRO_CADInterchange	0
#define PRO_Core	1
#define PRO_Full	2
#define PRO_Immersive	3
#define PRO_Interactive	4
#define PRO_Interchange	5
#define PRO_MPEG4	6

const char *stringProfileType(int st);

/* Table of built-in components */
extern const char *COMPONENTS[];
extern const int COMPONENTS_COUNT;
#define COM_CADGeometry	0
#define COM_Core	1
#define COM_CubeMapTexturing	2
#define COM_DIS	3
#define COM_EnvironmentalEffects	4
#define COM_EnvironmentalSensor	5
#define COM_EventUtilities	6
#define COM_Followers	7
#define COM_Geometry2D	8
#define COM_Geometry3D	9
#define COM_Geospatial	10
#define COM_Grouping	11
#define COM_HAnim	12
#define COM_Interpolation	13
#define COM_KeyDeviceSensor	14
#define COM_Layering	15
#define COM_Layout	16
#define COM_Lighting	17
#define COM_NURBS	18
#define COM_Navigation	19
#define COM_Networking	20
#define COM_ParticleSystems	21
#define COM_PickingSensor	22
#define COM_PointDeviceSensor	23
#define COM_Rendering	24
#define COM_RigidBodyPhysics	25
#define COM_Scripting	26
#define COM_Shaders	27
#define COM_Shape	28
#define COM_Sound	29
#define COM_Text	30
#define COM_Texturing	31
#define COM_Texturing3D	32
#define COM_Time	33

const char *stringComponentType(int st);

/* Table of built-in PROTO keywords */
extern const char *PROTOKEYWORDS[];
extern const int PROTOKEYWORDS_COUNT;
#define PKW_initializeOnly	0
#define PKW_inputOnly	1
#define PKW_outputOnly	2
#define PKW_inputOutput	3
#define PKW_field	4
#define PKW_eventIn	5
#define PKW_eventOut	6
#define PKW_exposedField	7

const char *stringPROTOKeywordType(int st);

/* Table of built-in MULTITEXTUREMODE keywords */
extern const char *MULTITEXTUREMODE[];
extern const int MULTITEXTUREMODE_COUNT;
#define MTMODE_ADD	0
#define MTMODE_ADDSIGNED	1
#define MTMODE_ADDSIGNED2X	2
#define MTMODE_ADDSMOOTH	3
#define MTMODE_BLENDCURRENTALPHA	4
#define MTMODE_BLENDDIFFUSEALPHA	5
#define MTMODE_DOTPRODUCT3	6
#define MTMODE_MODULATE	7
#define MTMODE_MODULATE2X	8
#define MTMODE_MODULATE4X	9
#define MTMODE_MODULATEALPHA_ADDCOLOR	10
#define MTMODE_MODULATEINVALPHA_ADDCOLOR	11
#define MTMODE_MODULATEINVCOLOR_ADDALPHA	12
#define MTMODE_OFF	13
#define MTMODE_REPLACE	14
#define MTMODE_SELECTARG1	15
#define MTMODE_SELECTARG2	16
#define MTMODE_SUBTRACT	17

const char *stringMULTITEXTUREMODEType(int st);
#define MULTITEXTUREDefs " \
#define MTMODE_ADD	0\n \
#define MTMODE_ADDSIGNED	1\n \
#define MTMODE_ADDSIGNED2X	2\n \
#define MTMODE_ADDSMOOTH	3\n \
#define MTMODE_BLENDCURRENTALPHA	4\n \
#define MTMODE_BLENDDIFFUSEALPHA	5\n \
#define MTMODE_DOTPRODUCT3	6\n \
#define MTMODE_MODULATE	7\n \
#define MTMODE_MODULATE2X	8\n \
#define MTMODE_MODULATE4X	9\n \
#define MTMODE_MODULATEALPHA_ADDCOLOR	10\n \
#define MTMODE_MODULATEINVALPHA_ADDCOLOR	11\n \
#define MTMODE_MODULATEINVCOLOR_ADDALPHA	12\n \
#define MTMODE_OFF	13\n \
#define MTMODE_REPLACE	14\n \
#define MTMODE_SELECTARG1	15\n \
#define MTMODE_SELECTARG2	16\n \
#define MTMODE_SUBTRACT	17\n \
";

/* Table of built-in MULTITEXTURESOURCE keywords */
extern const char *MULTITEXTURESOURCE[];
extern const int MULTITEXTURESOURCE_COUNT;
#define MTSRC_DIFFUSE	0
#define MTSRC_FACTOR	1
#define MTSRC_SPECULAR	2


/* Table of built-in TEXTURECOORDINATEGENERATOR keywords */
extern const char *TEXTURECOORDINATEGENERATOR[];
extern const int TEXTURECOORDINATEGENERATOR_COUNT;
#define TCGT_CAMERASPACENORMAL    0
#define TCGT_CAMERASPACEPOSITION    1
#define TCGT_CAMERASPACEREFLECTION    2
#define TCGT_COORD    3
#define TCGT_COORD_EYE    4
#define TCGT_NOISE    5
#define TCGT_NOISE_EYE    6
#define TCGT_SPHERE    7
#define TCGT_SPHERE_LOCAL    8
#define TCGT_SPHERE_REFLECT    9
#define TCGT_SPHERE_REFLECT_LOCAL    10

#define TEXTURECOORDINATEGENERATORDefs " \
#define TCGT_CAMERASPACENORMAL    0\n \
#define TCGT_CAMERASPACEPOSITION    1\n \
#define TCGT_CAMERASPACEREFLECTION    2\n \
#define TCGT_COORD    3\n \
#define TCGT_COORD_EYE    4\n \
#define TCGT_NOISE    5\n \
#define TCGT_NOISE_EYE    6\n \
#define TCGT_SPHERE    7\n \
#define TCGT_SPHERE_LOCAL    8\n \
#define TCGT_SPHERE_REFLECT    9\n \
#define TCGT_SPHERE_REFLECT_LOCAL    10\n \
";
const char *stringMULTITEXTURESOURCEType(int st);

/* Table of built-in MULTITEXTUREFUNCTION keywords */
extern const char *MULTITEXTUREFUNCTION[];
extern const int MULTITEXTUREFUNCTION_COUNT;
#define MTFN_ALPHAREPLICATE	0
#define MTFN_COMPLEMENT	1

const char *stringMULTITEXTUREFUNCTIONType(int st);

/* Table of built-in X3DSPECIAL keywords */
extern const char *X3DSPECIAL[];
extern const int X3DSPECIAL_COUNT;
#define X3DSP_EXPORT	0
#define X3DSP_ExternProtoDeclare	1
#define X3DSP_Header	2
#define X3DSP_IMPORT	3
#define X3DSP_IS	4
#define X3DSP_ProtoBody	5
#define X3DSP_ProtoDeclare	6
#define X3DSP_ProtoInstance	7
#define X3DSP_ProtoInterface	8
#define X3DSP_ROUTE	9
#define X3DSP_Scene	10
#define X3DSP_X3D	11
#define X3DSP_component	12
#define X3DSP_connect	13
#define X3DSP_field	14
#define X3DSP_fieldValue	15
#define X3DSP_head	16
#define X3DSP_meta	17

const char *stringX3DSPECIALType(int st);

/* Table of built-in TEXTUREBOUNDARY keywords */
extern const char *TEXTUREBOUNDARYKEYWORDS[];
extern const int TEXTUREBOUNDARYKEYWORDS_COUNT;
#define TB_CLAMP	0
#define TB_CLAMP_TO_BOUNDARY	1
#define TB_CLAMP_TO_EDGE	2
#define TB_MIRRORED_REPEAT	3
#define TB_REPEAT	4

const char *stringTEXTUREBOUNDARYKeywordType(int st);

/* Table of built-in TEXTUREMAGNIFICATION keywords */
extern const char *TEXTUREMAGNIFICATIONKEYWORDS[];
extern const int TEXTUREMAGNIFICATIONKEYWORDS_COUNT;
#define TMAG_AVG_PIXEL	0
#define TMAG_DEFAULT	1
#define TMAG_FASTEST	2
#define TMAG_NEAREST_PIXEL	3
#define TMAG_NICEST	4

const char *stringTEXTUREMAGNIFICATIONKeywordType(int st);

/* Table of built-in TEXTUREMINIFICATION keywords */
extern const char *TEXTUREMINIFICATIONKEYWORDS[];
extern const int TEXTUREMINIFICATIONKEYWORDS_COUNT;
#define TMIN_AVG_PIXEL	0
#define TMIN_AVG_PIXEL_AVG_MIPMAP	1
#define TMIN_AVG_PIXEL_NEAREST_MIPMAP	2
#define TMIN_DEFAULT	3
#define TMIN_FASTEST	4
#define TMIN_NEAREST_PIXEL	5
#define TMIN_NEAREST_PIXEL_AVG_MIPMAP	6
#define TMIN_NEAREST_PIXEL_NEAREST_MIPMAP	7
#define TMIN_NICEST	8

const char *stringTEXTUREMINIFICATIONKeywordType(int st);

/* Table of built-in TEXTURECOMPRESSION keywords */
extern const char *TEXTURECOMPRESSIONKEYWORDS[];
extern const int TEXTURECOMPRESSIONKEYWORDS_COUNT;
#define TC_DEFAULT	0
#define TC_FASTEST	1
#define TC_HIGH	2
#define TC_LOW	3
#define TC_MEDIUM	4
#define TC_NICEST	5

const char *stringTEXTURECOMPRESSIONKeywordType(int st);

/* Table of built-in GEOSPATIAL keywords */
extern const char *GEOSPATIAL[];
extern const int GEOSPATIAL_COUNT;
#define GEOSP_AA	0
#define GEOSP_AM	1
#define GEOSP_AN	2
#define GEOSP_BN	3
#define GEOSP_BR	4
#define GEOSP_CC	5
#define GEOSP_CD	6
#define GEOSP_EA	7
#define GEOSP_EB	8
#define GEOSP_EC	9
#define GEOSP_ED	10
#define GEOSP_EE	11
#define GEOSP_EF	12
#define GEOSP_FA	13
#define GEOSP_GC	14
#define GEOSP_GCC	15
#define GEOSP_GD	16
#define GEOSP_GDC	17
#define GEOSP_HE	18
#define GEOSP_HO	19
#define GEOSP_ID	20
#define GEOSP_IN	21
#define GEOSP_KA	22
#define GEOSP_RF	23
#define GEOSP_SA	24
#define GEOSP_UTM	25
#define GEOSP_WD	26
#define GEOSP_WE	27
#define GEOSP_WGS84	28
#define GEOSP_coordinateSystem	29
#define GEOSP_copyright	30
#define GEOSP_dataFormat	31
#define GEOSP_dataUrl	32
#define GEOSP_date	33
#define GEOSP_description	34
#define GEOSP_ellipsoid	35
#define GEOSP_extent	36
#define GEOSP_horizontalDatum	37
#define GEOSP_metadataFormat	38
#define GEOSP_originator	39
#define GEOSP_resolution	40
#define GEOSP_title	41
#define GEOSP_verticalDatum	42

const char *stringGEOSPATIALType(int st);
char mapFieldTypeToEAItype (int st);
int mapEAItypeToFieldType (char st);
int convertToSFType (int st);

/* Table of built-in fieldIds */
extern const char *FIELDTYPES[];
extern const int FIELDTYPES_COUNT;
#define FIELDTYPE_SFFloat	0
#define FIELDTYPE_MFFloat	1
#define FIELDTYPE_SFRotation	2
#define FIELDTYPE_MFRotation	3
#define FIELDTYPE_SFVec3f	4
#define FIELDTYPE_MFVec3f	5
#define FIELDTYPE_SFBool	6
#define FIELDTYPE_MFBool	7
#define FIELDTYPE_SFInt32	8
#define FIELDTYPE_MFInt32	9
#define FIELDTYPE_SFNode	10
#define FIELDTYPE_MFNode	11
#define FIELDTYPE_SFColor	12
#define FIELDTYPE_MFColor	13
#define FIELDTYPE_SFColorRGBA	14
#define FIELDTYPE_MFColorRGBA	15
#define FIELDTYPE_SFTime	16
#define FIELDTYPE_MFTime	17
#define FIELDTYPE_SFString	18
#define FIELDTYPE_MFString	19
#define FIELDTYPE_SFVec2f	20
#define FIELDTYPE_MFVec2f	21
#define FIELDTYPE_FreeWRLPTR	22
#define FIELDTYPE_SFImage	23
#define FIELDTYPE_SFVec3d	24
#define FIELDTYPE_MFVec3d	25
#define FIELDTYPE_SFDouble	26
#define FIELDTYPE_MFDouble	27
#define FIELDTYPE_SFMatrix3f	28
#define FIELDTYPE_MFMatrix3f	29
#define FIELDTYPE_SFMatrix3d	30
#define FIELDTYPE_MFMatrix3d	31
#define FIELDTYPE_SFMatrix4f	32
#define FIELDTYPE_MFMatrix4f	33
#define FIELDTYPE_SFMatrix4d	34
#define FIELDTYPE_MFMatrix4d	35
#define FIELDTYPE_SFVec2d	36
#define FIELDTYPE_MFVec2d	37
#define FIELDTYPE_SFVec4f	38
#define FIELDTYPE_MFVec4f	39
#define FIELDTYPE_SFVec4d	40
#define FIELDTYPE_MFVec4d	41
#define FIELDTYPE_FreeWRLThread	42

/*cstruct*/
struct Multi_Float { int n; float  *p; };
struct SFRotation { float c[4]; };
struct Multi_Rotation { int n; struct SFRotation  *p; };
struct SFVec3f { float c[3]; };
struct Multi_Vec3f { int n; struct SFVec3f  *p; };
/*cstruct*/
struct Multi_Bool { int n; int  *p; };
/*cstruct*/
struct Multi_Int32 { int n; int  *p; };

struct Multi_Node { int n; struct X3D_Node * *p; };
struct SFColor { float c[3]; };
struct Multi_Color { int n; struct SFColor  *p; };
struct SFColorRGBA { float c[4]; };
struct Multi_ColorRGBA { int n; struct SFColorRGBA  *p; };
/*cstruct*/
struct Multi_Time { int n; double  *p; };
/*cstruct*/
struct Multi_String { int n; struct Uni_String * *p; };
struct SFVec2f { float c[2]; };
struct Multi_Vec2f { int n; struct SFVec2f  *p; };
/*cstruct*/
/*cstruct*/
struct SFVec3d { double c[3]; };
struct Multi_Vec3d { int n; struct SFVec3d  *p; };
/*cstruct*/
struct Multi_Double { int n; double  *p; };
struct SFMatrix3f { float c[9]; };
struct Multi_Matrix3f { int n; struct SFMatrix3f  *p; };
struct SFMatrix3d { double c[9]; };
struct Multi_Matrix3d { int n; struct SFMatrix3d  *p; };
struct SFMatrix4f { float c[16]; };
struct Multi_Matrix4f { int n; struct SFMatrix4f  *p; };
struct SFMatrix4d { double c[16]; };
struct Multi_Matrix4d { int n; struct SFMatrix4d  *p; };
struct SFVec2d { double c[2]; };
struct Multi_Vec2d { int n; struct SFVec2d  *p; };
struct SFVec4f { float c[4]; };
struct Multi_Vec4f { int n; struct SFVec4f  *p; };
struct SFVec4d { double c[4]; };
struct Multi_Vec4d { int n; struct SFVec4d  *p; };
/*cstruct*/
const char *stringFieldtypeType(int st);

/* Table of built-in nodeIds */
extern const char *NODES[];
extern const int NODES_COUNT;

/* and now the structs for the nodetypes */ 
const char *stringNodeType(int st);

/* First, a generic struct, contains only the common elements */
struct X3D_Node {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
};
#define X3D_LINEPROPERTIES(node) ((struct X3D_LineProperties*)node)
#define X3D_FILLPROPERTIES(node) ((struct X3D_FillProperties*)node)
#define X3D_TEXTURE_TRANSFORM(node) ((struct X3D_TextureTransform*)node)
#define X3D_NODE(node) ((struct X3D_Node*)node)
#define X3D_APPEARANCE(node) ((struct X3D_Appearance*)node)
#define X3D_MATERIAL(node) ((struct X3D_Material*)node)
#define X3D_TWOSIDEDMATERIAL(node) ((struct X3D_TwoSidedMaterial*)node)
#define X3D_GROUP(node) ((struct X3D_Group*)node)
#define X3D_PROTO(node) ((struct X3D_Proto*)node)
#define X3D_PICKABLEGROUP(node) ((struct X3D_PickableGroup*)node)
#define X3D_POINTPICKSENSOR(node) ((struct X3D_PointPickSensor*)node)
#define X3D_STATICGROUP(node) ((struct X3D_StaticGroup*)node)
#define X3D_ANCHOR(node) ((struct X3D_Anchor*)node)
#define X3D_COLLISION(node) ((struct X3D_Collision*)node)
#define X3D_COMPOSEDSHADER(node) ((struct X3D_ComposedShader*)node)
#define X3D_PACKAGEDSHADER(node) ((struct X3D_PackagedShader*)node)
#define X3D_PROGRAMSHADER(node) ((struct X3D_ProgramShader*)node)
#define X3D_SHADERPROGRAM(node) ((struct X3D_ShaderProgram*)node)
#define X3D_SHAPE(node) ((struct X3D_Shape*)node)
#define X3D_VISIBILITYSENSOR(node) ((struct X3D_VisibilitySensor*)node)
#define X3D_BILLBOARD(node) ((struct X3D_Billboard*)node)
#define X3D_NAVIGATIONINFO(node) ((struct X3D_NavigationInfo*)node)
#define X3D_BACKGROUND(node) ((struct X3D_Background*)node)
#define X3D_TEXTUREBACKGROUND(node) ((struct X3D_TextureBackground*)node)
#define X3D_FOG(node) ((struct X3D_Fog*)node)
#define X3D_INLINE(node) ((struct X3D_Inline*)node)
#define X3D_SWITCH(node) ((struct X3D_Switch*)node)
#define X3D_CADASSEMBLY(node) ((struct X3D_CADAssembly*)node)
#define X3D_CADFACE(node) ((struct X3D_CADFace*)node)
#define X3D_CADLAYER(node) ((struct X3D_CADLayer*)node)
#define X3D_CADPART(node) ((struct X3D_CADPart*)node)
#define X3D_SCRIPT(node) ((struct X3D_Script*)node)
#define X3D_VIEWPOINT(node) ((struct X3D_Viewpoint*)node)
#define X3D_ORTHOVIEWPOINT(node) ((struct X3D_OrthoViewpoint*)node)
#define X3D_LODNODE(node) ((struct X3D_LOD*)node)
#define X3D_TRANSFORM(node) ((struct X3D_Transform*)node)
#define X3D_PROXIMITYSENSOR(node) ((struct X3D_ProximitySensor*)node)
#define X3D_POINTLIGHT(node) ((struct X3D_PointLight*)node)
#define X3D_SPOTLIGHT(node) ((struct X3D_SpotLight*)node)
#define X3D_DIRECTIONALLIGHT(node) ((struct X3D_DirectionalLight*)node)
#define X3D_INDEXEDFACESET(node) ((struct X3D_IndexedFaceSet*)node)
#define X3D_INDEXEDLINESET(node) ((struct X3D_IndexedLineSet*)node)
#define X3D_ELEVATIONGRID(node) ((struct X3D_ElevationGrid*)node)
#define X3D_INDEXEDTRIANGLEFANSET(node) ((struct X3D_IndexedTriangleFanSet*)node)
#define X3D_INDEXEDTRIANGLESET(node) ((struct X3D_IndexedTriangleSet*)node)
#define X3D_INDEXEDTRIANGLESTRIPSET(node) ((struct X3D_IndexedTriangleStripSet*)node)
#define X3D_TRIANGLEFANSET(node) ((struct X3D_TriangleFanSet*)node)
#define X3D_TRIANGLESET(node) ((struct X3D_TriangleSet*)node)
#define X3D_TRIANGLESTRIPSET(node) ((struct X3D_TriangleStripSet*)node)
#define X3D_QUADSET(node) ((struct X3D_QuadSet*)node)
#define X3D_INDEXEDQUADSET(node) ((struct X3D_IndexedQuadSet*)node)
#define X3D_GEOORIGIN(node) ((struct X3D_GeoOrigin*)node)
#define X3D_GEOLOD(node) ((struct X3D_GeoLOD*)node)
#define X3D_GEOCOORD(node) ((struct X3D_GeoCoordinate*)node)
#define X3D_GEOVIEWPOINT(node) ((struct X3D_GeoViewpoint*)node)
#define X3D_GEOELEVATIONGRID(node) ((struct X3D_GeoElevationGrid*)node)
#define X3D_GEOLOCATION(node) ((struct X3D_GeoLocation*)node)
#define X3D_GEOTRANSFORM(node) ((struct X3D_GeoTransform*)node)
#define X3D_GEOPROXIMITYSENSOR(node) ((struct X3D_GeoProximitySensor*)node)
#define X3D_COLOR(node) ((struct X3D_Color*)node)
#define X3D_COORDINATE(node) ((struct X3D_Coordinate*)node)
#define X3D_COORDINATEINTERPOLATOR(node) ((struct X3D_CoordinateInterpolator*)node)
#define X3D_NORMAL(node) ((struct X3D_Normal*)node)
#define X3D_TEXTURECOORDINATE(node) ((struct X3D_TextureCoordinate*)node)
#define X3D_IMAGETEXTURE(node) ((struct X3D_ImageTexture*)node)
#define X3D_TEXTUREPROPERTIES(node) ((struct X3D_TextureProperties*)node)
#define X3D_PIXELTEXTURE(node) ((struct X3D_PixelTexture*)node)
#undef DEBUG_VALIDNODE
#ifdef DEBUG_VALIDNODE	
#define X3D_NODE_CHECK(node) checkNode(node,__FILE__,__LINE__)
#define MARK_EVENT(node,offset) mark_event_check(node,(int) offset,__FILE__,__LINE__)
#else
#define X3D_NODE_CHECK(node)
#define MARK_EVENT(node,offset)	mark_event(node,(int) offset)
#endif
#define COPY_SFVEC3F_TO_POINT_XYZ(too,from) { too.x = from[0]; too.y = from[1]; too.z = from[2];}
#define COPY_POINT_XYZ_TO_SFVEC3F(too,from) { too[0] = (float) from.x; too[1] = (float) from.y; too[2] = (float) from.z;}
#define offsetPointer_deref(t, me, offs) ((t)(((char*)(me))+offs))

/* now, generated structures for each VRML/X3D Node*/
/***********************/
struct X3D_Anchor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct Uni_String *description;
	struct X3D_Node *metadata;
	struct Multi_String parameter;
	struct Multi_String url;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	void * _parentResource;
};
extern struct X3D_Virt virt_Anchor;
/***********************/
struct X3D_Appearance {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *fillProperties;
	struct X3D_Node *lineProperties;
	struct X3D_Node *material;
	struct X3D_Node *metadata;
	struct Multi_Node shaders;
	struct X3D_Node *texture;
	struct X3D_Node *textureTransform;
};
extern struct X3D_Virt virt_Appearance;
/***********************/
struct X3D_Arc2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	float endAngle;
	float radius;
	float startAngle;
	struct Multi_Vec2f __points;
	int __numPoints;
};
extern struct X3D_Virt virt_Arc2D;
/***********************/
struct X3D_ArcClose2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *closureType;
	float endAngle;
	float radius;
	int solid;
	float startAngle;
	struct Multi_Vec2f __points;
	int __numPoints;
};
extern struct X3D_Virt virt_ArcClose2D;
/***********************/
struct X3D_AudioClip {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *description;
	int loop;
	struct X3D_Node *metadata;
	double pauseTime;
	float pitch;
	double resumeTime;
	double startTime;
	double stopTime;
	struct Multi_String url;
	double duration_changed;
	double elapsedTime;
	int isActive;
	int isPaused;
	void * _parentResource;
	int __loadstatus;
	void * __loadResource;
	int __sourceNumber;
	void * __localFileName;
	double __inittime;
};
extern struct X3D_Virt virt_AudioClip;
/***********************/
struct X3D_Background {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct Multi_Float groundAngle;
	struct Multi_Color groundColor;
	struct Multi_Float skyAngle;
	struct Multi_Color skyColor;
	double bindTime;
	int isBound;
	void * _parentResource;
	struct Multi_Vec3f __points;
	struct Multi_Color __colours;
	int __quadcount;
	float transparency;
	struct Multi_String frontUrl;
	struct Multi_String backUrl;
	struct Multi_String topUrl;
	struct Multi_String bottomUrl;
	struct Multi_String leftUrl;
	struct Multi_String rightUrl;
	struct X3D_Node *metadata;
	int __textureright;
	struct X3D_Node *__frontTexture;
	struct X3D_Node *__backTexture;
	struct X3D_Node *__topTexture;
	struct X3D_Node *__bottomTexture;
	struct X3D_Node *__leftTexture;
	struct X3D_Node *__rightTexture;
	int __VBO;
};
extern struct X3D_Virt virt_Background;
/***********************/
struct X3D_Billboard {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct SFVec3f axisOfRotation;
	struct Multi_Node children;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
	double _rotationAngle;
};
extern struct X3D_Virt virt_Billboard;
/***********************/
struct X3D_BooleanFilter {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_boolean;
	int inputFalse;
	int inputNegate;
	int inputTrue;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_BooleanFilter;
/***********************/
struct X3D_BooleanSequencer {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int next;
	int previous;
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Bool keyValue;
	int value_changed;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_BooleanSequencer;
/***********************/
struct X3D_BooleanToggle {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_boolean;
	int toggle;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_BooleanToggle;
/***********************/
struct X3D_BooleanTrigger {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double set_triggerTime;
	int triggerTrue;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_BooleanTrigger;
/***********************/
struct X3D_Box {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct SFVec3f size;
	int solid;
	struct Multi_Vec3f __points;
};
extern struct X3D_Virt virt_Box;
/***********************/
struct X3D_CADAssembly {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_CADAssembly;
/***********************/
struct X3D_CADFace {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct X3D_Node *shape;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_CADFace;
/***********************/
struct X3D_CADLayer {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Multi_Bool visible;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_CADLayer;
/***********************/
struct X3D_CADPart {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct SFVec3f center;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int __do_center;
	int __do_trans;
	int __do_rotation;
	int __do_scaleO;
	int __do_scale;
	int __do_anything;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_CADPart;
/***********************/
struct X3D_Circle2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	float radius;
	struct Multi_Vec2f __points;
	int __numPoints;
};
extern struct X3D_Virt virt_Circle2D;
/***********************/
struct X3D_ClipPlane {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct X3D_Node *metadata;
	struct SFVec4f plane;
};
extern struct X3D_Virt virt_ClipPlane;
/***********************/
struct X3D_Collision {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	int enabled;
	int collide;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *proxy;
	double collideTime;
	struct X3D_Node *metadata;
	int __hit;
};
extern struct X3D_Virt virt_Collision;
/***********************/
struct X3D_Color {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Color color;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Color;
/***********************/
struct X3D_ColorInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Color keyValue;
	struct X3D_Node *metadata;
	struct SFColor value_changed;
};
extern struct X3D_Virt virt_ColorInterpolator;
/***********************/
struct X3D_ColorRGBA {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_ColorRGBA color;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_ColorRGBA;
/***********************/
struct X3D_ComposedCubeMapTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *back;
	struct X3D_Node *bottom;
	struct X3D_Node *front;
	struct X3D_Node *left;
	struct X3D_Node *top;
	struct X3D_Node *right;
	void * _parentResource;
};
extern struct X3D_Virt virt_ComposedCubeMapTexture;
/***********************/
struct X3D_ComposedShader {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int activate;
	struct Multi_Node parts;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	struct X3D_Node *metadata;
	int _initialized;
	struct X3D_Node *_shaderUserDefinedFields;
	int _shaderUserNumber;
	pthread_t _shaderLoadThread;
	int _retrievedURLData;
};
extern struct X3D_Virt virt_ComposedShader;
/***********************/
struct X3D_Cone {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	int bottom;
	float bottomRadius;
	float height;
	int side;
	int solid;
	struct Multi_Vec3f __sidepoints;
	struct Multi_Vec3f __botpoints;
	struct Multi_Vec3f __normals;
	int __coneVBO;
	int __coneTriangles;
};
extern struct X3D_Virt virt_Cone;
/***********************/
struct X3D_Contour2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Contour2D;
/***********************/
struct X3D_ContourPolyLine2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2d controlPoint;
};
extern struct X3D_Virt virt_ContourPolyLine2D;
/***********************/
struct X3D_Coordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3f point;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Coordinate;
/***********************/
struct X3D_CoordinateDouble {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec3d point;
};
extern struct X3D_Virt virt_CoordinateDouble;
/***********************/
struct X3D_CoordinateInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	struct Multi_Vec3f value_changed;
	int _GPU_Routes_out;
	int _CPU_Routes_out;
	int _keyVBO;
	int _keyValueVBO;
};
extern struct X3D_Virt virt_CoordinateInterpolator;
/***********************/
struct X3D_CoordinateInterpolator2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct X3D_Node *metadata;
	struct Multi_Vec2f value_changed;
};
extern struct X3D_Virt virt_CoordinateInterpolator2D;
/***********************/
struct X3D_Cylinder {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	int bottom;
	float height;
	float radius;
	int side;
	int solid;
	int top;
	struct Multi_Vec3f __points;
	struct Multi_Vec3f __normals;
	int __cylinderVBO;
	int __cylinderTriangles;
};
extern struct X3D_Virt virt_Cylinder;
/***********************/
struct X3D_CylinderSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int autoOffset;
	struct SFRotation axisRotation;
	float diskAngle;
	int enabled;
	float maxAngle;
	float minAngle;
	float offset;
	int isActive;
	int isOver;
	struct Uni_String *description;
	struct SFRotation rotation_changed;
	struct SFVec3f trackPoint_changed;
	struct X3D_Node *metadata;
	struct SFVec3f _oldtrackPoint;
	struct SFRotation _oldrotation;
	struct SFVec3f _origPoint;
	float _radius;
	int _dlchange;
	int __oldEnabled;
};
extern struct X3D_Virt virt_CylinderSensor;
/***********************/
struct X3D_DISEntityManager {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	int applicationID;
	struct Multi_Node mapping;
	struct X3D_Node *metadata;
	int port;
	int siteID;
	struct Multi_Node addedEntities;
	struct Multi_Node removedEntities;
};
extern struct X3D_Virt virt_DISEntityManager;
/***********************/
struct X3D_DISEntityTypeMapping {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String url;
	int category;
	int country;
	int domain;
	int extra;
	int kind;
	int specific;
	int subcategory;
};
extern struct X3D_Virt virt_DISEntityTypeMapping;
/***********************/
struct X3D_DirectionalLight {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float ambientIntensity;
	struct SFColor color;
	struct SFVec3f direction;
	int global;
	float intensity;
	struct X3D_Node *metadata;
	int on;
	struct SFVec4f _dir;
	struct SFVec4f _col;
	struct SFVec4f _amb;
};
extern struct X3D_Virt virt_DirectionalLight;
/***********************/
struct X3D_Disk2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	float innerRadius;
	float outerRadius;
	int solid;
	struct Multi_Vec2f __points;
	struct Multi_Vec2f __texCoords;
	int __numPoints;
	int __simpleDisk;
};
extern struct X3D_Virt virt_Disk2D;
/***********************/
struct X3D_EaseInEaseOut {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Vec2f easeInEaseOut;
	struct Multi_Float key;
	struct X3D_Node *metadata;
	float modifiedFraction_changed;
};
extern struct X3D_Virt virt_EaseInEaseOut;
/***********************/
struct X3D_ElevationGrid {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float set_height;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	float creaseAngle;
	struct Multi_Float height;
	int normalPerVertex;
	int solid;
	int xDimension;
	float xSpacing;
	int zDimension;
	float zSpacing;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_ElevationGrid;
/***********************/
struct X3D_EspduTransform {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	float set_articulationParameterValue0;
	float set_articulationParameterValue1;
	float set_articulationParameterValue2;
	float set_articulationParameterValue3;
	float set_articulationParameterValue4;
	float set_articulationParameterValue5;
	float set_articulationParameterValue6;
	float set_articulationParameterValue7;
	struct Uni_String *address;
	int applicationID;
	int articulationParameterCount;
	struct Multi_Int32 articulationParameterDesignatorArray;
	struct Multi_Int32 articulationParameterChangeIndicatorArr;
	struct Multi_Int32 articulationParameterIdPartAttachedToAr;
	struct Multi_Int32 articulationParameterTypeArray;
	struct Multi_Float articulationParameterArray;
	struct SFVec3f center;
	struct Multi_Node children;
	int collisionType;
	int deadReckoning;
	struct SFVec3f detonationLocation;
	struct SFVec3f detonationRelativeLocation;
	int detonationResult;
	int enabled;
	int entityCategory;
	int entityCountry;
	int entityDomain;
	int entityExtra;
	int entityID;
	int entityKind;
	int entitySpecific;
	int entitySubCategory;
	int eventApplicationID;
	int eventEntityID;
	int eventNumber;
	int eventSiteID;
	int fired1;
	int fired2;
	int fireMissionIndex;
	float firingRange;
	int firingRate;
	int forceID;
	int fuse;
	struct SFVec3f linearVelocity;
	struct SFVec3f linearAcceleration;
	struct Uni_String *marking;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	int munitionApplicationID;
	struct SFVec3f munitionEndPoint;
	int munitionEntityID;
	int munitionQuantity;
	int munitionSiteID;
	struct SFVec3f munitionStartPoint;
	struct Uni_String *networkMode;
	int port;
	double readInterval;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	int siteID;
	struct SFVec3f translation;
	int warhead;
	double writeInterval;
	float articulationParameterValue0_changed;
	float articulationParameterValue1_changed;
	float articulationParameterValue2_changed;
	float articulationParameterValue3_changed;
	float articulationParameterValue4_changed;
	float articulationParameterValue5_changed;
	float articulationParameterValue6_changed;
	float articulationParameterValue7_changed;
	double collideTime;
	double detonateTime;
	double firedTime;
	int isActive;
	int isCollided;
	int isDetonated;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	double timestamp;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int rtpHeaderExpected;
};
extern struct X3D_Virt virt_EspduTransform;
/***********************/
struct X3D_Extrusion {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f set_crossSection;
	struct Multi_Rotation set_orientation;
	struct Multi_Vec2f set_scale;
	struct Multi_Vec3f set_spine;
	struct X3D_Node *metadata;
	int beginCap;
	int ccw;
	int convex;
	float creaseAngle;
	struct Multi_Vec2f crossSection;
	int endCap;
	struct Multi_Rotation orientation;
	struct Multi_Vec2f scale;
	int solid;
	struct Multi_Vec3f spine;
};
extern struct X3D_Virt virt_Extrusion;
/***********************/
struct X3D_FillProperties {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int filled;
	struct SFColor hatchColor;
	int hatched;
	int hatchStyle;
	struct X3D_Node *metadata;
	int _enabled;
	struct SFVec2f _hatchScale;
};
extern struct X3D_Virt virt_FillProperties;
/***********************/
struct X3D_FloatVertexAttribute {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float value;
	struct Uni_String *name;
	int numComponents;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_FloatVertexAttribute;
/***********************/
struct X3D_Fog {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct SFColor color;
	struct Uni_String *fogType;
	float visibilityRange;
	double bindTime;
	int isBound;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Fog;
/***********************/
struct X3D_FogCoordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float depth;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_FogCoordinate;
/***********************/
struct X3D_FontStyle {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String family;
	int horizontal;
	struct Multi_String justify;
	struct Uni_String *language;
	int leftToRight;
	float size;
	float spacing;
	struct Uni_String *style;
	int topToBottom;
};
extern struct X3D_Virt virt_FontStyle;
/***********************/
struct X3D_GeneratedCubeMapTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *update;
	int size;
	struct X3D_Node *textureProperties;
	int __textureTableIndex;
};
extern struct X3D_Virt virt_GeneratedCubeMapTexture;
/***********************/
struct X3D_GeoCoordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec3d point;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct Multi_Int32 __geoSystem;
	struct Multi_Vec3f __movedCoords;
};
extern struct X3D_Virt virt_GeoCoordinate;
/***********************/
struct X3D_GeoElevationGrid {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Double set_height;
	struct X3D_Node *color;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	float yScale;
	int ccw;
	int colorPerVertex;
	double creaseAngle;
	struct SFVec3d geoGridOrigin;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct Multi_Double height;
	int normalPerVertex;
	int solid;
	int xDimension;
	double xSpacing;
	int zDimension;
	double zSpacing;
	struct Multi_Int32 _coordIndex;
	struct Multi_Int32 __geoSystem;
};
extern struct X3D_Virt virt_GeoElevationGrid;
/***********************/
struct X3D_GeoLOD {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node children;
	int level_changed;
	struct SFVec3d center;
	struct Multi_String child1Url;
	struct Multi_String child2Url;
	struct Multi_String child3Url;
	struct Multi_String child4Url;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	float range;
	struct Multi_String rootUrl;
	struct Multi_Node rootNode;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	int __inRange;
	struct X3D_Node *__child1Node;
	struct X3D_Node *__child2Node;
	struct X3D_Node *__child3Node;
	struct X3D_Node *__child4Node;
	struct X3D_Node *__rootUrl;
	int __childloadstatus;
	int __rooturlloadstatus;
	int __level;
};
extern struct X3D_Virt virt_GeoLOD;
/***********************/
struct X3D_GeoLocation {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct SFVec3d geoCoords;
	struct X3D_Node *metadata;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	struct SFVec4d __localOrient;
	struct SFVec3d __oldgeoCoords;
	struct Multi_Node __oldChildren;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_GeoLocation;
/***********************/
struct X3D_GeoMetadata {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node data;
	struct Multi_String summary;
	struct Multi_String url;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_GeoMetadata;
/***********************/
struct X3D_GeoOrigin {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3d geoCoords;
	struct Multi_String geoSystem;
	struct X3D_Node *metadata;
	int rotateYUp;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	struct SFVec3d __oldgeoCoords;
	struct Multi_String __oldMFString;
	struct SFVec4d __rotyup;
};
extern struct X3D_Virt virt_GeoOrigin;
/***********************/
struct X3D_GeoPositionInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec3d keyValue;
	struct X3D_Node *metadata;
	struct SFVec3d geovalue_changed;
	struct SFVec3f value_changed;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct Multi_Int32 __geoSystem;
	struct Multi_Vec3d __movedValue;
	struct Multi_Float __oldKeyPtr;
	struct Multi_Vec3d __oldKeyValuePtr;
};
extern struct X3D_Virt virt_GeoPositionInterpolator;
/***********************/
struct X3D_GeoProximitySensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct SFVec3d geoCenter;
	struct X3D_Node *metadata;
	struct SFVec3f size;
	struct SFVec3f centerOfRotation_changed;
	double enterTime;
	double exitTime;
	struct SFVec3d geoCoord_changed;
	int isActive;
	struct SFRotation orientation_changed;
	struct SFVec3f position_changed;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	int __hit;
	struct SFVec3f __t1;
	struct SFRotation __t2;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	struct SFVec4d __localOrient;
	int __oldEnabled;
	struct SFVec3d __oldGeoCenter;
	struct SFVec3f __oldSize;
};
extern struct X3D_Virt virt_GeoProximitySensor;
/***********************/
struct X3D_GeoTouchSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *description;
	int enabled;
	struct X3D_Node *metadata;
	struct SFVec3f hitNormal_changed;
	struct SFVec3f hitPoint_changed;
	struct SFVec2f hitTexCoord_changed;
	struct SFVec3d hitGeoCoord_changed;
	int isActive;
	int isOver;
	double touchTime;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct Multi_Int32 __geoSystem;
	struct SFVec3f _oldhitNormal;
	struct SFVec3f _oldhitPoint;
	struct SFVec2f _oldhitTexCoord;
	int __oldEnabled;
};
extern struct X3D_Virt virt_GeoTouchSensor;
/***********************/
struct X3D_GeoTransform {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct SFVec3d geoCenter;
	struct X3D_Node *metadata;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	int __do_center;
	int __do_trans;
	int __do_rotation;
	int __do_scaleO;
	int __do_scale;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedCoords;
	struct SFVec4d __localOrient;
	struct SFVec3d __oldGeoCenter;
	struct Multi_Node __oldChildren;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_GeoTransform;
/***********************/
struct X3D_GeoViewpoint {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct SFRotation set_orientation;
	struct SFVec3d set_position;
	struct Uni_String *description;
	float fieldOfView;
	int headlight;
	int jump;
	struct X3D_Node *metadata;
	struct Multi_String navType;
	double bindTime;
	int isBound;
	struct X3D_Node *geoOrigin;
	struct Multi_String geoSystem;
	struct SFRotation orientation;
	struct SFVec3d position;
	float speedFactor;
	struct Multi_Int32 __geoSystem;
	struct SFVec3d __movedPosition;
	struct SFRotation __movedOrientation;
	struct Uni_String *__oldSFString;
	float __oldFieldOfView;
	int __oldHeadlight;
	int __oldJump;
	struct Multi_String __oldMFString;
};
extern struct X3D_Virt virt_GeoViewpoint;
/***********************/
struct X3D_Group {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int FreeWRL__protoDef;
	struct Multi_Node FreeWRL_PROTOInterfaceNodes;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_Group;
/***********************/
struct X3D_HAnimDisplacer {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 coordIndex;
	struct Multi_Vec3f displacements;
	struct Uni_String *name;
	float weight;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_HAnimDisplacer;
/***********************/
struct X3D_HAnimHumanoid {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f center;
	struct Multi_String info;
	struct Multi_Node joints;
	struct Uni_String *name;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct Multi_Node segments;
	struct Multi_Node sites;
	struct Multi_Node skeleton;
	struct Multi_Node skin;
	struct X3D_Node *skinCoord;
	struct X3D_Node *skinNormal;
	struct SFVec3f translation;
	struct Uni_String *version;
	struct Multi_Node viewpoints;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_HAnimHumanoid;
/***********************/
struct X3D_HAnimJoint {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct SFVec3f center;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
	struct Multi_Node displacers;
	struct SFRotation limitOrientation;
	struct Multi_Float llimit;
	struct Uni_String *name;
	struct Multi_Int32 skinCoordIndex;
	struct Multi_Float skinCoordWeight;
	struct Multi_Float stiffness;
	struct Multi_Float ulimit;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
	int __do_center;
	int __do_trans;
	int __do_rotation;
	int __do_scaleO;
	int __do_scale;
};
extern struct X3D_Virt virt_HAnimJoint;
/***********************/
struct X3D_HAnimSegment {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct Uni_String *name;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f centerOfMass;
	struct X3D_Node *coord;
	struct Multi_Node displacers;
	float mass;
	struct Multi_Float momentsOfInertia;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_HAnimSegment;
/***********************/
struct X3D_HAnimSite {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct Uni_String *name;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct SFVec3f center;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
	struct X3D_Node *metadata;
	int __do_center;
	int __do_trans;
	int __do_rotation;
	int __do_scaleO;
	int __do_scale;
};
extern struct X3D_Virt virt_HAnimSite;
/***********************/
struct X3D_ImageCubeMapTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String url;
	struct X3D_Node *textureProperties;
	int __textureTableIndex;
	void * _parentResource;
	struct Multi_Node __subTextures;
	int __regenSubTextures;
};
extern struct X3D_Virt virt_ImageCubeMapTexture;
/***********************/
struct X3D_ImageTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String url;
	int repeatS;
	int repeatT;
	struct X3D_Node *textureProperties;
	int __textureTableIndex;
	void * _parentResource;
};
extern struct X3D_Virt virt_ImageTexture;
/***********************/
struct X3D_IndexedFaceSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_colorIndex;
	struct Multi_Int32 set_coordIndex;
	struct Multi_Int32 set_normalIndex;
	struct Multi_Int32 set_texCoordIndex;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	struct Multi_Int32 colorIndex;
	int colorPerVertex;
	int convex;
	struct Multi_Int32 coordIndex;
	float creaseAngle;
	struct Multi_Int32 normalIndex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 texCoordIndex;
};
extern struct X3D_Virt virt_IndexedFaceSet;
/***********************/
struct X3D_IndexedLineSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_colorIndex;
	struct Multi_Int32 set_coordIndex;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct Multi_Int32 colorIndex;
	int colorPerVertex;
	struct Multi_Int32 coordIndex;
	void * __vertArr;
	void * __vertIndx;
	void * __xcolours;
	void * __vertices;
	void * __vertexCount;
	int __segCount;
};
extern struct X3D_Virt virt_IndexedLineSet;
/***********************/
struct X3D_IndexedQuadSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_index;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	struct Multi_Int32 index;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_IndexedQuadSet;
/***********************/
struct X3D_IndexedTriangleFanSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_index;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 index;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_IndexedTriangleFanSet;
/***********************/
struct X3D_IndexedTriangleSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_index;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 index;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_IndexedTriangleSet;
/***********************/
struct X3D_IndexedTriangleStripSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 set_index;
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 index;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_IndexedTriangleStripSet;
/***********************/
struct X3D_Inline {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node __children;
	struct X3D_Node *metadata;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	void * __protoDeclares;
	void * __externProtoDeclares;
	void * __nodes;
	void * __subcontexts;
	void * __GC;
	void * __protoDef;
	int __protoFlags;
	struct X3D_Node *__prototype;
	struct X3D_Node *__parentProto;
	void * __ROUTES;
	void * __EXPORTS;
	void * __IMPORTS;
	void * __DEFnames;
	void * __IS;
	void * __scripts;
	struct Multi_String url;
	struct Multi_String __oldurl;
	void * __afterPound;
	int __loadstatus;
	void * _parentResource;
	void * __loadResource;
	void * __typename;
	int load;
	int __oldload;
};
extern struct X3D_Virt virt_Inline;
/***********************/
struct X3D_IntegerSequencer {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int next;
	int previous;
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Int32 keyValue;
	int value_changed;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_IntegerSequencer;
/***********************/
struct X3D_IntegerTrigger {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_boolean;
	int integerKey;
	int triggerValue;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_IntegerTrigger;
/***********************/
struct X3D_KeySensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	int actionKeyPress;
	int actionKeyRelease;
	int altKey;
	int controlKey;
	int isActive;
	struct Uni_String *keyPress;
	struct Uni_String *keyRelease;
	int shiftKey;
	struct X3D_Node *metadata;
	int __oldEnabled;
};
extern struct X3D_Virt virt_KeySensor;
/***********************/
struct X3D_LOD {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node level;
	struct Multi_Node children;
	struct SFVec3f center;
	struct Multi_Float range;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct X3D_Node *metadata;
	int levelChanged;
	int forceTransitions;
	int __isX3D;
	void * _selected;
};
extern struct X3D_Virt virt_LOD;
/***********************/
struct X3D_LineProperties {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int applied;
	int linetype;
	float linewidthScaleFactor;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_LineProperties;
/***********************/
struct X3D_LineSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int autoOffset;
	struct SFVec3f direction;
	int enabled;
	float maxPosition;
	float minPosition;
	float offset;
	int isActive;
	int isOver;
	struct Uni_String *description;
	struct SFVec3f trackPoint_changed;
	struct SFVec3f translation_changed;
	struct X3D_Node *metadata;
	struct SFVec3f _oldtrackPoint;
	struct SFVec3f _oldtranslation;
	struct SFVec3f _origPoint;
	int __oldEnabled;
};
extern struct X3D_Virt virt_LineSensor;
/***********************/
struct X3D_LineSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *metadata;
	struct X3D_Node *fogCoord;
	struct Multi_Int32 vertexCount;
	void * __vertArr;
	void * __vertIndx;
	int __segCount;
};
extern struct X3D_Virt virt_LineSet;
/***********************/
struct X3D_LoadSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct X3D_Node *metadata;
	double timeOut;
	struct Multi_Node watchList;
	int isActive;
	int isLoaded;
	double loadTime;
	float progress;
	int __loading;
	int __finishedloading;
	double __StartLoadTime;
	int __oldEnabled;
};
extern struct X3D_Virt virt_LoadSensor;
/***********************/
struct X3D_LocalFog {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColor color;
	int enabled;
	struct Uni_String *fogType;
	float visibilityRange;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_LocalFog;
/***********************/
struct X3D_Material {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float ambientIntensity;
	struct SFColor diffuseColor;
	struct SFColor emissiveColor;
	struct X3D_Node *metadata;
	float shininess;
	struct SFColor specularColor;
	float transparency;
	struct Multi_Float _verifiedColor;
};
extern struct X3D_Virt virt_Material;
/***********************/
struct X3D_Matrix3VertexAttribute {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix3f value;
	struct Uni_String *name;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_Matrix3VertexAttribute;
/***********************/
struct X3D_Matrix4VertexAttribute {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Matrix4f value;
	struct Uni_String *name;
};
extern struct X3D_Virt virt_Matrix4VertexAttribute;
/***********************/
struct X3D_MetadataDouble {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Double value;
};
extern struct X3D_Virt virt_MetadataDouble;
/***********************/
struct X3D_MetadataFloat {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Float value;
};
extern struct X3D_Virt virt_MetadataFloat;
/***********************/
struct X3D_MetadataInteger {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Int32 value;
};
extern struct X3D_Virt virt_MetadataInteger;
/***********************/
struct X3D_MetadataMFBool {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Bool value;
	struct Multi_Bool valueChanged;
	struct Multi_Bool setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFBool;
/***********************/
struct X3D_MetadataMFColor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Color value;
	struct Multi_Color valueChanged;
	struct Multi_Color setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFColor;
/***********************/
struct X3D_MetadataMFColorRGBA {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_ColorRGBA value;
	struct Multi_ColorRGBA valueChanged;
	struct Multi_ColorRGBA setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFColorRGBA;
/***********************/
struct X3D_MetadataMFDouble {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Double value;
	struct Multi_Double valueChanged;
	struct Multi_Double setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFDouble;
/***********************/
struct X3D_MetadataMFFloat {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Float value;
	struct Multi_Float valueChanged;
	struct Multi_Float setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFFloat;
/***********************/
struct X3D_MetadataMFInt32 {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 value;
	struct Multi_Int32 valueChanged;
	struct Multi_Int32 setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFInt32;
/***********************/
struct X3D_MetadataMFMatrix3d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix3d value;
	struct Multi_Matrix3d valueChanged;
	struct Multi_Matrix3d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFMatrix3d;
/***********************/
struct X3D_MetadataMFMatrix3f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix3f value;
	struct Multi_Matrix3f valueChanged;
	struct Multi_Matrix3f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFMatrix3f;
/***********************/
struct X3D_MetadataMFMatrix4d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix4d value;
	struct Multi_Matrix4d valueChanged;
	struct Multi_Matrix4d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFMatrix4d;
/***********************/
struct X3D_MetadataMFMatrix4f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Matrix4f value;
	struct Multi_Matrix4f valueChanged;
	struct Multi_Matrix4f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFMatrix4f;
/***********************/
struct X3D_MetadataMFNode {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node value;
	struct Multi_Node valueChanged;
	struct Multi_Node setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFNode;
/***********************/
struct X3D_MetadataMFRotation {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Rotation value;
	struct Multi_Rotation valueChanged;
	struct Multi_Rotation setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFRotation;
/***********************/
struct X3D_MetadataMFString {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String value;
	struct Multi_String valueChanged;
	struct Multi_String setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFString;
/***********************/
struct X3D_MetadataMFTime {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Time value;
	struct Multi_Time valueChanged;
	struct Multi_Time setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFTime;
/***********************/
struct X3D_MetadataMFVec2d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2d value;
	struct Multi_Vec2d valueChanged;
	struct Multi_Vec2d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec2d;
/***********************/
struct X3D_MetadataMFVec2f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec2f value;
	struct Multi_Vec2f valueChanged;
	struct Multi_Vec2f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec2f;
/***********************/
struct X3D_MetadataMFVec3d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3d value;
	struct Multi_Vec3d valueChanged;
	struct Multi_Vec3d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec3d;
/***********************/
struct X3D_MetadataMFVec3f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec3f value;
	struct Multi_Vec3f valueChanged;
	struct Multi_Vec3f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec3f;
/***********************/
struct X3D_MetadataMFVec4d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec4d value;
	struct Multi_Vec4d valueChanged;
	struct Multi_Vec4d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec4d;
/***********************/
struct X3D_MetadataMFVec4f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Vec4f value;
	struct Multi_Vec4f valueChanged;
	struct Multi_Vec4f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataMFVec4f;
/***********************/
struct X3D_MetadataSFBool {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int value;
	int valueChanged;
	int setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFBool;
/***********************/
struct X3D_MetadataSFColor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColor value;
	struct SFColor valueChanged;
	struct SFColor setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFColor;
/***********************/
struct X3D_MetadataSFColorRGBA {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFColorRGBA value;
	struct SFColorRGBA valueChanged;
	struct SFColorRGBA setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFColorRGBA;
/***********************/
struct X3D_MetadataSFDouble {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double value;
	double valueChanged;
	double setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFDouble;
/***********************/
struct X3D_MetadataSFFloat {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float value;
	float valueChanged;
	float setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFFloat;
/***********************/
struct X3D_MetadataSFImage {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 value;
	struct Multi_Int32 valueChanged;
	struct Multi_Int32 setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFImage;
/***********************/
struct X3D_MetadataSFInt32 {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int value;
	int valueChanged;
	int setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFInt32;
/***********************/
struct X3D_MetadataSFMatrix3d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix3d value;
	struct SFMatrix3d valueChanged;
	struct SFMatrix3d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFMatrix3d;
/***********************/
struct X3D_MetadataSFMatrix3f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix3f value;
	struct SFMatrix3f valueChanged;
	struct SFMatrix3f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFMatrix3f;
/***********************/
struct X3D_MetadataSFMatrix4d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix4d value;
	struct SFMatrix4d valueChanged;
	struct SFMatrix4d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFMatrix4d;
/***********************/
struct X3D_MetadataSFMatrix4f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFMatrix4f value;
	struct SFMatrix4f valueChanged;
	struct SFMatrix4f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFMatrix4f;
/***********************/
struct X3D_MetadataSFNode {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *value;
	struct X3D_Node *valueChanged;
	struct X3D_Node *setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFNode;
/***********************/
struct X3D_MetadataSFRotation {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFRotation value;
	struct SFRotation valueChanged;
	struct SFRotation setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFRotation;
/***********************/
struct X3D_MetadataSFString {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *value;
	struct Uni_String *valueChanged;
	struct Uni_String *setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFString;
/***********************/
struct X3D_MetadataSFTime {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double value;
	double valueChanged;
	double setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFTime;
/***********************/
struct X3D_MetadataSFVec2d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2d value;
	struct SFVec2d valueChanged;
	struct SFVec2d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec2d;
/***********************/
struct X3D_MetadataSFVec2f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2f value;
	struct SFVec2f valueChanged;
	struct SFVec2f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec2f;
/***********************/
struct X3D_MetadataSFVec3d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3d value;
	struct SFVec3d valueChanged;
	struct SFVec3d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec3d;
/***********************/
struct X3D_MetadataSFVec3f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f value;
	struct SFVec3f valueChanged;
	struct SFVec3f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec3f;
/***********************/
struct X3D_MetadataSFVec4d {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4d value;
	struct SFVec4d valueChanged;
	struct SFVec4d setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec4d;
/***********************/
struct X3D_MetadataSFVec4f {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec4f value;
	struct SFVec4f valueChanged;
	struct SFVec4f setValue;
	double tickTime;
};
extern struct X3D_Virt virt_MetadataSFVec4f;
/***********************/
struct X3D_MetadataSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_Node value;
};
extern struct X3D_Virt virt_MetadataSet;
/***********************/
struct X3D_MetadataString {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *name;
	struct Uni_String *reference;
	struct Multi_String value;
};
extern struct X3D_Virt virt_MetadataString;
/***********************/
struct X3D_MovieTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *description;
	int loop;
	struct X3D_Node *metadata;
	double resumeTime;
	double pauseTime;
	float speed;
	double startTime;
	double stopTime;
	struct Multi_String url;
	double duration_changed;
	double elapsedTime;
	int isActive;
	double isPaused;
	int repeatS;
	int repeatT;
	struct X3D_Node *textureProperties;
	int __textureTableIndex;
	void * _parentResource;
};
extern struct X3D_Virt virt_MovieTexture;
/***********************/
struct X3D_MultiTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float alpha;
	struct SFColor color;
	struct Multi_String function;
	struct X3D_Node *metadata;
	struct Multi_String mode;
	struct Multi_String source;
	struct Multi_Node texture;
	void * __xparams;
};
extern struct X3D_Virt virt_MultiTexture;
/***********************/
struct X3D_MultiTextureCoordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node texCoord;
};
extern struct X3D_Virt virt_MultiTextureCoordinate;
/***********************/
struct X3D_MultiTextureTransform {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node textureTransform;
};
extern struct X3D_Virt virt_MultiTextureTransform;
/***********************/
struct X3D_NavigationInfo {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct Multi_Float avatarSize;
	int headlight;
	float speed;
	struct Multi_String type;
	float visibilityLimit;
	int isBound;
	struct Multi_String transitionType;
	double bindTime;
	struct X3D_Node *metadata;
	double transitionTime;
	int transitionComplete;
};
extern struct X3D_Virt virt_NavigationInfo;
/***********************/
struct X3D_Normal {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec3f vector;
};
extern struct X3D_Virt virt_Normal;
/***********************/
struct X3D_NormalInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	struct Multi_Vec3f value_changed;
};
extern struct X3D_Virt virt_NormalInterpolator;
/***********************/
struct X3D_NurbsCurve {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double knot;
	int order;
	int tessellation;
	struct Multi_Vec3f __points;
	int __numPoints;
};
extern struct X3D_Virt virt_NurbsCurve;
/***********************/
struct X3D_NurbsCurve2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2d controlPoint;
	struct Multi_Double weight;
	struct Multi_Double knot;
	int order;
	int tessellation;
};
extern struct X3D_Virt virt_NurbsCurve2D;
/***********************/
struct X3D_NurbsOrientationInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double knot;
	int order;
	float set_fraction;
	struct SFRotation value_changed;
};
extern struct X3D_Virt virt_NurbsOrientationInterpolator;
/***********************/
struct X3D_NurbsPatchSurface {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double uKnot;
	int uOrder;
	int uDimension;
	int uTessellation;
	int uClosed;
	struct Multi_Double vKnot;
	int vOrder;
	int vDimension;
	int vTessellation;
	int vClosed;
	struct X3D_Node *texCoord;
	int solid;
};
extern struct X3D_Virt virt_NurbsPatchSurface;
/***********************/
struct X3D_NurbsPositionInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double knot;
	int order;
	float set_fraction;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_NurbsPositionInterpolator;
/***********************/
struct X3D_NurbsSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addGeometry;
	struct Multi_Node removeGeometry;
	struct Multi_Node geometry;
	struct X3D_Node *metadata;
	float tessellationScale;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_NurbsSet;
/***********************/
struct X3D_NurbsSurfaceInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double uKnot;
	int uOrder;
	int uDimension;
	struct Multi_Double vKnot;
	int vOrder;
	int vDimension;
	struct SFVec2f set_fraction;
	struct SFVec3f position_changed;
	struct SFVec3f normal_changed;
};
extern struct X3D_Virt virt_NurbsSurfaceInterpolator;
/***********************/
struct X3D_NurbsSweptSurface {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *crossSectionCurve;
	struct X3D_Node *metadata;
	struct X3D_Node *trajectoryCurve;
	int ccw;
	int solid;
};
extern struct X3D_Virt virt_NurbsSweptSurface;
/***********************/
struct X3D_NurbsSwungSurface {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *profileCurve;
	struct X3D_Node *trajectoryCurve;
	int ccw;
	int solid;
};
extern struct X3D_Virt virt_NurbsSwungSurface;
/***********************/
struct X3D_NurbsTextureCoordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f controlPoint;
	struct Multi_Float weight;
	struct Multi_Double uKnot;
	int uOrder;
	int uDimension;
	struct Multi_Double vKnot;
	int vOrder;
	int vDimension;
};
extern struct X3D_Virt virt_NurbsTextureCoordinate;
/***********************/
struct X3D_NurbsTrimmedSurface {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct X3D_Node *controlPoint;
	struct Multi_Double weight;
	struct Multi_Double uKnot;
	int uOrder;
	int uDimension;
	int uTessellation;
	int uClosed;
	struct Multi_Double vKnot;
	int vOrder;
	int vDimension;
	int vTessellation;
	int vClosed;
	struct X3D_Node *texCoord;
	int solid;
	struct Multi_Node addTrimmingContour;
	struct Multi_Node removeTrimmingContour;
	struct Multi_Node trimmingContour;
};
extern struct X3D_Virt virt_NurbsTrimmedSurface;
/***********************/
struct X3D_OSC_Sensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct Uni_String *description;
	struct Uni_String *protocol;
	struct Uni_String *listenfor;
	int port;
	struct Uni_String *filter;
	struct Uni_String *handler;
	struct Multi_String talksTo;
	int FIFOsize;
	int int32Inp;
	float floatInp;
	struct Uni_String *stringInp;
	int gotEvents;
	struct X3D_Node *metadata;
	struct Multi_Node _talkToNodes;
	int _status;
	void * _int32InpFIFO;
	void * _floatInpFIFO;
	void * _stringInpFIFO;
	void * _int32OutFIFO;
	void * _floatOutFIFO;
	void * _stringOutFIFO;
	struct X3D_Node *__oldmetadata;
};
extern struct X3D_Virt virt_OSC_Sensor;
/***********************/
struct X3D_OrientationInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Rotation keyValue;
	struct X3D_Node *metadata;
	struct SFRotation value_changed;
};
extern struct X3D_Virt virt_OrientationInterpolator;
/***********************/
struct X3D_OrthoViewpoint {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct SFVec3f centerOfRotation;
	struct Uni_String *description;
	struct Multi_Float fieldOfView;
	int jump;
	struct X3D_Node *metadata;
	struct SFRotation orientation;
	struct SFVec3f position;
	int retainUserOffsets;
	double bindTime;
	int isBound;
};
extern struct X3D_Virt virt_OrthoViewpoint;
/***********************/
struct X3D_PackagedShader {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int activate;
	struct X3D_Node *metadata;
	struct Multi_String url;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	int _initialized;
	int _shaderUserNumber;
	struct X3D_Node *_shaderUserDefinedFields;
	pthread_t _shaderLoadThread;
	int _retrievedURLData;
};
extern struct X3D_Virt virt_PackagedShader;
/***********************/
struct X3D_PickableGroup {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct Multi_String objectType;
	int pickable;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int FreeWRL__protoDef;
	struct Multi_Node FreeWRL_PROTOInterfaceNodes;
};
extern struct X3D_Virt virt_PickableGroup;
/***********************/
struct X3D_PixelTexture {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Int32 image;
	struct X3D_Node *metadata;
	int repeatS;
	int repeatT;
	struct X3D_Node *textureProperties;
	void * _parentResource;
	int __textureTableIndex;
};
extern struct X3D_Virt virt_PixelTexture;
/***********************/
struct X3D_PlaneSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int autoOffset;
	struct SFRotation axisRotation;
	int enabled;
	struct SFVec2f maxPosition;
	struct SFVec2f minPosition;
	struct SFVec3f offset;
	int isActive;
	int isOver;
	struct Uni_String *description;
	struct SFVec3f trackPoint_changed;
	struct SFVec3f translation_changed;
	struct X3D_Node *metadata;
	struct SFVec3f _oldtrackPoint;
	struct SFVec3f _oldtranslation;
	struct SFVec3f _origPoint;
	int __oldEnabled;
};
extern struct X3D_Virt virt_PlaneSensor;
/***********************/
struct X3D_PointLight {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float ambientIntensity;
	struct SFVec3f attenuation;
	struct SFColor color;
	int global;
	float intensity;
	struct SFVec3f location;
	struct X3D_Node *metadata;
	int on;
	float radius;
	struct SFVec4f _loc;
	struct SFVec4f _col;
	struct SFVec4f _amb;
};
extern struct X3D_Virt virt_PointLight;
/***********************/
struct X3D_PointPickSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct X3D_Node *metadata;
	struct Multi_String objectType;
	struct X3D_Node *pickingGeometry;
	struct Multi_Node pickTarget;
	int isActive;
	struct Multi_Node pickedGeometry;
	struct Multi_Vec3f pickedPoint;
	struct Uni_String *set_intersectionType;
	struct Uni_String *intersectionType;
	struct Uni_String *set_sortOrder;
	struct Uni_String *sortOrder;
	int _oldisActive;
	struct Multi_Node _oldpickTarget;
	struct Multi_Node _oldpickedGeometry;
	struct Multi_Vec3f _oldpickedPoint;
	struct SFVec3f _bboxCenter;
	struct SFVec3f _bboxSize;
};
extern struct X3D_Virt virt_PointPickSensor;
/***********************/
struct X3D_PointSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	int _pointsVBO;
	int _coloursVBO;
	int _npoints;
	int _colourSize;
};
extern struct X3D_Virt virt_PointSet;
/***********************/
struct X3D_Polyline2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f lineSegments;
};
extern struct X3D_Virt virt_Polyline2D;
/***********************/
struct X3D_Polypoint2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f point;
};
extern struct X3D_Virt virt_Polypoint2D;
/***********************/
struct X3D_PositionInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct X3D_Node *metadata;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_PositionInterpolator;
/***********************/
struct X3D_PositionInterpolator2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct X3D_Node *metadata;
	struct SFVec2f value_changed;
};
extern struct X3D_Virt virt_PositionInterpolator2D;
/***********************/
struct X3D_ProgramShader {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int activate;
	struct X3D_Node *metadata;
	struct Multi_Node programs;
	int isSelected;
	int isValid;
	struct Uni_String *language;
	int _initialized;
	int _shaderUserNumber;
	pthread_t _shaderLoadThread;
	int _retrievedURLData;
};
extern struct X3D_Virt virt_ProgramShader;
/***********************/
struct X3D_Proto {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node __children;
	struct X3D_Node *metadata;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	struct Multi_Node _sortedChildren;
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	void * __protoDeclares;
	void * __externProtoDeclares;
	void * __nodes;
	void * __subcontexts;
	void * __GC;
	void * __protoDef;
	int __protoFlags;
	struct X3D_Node *__prototype;
	struct X3D_Node *__parentProto;
	void * __ROUTES;
	void * __EXPORTS;
	void * __IMPORTS;
	void * __DEFnames;
	void * __IS;
	void * __scripts;
	struct Multi_String url;
	struct Multi_String __oldurl;
	void * __afterPound;
	int __loadstatus;
	void * _parentResource;
	void * __loadResource;
	void * __typename;
	int load;
	int __oldload;
};
extern struct X3D_Virt virt_Proto;
/***********************/
struct X3D_ProximitySensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f center;
	struct SFVec3f size;
	int enabled;
	int isActive;
	struct SFVec3f position_changed;
	struct SFRotation orientation_changed;
	double enterTime;
	double exitTime;
	struct SFVec3f centerOfRotation_changed;
	struct X3D_Node *metadata;
	int __hit;
	struct SFVec3f __t1;
	struct SFRotation __t2;
	int __oldEnabled;
};
extern struct X3D_Virt virt_ProximitySensor;
/***********************/
struct X3D_QuadSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_QuadSet;
/***********************/
struct X3D_ReceiverPdu {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	int applicationID;
	int enabled;
	int entityID;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	int radioID;
	float readInterval;
	float receivedPower;
	int receiverState;
	int rtpHeaderExpected;
	int siteID;
	int transmitterApplicationID;
	int transmitterEntityID;
	int transmitterRadioID;
	int transmitterSiteID;
	int whichGeometry;
	float writeInterval;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	double timestamp;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_ReceiverPdu;
/***********************/
struct X3D_Rectangle2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct SFVec2f size;
	int solid;
	struct Multi_Vec3f __points;
	int __numPoints;
};
extern struct X3D_Virt virt_Rectangle2D;
/***********************/
struct X3D_ScalarInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Float keyValue;
	struct X3D_Node *metadata;
	float value_changed;
};
extern struct X3D_Virt virt_ScalarInterpolator;
/***********************/
struct X3D_Script {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String url;
	int directOutput;
	int mustEvaluate;
	struct X3D_Node *metadata;
	void * __scriptObj;
	void * _parentResource;
};
extern struct X3D_Virt virt_Script;
/***********************/
struct X3D_ShaderPart {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String url;
	struct Uni_String *type;
	int __loadstatus;
	void * _parentResource;
	void * __loadResource;
	struct X3D_Node *_shaderUserDefinedFields;
};
extern struct X3D_Virt virt_ShaderPart;
/***********************/
struct X3D_ShaderProgram {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_String url;
	struct Uni_String *type;
	int __loadstatus;
	void * _parentResource;
	void * __loadResource;
	struct X3D_Node *_shaderUserDefinedFields;
};
extern struct X3D_Virt virt_ShaderProgram;
/***********************/
struct X3D_Shape {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *appearance;
	struct X3D_Node *geometry;
	struct X3D_Node *metadata;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int __visible;
	int __occludeCheckCount;
	int __Samples;
	int _shaderTableEntry;
};
extern struct X3D_Virt virt_Shape;
/***********************/
struct X3D_SignalPdu {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	int applicationID;
	struct Multi_Int32 data;
	int dataLength;
	int enabled;
	int encodingScheme;
	int entityID;
	struct X3D_Node *metadata;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	int radioID;
	float readInterval;
	int rtpHeaderExpected;
	int sampleRate;
	int samples;
	int siteID;
	int tdlType;
	int whichGeometry;
	float writeInterval;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	double timestamp;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_SignalPdu;
/***********************/
struct X3D_Sound {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f direction;
	float intensity;
	struct SFVec3f location;
	float maxBack;
	float maxFront;
	struct X3D_Node *metadata;
	float minBack;
	float minFront;
	float priority;
	struct X3D_Node *source;
	int spatialize;
	int __sourceNumber;
	struct SFVec3f __lastlocation;
	double __lasttime;
};
extern struct X3D_Virt virt_Sound;
/***********************/
struct X3D_Sphere {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	float radius;
	int solid;
	struct Multi_Vec3f __points;
	int _sideVBO;
	int __SphereIndxVBO;
};
extern struct X3D_Virt virt_Sphere;
/***********************/
struct X3D_SphereSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int autoOffset;
	int enabled;
	struct SFRotation offset;
	int isActive;
	struct SFRotation rotation_changed;
	struct SFVec3f trackPoint_changed;
	struct SFVec3f _oldtrackPoint;
	struct SFRotation _oldrotation;
	int isOver;
	struct Uni_String *description;
	struct X3D_Node *metadata;
	struct SFVec3f _origPoint;
	struct SFVec3f _origNormalizedPoint;
	float _radius;
	int __oldEnabled;
};
extern struct X3D_Virt virt_SphereSensor;
/***********************/
struct X3D_SplinePositionInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	int closed;
	struct Multi_Float key;
	struct Multi_Vec3f keyValue;
	struct Multi_Vec3f keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	struct SFVec3f value_changed;
};
extern struct X3D_Virt virt_SplinePositionInterpolator;
/***********************/
struct X3D_SplinePositionInterpolator2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	int closed;
	struct Multi_Float key;
	struct Multi_Vec2f keyValue;
	struct Multi_Vec2f keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	struct SFVec2f value_changed;
};
extern struct X3D_Virt virt_SplinePositionInterpolator2D;
/***********************/
struct X3D_SplineScalarInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	int closed;
	struct Multi_Float key;
	struct Multi_Float keyValue;
	struct Multi_Float keyVelocity;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	float value_changed;
};
extern struct X3D_Virt virt_SplineScalarInterpolator;
/***********************/
struct X3D_SpotLight {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float ambientIntensity;
	struct SFVec3f attenuation;
	float beamWidth;
	struct SFColor color;
	float cutOffAngle;
	struct SFVec3f direction;
	int global;
	float intensity;
	struct SFVec3f location;
	struct X3D_Node *metadata;
	int on;
	float radius;
	struct SFVec4f _dir;
	struct SFVec4f _loc;
	struct SFVec4f _col;
	struct SFVec4f _amb;
};
extern struct X3D_Virt virt_SpotLight;
/***********************/
struct X3D_SquadOrientationInterpolator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float set_fraction;
	struct Multi_Float key;
	struct Multi_Rotation keyValue;
	struct X3D_Node *metadata;
	int normalizeVelocity;
	struct SFRotation value_changed;
};
extern struct X3D_Virt virt_SquadOrientationInterpolator;
/***********************/
struct X3D_StaticGroup {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Node children;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int __transparency;
	int __solid;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_StaticGroup;
/***********************/
struct X3D_StringSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int deletionAllowed;
	int enabled;
	struct Uni_String *enteredText;
	struct Uni_String *finalText;
	int isActive;
	struct X3D_Node *metadata;
	int _initialized;
	int __oldEnabled;
};
extern struct X3D_Virt virt_StringSensor;
/***********************/
struct X3D_Switch {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct Multi_Node choice;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	int whichChoice;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int __isX3D;
};
extern struct X3D_Virt virt_Switch;
/***********************/
struct X3D_Text {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *fontStyle;
	struct Multi_Float length;
	float maxExtent;
	struct X3D_Node *metadata;
	struct Multi_String string;
	struct Multi_Vec2f lineBounds;
	struct SFVec3f origin;
	int solid;
	struct SFVec2f textBounds;
	int __rendersub;
};
extern struct X3D_Virt virt_Text;
/***********************/
struct X3D_TextureBackground {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct Multi_Float groundAngle;
	struct Multi_Color groundColor;
	struct Multi_Float skyAngle;
	struct Multi_Color skyColor;
	double bindTime;
	int isBound;
	struct X3D_Node *metadata;
	void * _parentResource;
	struct Multi_Vec3f __points;
	struct Multi_Vec3f __colours;
	int __quadcount;
	int __VBO;
	struct X3D_Node *frontTexture;
	struct X3D_Node *backTexture;
	struct X3D_Node *topTexture;
	struct X3D_Node *bottomTexture;
	struct X3D_Node *leftTexture;
	struct X3D_Node *rightTexture;
	struct Multi_Float transparency;
};
extern struct X3D_Virt virt_TextureBackground;
/***********************/
struct X3D_TextureCoordinate {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f point;
};
extern struct X3D_Virt virt_TextureCoordinate;
/***********************/
struct X3D_TextureCoordinateGenerator {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Uni_String *mode;
	struct Multi_Float parameter;
};
extern struct X3D_Virt virt_TextureCoordinateGenerator;
/***********************/
struct X3D_TextureProperties {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float anisotropicDegree;
	struct SFColorRGBA borderColor;
	int borderWidth;
	struct Uni_String *boundaryModeS;
	struct Uni_String *boundaryModeT;
	struct Uni_String *boundaryModeR;
	struct Uni_String *magnificationFilter;
	struct X3D_Node *metadata;
	struct Uni_String *minificationFilter;
	struct Uni_String *textureCompression;
	float texturePriority;
	int generateMipMaps;
};
extern struct X3D_Virt virt_TextureProperties;
/***********************/
struct X3D_TextureTransform {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec2f center;
	struct X3D_Node *metadata;
	float rotation;
	struct SFVec2f scale;
	struct SFVec2f translation;
};
extern struct X3D_Virt virt_TextureTransform;
/***********************/
struct X3D_TimeSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	double cycleInterval;
	int enabled;
	int loop;
	struct X3D_Node *metadata;
	double pauseTime;
	double resumeTime;
	double startTime;
	double stopTime;
	double cycleTime;
	double elapsedTime;
	float fraction_changed;
	int isActive;
	double isPaused;
	double time;
	double __inittime;
	double __ctflag;
	int __oldEnabled;
};
extern struct X3D_Virt virt_TimeSensor;
/***********************/
struct X3D_TimeTrigger {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_boolean;
	double triggerTime;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_TimeTrigger;
/***********************/
struct X3D_TouchSensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int enabled;
	struct SFVec3f hitNormal_changed;
	struct SFVec3f hitPoint_changed;
	struct SFVec2f hitTexCoord_changed;
	struct SFVec3f _oldhitNormal;
	struct SFVec3f _oldhitPoint;
	struct SFVec2f _oldhitTexCoord;
	int isActive;
	int isOver;
	struct Uni_String *description;
	double touchTime;
	struct X3D_Node *metadata;
	int __oldEnabled;
};
extern struct X3D_Virt virt_TouchSensor;
/***********************/
struct X3D_Transform {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node addChildren;
	struct Multi_Node removeChildren;
	struct SFVec3f center;
	struct Multi_Node children;
	struct X3D_Node *metadata;
	struct SFRotation rotation;
	struct SFVec3f scale;
	struct SFRotation scaleOrientation;
	struct SFVec3f translation;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
	int __do_center;
	int __do_trans;
	int __do_rotation;
	int __do_scaleO;
	int __do_scale;
	int __do_anything;
	struct Multi_Node _sortedChildren;
};
extern struct X3D_Virt virt_Transform;
/***********************/
struct X3D_TransmitterPdu {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Uni_String *address;
	struct SFVec3f antennaLocation;
	int antennaPatternLength;
	int antennaPatternType;
	int applicationID;
	int cryptoKeyID;
	int cryptoSystem;
	int enabled;
	int entityID;
	int frequency;
	int inputSource;
	int lengthOfModulationParameters;
	struct X3D_Node *metadata;
	int modulationTypeDetail;
	int modulationTypeMajor;
	int modulationTypeSpreadSpectrum;
	int modulationTypeSystem;
	struct Uni_String *multicastRelayHost;
	int multicastRelayPort;
	struct Uni_String *networkMode;
	int port;
	float power;
	int radioEntityTypeCategory;
	int radioEntityTypeCountry;
	int radioEntityTypeDomain;
	int radioEntityTypeKind;
	int radioEntityTypeNomenclature;
	int radioEntityTypeNomenclatureVersion;
	int radioID;
	float readInterval;
	struct SFVec3f relativeAntennaLocation;
	int rtpHeaderExpected;
	int siteID;
	float transmitFrequencyBandwidth;
	int transmitState;
	int whichGeometry;
	float writeInterval;
	int isActive;
	int isNetworkReader;
	int isNetworkWriter;
	int isRtpHeaderHeard;
	int isStandAlone;
	double timestamp;
	struct SFVec3f bboxCenter;
	struct SFVec3f bboxSize;
};
extern struct X3D_Virt virt_TransmitterPdu;
/***********************/
struct X3D_TriangleFanSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct Multi_Int32 fanCount;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_TriangleFanSet;
/***********************/
struct X3D_TriangleSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_TriangleSet;
/***********************/
struct X3D_TriangleSet2D {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct X3D_Node *metadata;
	struct Multi_Vec2f vertices;
	int solid;
	struct Multi_Vec2f __texCoords;
};
extern struct X3D_Virt virt_TriangleSet2D;
/***********************/
struct X3D_TriangleStripSet {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_Node attrib;
	struct X3D_Node *color;
	struct X3D_Node *coord;
	struct X3D_Node *fogCoord;
	struct X3D_Node *metadata;
	struct X3D_Node *normal;
	struct Multi_Int32 stripCount;
	struct X3D_Node *texCoord;
	int ccw;
	int colorPerVertex;
	int normalPerVertex;
	int solid;
	struct Multi_Int32 _coordIndex;
};
extern struct X3D_Virt virt_TriangleStripSet;
/***********************/
struct X3D_TwoSidedMaterial {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	float ambientIntensity;
	float backAmbientIntensity;
	struct SFColor backDiffuseColor;
	struct SFColor backEmissiveColor;
	float backShininess;
	struct SFColor backSpecularColor;
	float backTransparency;
	struct SFColor diffuseColor;
	struct SFColor emissiveColor;
	struct X3D_Node *metadata;
	float shininess;
	int separateBackColor;
	struct SFColor specularColor;
	float transparency;
	struct Multi_Float _verifiedFrontColor;
	struct Multi_Float _verifiedBackColor;
};
extern struct X3D_Virt virt_TwoSidedMaterial;
/***********************/
struct X3D_Viewpoint {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	int set_bind;
	struct SFVec3f centerOfRotation;
	struct Uni_String *description;
	float fieldOfView;
	int jump;
	struct X3D_Node *metadata;
	struct SFRotation orientation;
	struct SFVec3f position;
	int retainUserOffsets;
	double bindTime;
	int isBound;
};
extern struct X3D_Virt virt_Viewpoint;
/***********************/
struct X3D_ViewpointGroup {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f center;
	struct Multi_Node children;
	struct Uni_String *description;
	int displayed;
	struct X3D_Node *metadata;
	int retainUserOffsets;
	struct SFVec3f size;
	struct X3D_Node *__proxNode;
};
extern struct X3D_Virt virt_ViewpointGroup;
/***********************/
struct X3D_VisibilitySensor {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct SFVec3f center;
	int enabled;
	struct SFVec3f size;
	double enterTime;
	double exitTime;
	int isActive;
	struct X3D_Node *metadata;
	int __visible;
	int __occludeCheckCount;
	struct Multi_Vec3f __points;
	int __Samples;
	int __oldEnabled;
};
extern struct X3D_Virt virt_VisibilitySensor;
/***********************/
struct X3D_WorldInfo {
       int _nodeType; /* unique integer for each type */ 
       int _renderFlags; /*sensitive, etc */ 
       int _hit; 
       int _change; 
       int _ichange; 
       struct Vector* _parentVector; 
       double _dist; /*sorting for blending */ 
       float _extent[6]; /* used for boundingboxes - +-x, +-y, +-z */ 
       struct X3D_PolyRep *_intern; 
       int referenceCount; /* if this reaches zero, nobody wants it anymore */ 
       int _defaultContainer; /* holds the container */
       struct X3D_Node* _executionContext; /* scene or protoInstance */
 	/*** node specific data: *****/
	struct Multi_String info;
	struct Uni_String *title;
	struct X3D_Node *metadata;
};
extern struct X3D_Virt virt_WorldInfo;
extern struct X3D_Virt* virtTable[];

extern const int *NODE_OFFSETS[];

int getSAI_X3DNodeType (int FreeWRLNodeType);

#endif /* __FREEWRL_STRUCTS_H__ */
