/*

  NodeFields.h: generated by VRMLC.pm. DO NOT MODIFY, MODIFY VRMLC.pm INSTEAD.

*/

/****************************************************************************
    This file is part of the FreeWRL/FreeX3D Distribution.

    Copyright 2009 CRC Canada. (http://www.crc.gc.ca)

    FreeWRL/FreeX3D is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FreeWRL/FreeX3D is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FreeWRL/FreeX3D.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************************/



/*
Information for all the fields of all the nodes.

Format is as follows:
BEGIN_NODE(NodeName)
 FIELD(Node, field, type, varToAssignInStruct)
 EXPOSED_FIELD(Node, field, type, varToAssignInStruct)
 EVENT_IN(Node, event, type, varToAssignInStruct)
 EVENT_OUT(Node, event, type, varToAssignInStruct)
END_NODE(NodeName)

*/


/* Anchor node */
BEGIN_NODE(Anchor)
EVENT_IN(Anchor,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Anchor,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Anchor,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Anchor,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Anchor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(Anchor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Anchor,parameter,mfstring,parameter,FIELDTYPE_MFString)
EVENT_IN(Anchor,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Anchor,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(Anchor)

/* Appearance node */
BEGIN_NODE(Appearance)
EXPOSED_FIELD(Appearance,fillProperties,sfnode,fillProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(Appearance,lineProperties,sfnode,lineProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(Appearance,material,sfnode,material,FIELDTYPE_SFNode)
EXPOSED_FIELD(Appearance,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Appearance,shaders,mfnode,shaders,FIELDTYPE_MFNode)
EXPOSED_FIELD(Appearance,texture,sfnode,texture,FIELDTYPE_SFNode)
EXPOSED_FIELD(Appearance,textureTransform,sfnode,textureTransform,FIELDTYPE_SFNode)
END_NODE(Appearance)

/* Arc2D node */
BEGIN_NODE(Arc2D)
FIELD(Arc2D,endAngle,sffloat,endAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Arc2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Arc2D,radius,sffloat,radius,FIELDTYPE_SFFloat)
FIELD(Arc2D,startAngle,sffloat,startAngle,FIELDTYPE_SFFloat)
END_NODE(Arc2D)

/* ArcClose2D node */
BEGIN_NODE(ArcClose2D)
FIELD(ArcClose2D,closureType,sfstring,closureType,FIELDTYPE_SFString)
FIELD(ArcClose2D,endAngle,sffloat,endAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(ArcClose2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ArcClose2D,radius,sffloat,radius,FIELDTYPE_SFFloat)
FIELD(ArcClose2D,solid,sfbool,solid,FIELDTYPE_SFBool)
FIELD(ArcClose2D,startAngle,sffloat,startAngle,FIELDTYPE_SFFloat)
END_NODE(ArcClose2D)

/* AudioClip node */
BEGIN_NODE(AudioClip)
EXPOSED_FIELD(AudioClip,description,sfstring,description,FIELDTYPE_SFString)
EVENT_OUT(AudioClip,duration_changed,sftime,duration_changed,FIELDTYPE_SFTime)
EVENT_OUT(AudioClip,elapsedTime,sftime,elapsedTime,FIELDTYPE_SFTime)
EVENT_OUT(AudioClip,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(AudioClip,isPaused,sfbool,isPaused,FIELDTYPE_SFBool)
EXPOSED_FIELD(AudioClip,loop,sfbool,loop,FIELDTYPE_SFBool)
EXPOSED_FIELD(AudioClip,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(AudioClip,pauseTime,sftime,pauseTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(AudioClip,pitch,sffloat,pitch,FIELDTYPE_SFFloat)
EXPOSED_FIELD(AudioClip,resumeTime,sftime,resumeTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(AudioClip,startTime,sftime,startTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(AudioClip,stopTime,sftime,stopTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(AudioClip,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(AudioClip)

/* Background node */
BEGIN_NODE(Background)
EXPOSED_FIELD(Background,backUrl,mfstring,backUrl,FIELDTYPE_MFString)
EVENT_OUT(Background,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(Background,bottomUrl,mfstring,bottomUrl,FIELDTYPE_MFString)
EXPOSED_FIELD(Background,frontUrl,mfstring,frontUrl,FIELDTYPE_MFString)
EXPOSED_FIELD(Background,groundAngle,mffloat,groundAngle,FIELDTYPE_MFFloat)
EXPOSED_FIELD(Background,groundColor,mfcolor,groundColor,FIELDTYPE_MFColor)
EVENT_OUT(Background,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(Background,leftUrl,mfstring,leftUrl,FIELDTYPE_MFString)
EXPOSED_FIELD(Background,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Background,rightUrl,mfstring,rightUrl,FIELDTYPE_MFString)
EVENT_IN(Background,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
EXPOSED_FIELD(Background,skyAngle,mffloat,skyAngle,FIELDTYPE_MFFloat)
EXPOSED_FIELD(Background,skyColor,mfcolor,skyColor,FIELDTYPE_MFColor)
EXPOSED_FIELD(Background,topUrl,mfstring,topUrl,FIELDTYPE_MFString)
EXPOSED_FIELD(Background,transparency,sffloat,transparency,FIELDTYPE_SFFloat)
END_NODE(Background)

/* Billboard node */
BEGIN_NODE(Billboard)
EVENT_IN(Billboard,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Billboard,axisOfRotation,sfvec3f,axisOfRotation,FIELDTYPE_SFVec3f)
FIELD(Billboard,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Billboard,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Billboard,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Billboard,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Billboard,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(Billboard)

/* BooleanFilter node */
BEGIN_NODE(BooleanFilter)
EVENT_OUT(BooleanFilter,inputFalse,sfbool,inputFalse,FIELDTYPE_SFBool)
EVENT_OUT(BooleanFilter,inputNegate,sfbool,inputNegate,FIELDTYPE_SFBool)
EVENT_OUT(BooleanFilter,inputTrue,sfbool,inputTrue,FIELDTYPE_SFBool)
EXPOSED_FIELD(BooleanFilter,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(BooleanFilter,set_boolean,sfbool,set_boolean,FIELDTYPE_SFBool)
END_NODE(BooleanFilter)

/* BooleanSequencer node */
BEGIN_NODE(BooleanSequencer)
EXPOSED_FIELD(BooleanSequencer,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(BooleanSequencer,keyValue,mfbool,keyValue,FIELDTYPE_MFBool)
EXPOSED_FIELD(BooleanSequencer,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(BooleanSequencer,next,sfbool,next,FIELDTYPE_SFBool)
EVENT_IN(BooleanSequencer,previous,sfbool,previous,FIELDTYPE_SFBool)
EVENT_IN(BooleanSequencer,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(BooleanSequencer,value_changed,sfbool,value_changed,FIELDTYPE_SFBool)
END_NODE(BooleanSequencer)

/* BooleanToggle node */
BEGIN_NODE(BooleanToggle)
EXPOSED_FIELD(BooleanToggle,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(BooleanToggle,set_boolean,sfbool,set_boolean,FIELDTYPE_SFBool)
EVENT_OUT(BooleanToggle,toggle,sfbool,toggle,FIELDTYPE_SFBool)
END_NODE(BooleanToggle)

/* BooleanTrigger node */
BEGIN_NODE(BooleanTrigger)
EXPOSED_FIELD(BooleanTrigger,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(BooleanTrigger,set_triggerTime,sftime,set_triggerTime,FIELDTYPE_SFTime)
EVENT_OUT(BooleanTrigger,triggerTrue,sfbool,triggerTrue,FIELDTYPE_SFBool)
END_NODE(BooleanTrigger)

/* Box node */
BEGIN_NODE(Box)
EXPOSED_FIELD(Box,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Box,size,sfvec3f,size,FIELDTYPE_SFVec3f)
FIELD(Box,solid,sfbool,solid,FIELDTYPE_SFBool)
END_NODE(Box)

/* CADAssembly node */
BEGIN_NODE(CADAssembly)
EVENT_IN(CADAssembly,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(CADAssembly,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(CADAssembly,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADAssembly,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(CADAssembly,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CADAssembly,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(CADAssembly,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(CADAssembly)

/* CADFace node */
BEGIN_NODE(CADFace)
FIELD(CADFace,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(CADFace,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADFace,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CADFace,name,sfstring,name,FIELDTYPE_SFString)
EXPOSED_FIELD(CADFace,shape,sfnode,shape,FIELDTYPE_SFNode)
END_NODE(CADFace)

/* CADLayer node */
BEGIN_NODE(CADLayer)
EVENT_IN(CADLayer,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(CADLayer,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(CADLayer,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADLayer,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(CADLayer,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CADLayer,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(CADLayer,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(CADLayer,visible,mfbool,visible,FIELDTYPE_MFBool)
END_NODE(CADLayer)

/* CADPart node */
BEGIN_NODE(CADPart)
EVENT_IN(CADPart,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(CADPart,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(CADPart,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADPart,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADPart,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(CADPart,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CADPart,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(CADPart,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(CADPart,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(CADPart,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(CADPart,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(CADPart,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
END_NODE(CADPart)

/* Circle2D node */
BEGIN_NODE(Circle2D)
EXPOSED_FIELD(Circle2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Circle2D,radius,sffloat,radius,FIELDTYPE_SFFloat)
END_NODE(Circle2D)

/* ClipPlane node */
BEGIN_NODE(ClipPlane)
EXPOSED_FIELD(ClipPlane,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(ClipPlane,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ClipPlane,plane,sfvec4f,plane,FIELDTYPE_SFVec4f)
END_NODE(ClipPlane)

/* Collision node */
BEGIN_NODE(Collision)
EVENT_IN(Collision,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Collision,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Collision,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Collision,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Collision,collide,sfbool,collide,FIELDTYPE_SFBool)
EVENT_OUT(Collision,collideTime,sftime,collideTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(Collision,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(Collision,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(Collision,proxy,sfnode,proxy,FIELDTYPE_SFNode)
EVENT_IN(Collision,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(Collision)

/* Color node */
BEGIN_NODE(Color)
EXPOSED_FIELD(Color,color,mfcolor,color,FIELDTYPE_MFColor)
EXPOSED_FIELD(Color,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(Color)

/* ColorInterpolator node */
BEGIN_NODE(ColorInterpolator)
EXPOSED_FIELD(ColorInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(ColorInterpolator,keyValue,mfcolor,keyValue,FIELDTYPE_MFColor)
EXPOSED_FIELD(ColorInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(ColorInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(ColorInterpolator,value_changed,sfcolor,value_changed,FIELDTYPE_SFColor)
END_NODE(ColorInterpolator)

/* ColorRGBA node */
BEGIN_NODE(ColorRGBA)
EXPOSED_FIELD(ColorRGBA,color,mfcolorrgba,color,FIELDTYPE_MFColorRGBA)
EXPOSED_FIELD(ColorRGBA,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(ColorRGBA)

/* ComposedCubeMapTexture node */
BEGIN_NODE(ComposedCubeMapTexture)
EXPOSED_FIELD(ComposedCubeMapTexture,back,sfnode,back,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,bottom,sfnode,bottom,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,front,sfnode,front,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,left,sfnode,left,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,right,sfnode,right,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedCubeMapTexture,top,sfnode,top,FIELDTYPE_SFNode)
END_NODE(ComposedCubeMapTexture)

/* ComposedShader node */
BEGIN_NODE(ComposedShader)
EVENT_IN(ComposedShader,activate,sfbool,activate,FIELDTYPE_SFBool)
EVENT_OUT(ComposedShader,isSelected,sfbool,isSelected,FIELDTYPE_SFBool)
EVENT_OUT(ComposedShader,isValid,sfbool,isValid,FIELDTYPE_SFBool)
FIELD(ComposedShader,language,sfstring,language,FIELDTYPE_SFString)
EXPOSED_FIELD(ComposedShader,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ComposedShader,parts,mfnode,parts,FIELDTYPE_MFNode)
END_NODE(ComposedShader)

/* Cone node */
BEGIN_NODE(Cone)
EXPOSED_FIELD(Cone,bottom,sfbool,bottom,FIELDTYPE_SFBool)
FIELD(Cone,bottomRadius,sffloat,bottomRadius,FIELDTYPE_SFFloat)
FIELD(Cone,height,sffloat,height,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Cone,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(Cone,side,sfbool,side,FIELDTYPE_SFBool)
FIELD(Cone,solid,sfbool,solid,FIELDTYPE_SFBool)
END_NODE(Cone)

/* Contour2D node */
BEGIN_NODE(Contour2D)
EVENT_IN(Contour2D,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Contour2D,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Contour2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Contour2D,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(Contour2D)

/* ContourPolyLine2D node */
BEGIN_NODE(ContourPolyLine2D)
EXPOSED_FIELD(ContourPolyLine2D,controlPoint,mfvec2d,controlPoint,FIELDTYPE_MFVec2d)
EXPOSED_FIELD(ContourPolyLine2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(ContourPolyLine2D)

/* Coordinate node */
BEGIN_NODE(Coordinate)
EXPOSED_FIELD(Coordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Coordinate,point,mfvec3f,point,FIELDTYPE_MFVec3f)
END_NODE(Coordinate)

/* CoordinateDouble node */
BEGIN_NODE(CoordinateDouble)
EXPOSED_FIELD(CoordinateDouble,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CoordinateDouble,point,mfvec3d,point,FIELDTYPE_MFVec3d)
END_NODE(CoordinateDouble)

/* CoordinateInterpolator node */
BEGIN_NODE(CoordinateInterpolator)
EXPOSED_FIELD(CoordinateInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(CoordinateInterpolator,keyValue,mfvec3f,keyValue,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(CoordinateInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(CoordinateInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(CoordinateInterpolator,value_changed,mfvec3f,value_changed,FIELDTYPE_MFVec3f)
END_NODE(CoordinateInterpolator)

/* CoordinateInterpolator2D node */
BEGIN_NODE(CoordinateInterpolator2D)
EXPOSED_FIELD(CoordinateInterpolator2D,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(CoordinateInterpolator2D,keyValue,mfvec2f,keyValue,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(CoordinateInterpolator2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(CoordinateInterpolator2D,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(CoordinateInterpolator2D,value_changed,mfvec2f,value_changed,FIELDTYPE_MFVec2f)
END_NODE(CoordinateInterpolator2D)

/* Cylinder node */
BEGIN_NODE(Cylinder)
EXPOSED_FIELD(Cylinder,bottom,sfbool,bottom,FIELDTYPE_SFBool)
FIELD(Cylinder,height,sffloat,height,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Cylinder,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Cylinder,radius,sffloat,radius,FIELDTYPE_SFFloat)
FIELD(Cylinder,side,sfbool,side,FIELDTYPE_SFBool)
FIELD(Cylinder,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(Cylinder,top,sfbool,top,FIELDTYPE_SFBool)
END_NODE(Cylinder)

/* CylinderSensor node */
BEGIN_NODE(CylinderSensor)
EXPOSED_FIELD(CylinderSensor,autoOffset,sfbool,autoOffset,FIELDTYPE_SFBool)
EXPOSED_FIELD(CylinderSensor,axisRotation,sfrotation,axisRotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(CylinderSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(CylinderSensor,diskAngle,sffloat,diskAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(CylinderSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(CylinderSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(CylinderSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(CylinderSensor,maxAngle,sffloat,maxAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(CylinderSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(CylinderSensor,minAngle,sffloat,minAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(CylinderSensor,offset,sffloat,offset,FIELDTYPE_SFFloat)
EVENT_OUT(CylinderSensor,rotation_changed,sfrotation,rotation_changed,FIELDTYPE_SFRotation)
EVENT_OUT(CylinderSensor,trackPoint_changed,sfvec3f,trackPoint_changed,FIELDTYPE_SFVec3f)
END_NODE(CylinderSensor)

/* DISEntityManager node */
BEGIN_NODE(DISEntityManager)
EVENT_OUT(DISEntityManager,addedEntities,mfnode,addedEntities,FIELDTYPE_MFNode)
EXPOSED_FIELD(DISEntityManager,address,sfstring,address,FIELDTYPE_SFString)
EXPOSED_FIELD(DISEntityManager,applicationID,sfint32,applicationID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(DISEntityManager,mapping,mfnode,mapping,FIELDTYPE_MFNode)
EXPOSED_FIELD(DISEntityManager,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(DISEntityManager,port,sfint32,port,FIELDTYPE_SFInt32)
EVENT_OUT(DISEntityManager,removedEntities,mfnode,removedEntities,FIELDTYPE_MFNode)
EXPOSED_FIELD(DISEntityManager,siteID,sfint32,siteID,FIELDTYPE_SFInt32)
END_NODE(DISEntityManager)

/* DISEntityTypeMapping node */
BEGIN_NODE(DISEntityTypeMapping)
FIELD(DISEntityTypeMapping,category,sfint32,category,FIELDTYPE_SFInt32)
FIELD(DISEntityTypeMapping,country,sfint32,country,FIELDTYPE_SFInt32)
FIELD(DISEntityTypeMapping,domain,sfint32,domain,FIELDTYPE_SFInt32)
FIELD(DISEntityTypeMapping,extra,sfint32,extra,FIELDTYPE_SFInt32)
FIELD(DISEntityTypeMapping,kind,sfint32,kind,FIELDTYPE_SFInt32)
EXPOSED_FIELD(DISEntityTypeMapping,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(DISEntityTypeMapping,specific,sfint32,specific,FIELDTYPE_SFInt32)
FIELD(DISEntityTypeMapping,subcategory,sfint32,subcategory,FIELDTYPE_SFInt32)
EXPOSED_FIELD(DISEntityTypeMapping,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(DISEntityTypeMapping)

/* DirectionalLight node */
BEGIN_NODE(DirectionalLight)
EXPOSED_FIELD(DirectionalLight,ambientIntensity,sffloat,ambientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(DirectionalLight,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(DirectionalLight,direction,sfvec3f,direction,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(DirectionalLight,global,sfbool,global,FIELDTYPE_SFBool)
EXPOSED_FIELD(DirectionalLight,intensity,sffloat,intensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(DirectionalLight,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(DirectionalLight,on,sfbool,on,FIELDTYPE_SFBool)
END_NODE(DirectionalLight)

/* Disk2D node */
BEGIN_NODE(Disk2D)
FIELD(Disk2D,innerRadius,sffloat,innerRadius,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Disk2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(Disk2D,outerRadius,sffloat,outerRadius,FIELDTYPE_SFFloat)
FIELD(Disk2D,solid,sfbool,solid,FIELDTYPE_SFBool)
END_NODE(Disk2D)

/* EaseInEaseOut node */
BEGIN_NODE(EaseInEaseOut)
EXPOSED_FIELD(EaseInEaseOut,easeInEaseOut,mfvec2f,easeInEaseOut,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(EaseInEaseOut,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(EaseInEaseOut,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(EaseInEaseOut,modifiedFraction_changed,sffloat,modifiedFraction_changed,FIELDTYPE_SFFloat)
EVENT_IN(EaseInEaseOut,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
END_NODE(EaseInEaseOut)

/* ElevationGrid node */
BEGIN_NODE(ElevationGrid)
EXPOSED_FIELD(ElevationGrid,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(ElevationGrid,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(ElevationGrid,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(ElevationGrid,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
FIELD(ElevationGrid,creaseAngle,sffloat,creaseAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(ElevationGrid,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
FIELD(ElevationGrid,height,mffloat,height,FIELDTYPE_MFFloat)
EXPOSED_FIELD(ElevationGrid,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ElevationGrid,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(ElevationGrid,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(ElevationGrid,set_height,mffloat,set_height,FIELDTYPE_MFFloat)
FIELD(ElevationGrid,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(ElevationGrid,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
FIELD(ElevationGrid,xDimension,sfint32,xDimension,FIELDTYPE_SFInt32)
FIELD(ElevationGrid,xSpacing,sffloat,xSpacing,FIELDTYPE_SFFloat)
FIELD(ElevationGrid,zDimension,sfint32,zDimension,FIELDTYPE_SFInt32)
FIELD(ElevationGrid,zSpacing,sffloat,zSpacing,FIELDTYPE_SFFloat)
END_NODE(ElevationGrid)

/* EspduTransform node */
BEGIN_NODE(EspduTransform)
EVENT_IN(EspduTransform,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(EspduTransform,address,sfstring,address,FIELDTYPE_SFString)
EXPOSED_FIELD(EspduTransform,applicationID,sfint32,applicationID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,articulationParameterArray,mffloat,articulationParameterArray,FIELDTYPE_MFFloat)
EXPOSED_FIELD(EspduTransform,articulationParameterChangeIndicatorArr,mfint32,articulationParameterChangeIndicatorArr,FIELDTYPE_MFInt32)
EXPOSED_FIELD(EspduTransform,articulationParameterCount,sfint32,articulationParameterCount,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,articulationParameterDesignatorArray,mfint32,articulationParameterDesignatorArray,FIELDTYPE_MFInt32)
EXPOSED_FIELD(EspduTransform,articulationParameterIdPartAttachedToAr,mfint32,articulationParameterIdPartAttachedToAr,FIELDTYPE_MFInt32)
EXPOSED_FIELD(EspduTransform,articulationParameterTypeArray,mfint32,articulationParameterTypeArray,FIELDTYPE_MFInt32)
EVENT_OUT(EspduTransform,articulationParameterValue0_changed,sffloat,articulationParameterValue0_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue1_changed,sffloat,articulationParameterValue1_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue2_changed,sffloat,articulationParameterValue2_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue3_changed,sffloat,articulationParameterValue3_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue4_changed,sffloat,articulationParameterValue4_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue5_changed,sffloat,articulationParameterValue5_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue6_changed,sffloat,articulationParameterValue6_changed,FIELDTYPE_SFFloat)
EVENT_OUT(EspduTransform,articulationParameterValue7_changed,sffloat,articulationParameterValue7_changed,FIELDTYPE_SFFloat)
FIELD(EspduTransform,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(EspduTransform,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,children,mfnode,children,FIELDTYPE_MFNode)
EVENT_OUT(EspduTransform,collideTime,sftime,collideTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(EspduTransform,collisionType,sfint32,collisionType,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,deadReckoning,sfint32,deadReckoning,FIELDTYPE_SFInt32)
EVENT_OUT(EspduTransform,detonateTime,sftime,detonateTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(EspduTransform,detonationLocation,sfvec3f,detonationLocation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,detonationRelativeLocation,sfvec3f,detonationRelativeLocation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,detonationResult,sfint32,detonationResult,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(EspduTransform,entityCategory,sfint32,entityCategory,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entityCountry,sfint32,entityCountry,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entityDomain,sfint32,entityDomain,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entityExtra,sfint32,entityExtra,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entityID,sfint32,entityID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entityKind,sfint32,entityKind,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entitySpecific,sfint32,entitySpecific,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,entitySubCategory,sfint32,entitySubCategory,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,eventApplicationID,sfint32,eventApplicationID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,eventEntityID,sfint32,eventEntityID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,eventNumber,sfint32,eventNumber,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,eventSiteID,sfint32,eventSiteID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,fireMissionIndex,sfint32,fireMissionIndex,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,fired1,sfbool,fired1,FIELDTYPE_SFBool)
EXPOSED_FIELD(EspduTransform,fired2,sfbool,fired2,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,firedTime,sftime,firedTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(EspduTransform,firingRange,sffloat,firingRange,FIELDTYPE_SFFloat)
EXPOSED_FIELD(EspduTransform,firingRate,sfint32,firingRate,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,forceID,sfint32,forceID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,fuse,sfint32,fuse,FIELDTYPE_SFInt32)
EVENT_OUT(EspduTransform,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isCollided,sfbool,isCollided,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isDetonated,sfbool,isDetonated,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isNetworkReader,sfbool,isNetworkReader,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isNetworkWriter,sfbool,isNetworkWriter,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isRtpHeaderHeard,sfbool,isRtpHeaderHeard,FIELDTYPE_SFBool)
EVENT_OUT(EspduTransform,isStandAlone,sfbool,isStandAlone,FIELDTYPE_SFBool)
EXPOSED_FIELD(EspduTransform,linearAcceleration,sfvec3f,linearAcceleration,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,linearVelocity,sfvec3f,linearVelocity,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,marking,sfstring,marking,FIELDTYPE_SFString)
EXPOSED_FIELD(EspduTransform,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(EspduTransform,multicastRelayHost,sfstring,multicastRelayHost,FIELDTYPE_SFString)
EXPOSED_FIELD(EspduTransform,multicastRelayPort,sfint32,multicastRelayPort,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,munitionApplicationID,sfint32,munitionApplicationID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,munitionEndPoint,sfvec3f,munitionEndPoint,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,munitionEntityID,sfint32,munitionEntityID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,munitionQuantity,sfint32,munitionQuantity,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,munitionSiteID,sfint32,munitionSiteID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,munitionStartPoint,sfvec3f,munitionStartPoint,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,networkMode,sfstring,networkMode,FIELDTYPE_SFString)
EXPOSED_FIELD(EspduTransform,port,sfint32,port,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,readInterval,sftime,readInterval,FIELDTYPE_SFTime)
EVENT_IN(EspduTransform,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(EspduTransform,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
FIELD(EspduTransform,rtpHeaderExpected,sfbool,rtpHeaderExpected,FIELDTYPE_SFBool)
EXPOSED_FIELD(EspduTransform,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EVENT_IN(EspduTransform,set_articulationParameterValue0,sffloat,set_articulationParameterValue0,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue1,sffloat,set_articulationParameterValue1,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue2,sffloat,set_articulationParameterValue2,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue3,sffloat,set_articulationParameterValue3,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue4,sffloat,set_articulationParameterValue4,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue5,sffloat,set_articulationParameterValue5,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue6,sffloat,set_articulationParameterValue6,FIELDTYPE_SFFloat)
EVENT_IN(EspduTransform,set_articulationParameterValue7,sffloat,set_articulationParameterValue7,FIELDTYPE_SFFloat)
EXPOSED_FIELD(EspduTransform,siteID,sfint32,siteID,FIELDTYPE_SFInt32)
EVENT_OUT(EspduTransform,timestamp,sftime,timestamp,FIELDTYPE_SFTime)
EXPOSED_FIELD(EspduTransform,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(EspduTransform,warhead,sfint32,warhead,FIELDTYPE_SFInt32)
EXPOSED_FIELD(EspduTransform,writeInterval,sftime,writeInterval,FIELDTYPE_SFTime)
END_NODE(EspduTransform)

/* Extrusion node */
BEGIN_NODE(Extrusion)
FIELD(Extrusion,beginCap,sfbool,beginCap,FIELDTYPE_SFBool)
FIELD(Extrusion,ccw,sfbool,ccw,FIELDTYPE_SFBool)
FIELD(Extrusion,convex,sfbool,convex,FIELDTYPE_SFBool)
FIELD(Extrusion,creaseAngle,sffloat,creaseAngle,FIELDTYPE_SFFloat)
FIELD(Extrusion,crossSection,mfvec2f,crossSection,FIELDTYPE_MFVec2f)
FIELD(Extrusion,endCap,sfbool,endCap,FIELDTYPE_SFBool)
EXPOSED_FIELD(Extrusion,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Extrusion,orientation,mfrotation,orientation,FIELDTYPE_MFRotation)
EXPOSED_FIELD(Extrusion,scale,mfvec2f,scale,FIELDTYPE_MFVec2f)
EVENT_IN(Extrusion,set_crossSection,mfvec2f,set_crossSection,FIELDTYPE_MFVec2f)
EVENT_IN(Extrusion,set_orientation,mfrotation,set_orientation,FIELDTYPE_MFRotation)
EVENT_IN(Extrusion,set_scale,mfvec2f,set_scale,FIELDTYPE_MFVec2f)
EVENT_IN(Extrusion,set_spine,mfvec3f,set_spine,FIELDTYPE_MFVec3f)
FIELD(Extrusion,solid,sfbool,solid,FIELDTYPE_SFBool)
FIELD(Extrusion,spine,mfvec3f,spine,FIELDTYPE_MFVec3f)
END_NODE(Extrusion)

/* FillProperties node */
BEGIN_NODE(FillProperties)
EXPOSED_FIELD(FillProperties,filled,sfbool,filled,FIELDTYPE_SFBool)
EXPOSED_FIELD(FillProperties,hatchColor,sfcolor,hatchColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(FillProperties,hatchStyle,sfint32,hatchStyle,FIELDTYPE_SFInt32)
EXPOSED_FIELD(FillProperties,hatched,sfbool,hatched,FIELDTYPE_SFBool)
EXPOSED_FIELD(FillProperties,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(FillProperties)

/* FloatVertexAttribute node */
BEGIN_NODE(FloatVertexAttribute)
EXPOSED_FIELD(FloatVertexAttribute,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(FloatVertexAttribute,name,sfstring,name,FIELDTYPE_SFString)
FIELD(FloatVertexAttribute,numComponents,sfint32,numComponents,FIELDTYPE_SFInt32)
EXPOSED_FIELD(FloatVertexAttribute,value,mffloat,value,FIELDTYPE_MFFloat)
END_NODE(FloatVertexAttribute)

/* Fog node */
BEGIN_NODE(Fog)
EVENT_OUT(Fog,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(Fog,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(Fog,fogType,sfstring,fogType,FIELDTYPE_SFString)
EVENT_OUT(Fog,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(Fog,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Fog,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
EXPOSED_FIELD(Fog,visibilityRange,sffloat,visibilityRange,FIELDTYPE_SFFloat)
END_NODE(Fog)

/* FogCoordinate node */
BEGIN_NODE(FogCoordinate)
EXPOSED_FIELD(FogCoordinate,depth,mffloat,depth,FIELDTYPE_MFFloat)
EXPOSED_FIELD(FogCoordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(FogCoordinate)

/* FontStyle node */
BEGIN_NODE(FontStyle)
FIELD(FontStyle,family,mfstring,family,FIELDTYPE_MFString)
FIELD(FontStyle,horizontal,sfbool,horizontal,FIELDTYPE_SFBool)
FIELD(FontStyle,justify,mfstring,justify,FIELDTYPE_MFString)
FIELD(FontStyle,language,sfstring,language,FIELDTYPE_SFString)
FIELD(FontStyle,leftToRight,sfbool,leftToRight,FIELDTYPE_SFBool)
EXPOSED_FIELD(FontStyle,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(FontStyle,size,sffloat,size,FIELDTYPE_SFFloat)
FIELD(FontStyle,spacing,sffloat,spacing,FIELDTYPE_SFFloat)
FIELD(FontStyle,style,sfstring,style,FIELDTYPE_SFString)
FIELD(FontStyle,topToBottom,sfbool,topToBottom,FIELDTYPE_SFBool)
END_NODE(FontStyle)

/* GeneratedCubeMapTexture node */
BEGIN_NODE(GeneratedCubeMapTexture)
EXPOSED_FIELD(GeneratedCubeMapTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeneratedCubeMapTexture,size,sfint32,size,FIELDTYPE_SFInt32)
FIELD(GeneratedCubeMapTexture,textureProperties,sfnode,textureProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeneratedCubeMapTexture,update,sfstring,update,FIELDTYPE_SFString)
END_NODE(GeneratedCubeMapTexture)

/* GeoCoordinate node */
BEGIN_NODE(GeoCoordinate)
FIELD(GeoCoordinate,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoCoordinate,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoCoordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeoCoordinate,point,mfvec3d,point,FIELDTYPE_MFVec3d)
END_NODE(GeoCoordinate)

/* GeoElevationGrid node */
BEGIN_NODE(GeoElevationGrid)
FIELD(GeoElevationGrid,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoElevationGrid,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(GeoElevationGrid,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
FIELD(GeoElevationGrid,creaseAngle,sfdouble,creaseAngle,FIELDTYPE_SFDouble)
FIELD(GeoElevationGrid,geoGridOrigin,sfvec3d,geoGridOrigin,FIELDTYPE_SFVec3d)
FIELD(GeoElevationGrid,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoElevationGrid,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
FIELD(GeoElevationGrid,height,mfdouble,height,FIELDTYPE_MFDouble)
EXPOSED_FIELD(GeoElevationGrid,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeoElevationGrid,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(GeoElevationGrid,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(GeoElevationGrid,set_height,mfdouble,set_height,FIELDTYPE_MFDouble)
FIELD(GeoElevationGrid,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoElevationGrid,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
FIELD(GeoElevationGrid,xDimension,sfint32,xDimension,FIELDTYPE_SFInt32)
FIELD(GeoElevationGrid,xSpacing,sfdouble,xSpacing,FIELDTYPE_SFDouble)
FIELD(GeoElevationGrid,yScale,sffloat,yScale,FIELDTYPE_SFFloat)
FIELD(GeoElevationGrid,zDimension,sfint32,zDimension,FIELDTYPE_SFInt32)
FIELD(GeoElevationGrid,zSpacing,sfdouble,zSpacing,FIELDTYPE_SFDouble)
END_NODE(GeoElevationGrid)

/* GeoLOD node */
BEGIN_NODE(GeoLOD)
FIELD(GeoLOD,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(GeoLOD,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoLOD,center,sfvec3d,center,FIELDTYPE_SFVec3d)
FIELD(GeoLOD,child1Url,mfstring,child1Url,FIELDTYPE_MFString)
FIELD(GeoLOD,child2Url,mfstring,child2Url,FIELDTYPE_MFString)
FIELD(GeoLOD,child3Url,mfstring,child3Url,FIELDTYPE_MFString)
FIELD(GeoLOD,child4Url,mfstring,child4Url,FIELDTYPE_MFString)
EVENT_OUT(GeoLOD,children,mfnode,children,FIELDTYPE_MFNode)
FIELD(GeoLOD,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoLOD,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EVENT_OUT(GeoLOD,level_changed,sfint32,level_changed,FIELDTYPE_SFInt32)
EXPOSED_FIELD(GeoLOD,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(GeoLOD,range,sffloat,range,FIELDTYPE_SFFloat)
FIELD(GeoLOD,rootNode,mfnode,rootNode,FIELDTYPE_MFNode)
FIELD(GeoLOD,rootUrl,mfstring,rootUrl,FIELDTYPE_MFString)
END_NODE(GeoLOD)

/* GeoLocation node */
BEGIN_NODE(GeoLocation)
EVENT_IN(GeoLocation,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(GeoLocation,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(GeoLocation,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoLocation,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(GeoLocation,geoCoords,sfvec3d,geoCoords,FIELDTYPE_SFVec3d)
FIELD(GeoLocation,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoLocation,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoLocation,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(GeoLocation,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(GeoLocation)

/* GeoMetadata node */
BEGIN_NODE(GeoMetadata)
EXPOSED_FIELD(GeoMetadata,data,mfnode,data,FIELDTYPE_MFNode)
EXPOSED_FIELD(GeoMetadata,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeoMetadata,summary,mfstring,summary,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoMetadata,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(GeoMetadata)

/* GeoOrigin node */
BEGIN_NODE(GeoOrigin)
EXPOSED_FIELD(GeoOrigin,geoCoords,sfvec3d,geoCoords,FIELDTYPE_SFVec3d)
FIELD(GeoOrigin,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoOrigin,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(GeoOrigin,rotateYUp,sfbool,rotateYUp,FIELDTYPE_SFBool)
END_NODE(GeoOrigin)

/* GeoPositionInterpolator node */
BEGIN_NODE(GeoPositionInterpolator)
FIELD(GeoPositionInterpolator,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoPositionInterpolator,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EVENT_OUT(GeoPositionInterpolator,geovalue_changed,sfvec3d,geovalue_changed,FIELDTYPE_SFVec3d)
EXPOSED_FIELD(GeoPositionInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(GeoPositionInterpolator,keyValue,mfvec3d,keyValue,FIELDTYPE_MFVec3d)
EXPOSED_FIELD(GeoPositionInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(GeoPositionInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(GeoPositionInterpolator,value_changed,sfvec3f,value_changed,FIELDTYPE_SFVec3f)
END_NODE(GeoPositionInterpolator)

/* GeoProximitySensor node */
BEGIN_NODE(GeoProximitySensor)
EVENT_OUT(GeoProximitySensor,centerOfRotation_changed,sfvec3f,centerOfRotation_changed,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoProximitySensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(GeoProximitySensor,enterTime,sftime,enterTime,FIELDTYPE_SFTime)
EVENT_OUT(GeoProximitySensor,exitTime,sftime,exitTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(GeoProximitySensor,geoCenter,sfvec3d,geoCenter,FIELDTYPE_SFVec3d)
EVENT_OUT(GeoProximitySensor,geoCoord_changed,sfvec3d,geoCoord_changed,FIELDTYPE_SFVec3d)
FIELD(GeoProximitySensor,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoProximitySensor,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EVENT_OUT(GeoProximitySensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoProximitySensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(GeoProximitySensor,orientation_changed,sfrotation,orientation_changed,FIELDTYPE_SFRotation)
EVENT_OUT(GeoProximitySensor,position_changed,sfvec3f,position_changed,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoProximitySensor,size,sfvec3f,size,FIELDTYPE_SFVec3f)
END_NODE(GeoProximitySensor)

/* GeoTouchSensor node */
BEGIN_NODE(GeoTouchSensor)
EXPOSED_FIELD(GeoTouchSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(GeoTouchSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
FIELD(GeoTouchSensor,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoTouchSensor,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EVENT_OUT(GeoTouchSensor,hitGeoCoord_changed,sfvec3d,hitGeoCoord_changed,FIELDTYPE_SFVec3d)
EVENT_OUT(GeoTouchSensor,hitNormal_changed,sfvec3f,hitNormal_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(GeoTouchSensor,hitPoint_changed,sfvec3f,hitPoint_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(GeoTouchSensor,hitTexCoord_changed,sfvec2f,hitTexCoord_changed,FIELDTYPE_SFVec2f)
EVENT_OUT(GeoTouchSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(GeoTouchSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoTouchSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(GeoTouchSensor,touchTime,sftime,touchTime,FIELDTYPE_SFTime)
END_NODE(GeoTouchSensor)

/* GeoTransform node */
BEGIN_NODE(GeoTransform)
EVENT_IN(GeoTransform,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(GeoTransform,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(GeoTransform,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoTransform,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(GeoTransform,geoCenter,sfvec3d,geoCenter,FIELDTYPE_SFVec3d)
FIELD(GeoTransform,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoTransform,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoTransform,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(GeoTransform,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(GeoTransform,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(GeoTransform,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(GeoTransform,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(GeoTransform,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
END_NODE(GeoTransform)

/* GeoViewpoint node */
BEGIN_NODE(GeoViewpoint)
EVENT_OUT(GeoViewpoint,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(GeoViewpoint,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(GeoViewpoint,fieldOfView,sffloat,fieldOfView,FIELDTYPE_SFFloat)
FIELD(GeoViewpoint,geoOrigin,sfnode,geoOrigin,FIELDTYPE_SFNode)
FIELD(GeoViewpoint,geoSystem,mfstring,geoSystem,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoViewpoint,headlight,sfbool,headlight,FIELDTYPE_SFBool)
EVENT_OUT(GeoViewpoint,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoViewpoint,jump,sfbool,jump,FIELDTYPE_SFBool)
EXPOSED_FIELD(GeoViewpoint,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(GeoViewpoint,navType,mfstring,navType,FIELDTYPE_MFString)
EXPOSED_FIELD(GeoViewpoint,orientation,sfrotation,orientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(GeoViewpoint,position,sfvec3d,position,FIELDTYPE_SFVec3d)
EVENT_IN(GeoViewpoint,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
EVENT_IN(GeoViewpoint,set_orientation,sfrotation,set_orientation,FIELDTYPE_SFRotation)
EVENT_IN(GeoViewpoint,set_position,sfvec3d,set_position,FIELDTYPE_SFVec3d)
FIELD(GeoViewpoint,speedFactor,sffloat,speedFactor,FIELDTYPE_SFFloat)
END_NODE(GeoViewpoint)

/* Group node */
BEGIN_NODE(Group)
EXPOSED_FIELD(Group,FreeWRL_PROTOInterfaceNodes,mfnode,FreeWRL_PROTOInterfaceNodes,FIELDTYPE_MFNode)
FIELD(Group,FreeWRL__protoDef,sfint32,FreeWRL__protoDef,FIELDTYPE_SFInt32)
EVENT_IN(Group,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Group,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Group,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Group,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Group,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Group,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(Group)

/* HAnimDisplacer node */
BEGIN_NODE(HAnimDisplacer)
EVENT_IN(HAnimDisplacer,coordIndex,mfint32,coordIndex,FIELDTYPE_MFInt32)
EXPOSED_FIELD(HAnimDisplacer,displacements,mfvec3f,displacements,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(HAnimDisplacer,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimDisplacer,name,sfstring,name,FIELDTYPE_SFString)
EXPOSED_FIELD(HAnimDisplacer,weight,sffloat,weight,FIELDTYPE_SFFloat)
END_NODE(HAnimDisplacer)

/* HAnimHumanoid node */
BEGIN_NODE(HAnimHumanoid)
FIELD(HAnimHumanoid,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(HAnimHumanoid,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimHumanoid,center,sfvec3f,center,FIELDTYPE_SFVec3f)
FIELD(HAnimHumanoid,info,mfstring,info,FIELDTYPE_MFString)
EXPOSED_FIELD(HAnimHumanoid,joints,mfnode,joints,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimHumanoid,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimHumanoid,name,sfstring,name,FIELDTYPE_SFString)
EXPOSED_FIELD(HAnimHumanoid,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimHumanoid,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimHumanoid,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimHumanoid,segments,mfnode,segments,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimHumanoid,sites,mfnode,sites,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimHumanoid,skeleton,mfnode,skeleton,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimHumanoid,skin,mfnode,skin,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimHumanoid,skinCoord,sfnode,skinCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimHumanoid,skinNormal,sfnode,skinNormal,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimHumanoid,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimHumanoid,version,sfstring,version,FIELDTYPE_SFString)
EXPOSED_FIELD(HAnimHumanoid,viewpoints,mfnode,viewpoints,FIELDTYPE_MFNode)
END_NODE(HAnimHumanoid)

/* HAnimJoint node */
BEGIN_NODE(HAnimJoint)
EVENT_IN(HAnimJoint,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(HAnimJoint,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(HAnimJoint,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimJoint,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimJoint,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimJoint,displacers,mfnode,displacers,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimJoint,limitOrientation,sfrotation,limitOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimJoint,llimit,mffloat,llimit,FIELDTYPE_MFFloat)
EXPOSED_FIELD(HAnimJoint,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimJoint,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(HAnimJoint,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimJoint,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimJoint,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimJoint,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimJoint,skinCoordIndex,mfint32,skinCoordIndex,FIELDTYPE_MFInt32)
EXPOSED_FIELD(HAnimJoint,skinCoordWeight,mffloat,skinCoordWeight,FIELDTYPE_MFFloat)
EXPOSED_FIELD(HAnimJoint,stiffness,mffloat,stiffness,FIELDTYPE_MFFloat)
EXPOSED_FIELD(HAnimJoint,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimJoint,ulimit,mffloat,ulimit,FIELDTYPE_MFFloat)
END_NODE(HAnimJoint)

/* HAnimSegment node */
BEGIN_NODE(HAnimSegment)
EVENT_IN(HAnimSegment,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(HAnimSegment,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(HAnimSegment,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimSegment,centerOfMass,sfvec3f,centerOfMass,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimSegment,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimSegment,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimSegment,displacers,mfnode,displacers,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimSegment,mass,sffloat,mass,FIELDTYPE_SFFloat)
EXPOSED_FIELD(HAnimSegment,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimSegment,momentsOfInertia,mffloat,momentsOfInertia,FIELDTYPE_MFFloat)
EXPOSED_FIELD(HAnimSegment,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(HAnimSegment,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(HAnimSegment)

/* HAnimSite node */
BEGIN_NODE(HAnimSite)
EVENT_IN(HAnimSite,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(HAnimSite,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(HAnimSite,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimSite,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimSite,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimSite,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(HAnimSite,name,sfstring,name,FIELDTYPE_SFString)
EVENT_IN(HAnimSite,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(HAnimSite,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimSite,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(HAnimSite,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(HAnimSite,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
END_NODE(HAnimSite)

/* ImageCubeMapTexture node */
BEGIN_NODE(ImageCubeMapTexture)
EXPOSED_FIELD(ImageCubeMapTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(ImageCubeMapTexture,textureProperties,sfnode,textureProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(ImageCubeMapTexture,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(ImageCubeMapTexture)

/* ImageTexture node */
BEGIN_NODE(ImageTexture)
EXPOSED_FIELD(ImageTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(ImageTexture,repeatS,sfbool,repeatS,FIELDTYPE_SFBool)
FIELD(ImageTexture,repeatT,sfbool,repeatT,FIELDTYPE_SFBool)
FIELD(ImageTexture,textureProperties,sfnode,textureProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(ImageTexture,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(ImageTexture)

/* IndexedFaceSet node */
BEGIN_NODE(IndexedFaceSet)
EXPOSED_FIELD(IndexedFaceSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(IndexedFaceSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedFaceSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedFaceSet,colorIndex,mfint32,colorIndex,FIELDTYPE_MFInt32)
FIELD(IndexedFaceSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
FIELD(IndexedFaceSet,convex,sfbool,convex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedFaceSet,coord,sfnode,coord,FIELDTYPE_SFNode)
FIELD(IndexedFaceSet,coordIndex,mfint32,coordIndex,FIELDTYPE_MFInt32)
FIELD(IndexedFaceSet,creaseAngle,sffloat,creaseAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(IndexedFaceSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedFaceSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedFaceSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(IndexedFaceSet,normalIndex,mfint32,normalIndex,FIELDTYPE_MFInt32)
FIELD(IndexedFaceSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(IndexedFaceSet,set_colorIndex,mfint32,set_colorIndex,FIELDTYPE_MFInt32)
EVENT_IN(IndexedFaceSet,set_coordIndex,mfint32,set_coordIndex,FIELDTYPE_MFInt32)
EVENT_IN(IndexedFaceSet,set_normalIndex,mfint32,set_normalIndex,FIELDTYPE_MFInt32)
EVENT_IN(IndexedFaceSet,set_texCoordIndex,mfint32,set_texCoordIndex,FIELDTYPE_MFInt32)
FIELD(IndexedFaceSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedFaceSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
FIELD(IndexedFaceSet,texCoordIndex,mfint32,texCoordIndex,FIELDTYPE_MFInt32)
END_NODE(IndexedFaceSet)

/* IndexedLineSet node */
BEGIN_NODE(IndexedLineSet)
EXPOSED_FIELD(IndexedLineSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
EXPOSED_FIELD(IndexedLineSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedLineSet,colorIndex,mfint32,colorIndex,FIELDTYPE_MFInt32)
FIELD(IndexedLineSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedLineSet,coord,sfnode,coord,FIELDTYPE_SFNode)
FIELD(IndexedLineSet,coordIndex,mfint32,coordIndex,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IndexedLineSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedLineSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(IndexedLineSet,set_colorIndex,mfint32,set_colorIndex,FIELDTYPE_MFInt32)
EVENT_IN(IndexedLineSet,set_coordIndex,mfint32,set_coordIndex,FIELDTYPE_MFInt32)
END_NODE(IndexedLineSet)

/* IndexedQuadSet node */
BEGIN_NODE(IndexedQuadSet)
EXPOSED_FIELD(IndexedQuadSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(IndexedQuadSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedQuadSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedQuadSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedQuadSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedQuadSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
FIELD(IndexedQuadSet,index,mfint32,index,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IndexedQuadSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedQuadSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(IndexedQuadSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(IndexedQuadSet,set_index,mfint32,set_index,FIELDTYPE_MFInt32)
FIELD(IndexedQuadSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedQuadSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(IndexedQuadSet)

/* IndexedTriangleFanSet node */
BEGIN_NODE(IndexedTriangleFanSet)
EXPOSED_FIELD(IndexedTriangleFanSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(IndexedTriangleFanSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleFanSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedTriangleFanSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleFanSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleFanSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleFanSet,index,mfint32,index,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IndexedTriangleFanSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleFanSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(IndexedTriangleFanSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(IndexedTriangleFanSet,set_index,mfint32,set_index,FIELDTYPE_MFInt32)
FIELD(IndexedTriangleFanSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleFanSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(IndexedTriangleFanSet)

/* IndexedTriangleSet node */
BEGIN_NODE(IndexedTriangleSet)
EXPOSED_FIELD(IndexedTriangleSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(IndexedTriangleSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedTriangleSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleSet,index,mfint32,index,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IndexedTriangleSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(IndexedTriangleSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(IndexedTriangleSet,set_index,mfint32,set_index,FIELDTYPE_MFInt32)
FIELD(IndexedTriangleSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(IndexedTriangleSet)

/* IndexedTriangleStripSet node */
BEGIN_NODE(IndexedTriangleStripSet)
EXPOSED_FIELD(IndexedTriangleStripSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(IndexedTriangleStripSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleStripSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(IndexedTriangleStripSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleStripSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleStripSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleStripSet,index,mfint32,index,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IndexedTriangleStripSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(IndexedTriangleStripSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(IndexedTriangleStripSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
EVENT_IN(IndexedTriangleStripSet,set_index,mfint32,set_index,FIELDTYPE_MFInt32)
FIELD(IndexedTriangleStripSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(IndexedTriangleStripSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(IndexedTriangleStripSet)

/* Inline node */
BEGIN_NODE(Inline)
EVENT_IN(Inline,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Inline,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Inline,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Inline,load,sfbool,load,FIELDTYPE_SFBool)
EXPOSED_FIELD(Inline,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Inline,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Inline,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(Inline)

/* IntegerSequencer node */
BEGIN_NODE(IntegerSequencer)
EXPOSED_FIELD(IntegerSequencer,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(IntegerSequencer,keyValue,mfint32,keyValue,FIELDTYPE_MFInt32)
EXPOSED_FIELD(IntegerSequencer,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(IntegerSequencer,next,sfbool,next,FIELDTYPE_SFBool)
EVENT_IN(IntegerSequencer,previous,sfbool,previous,FIELDTYPE_SFBool)
EVENT_IN(IntegerSequencer,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(IntegerSequencer,value_changed,sfint32,value_changed,FIELDTYPE_SFInt32)
END_NODE(IntegerSequencer)

/* IntegerTrigger node */
BEGIN_NODE(IntegerTrigger)
EXPOSED_FIELD(IntegerTrigger,integerKey,sfint32,integerKey,FIELDTYPE_SFInt32)
EXPOSED_FIELD(IntegerTrigger,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(IntegerTrigger,set_boolean,sfbool,set_boolean,FIELDTYPE_SFBool)
EVENT_OUT(IntegerTrigger,triggerValue,sfint32,triggerValue,FIELDTYPE_SFInt32)
END_NODE(IntegerTrigger)

/* KeySensor node */
BEGIN_NODE(KeySensor)
EVENT_OUT(KeySensor,actionKeyPress,sfint32,actionKeyPress,FIELDTYPE_SFInt32)
EVENT_OUT(KeySensor,actionKeyRelease,sfint32,actionKeyRelease,FIELDTYPE_SFInt32)
EVENT_OUT(KeySensor,altKey,sfbool,altKey,FIELDTYPE_SFBool)
EVENT_OUT(KeySensor,controlKey,sfbool,controlKey,FIELDTYPE_SFBool)
EXPOSED_FIELD(KeySensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(KeySensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(KeySensor,keyPress,sfstring,keyPress,FIELDTYPE_SFString)
EVENT_OUT(KeySensor,keyRelease,sfstring,keyRelease,FIELDTYPE_SFString)
EXPOSED_FIELD(KeySensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(KeySensor,shiftKey,sfbool,shiftKey,FIELDTYPE_SFBool)
END_NODE(KeySensor)

/* LOD node */
BEGIN_NODE(LOD)
EVENT_IN(LOD,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(LOD,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(LOD,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(LOD,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(LOD,children,mfnode,children,FIELDTYPE_MFNode)
FIELD(LOD,forceTransitions,sfbool,forceTransitions,FIELDTYPE_SFBool)
EXPOSED_FIELD(LOD,level,mfnode,level,FIELDTYPE_MFNode)
EVENT_OUT(LOD,levelChanged,sfint32,levelChanged,FIELDTYPE_SFInt32)
EXPOSED_FIELD(LOD,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(LOD,range,mffloat,range,FIELDTYPE_MFFloat)
EVENT_IN(LOD,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(LOD)

/* LineProperties node */
BEGIN_NODE(LineProperties)
EXPOSED_FIELD(LineProperties,applied,sfbool,applied,FIELDTYPE_SFBool)
EXPOSED_FIELD(LineProperties,linetype,sfint32,linetype,FIELDTYPE_SFInt32)
EXPOSED_FIELD(LineProperties,linewidthScaleFactor,sffloat,linewidthScaleFactor,FIELDTYPE_SFFloat)
EXPOSED_FIELD(LineProperties,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(LineProperties)

/* LineSensor node */
BEGIN_NODE(LineSensor)
EXPOSED_FIELD(LineSensor,autoOffset,sfbool,autoOffset,FIELDTYPE_SFBool)
EXPOSED_FIELD(LineSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(LineSensor,direction,sfvec3f,direction,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(LineSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(LineSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(LineSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(LineSensor,maxPosition,sffloat,maxPosition,FIELDTYPE_SFFloat)
EXPOSED_FIELD(LineSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(LineSensor,minPosition,sffloat,minPosition,FIELDTYPE_SFFloat)
EXPOSED_FIELD(LineSensor,offset,sffloat,offset,FIELDTYPE_SFFloat)
EVENT_OUT(LineSensor,trackPoint_changed,sfvec3f,trackPoint_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(LineSensor,translation_changed,sfvec3f,translation_changed,FIELDTYPE_SFVec3f)
END_NODE(LineSensor)

/* LineSet node */
BEGIN_NODE(LineSet)
EXPOSED_FIELD(LineSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
EXPOSED_FIELD(LineSet,color,sfnode,color,FIELDTYPE_SFNode)
EXPOSED_FIELD(LineSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(LineSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(LineSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(LineSet,vertexCount,mfint32,vertexCount,FIELDTYPE_MFInt32)
END_NODE(LineSet)

/* LoadSensor node */
BEGIN_NODE(LoadSensor)
EXPOSED_FIELD(LoadSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(LoadSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(LoadSensor,isLoaded,sfbool,isLoaded,FIELDTYPE_SFBool)
EVENT_OUT(LoadSensor,loadTime,sftime,loadTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(LoadSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(LoadSensor,progress,sffloat,progress,FIELDTYPE_SFFloat)
EXPOSED_FIELD(LoadSensor,timeOut,sftime,timeOut,FIELDTYPE_SFTime)
EXPOSED_FIELD(LoadSensor,watchList,mfnode,watchList,FIELDTYPE_MFNode)
END_NODE(LoadSensor)

/* LocalFog node */
BEGIN_NODE(LocalFog)
EXPOSED_FIELD(LocalFog,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(LocalFog,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(LocalFog,fogType,sfstring,fogType,FIELDTYPE_SFString)
EXPOSED_FIELD(LocalFog,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(LocalFog,visibilityRange,sffloat,visibilityRange,FIELDTYPE_SFFloat)
END_NODE(LocalFog)

/* Material node */
BEGIN_NODE(Material)
EXPOSED_FIELD(Material,ambientIntensity,sffloat,ambientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Material,diffuseColor,sfcolor,diffuseColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(Material,emissiveColor,sfcolor,emissiveColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(Material,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Material,shininess,sffloat,shininess,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Material,specularColor,sfcolor,specularColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(Material,transparency,sffloat,transparency,FIELDTYPE_SFFloat)
END_NODE(Material)

/* Matrix3VertexAttribute node */
BEGIN_NODE(Matrix3VertexAttribute)
EXPOSED_FIELD(Matrix3VertexAttribute,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Matrix3VertexAttribute,name,sfstring,name,FIELDTYPE_SFString)
EXPOSED_FIELD(Matrix3VertexAttribute,value,mfmatrix3f,value,FIELDTYPE_MFMatrix3f)
END_NODE(Matrix3VertexAttribute)

/* Matrix4VertexAttribute node */
BEGIN_NODE(Matrix4VertexAttribute)
EXPOSED_FIELD(Matrix4VertexAttribute,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Matrix4VertexAttribute,name,sfstring,name,FIELDTYPE_SFString)
EXPOSED_FIELD(Matrix4VertexAttribute,value,mfmatrix4f,value,FIELDTYPE_MFMatrix4f)
END_NODE(Matrix4VertexAttribute)

/* MetadataDouble node */
BEGIN_NODE(MetadataDouble)
EXPOSED_FIELD(MetadataDouble,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MetadataDouble,name,sfstring,name,FIELDTYPE_SFString)
FIELD(MetadataDouble,reference,sfstring,reference,FIELDTYPE_SFString)
EXPOSED_FIELD(MetadataDouble,value,mfdouble,value,FIELDTYPE_MFDouble)
END_NODE(MetadataDouble)

/* MetadataFloat node */
BEGIN_NODE(MetadataFloat)
EXPOSED_FIELD(MetadataFloat,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MetadataFloat,name,sfstring,name,FIELDTYPE_SFString)
FIELD(MetadataFloat,reference,sfstring,reference,FIELDTYPE_SFString)
EXPOSED_FIELD(MetadataFloat,value,mffloat,value,FIELDTYPE_MFFloat)
END_NODE(MetadataFloat)

/* MetadataInteger node */
BEGIN_NODE(MetadataInteger)
EXPOSED_FIELD(MetadataInteger,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MetadataInteger,name,sfstring,name,FIELDTYPE_SFString)
FIELD(MetadataInteger,reference,sfstring,reference,FIELDTYPE_SFString)
EXPOSED_FIELD(MetadataInteger,value,mfint32,value,FIELDTYPE_MFInt32)
END_NODE(MetadataInteger)

/* MetadataMFBool node */
BEGIN_NODE(MetadataMFBool)
EVENT_IN(MetadataMFBool,setValue,mfbool,setValue,FIELDTYPE_MFBool)
EVENT_IN(MetadataMFBool,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFBool,value,mfbool,value,FIELDTYPE_MFBool)
EVENT_OUT(MetadataMFBool,valueChanged,mfbool,valueChanged,FIELDTYPE_MFBool)
END_NODE(MetadataMFBool)

/* MetadataMFColor node */
BEGIN_NODE(MetadataMFColor)
EVENT_IN(MetadataMFColor,setValue,mfcolor,setValue,FIELDTYPE_MFColor)
EVENT_IN(MetadataMFColor,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFColor,value,mfcolor,value,FIELDTYPE_MFColor)
EVENT_OUT(MetadataMFColor,valueChanged,mfcolor,valueChanged,FIELDTYPE_MFColor)
END_NODE(MetadataMFColor)

/* MetadataMFColorRGBA node */
BEGIN_NODE(MetadataMFColorRGBA)
EVENT_IN(MetadataMFColorRGBA,setValue,mfcolorrgba,setValue,FIELDTYPE_MFColorRGBA)
EVENT_IN(MetadataMFColorRGBA,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFColorRGBA,value,mfcolorrgba,value,FIELDTYPE_MFColorRGBA)
EVENT_OUT(MetadataMFColorRGBA,valueChanged,mfcolorrgba,valueChanged,FIELDTYPE_MFColorRGBA)
END_NODE(MetadataMFColorRGBA)

/* MetadataMFDouble node */
BEGIN_NODE(MetadataMFDouble)
EVENT_IN(MetadataMFDouble,setValue,mfdouble,setValue,FIELDTYPE_MFDouble)
EVENT_IN(MetadataMFDouble,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFDouble,value,mfdouble,value,FIELDTYPE_MFDouble)
EVENT_OUT(MetadataMFDouble,valueChanged,mfdouble,valueChanged,FIELDTYPE_MFDouble)
END_NODE(MetadataMFDouble)

/* MetadataMFFloat node */
BEGIN_NODE(MetadataMFFloat)
EVENT_IN(MetadataMFFloat,setValue,mffloat,setValue,FIELDTYPE_MFFloat)
EVENT_IN(MetadataMFFloat,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFFloat,value,mffloat,value,FIELDTYPE_MFFloat)
EVENT_OUT(MetadataMFFloat,valueChanged,mffloat,valueChanged,FIELDTYPE_MFFloat)
END_NODE(MetadataMFFloat)

/* MetadataMFInt32 node */
BEGIN_NODE(MetadataMFInt32)
EVENT_IN(MetadataMFInt32,setValue,mfint32,setValue,FIELDTYPE_MFInt32)
EVENT_IN(MetadataMFInt32,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFInt32,value,mfint32,value,FIELDTYPE_MFInt32)
EVENT_OUT(MetadataMFInt32,valueChanged,mfint32,valueChanged,FIELDTYPE_MFInt32)
END_NODE(MetadataMFInt32)

/* MetadataMFMatrix3d node */
BEGIN_NODE(MetadataMFMatrix3d)
EVENT_IN(MetadataMFMatrix3d,setValue,mfmatrix3d,setValue,FIELDTYPE_MFMatrix3d)
EVENT_IN(MetadataMFMatrix3d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFMatrix3d,value,mfmatrix3d,value,FIELDTYPE_MFMatrix3d)
EVENT_OUT(MetadataMFMatrix3d,valueChanged,mfmatrix3d,valueChanged,FIELDTYPE_MFMatrix3d)
END_NODE(MetadataMFMatrix3d)

/* MetadataMFMatrix3f node */
BEGIN_NODE(MetadataMFMatrix3f)
EVENT_IN(MetadataMFMatrix3f,setValue,mfmatrix3f,setValue,FIELDTYPE_MFMatrix3f)
EVENT_IN(MetadataMFMatrix3f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFMatrix3f,value,mfmatrix3f,value,FIELDTYPE_MFMatrix3f)
EVENT_OUT(MetadataMFMatrix3f,valueChanged,mfmatrix3f,valueChanged,FIELDTYPE_MFMatrix3f)
END_NODE(MetadataMFMatrix3f)

/* MetadataMFMatrix4d node */
BEGIN_NODE(MetadataMFMatrix4d)
EVENT_IN(MetadataMFMatrix4d,setValue,mfmatrix4d,setValue,FIELDTYPE_MFMatrix4d)
EVENT_IN(MetadataMFMatrix4d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFMatrix4d,value,mfmatrix4d,value,FIELDTYPE_MFMatrix4d)
EVENT_OUT(MetadataMFMatrix4d,valueChanged,mfmatrix4d,valueChanged,FIELDTYPE_MFMatrix4d)
END_NODE(MetadataMFMatrix4d)

/* MetadataMFMatrix4f node */
BEGIN_NODE(MetadataMFMatrix4f)
EVENT_IN(MetadataMFMatrix4f,setValue,mfmatrix4f,setValue,FIELDTYPE_MFMatrix4f)
EVENT_IN(MetadataMFMatrix4f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFMatrix4f,value,mfmatrix4f,value,FIELDTYPE_MFMatrix4f)
EVENT_OUT(MetadataMFMatrix4f,valueChanged,mfmatrix4f,valueChanged,FIELDTYPE_MFMatrix4f)
END_NODE(MetadataMFMatrix4f)

/* MetadataMFNode node */
BEGIN_NODE(MetadataMFNode)
EVENT_IN(MetadataMFNode,setValue,mfnode,setValue,FIELDTYPE_MFNode)
EVENT_IN(MetadataMFNode,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFNode,value,mfnode,value,FIELDTYPE_MFNode)
EVENT_OUT(MetadataMFNode,valueChanged,mfnode,valueChanged,FIELDTYPE_MFNode)
END_NODE(MetadataMFNode)

/* MetadataMFRotation node */
BEGIN_NODE(MetadataMFRotation)
EVENT_IN(MetadataMFRotation,setValue,mfrotation,setValue,FIELDTYPE_MFRotation)
EVENT_IN(MetadataMFRotation,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFRotation,value,mfrotation,value,FIELDTYPE_MFRotation)
EVENT_OUT(MetadataMFRotation,valueChanged,mfrotation,valueChanged,FIELDTYPE_MFRotation)
END_NODE(MetadataMFRotation)

/* MetadataMFString node */
BEGIN_NODE(MetadataMFString)
EVENT_IN(MetadataMFString,setValue,mfstring,setValue,FIELDTYPE_MFString)
EVENT_IN(MetadataMFString,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFString,value,mfstring,value,FIELDTYPE_MFString)
EVENT_OUT(MetadataMFString,valueChanged,mfstring,valueChanged,FIELDTYPE_MFString)
END_NODE(MetadataMFString)

/* MetadataMFTime node */
BEGIN_NODE(MetadataMFTime)
EVENT_IN(MetadataMFTime,setValue,mftime,setValue,FIELDTYPE_MFTime)
EVENT_IN(MetadataMFTime,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFTime,value,mftime,value,FIELDTYPE_MFTime)
EVENT_OUT(MetadataMFTime,valueChanged,mftime,valueChanged,FIELDTYPE_MFTime)
END_NODE(MetadataMFTime)

/* MetadataMFVec2d node */
BEGIN_NODE(MetadataMFVec2d)
EVENT_IN(MetadataMFVec2d,setValue,mfvec2d,setValue,FIELDTYPE_MFVec2d)
EVENT_IN(MetadataMFVec2d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec2d,value,mfvec2d,value,FIELDTYPE_MFVec2d)
EVENT_OUT(MetadataMFVec2d,valueChanged,mfvec2d,valueChanged,FIELDTYPE_MFVec2d)
END_NODE(MetadataMFVec2d)

/* MetadataMFVec2f node */
BEGIN_NODE(MetadataMFVec2f)
EVENT_IN(MetadataMFVec2f,setValue,mfvec2f,setValue,FIELDTYPE_MFVec2f)
EVENT_IN(MetadataMFVec2f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec2f,value,mfvec2f,value,FIELDTYPE_MFVec2f)
EVENT_OUT(MetadataMFVec2f,valueChanged,mfvec2f,valueChanged,FIELDTYPE_MFVec2f)
END_NODE(MetadataMFVec2f)

/* MetadataMFVec3d node */
BEGIN_NODE(MetadataMFVec3d)
EVENT_IN(MetadataMFVec3d,setValue,mfvec3d,setValue,FIELDTYPE_MFVec3d)
EVENT_IN(MetadataMFVec3d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec3d,value,mfvec3d,value,FIELDTYPE_MFVec3d)
EVENT_OUT(MetadataMFVec3d,valueChanged,mfvec3d,valueChanged,FIELDTYPE_MFVec3d)
END_NODE(MetadataMFVec3d)

/* MetadataMFVec3f node */
BEGIN_NODE(MetadataMFVec3f)
EVENT_IN(MetadataMFVec3f,setValue,mfvec3f,setValue,FIELDTYPE_MFVec3f)
EVENT_IN(MetadataMFVec3f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec3f,value,mfvec3f,value,FIELDTYPE_MFVec3f)
EVENT_OUT(MetadataMFVec3f,valueChanged,mfvec3f,valueChanged,FIELDTYPE_MFVec3f)
END_NODE(MetadataMFVec3f)

/* MetadataMFVec4d node */
BEGIN_NODE(MetadataMFVec4d)
EVENT_IN(MetadataMFVec4d,setValue,mfvec4d,setValue,FIELDTYPE_MFVec4d)
EVENT_IN(MetadataMFVec4d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec4d,value,mfvec4d,value,FIELDTYPE_MFVec4d)
EVENT_OUT(MetadataMFVec4d,valueChanged,mfvec4d,valueChanged,FIELDTYPE_MFVec4d)
END_NODE(MetadataMFVec4d)

/* MetadataMFVec4f node */
BEGIN_NODE(MetadataMFVec4f)
EVENT_IN(MetadataMFVec4f,setValue,mfvec4f,setValue,FIELDTYPE_MFVec4f)
EVENT_IN(MetadataMFVec4f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataMFVec4f,value,mfvec4f,value,FIELDTYPE_MFVec4f)
EVENT_OUT(MetadataMFVec4f,valueChanged,mfvec4f,valueChanged,FIELDTYPE_MFVec4f)
END_NODE(MetadataMFVec4f)

/* MetadataSFBool node */
BEGIN_NODE(MetadataSFBool)
EVENT_IN(MetadataSFBool,setValue,sfbool,setValue,FIELDTYPE_SFBool)
EVENT_IN(MetadataSFBool,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFBool,value,sfbool,value,FIELDTYPE_SFBool)
EVENT_OUT(MetadataSFBool,valueChanged,sfbool,valueChanged,FIELDTYPE_SFBool)
END_NODE(MetadataSFBool)

/* MetadataSFColor node */
BEGIN_NODE(MetadataSFColor)
EVENT_IN(MetadataSFColor,setValue,sfcolor,setValue,FIELDTYPE_SFColor)
EVENT_IN(MetadataSFColor,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFColor,value,sfcolor,value,FIELDTYPE_SFColor)
EVENT_OUT(MetadataSFColor,valueChanged,sfcolor,valueChanged,FIELDTYPE_SFColor)
END_NODE(MetadataSFColor)

/* MetadataSFColorRGBA node */
BEGIN_NODE(MetadataSFColorRGBA)
EVENT_IN(MetadataSFColorRGBA,setValue,sfcolorrgba,setValue,FIELDTYPE_SFColorRGBA)
EVENT_IN(MetadataSFColorRGBA,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFColorRGBA,value,sfcolorrgba,value,FIELDTYPE_SFColorRGBA)
EVENT_OUT(MetadataSFColorRGBA,valueChanged,sfcolorrgba,valueChanged,FIELDTYPE_SFColorRGBA)
END_NODE(MetadataSFColorRGBA)

/* MetadataSFDouble node */
BEGIN_NODE(MetadataSFDouble)
EVENT_IN(MetadataSFDouble,setValue,sfdouble,setValue,FIELDTYPE_SFDouble)
EVENT_IN(MetadataSFDouble,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFDouble,value,sfdouble,value,FIELDTYPE_SFDouble)
EVENT_OUT(MetadataSFDouble,valueChanged,sfdouble,valueChanged,FIELDTYPE_SFDouble)
END_NODE(MetadataSFDouble)

/* MetadataSFFloat node */
BEGIN_NODE(MetadataSFFloat)
EVENT_IN(MetadataSFFloat,setValue,sffloat,setValue,FIELDTYPE_SFFloat)
EVENT_IN(MetadataSFFloat,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFFloat,value,sffloat,value,FIELDTYPE_SFFloat)
EVENT_OUT(MetadataSFFloat,valueChanged,sffloat,valueChanged,FIELDTYPE_SFFloat)
END_NODE(MetadataSFFloat)

/* MetadataSFImage node */
BEGIN_NODE(MetadataSFImage)
EVENT_IN(MetadataSFImage,setValue,sfimage,setValue,FIELDTYPE_SFImage)
EVENT_IN(MetadataSFImage,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFImage,value,sfimage,value,FIELDTYPE_SFImage)
EVENT_OUT(MetadataSFImage,valueChanged,sfimage,valueChanged,FIELDTYPE_SFImage)
END_NODE(MetadataSFImage)

/* MetadataSFInt32 node */
BEGIN_NODE(MetadataSFInt32)
EVENT_IN(MetadataSFInt32,setValue,sfint32,setValue,FIELDTYPE_SFInt32)
EVENT_IN(MetadataSFInt32,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFInt32,value,sfint32,value,FIELDTYPE_SFInt32)
EVENT_OUT(MetadataSFInt32,valueChanged,sfint32,valueChanged,FIELDTYPE_SFInt32)
END_NODE(MetadataSFInt32)

/* MetadataSFMatrix3d node */
BEGIN_NODE(MetadataSFMatrix3d)
EVENT_IN(MetadataSFMatrix3d,setValue,sfmatrix3d,setValue,FIELDTYPE_SFMatrix3d)
EVENT_IN(MetadataSFMatrix3d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFMatrix3d,value,sfmatrix3d,value,FIELDTYPE_SFMatrix3d)
EVENT_OUT(MetadataSFMatrix3d,valueChanged,sfmatrix3d,valueChanged,FIELDTYPE_SFMatrix3d)
END_NODE(MetadataSFMatrix3d)

/* MetadataSFMatrix3f node */
BEGIN_NODE(MetadataSFMatrix3f)
EVENT_IN(MetadataSFMatrix3f,setValue,sfmatrix3f,setValue,FIELDTYPE_SFMatrix3f)
EVENT_IN(MetadataSFMatrix3f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFMatrix3f,value,sfmatrix3f,value,FIELDTYPE_SFMatrix3f)
EVENT_OUT(MetadataSFMatrix3f,valueChanged,sfmatrix3f,valueChanged,FIELDTYPE_SFMatrix3f)
END_NODE(MetadataSFMatrix3f)

/* MetadataSFMatrix4d node */
BEGIN_NODE(MetadataSFMatrix4d)
EVENT_IN(MetadataSFMatrix4d,setValue,sfmatrix4d,setValue,FIELDTYPE_SFMatrix4d)
EVENT_IN(MetadataSFMatrix4d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFMatrix4d,value,sfmatrix4d,value,FIELDTYPE_SFMatrix4d)
EVENT_OUT(MetadataSFMatrix4d,valueChanged,sfmatrix4d,valueChanged,FIELDTYPE_SFMatrix4d)
END_NODE(MetadataSFMatrix4d)

/* MetadataSFMatrix4f node */
BEGIN_NODE(MetadataSFMatrix4f)
EVENT_IN(MetadataSFMatrix4f,setValue,sfmatrix4f,setValue,FIELDTYPE_SFMatrix4f)
EVENT_IN(MetadataSFMatrix4f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFMatrix4f,value,sfmatrix4f,value,FIELDTYPE_SFMatrix4f)
EVENT_OUT(MetadataSFMatrix4f,valueChanged,sfmatrix4f,valueChanged,FIELDTYPE_SFMatrix4f)
END_NODE(MetadataSFMatrix4f)

/* MetadataSFNode node */
BEGIN_NODE(MetadataSFNode)
EVENT_IN(MetadataSFNode,setValue,sfnode,setValue,FIELDTYPE_SFNode)
EVENT_IN(MetadataSFNode,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFNode,value,sfnode,value,FIELDTYPE_SFNode)
EVENT_OUT(MetadataSFNode,valueChanged,sfnode,valueChanged,FIELDTYPE_SFNode)
END_NODE(MetadataSFNode)

/* MetadataSFRotation node */
BEGIN_NODE(MetadataSFRotation)
EVENT_IN(MetadataSFRotation,setValue,sfrotation,setValue,FIELDTYPE_SFRotation)
EVENT_IN(MetadataSFRotation,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFRotation,value,sfrotation,value,FIELDTYPE_SFRotation)
EVENT_OUT(MetadataSFRotation,valueChanged,sfrotation,valueChanged,FIELDTYPE_SFRotation)
END_NODE(MetadataSFRotation)

/* MetadataSFString node */
BEGIN_NODE(MetadataSFString)
EVENT_IN(MetadataSFString,setValue,sfstring,setValue,FIELDTYPE_SFString)
EVENT_IN(MetadataSFString,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFString,value,sfstring,value,FIELDTYPE_SFString)
EVENT_OUT(MetadataSFString,valueChanged,sfstring,valueChanged,FIELDTYPE_SFString)
END_NODE(MetadataSFString)

/* MetadataSFTime node */
BEGIN_NODE(MetadataSFTime)
EVENT_IN(MetadataSFTime,setValue,sftime,setValue,FIELDTYPE_SFTime)
EVENT_IN(MetadataSFTime,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFTime,value,sftime,value,FIELDTYPE_SFTime)
EVENT_OUT(MetadataSFTime,valueChanged,sftime,valueChanged,FIELDTYPE_SFTime)
END_NODE(MetadataSFTime)

/* MetadataSFVec2d node */
BEGIN_NODE(MetadataSFVec2d)
EVENT_IN(MetadataSFVec2d,setValue,sfvec2d,setValue,FIELDTYPE_SFVec2d)
EVENT_IN(MetadataSFVec2d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec2d,value,sfvec2d,value,FIELDTYPE_SFVec2d)
EVENT_OUT(MetadataSFVec2d,valueChanged,sfvec2d,valueChanged,FIELDTYPE_SFVec2d)
END_NODE(MetadataSFVec2d)

/* MetadataSFVec2f node */
BEGIN_NODE(MetadataSFVec2f)
EVENT_IN(MetadataSFVec2f,setValue,sfvec2f,setValue,FIELDTYPE_SFVec2f)
EVENT_IN(MetadataSFVec2f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec2f,value,sfvec2f,value,FIELDTYPE_SFVec2f)
EVENT_OUT(MetadataSFVec2f,valueChanged,sfvec2f,valueChanged,FIELDTYPE_SFVec2f)
END_NODE(MetadataSFVec2f)

/* MetadataSFVec3d node */
BEGIN_NODE(MetadataSFVec3d)
EVENT_IN(MetadataSFVec3d,setValue,sfvec3d,setValue,FIELDTYPE_SFVec3d)
EVENT_IN(MetadataSFVec3d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec3d,value,sfvec3d,value,FIELDTYPE_SFVec3d)
EVENT_OUT(MetadataSFVec3d,valueChanged,sfvec3d,valueChanged,FIELDTYPE_SFVec3d)
END_NODE(MetadataSFVec3d)

/* MetadataSFVec3f node */
BEGIN_NODE(MetadataSFVec3f)
EVENT_IN(MetadataSFVec3f,setValue,sfvec3f,setValue,FIELDTYPE_SFVec3f)
EVENT_IN(MetadataSFVec3f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec3f,value,sfvec3f,value,FIELDTYPE_SFVec3f)
EVENT_OUT(MetadataSFVec3f,valueChanged,sfvec3f,valueChanged,FIELDTYPE_SFVec3f)
END_NODE(MetadataSFVec3f)

/* MetadataSFVec4d node */
BEGIN_NODE(MetadataSFVec4d)
EVENT_IN(MetadataSFVec4d,setValue,sfvec4d,setValue,FIELDTYPE_SFVec4d)
EVENT_IN(MetadataSFVec4d,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec4d,value,sfvec4d,value,FIELDTYPE_SFVec4d)
EVENT_OUT(MetadataSFVec4d,valueChanged,sfvec4d,valueChanged,FIELDTYPE_SFVec4d)
END_NODE(MetadataSFVec4d)

/* MetadataSFVec4f node */
BEGIN_NODE(MetadataSFVec4f)
EVENT_IN(MetadataSFVec4f,setValue,sfvec4f,setValue,FIELDTYPE_SFVec4f)
EVENT_IN(MetadataSFVec4f,tickTime,sftime,tickTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MetadataSFVec4f,value,sfvec4f,value,FIELDTYPE_SFVec4f)
EVENT_OUT(MetadataSFVec4f,valueChanged,sfvec4f,valueChanged,FIELDTYPE_SFVec4f)
END_NODE(MetadataSFVec4f)

/* MetadataSet node */
BEGIN_NODE(MetadataSet)
EXPOSED_FIELD(MetadataSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MetadataSet,name,sfstring,name,FIELDTYPE_SFString)
FIELD(MetadataSet,reference,sfstring,reference,FIELDTYPE_SFString)
EXPOSED_FIELD(MetadataSet,value,mfnode,value,FIELDTYPE_MFNode)
END_NODE(MetadataSet)

/* MetadataString node */
BEGIN_NODE(MetadataString)
EXPOSED_FIELD(MetadataString,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MetadataString,name,sfstring,name,FIELDTYPE_SFString)
FIELD(MetadataString,reference,sfstring,reference,FIELDTYPE_SFString)
EXPOSED_FIELD(MetadataString,value,mfstring,value,FIELDTYPE_MFString)
END_NODE(MetadataString)

/* MovieTexture node */
BEGIN_NODE(MovieTexture)
EXPOSED_FIELD(MovieTexture,description,sfstring,description,FIELDTYPE_SFString)
EVENT_OUT(MovieTexture,duration_changed,sftime,duration_changed,FIELDTYPE_SFTime)
EVENT_OUT(MovieTexture,elapsedTime,sftime,elapsedTime,FIELDTYPE_SFTime)
EVENT_OUT(MovieTexture,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(MovieTexture,isPaused,sftime,isPaused,FIELDTYPE_SFTime)
EXPOSED_FIELD(MovieTexture,loop,sfbool,loop,FIELDTYPE_SFBool)
EXPOSED_FIELD(MovieTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MovieTexture,pauseTime,sftime,pauseTime,FIELDTYPE_SFTime)
FIELD(MovieTexture,repeatS,sfbool,repeatS,FIELDTYPE_SFBool)
FIELD(MovieTexture,repeatT,sfbool,repeatT,FIELDTYPE_SFBool)
EXPOSED_FIELD(MovieTexture,resumeTime,sftime,resumeTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MovieTexture,speed,sffloat,speed,FIELDTYPE_SFFloat)
EXPOSED_FIELD(MovieTexture,startTime,sftime,startTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(MovieTexture,stopTime,sftime,stopTime,FIELDTYPE_SFTime)
FIELD(MovieTexture,textureProperties,sfnode,textureProperties,FIELDTYPE_SFNode)
EXPOSED_FIELD(MovieTexture,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(MovieTexture)

/* MultiTexture node */
BEGIN_NODE(MultiTexture)
EXPOSED_FIELD(MultiTexture,alpha,sffloat,alpha,FIELDTYPE_SFFloat)
EXPOSED_FIELD(MultiTexture,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(MultiTexture,function,mfstring,function,FIELDTYPE_MFString)
EXPOSED_FIELD(MultiTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MultiTexture,mode,mfstring,mode,FIELDTYPE_MFString)
EXPOSED_FIELD(MultiTexture,source,mfstring,source,FIELDTYPE_MFString)
EXPOSED_FIELD(MultiTexture,texture,mfnode,texture,FIELDTYPE_MFNode)
END_NODE(MultiTexture)

/* MultiTextureCoordinate node */
BEGIN_NODE(MultiTextureCoordinate)
EXPOSED_FIELD(MultiTextureCoordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MultiTextureCoordinate,texCoord,mfnode,texCoord,FIELDTYPE_MFNode)
END_NODE(MultiTextureCoordinate)

/* MultiTextureTransform node */
BEGIN_NODE(MultiTextureTransform)
EXPOSED_FIELD(MultiTextureTransform,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(MultiTextureTransform,textureTransform,mfnode,textureTransform,FIELDTYPE_MFNode)
END_NODE(MultiTextureTransform)

/* NavigationInfo node */
BEGIN_NODE(NavigationInfo)
EXPOSED_FIELD(NavigationInfo,avatarSize,mffloat,avatarSize,FIELDTYPE_MFFloat)
EVENT_OUT(NavigationInfo,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(NavigationInfo,headlight,sfbool,headlight,FIELDTYPE_SFBool)
EVENT_OUT(NavigationInfo,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(NavigationInfo,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(NavigationInfo,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
EXPOSED_FIELD(NavigationInfo,speed,sffloat,speed,FIELDTYPE_SFFloat)
EVENT_OUT(NavigationInfo,transitionComplete,sfbool,transitionComplete,FIELDTYPE_SFBool)
EXPOSED_FIELD(NavigationInfo,transitionTime,sftime,transitionTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(NavigationInfo,transitionType,mfstring,transitionType,FIELDTYPE_MFString)
EXPOSED_FIELD(NavigationInfo,type,mfstring,type,FIELDTYPE_MFString)
EXPOSED_FIELD(NavigationInfo,visibilityLimit,sffloat,visibilityLimit,FIELDTYPE_SFFloat)
END_NODE(NavigationInfo)

/* Normal node */
BEGIN_NODE(Normal)
EXPOSED_FIELD(Normal,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Normal,vector,mfvec3f,vector,FIELDTYPE_MFVec3f)
END_NODE(Normal)

/* NormalInterpolator node */
BEGIN_NODE(NormalInterpolator)
EXPOSED_FIELD(NormalInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(NormalInterpolator,keyValue,mfvec3f,keyValue,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(NormalInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(NormalInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(NormalInterpolator,value_changed,mfvec3f,value_changed,FIELDTYPE_MFVec3f)
END_NODE(NormalInterpolator)

/* NurbsCurve node */
BEGIN_NODE(NurbsCurve)
EXPOSED_FIELD(NurbsCurve,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
FIELD(NurbsCurve,knot,mfdouble,knot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsCurve,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsCurve,order,sfint32,order,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsCurve,tessellation,sfint32,tessellation,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsCurve,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsCurve)

/* NurbsCurve2D node */
BEGIN_NODE(NurbsCurve2D)
EXPOSED_FIELD(NurbsCurve2D,controlPoint,mfvec2d,controlPoint,FIELDTYPE_MFVec2d)
FIELD(NurbsCurve2D,knot,mfdouble,knot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsCurve2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsCurve2D,order,sfint32,order,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsCurve2D,tessellation,sfint32,tessellation,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsCurve2D,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsCurve2D)

/* NurbsOrientationInterpolator node */
BEGIN_NODE(NurbsOrientationInterpolator)
EXPOSED_FIELD(NurbsOrientationInterpolator,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsOrientationInterpolator,knot,mfdouble,knot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsOrientationInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsOrientationInterpolator,order,sfint32,order,FIELDTYPE_SFInt32)
EVENT_IN(NurbsOrientationInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(NurbsOrientationInterpolator,value_changed,sfrotation,value_changed,FIELDTYPE_SFRotation)
EXPOSED_FIELD(NurbsOrientationInterpolator,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsOrientationInterpolator)

/* NurbsPatchSurface node */
BEGIN_NODE(NurbsPatchSurface)
EXPOSED_FIELD(NurbsPatchSurface,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsPatchSurface,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(NurbsPatchSurface,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsPatchSurface,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
FIELD(NurbsPatchSurface,uClosed,sfbool,uClosed,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsPatchSurface,uDimension,sfint32,uDimension,FIELDTYPE_SFInt32)
FIELD(NurbsPatchSurface,uKnot,mfdouble,uKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsPatchSurface,uOrder,sfint32,uOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsPatchSurface,uTessellation,sfint32,uTessellation,FIELDTYPE_SFInt32)
FIELD(NurbsPatchSurface,vClosed,sfbool,vClosed,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsPatchSurface,vDimension,sfint32,vDimension,FIELDTYPE_SFInt32)
FIELD(NurbsPatchSurface,vKnot,mfdouble,vKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsPatchSurface,vOrder,sfint32,vOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsPatchSurface,vTessellation,sfint32,vTessellation,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsPatchSurface,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsPatchSurface)

/* NurbsPositionInterpolator node */
BEGIN_NODE(NurbsPositionInterpolator)
EXPOSED_FIELD(NurbsPositionInterpolator,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsPositionInterpolator,knot,mfdouble,knot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsPositionInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsPositionInterpolator,order,sfint32,order,FIELDTYPE_SFInt32)
EVENT_IN(NurbsPositionInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(NurbsPositionInterpolator,value_changed,sfvec3f,value_changed,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(NurbsPositionInterpolator,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsPositionInterpolator)

/* NurbsSet node */
BEGIN_NODE(NurbsSet)
EVENT_IN(NurbsSet,addGeometry,mfnode,addGeometry,FIELDTYPE_MFNode)
FIELD(NurbsSet,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(NurbsSet,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(NurbsSet,geometry,mfnode,geometry,FIELDTYPE_MFNode)
EXPOSED_FIELD(NurbsSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(NurbsSet,removeGeometry,mfnode,removeGeometry,FIELDTYPE_MFNode)
EXPOSED_FIELD(NurbsSet,tessellationScale,sffloat,tessellationScale,FIELDTYPE_SFFloat)
END_NODE(NurbsSet)

/* NurbsSurfaceInterpolator node */
BEGIN_NODE(NurbsSurfaceInterpolator)
EXPOSED_FIELD(NurbsSurfaceInterpolator,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsSurfaceInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(NurbsSurfaceInterpolator,normal_changed,sfvec3f,normal_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(NurbsSurfaceInterpolator,position_changed,sfvec3f,position_changed,FIELDTYPE_SFVec3f)
EVENT_IN(NurbsSurfaceInterpolator,set_fraction,sfvec2f,set_fraction,FIELDTYPE_SFVec2f)
EXPOSED_FIELD(NurbsSurfaceInterpolator,uDimension,sfint32,uDimension,FIELDTYPE_SFInt32)
FIELD(NurbsSurfaceInterpolator,uKnot,mfdouble,uKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsSurfaceInterpolator,uOrder,sfint32,uOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsSurfaceInterpolator,vDimension,sfint32,vDimension,FIELDTYPE_SFInt32)
FIELD(NurbsSurfaceInterpolator,vKnot,mfdouble,vKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsSurfaceInterpolator,vOrder,sfint32,vOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsSurfaceInterpolator,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsSurfaceInterpolator)

/* NurbsSweptSurface node */
BEGIN_NODE(NurbsSweptSurface)
FIELD(NurbsSweptSurface,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsSweptSurface,crossSectionCurve,sfnode,crossSectionCurve,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsSweptSurface,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(NurbsSweptSurface,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsSweptSurface,trajectoryCurve,sfnode,trajectoryCurve,FIELDTYPE_SFNode)
END_NODE(NurbsSweptSurface)

/* NurbsSwungSurface node */
BEGIN_NODE(NurbsSwungSurface)
FIELD(NurbsSwungSurface,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsSwungSurface,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsSwungSurface,profileCurve,sfnode,profileCurve,FIELDTYPE_SFNode)
FIELD(NurbsSwungSurface,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsSwungSurface,trajectoryCurve,sfnode,trajectoryCurve,FIELDTYPE_SFNode)
END_NODE(NurbsSwungSurface)

/* NurbsTextureCoordinate node */
BEGIN_NODE(NurbsTextureCoordinate)
EXPOSED_FIELD(NurbsTextureCoordinate,controlPoint,mfvec2f,controlPoint,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(NurbsTextureCoordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsTextureCoordinate,uDimension,sfint32,uDimension,FIELDTYPE_SFInt32)
FIELD(NurbsTextureCoordinate,uKnot,mfdouble,uKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsTextureCoordinate,uOrder,sfint32,uOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsTextureCoordinate,vDimension,sfint32,vDimension,FIELDTYPE_SFInt32)
FIELD(NurbsTextureCoordinate,vKnot,mfdouble,vKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsTextureCoordinate,vOrder,sfint32,vOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsTextureCoordinate,weight,mffloat,weight,FIELDTYPE_MFFloat)
END_NODE(NurbsTextureCoordinate)

/* NurbsTrimmedSurface node */
BEGIN_NODE(NurbsTrimmedSurface)
EVENT_IN(NurbsTrimmedSurface,addTrimmingContour,mfnode,addTrimmingContour,FIELDTYPE_MFNode)
EXPOSED_FIELD(NurbsTrimmedSurface,controlPoint,sfnode,controlPoint,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsTrimmedSurface,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(NurbsTrimmedSurface,removeTrimmingContour,mfnode,removeTrimmingContour,FIELDTYPE_MFNode)
FIELD(NurbsTrimmedSurface,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsTrimmedSurface,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(NurbsTrimmedSurface,trimmingContour,mfnode,trimmingContour,FIELDTYPE_MFNode)
FIELD(NurbsTrimmedSurface,uClosed,sfbool,uClosed,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsTrimmedSurface,uDimension,sfint32,uDimension,FIELDTYPE_SFInt32)
FIELD(NurbsTrimmedSurface,uKnot,mfdouble,uKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsTrimmedSurface,uOrder,sfint32,uOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsTrimmedSurface,uTessellation,sfint32,uTessellation,FIELDTYPE_SFInt32)
FIELD(NurbsTrimmedSurface,vClosed,sfbool,vClosed,FIELDTYPE_SFBool)
EXPOSED_FIELD(NurbsTrimmedSurface,vDimension,sfint32,vDimension,FIELDTYPE_SFInt32)
FIELD(NurbsTrimmedSurface,vKnot,mfdouble,vKnot,FIELDTYPE_MFDouble)
EXPOSED_FIELD(NurbsTrimmedSurface,vOrder,sfint32,vOrder,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsTrimmedSurface,vTessellation,sfint32,vTessellation,FIELDTYPE_SFInt32)
EXPOSED_FIELD(NurbsTrimmedSurface,weight,mfdouble,weight,FIELDTYPE_MFDouble)
END_NODE(NurbsTrimmedSurface)

/* OSC_Sensor node */
BEGIN_NODE(OSC_Sensor)
EXPOSED_FIELD(OSC_Sensor,FIFOsize,sfint32,FIFOsize,FIELDTYPE_SFInt32)
EXPOSED_FIELD(OSC_Sensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(OSC_Sensor,filter,sfstring,filter,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,floatInp,sffloat,floatInp,FIELDTYPE_SFFloat)
EXPOSED_FIELD(OSC_Sensor,gotEvents,sfint32,gotEvents,FIELDTYPE_SFInt32)
EXPOSED_FIELD(OSC_Sensor,handler,sfstring,handler,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,int32Inp,sfint32,int32Inp,FIELDTYPE_SFInt32)
EXPOSED_FIELD(OSC_Sensor,listenfor,sfstring,listenfor,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(OSC_Sensor,port,sfint32,port,FIELDTYPE_SFInt32)
EXPOSED_FIELD(OSC_Sensor,protocol,sfstring,protocol,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,stringInp,sfstring,stringInp,FIELDTYPE_SFString)
EXPOSED_FIELD(OSC_Sensor,talksTo,mfstring,talksTo,FIELDTYPE_MFString)
END_NODE(OSC_Sensor)

/* OrientationInterpolator node */
BEGIN_NODE(OrientationInterpolator)
EXPOSED_FIELD(OrientationInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(OrientationInterpolator,keyValue,mfrotation,keyValue,FIELDTYPE_MFRotation)
EXPOSED_FIELD(OrientationInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(OrientationInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(OrientationInterpolator,value_changed,sfrotation,value_changed,FIELDTYPE_SFRotation)
END_NODE(OrientationInterpolator)

/* OrthoViewpoint node */
BEGIN_NODE(OrthoViewpoint)
EVENT_OUT(OrthoViewpoint,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(OrthoViewpoint,centerOfRotation,sfvec3f,centerOfRotation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(OrthoViewpoint,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(OrthoViewpoint,fieldOfView,mffloat,fieldOfView,FIELDTYPE_MFFloat)
EVENT_OUT(OrthoViewpoint,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(OrthoViewpoint,jump,sfbool,jump,FIELDTYPE_SFBool)
EXPOSED_FIELD(OrthoViewpoint,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(OrthoViewpoint,orientation,sfrotation,orientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(OrthoViewpoint,position,sfvec3f,position,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(OrthoViewpoint,retainUserOffsets,sfbool,retainUserOffsets,FIELDTYPE_SFBool)
EVENT_IN(OrthoViewpoint,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
END_NODE(OrthoViewpoint)

/* PackagedShader node */
BEGIN_NODE(PackagedShader)
EVENT_IN(PackagedShader,activate,sfbool,activate,FIELDTYPE_SFBool)
EVENT_OUT(PackagedShader,isSelected,sfbool,isSelected,FIELDTYPE_SFBool)
EVENT_OUT(PackagedShader,isValid,sfbool,isValid,FIELDTYPE_SFBool)
FIELD(PackagedShader,language,sfstring,language,FIELDTYPE_SFString)
EXPOSED_FIELD(PackagedShader,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(PackagedShader,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(PackagedShader)

/* PickableGroup node */
BEGIN_NODE(PickableGroup)
EXPOSED_FIELD(PickableGroup,FreeWRL_PROTOInterfaceNodes,mfnode,FreeWRL_PROTOInterfaceNodes,FIELDTYPE_MFNode)
FIELD(PickableGroup,FreeWRL__protoDef,sfint32,FreeWRL__protoDef,FIELDTYPE_SFInt32)
EVENT_IN(PickableGroup,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(PickableGroup,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(PickableGroup,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(PickableGroup,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(PickableGroup,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(PickableGroup,objectType,mfstring,objectType,FIELDTYPE_MFString)
EXPOSED_FIELD(PickableGroup,pickable,sfbool,pickable,FIELDTYPE_SFBool)
EVENT_IN(PickableGroup,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
END_NODE(PickableGroup)

/* PixelTexture node */
BEGIN_NODE(PixelTexture)
EXPOSED_FIELD(PixelTexture,image,sfimage,image,FIELDTYPE_SFImage)
EXPOSED_FIELD(PixelTexture,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(PixelTexture,repeatS,sfbool,repeatS,FIELDTYPE_SFBool)
FIELD(PixelTexture,repeatT,sfbool,repeatT,FIELDTYPE_SFBool)
FIELD(PixelTexture,textureProperties,sfnode,textureProperties,FIELDTYPE_SFNode)
END_NODE(PixelTexture)

/* PlaneSensor node */
BEGIN_NODE(PlaneSensor)
EXPOSED_FIELD(PlaneSensor,autoOffset,sfbool,autoOffset,FIELDTYPE_SFBool)
EXPOSED_FIELD(PlaneSensor,axisRotation,sfrotation,axisRotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(PlaneSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(PlaneSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(PlaneSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(PlaneSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(PlaneSensor,maxPosition,sfvec2f,maxPosition,FIELDTYPE_SFVec2f)
EXPOSED_FIELD(PlaneSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(PlaneSensor,minPosition,sfvec2f,minPosition,FIELDTYPE_SFVec2f)
EXPOSED_FIELD(PlaneSensor,offset,sfvec3f,offset,FIELDTYPE_SFVec3f)
EVENT_OUT(PlaneSensor,trackPoint_changed,sfvec3f,trackPoint_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(PlaneSensor,translation_changed,sfvec3f,translation_changed,FIELDTYPE_SFVec3f)
END_NODE(PlaneSensor)

/* PointLight node */
BEGIN_NODE(PointLight)
EXPOSED_FIELD(PointLight,ambientIntensity,sffloat,ambientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(PointLight,attenuation,sfvec3f,attenuation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(PointLight,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(PointLight,global,sfbool,global,FIELDTYPE_SFBool)
EXPOSED_FIELD(PointLight,intensity,sffloat,intensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(PointLight,location,sfvec3f,location,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(PointLight,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(PointLight,on,sfbool,on,FIELDTYPE_SFBool)
EXPOSED_FIELD(PointLight,radius,sffloat,radius,FIELDTYPE_SFFloat)
END_NODE(PointLight)

/* PointPickSensor node */
BEGIN_NODE(PointPickSensor)
EXPOSED_FIELD(PointPickSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
FIELD(PointPickSensor,intersectionType,sfstring,intersectionType,FIELDTYPE_SFString)
EVENT_OUT(PointPickSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EXPOSED_FIELD(PointPickSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(PointPickSensor,objectType,mfstring,objectType,FIELDTYPE_MFString)
EXPOSED_FIELD(PointPickSensor,pickTarget,mfnode,pickTarget,FIELDTYPE_MFNode)
EVENT_OUT(PointPickSensor,pickedGeometry,mfnode,pickedGeometry,FIELDTYPE_MFNode)
EVENT_OUT(PointPickSensor,pickedPoint,mfvec3f,pickedPoint,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(PointPickSensor,pickingGeometry,sfnode,pickingGeometry,FIELDTYPE_SFNode)
EVENT_IN(PointPickSensor,set_intersectionType,sfstring,set_intersectionType,FIELDTYPE_SFString)
EVENT_IN(PointPickSensor,set_sortOrder,sfstring,set_sortOrder,FIELDTYPE_SFString)
FIELD(PointPickSensor,sortOrder,sfstring,sortOrder,FIELDTYPE_SFString)
END_NODE(PointPickSensor)

/* PointSet node */
BEGIN_NODE(PointSet)
EXPOSED_FIELD(PointSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
EXPOSED_FIELD(PointSet,color,sfnode,color,FIELDTYPE_SFNode)
EXPOSED_FIELD(PointSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(PointSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(PointSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(PointSet)

/* Polyline2D node */
BEGIN_NODE(Polyline2D)
FIELD(Polyline2D,lineSegments,mfvec2f,lineSegments,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(Polyline2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(Polyline2D)

/* Polypoint2D node */
BEGIN_NODE(Polypoint2D)
EXPOSED_FIELD(Polypoint2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Polypoint2D,point,mfvec2f,point,FIELDTYPE_MFVec2f)
END_NODE(Polypoint2D)

/* PositionInterpolator node */
BEGIN_NODE(PositionInterpolator)
EXPOSED_FIELD(PositionInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(PositionInterpolator,keyValue,mfvec3f,keyValue,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(PositionInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(PositionInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(PositionInterpolator,value_changed,sfvec3f,value_changed,FIELDTYPE_SFVec3f)
END_NODE(PositionInterpolator)

/* PositionInterpolator2D node */
BEGIN_NODE(PositionInterpolator2D)
EXPOSED_FIELD(PositionInterpolator2D,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(PositionInterpolator2D,keyValue,mfvec2f,keyValue,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(PositionInterpolator2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(PositionInterpolator2D,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(PositionInterpolator2D,value_changed,sfvec2f,value_changed,FIELDTYPE_SFVec2f)
END_NODE(PositionInterpolator2D)

/* ProgramShader node */
BEGIN_NODE(ProgramShader)
EVENT_IN(ProgramShader,activate,sfbool,activate,FIELDTYPE_SFBool)
EVENT_OUT(ProgramShader,isSelected,sfbool,isSelected,FIELDTYPE_SFBool)
EVENT_OUT(ProgramShader,isValid,sfbool,isValid,FIELDTYPE_SFBool)
FIELD(ProgramShader,language,sfstring,language,FIELDTYPE_SFString)
EXPOSED_FIELD(ProgramShader,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ProgramShader,programs,mfnode,programs,FIELDTYPE_MFNode)
END_NODE(ProgramShader)

/* Proto node */
BEGIN_NODE(Proto)
EVENT_IN(Proto,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Proto,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Proto,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Proto,load,sfbool,load,FIELDTYPE_SFBool)
EXPOSED_FIELD(Proto,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Proto,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Proto,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(Proto)

/* ProximitySensor node */
BEGIN_NODE(ProximitySensor)
EXPOSED_FIELD(ProximitySensor,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EVENT_OUT(ProximitySensor,centerOfRotation_changed,sfvec3f,centerOfRotation_changed,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(ProximitySensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(ProximitySensor,enterTime,sftime,enterTime,FIELDTYPE_SFTime)
EVENT_OUT(ProximitySensor,exitTime,sftime,exitTime,FIELDTYPE_SFTime)
EVENT_OUT(ProximitySensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EXPOSED_FIELD(ProximitySensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(ProximitySensor,orientation_changed,sfrotation,orientation_changed,FIELDTYPE_SFRotation)
EVENT_OUT(ProximitySensor,position_changed,sfvec3f,position_changed,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(ProximitySensor,size,sfvec3f,size,FIELDTYPE_SFVec3f)
END_NODE(ProximitySensor)

/* QuadSet node */
BEGIN_NODE(QuadSet)
EXPOSED_FIELD(QuadSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(QuadSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(QuadSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(QuadSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(QuadSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(QuadSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(QuadSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(QuadSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(QuadSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
FIELD(QuadSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(QuadSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(QuadSet)

/* ReceiverPdu node */
BEGIN_NODE(ReceiverPdu)
EXPOSED_FIELD(ReceiverPdu,address,sfstring,address,FIELDTYPE_SFString)
EXPOSED_FIELD(ReceiverPdu,applicationID,sfint32,applicationID,FIELDTYPE_SFInt32)
FIELD(ReceiverPdu,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(ReceiverPdu,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(ReceiverPdu,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(ReceiverPdu,entityID,sfint32,entityID,FIELDTYPE_SFInt32)
EVENT_OUT(ReceiverPdu,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(ReceiverPdu,isNetworkReader,sfbool,isNetworkReader,FIELDTYPE_SFBool)
EVENT_OUT(ReceiverPdu,isNetworkWriter,sfbool,isNetworkWriter,FIELDTYPE_SFBool)
EVENT_OUT(ReceiverPdu,isRtpHeaderHeard,sfbool,isRtpHeaderHeard,FIELDTYPE_SFBool)
EVENT_OUT(ReceiverPdu,isStandAlone,sfbool,isStandAlone,FIELDTYPE_SFBool)
EXPOSED_FIELD(ReceiverPdu,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ReceiverPdu,multicastRelayHost,sfstring,multicastRelayHost,FIELDTYPE_SFString)
EXPOSED_FIELD(ReceiverPdu,multicastRelayPort,sfint32,multicastRelayPort,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,networkMode,sfstring,networkMode,FIELDTYPE_SFString)
EXPOSED_FIELD(ReceiverPdu,port,sfint32,port,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,radioID,sfint32,radioID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,readInterval,sffloat,readInterval,FIELDTYPE_SFFloat)
EXPOSED_FIELD(ReceiverPdu,receivedPower,sffloat,receivedPower,FIELDTYPE_SFFloat)
EXPOSED_FIELD(ReceiverPdu,receiverState,sfint32,receiverState,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,rtpHeaderExpected,sfbool,rtpHeaderExpected,FIELDTYPE_SFBool)
EXPOSED_FIELD(ReceiverPdu,siteID,sfint32,siteID,FIELDTYPE_SFInt32)
EVENT_OUT(ReceiverPdu,timestamp,sftime,timestamp,FIELDTYPE_SFTime)
EXPOSED_FIELD(ReceiverPdu,transmitterApplicationID,sfint32,transmitterApplicationID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,transmitterEntityID,sfint32,transmitterEntityID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,transmitterRadioID,sfint32,transmitterRadioID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,transmitterSiteID,sfint32,transmitterSiteID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,whichGeometry,sfint32,whichGeometry,FIELDTYPE_SFInt32)
EXPOSED_FIELD(ReceiverPdu,writeInterval,sffloat,writeInterval,FIELDTYPE_SFFloat)
END_NODE(ReceiverPdu)

/* Rectangle2D node */
BEGIN_NODE(Rectangle2D)
EXPOSED_FIELD(Rectangle2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Rectangle2D,size,sfvec2f,size,FIELDTYPE_SFVec2f)
FIELD(Rectangle2D,solid,sfbool,solid,FIELDTYPE_SFBool)
END_NODE(Rectangle2D)

/* ScalarInterpolator node */
BEGIN_NODE(ScalarInterpolator)
EXPOSED_FIELD(ScalarInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(ScalarInterpolator,keyValue,mffloat,keyValue,FIELDTYPE_MFFloat)
EXPOSED_FIELD(ScalarInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(ScalarInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(ScalarInterpolator,value_changed,sffloat,value_changed,FIELDTYPE_SFFloat)
END_NODE(ScalarInterpolator)

/* Script node */
BEGIN_NODE(Script)
FIELD(Script,directOutput,sfbool,directOutput,FIELDTYPE_SFBool)
EXPOSED_FIELD(Script,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(Script,mustEvaluate,sfbool,mustEvaluate,FIELDTYPE_SFBool)
EXPOSED_FIELD(Script,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(Script)

/* ShaderPart node */
BEGIN_NODE(ShaderPart)
EXPOSED_FIELD(ShaderPart,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ShaderPart,type,sfstring,type,FIELDTYPE_SFString)
EXPOSED_FIELD(ShaderPart,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(ShaderPart)

/* ShaderProgram node */
BEGIN_NODE(ShaderProgram)
EXPOSED_FIELD(ShaderProgram,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ShaderProgram,type,sfstring,type,FIELDTYPE_SFString)
EXPOSED_FIELD(ShaderProgram,url,mfstring,url,FIELDTYPE_MFString)
END_NODE(ShaderProgram)

/* Shape node */
BEGIN_NODE(Shape)
EXPOSED_FIELD(Shape,appearance,sfnode,appearance,FIELDTYPE_SFNode)
FIELD(Shape,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Shape,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Shape,geometry,sfnode,geometry,FIELDTYPE_SFNode)
EXPOSED_FIELD(Shape,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(Shape)

/* SignalPdu node */
BEGIN_NODE(SignalPdu)
EXPOSED_FIELD(SignalPdu,address,sfstring,address,FIELDTYPE_SFString)
EXPOSED_FIELD(SignalPdu,applicationID,sfint32,applicationID,FIELDTYPE_SFInt32)
FIELD(SignalPdu,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(SignalPdu,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(SignalPdu,data,mfint32,data,FIELDTYPE_MFInt32)
EXPOSED_FIELD(SignalPdu,dataLength,sfint32,dataLength,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(SignalPdu,encodingScheme,sfint32,encodingScheme,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,entityID,sfint32,entityID,FIELDTYPE_SFInt32)
EVENT_OUT(SignalPdu,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(SignalPdu,isNetworkReader,sfbool,isNetworkReader,FIELDTYPE_SFBool)
EVENT_OUT(SignalPdu,isNetworkWriter,sfbool,isNetworkWriter,FIELDTYPE_SFBool)
EVENT_OUT(SignalPdu,isRtpHeaderHeard,sfbool,isRtpHeaderHeard,FIELDTYPE_SFBool)
EVENT_OUT(SignalPdu,isStandAlone,sfbool,isStandAlone,FIELDTYPE_SFBool)
EXPOSED_FIELD(SignalPdu,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SignalPdu,multicastRelayHost,sfstring,multicastRelayHost,FIELDTYPE_SFString)
EXPOSED_FIELD(SignalPdu,multicastRelayPort,sfint32,multicastRelayPort,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,networkMode,sfstring,networkMode,FIELDTYPE_SFString)
EXPOSED_FIELD(SignalPdu,port,sfint32,port,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,radioID,sfint32,radioID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,readInterval,sffloat,readInterval,FIELDTYPE_SFFloat)
EXPOSED_FIELD(SignalPdu,rtpHeaderExpected,sfbool,rtpHeaderExpected,FIELDTYPE_SFBool)
EXPOSED_FIELD(SignalPdu,sampleRate,sfint32,sampleRate,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,samples,sfint32,samples,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,siteID,sfint32,siteID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,tdlType,sfint32,tdlType,FIELDTYPE_SFInt32)
EVENT_OUT(SignalPdu,timestamp,sftime,timestamp,FIELDTYPE_SFTime)
EXPOSED_FIELD(SignalPdu,whichGeometry,sfint32,whichGeometry,FIELDTYPE_SFInt32)
EXPOSED_FIELD(SignalPdu,writeInterval,sffloat,writeInterval,FIELDTYPE_SFFloat)
END_NODE(SignalPdu)

/* Sound node */
BEGIN_NODE(Sound)
EXPOSED_FIELD(Sound,direction,sfvec3f,direction,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Sound,intensity,sffloat,intensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,location,sfvec3f,location,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Sound,maxBack,sffloat,maxBack,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,maxFront,sffloat,maxFront,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Sound,minBack,sffloat,minBack,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,minFront,sffloat,minFront,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,priority,sffloat,priority,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Sound,source,sfnode,source,FIELDTYPE_SFNode)
FIELD(Sound,spatialize,sfbool,spatialize,FIELDTYPE_SFBool)
END_NODE(Sound)

/* Sphere node */
BEGIN_NODE(Sphere)
EXPOSED_FIELD(Sphere,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Sphere,radius,sffloat,radius,FIELDTYPE_SFFloat)
FIELD(Sphere,solid,sfbool,solid,FIELDTYPE_SFBool)
END_NODE(Sphere)

/* SphereSensor node */
BEGIN_NODE(SphereSensor)
EXPOSED_FIELD(SphereSensor,autoOffset,sfbool,autoOffset,FIELDTYPE_SFBool)
EXPOSED_FIELD(SphereSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(SphereSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(SphereSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(SphereSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(SphereSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SphereSensor,offset,sfrotation,offset,FIELDTYPE_SFRotation)
EVENT_OUT(SphereSensor,rotation_changed,sfrotation,rotation_changed,FIELDTYPE_SFRotation)
EVENT_OUT(SphereSensor,trackPoint_changed,sfvec3f,trackPoint_changed,FIELDTYPE_SFVec3f)
END_NODE(SphereSensor)

/* SplinePositionInterpolator node */
BEGIN_NODE(SplinePositionInterpolator)
EXPOSED_FIELD(SplinePositionInterpolator,closed,sfbool,closed,FIELDTYPE_SFBool)
EXPOSED_FIELD(SplinePositionInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SplinePositionInterpolator,keyValue,mfvec3f,keyValue,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(SplinePositionInterpolator,keyVelocity,mfvec3f,keyVelocity,FIELDTYPE_MFVec3f)
EXPOSED_FIELD(SplinePositionInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SplinePositionInterpolator,normalizeVelocity,sfbool,normalizeVelocity,FIELDTYPE_SFBool)
EVENT_IN(SplinePositionInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(SplinePositionInterpolator,value_changed,sfvec3f,value_changed,FIELDTYPE_SFVec3f)
END_NODE(SplinePositionInterpolator)

/* SplinePositionInterpolator2D node */
BEGIN_NODE(SplinePositionInterpolator2D)
EXPOSED_FIELD(SplinePositionInterpolator2D,closed,sfbool,closed,FIELDTYPE_SFBool)
EXPOSED_FIELD(SplinePositionInterpolator2D,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SplinePositionInterpolator2D,keyValue,mfvec2f,keyValue,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(SplinePositionInterpolator2D,keyVelocity,mfvec2f,keyVelocity,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(SplinePositionInterpolator2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SplinePositionInterpolator2D,normalizeVelocity,sfbool,normalizeVelocity,FIELDTYPE_SFBool)
EVENT_IN(SplinePositionInterpolator2D,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(SplinePositionInterpolator2D,value_changed,sfvec2f,value_changed,FIELDTYPE_SFVec2f)
END_NODE(SplinePositionInterpolator2D)

/* SplineScalarInterpolator node */
BEGIN_NODE(SplineScalarInterpolator)
EXPOSED_FIELD(SplineScalarInterpolator,closed,sfbool,closed,FIELDTYPE_SFBool)
EXPOSED_FIELD(SplineScalarInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SplineScalarInterpolator,keyValue,mffloat,keyValue,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SplineScalarInterpolator,keyVelocity,mffloat,keyVelocity,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SplineScalarInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SplineScalarInterpolator,normalizeVelocity,sfbool,normalizeVelocity,FIELDTYPE_SFBool)
EVENT_IN(SplineScalarInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(SplineScalarInterpolator,value_changed,sffloat,value_changed,FIELDTYPE_SFFloat)
END_NODE(SplineScalarInterpolator)

/* SpotLight node */
BEGIN_NODE(SpotLight)
EXPOSED_FIELD(SpotLight,ambientIntensity,sffloat,ambientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(SpotLight,attenuation,sfvec3f,attenuation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(SpotLight,beamWidth,sffloat,beamWidth,FIELDTYPE_SFFloat)
EXPOSED_FIELD(SpotLight,color,sfcolor,color,FIELDTYPE_SFColor)
EXPOSED_FIELD(SpotLight,cutOffAngle,sffloat,cutOffAngle,FIELDTYPE_SFFloat)
EXPOSED_FIELD(SpotLight,direction,sfvec3f,direction,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(SpotLight,global,sfbool,global,FIELDTYPE_SFBool)
EXPOSED_FIELD(SpotLight,intensity,sffloat,intensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(SpotLight,location,sfvec3f,location,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(SpotLight,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SpotLight,on,sfbool,on,FIELDTYPE_SFBool)
EXPOSED_FIELD(SpotLight,radius,sffloat,radius,FIELDTYPE_SFFloat)
END_NODE(SpotLight)

/* SquadOrientationInterpolator node */
BEGIN_NODE(SquadOrientationInterpolator)
EXPOSED_FIELD(SquadOrientationInterpolator,key,mffloat,key,FIELDTYPE_MFFloat)
EXPOSED_FIELD(SquadOrientationInterpolator,keyValue,mfrotation,keyValue,FIELDTYPE_MFRotation)
EXPOSED_FIELD(SquadOrientationInterpolator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(SquadOrientationInterpolator,normalizeVelocity,sfbool,normalizeVelocity,FIELDTYPE_SFBool)
EVENT_IN(SquadOrientationInterpolator,set_fraction,sffloat,set_fraction,FIELDTYPE_SFFloat)
EVENT_OUT(SquadOrientationInterpolator,value_changed,sfrotation,value_changed,FIELDTYPE_SFRotation)
END_NODE(SquadOrientationInterpolator)

/* StaticGroup node */
BEGIN_NODE(StaticGroup)
FIELD(StaticGroup,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(StaticGroup,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(StaticGroup,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(StaticGroup,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(StaticGroup)

/* StringSensor node */
BEGIN_NODE(StringSensor)
EXPOSED_FIELD(StringSensor,deletionAllowed,sfbool,deletionAllowed,FIELDTYPE_SFBool)
EXPOSED_FIELD(StringSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(StringSensor,enteredText,sfstring,enteredText,FIELDTYPE_SFString)
EVENT_OUT(StringSensor,finalText,sfstring,finalText,FIELDTYPE_SFString)
EVENT_OUT(StringSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EXPOSED_FIELD(StringSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
END_NODE(StringSensor)

/* Switch node */
BEGIN_NODE(Switch)
EVENT_IN(Switch,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Switch,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Switch,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Switch,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Switch,choice,mfnode,choice,FIELDTYPE_MFNode)
EXPOSED_FIELD(Switch,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Switch,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Switch,whichChoice,sfint32,whichChoice,FIELDTYPE_SFInt32)
END_NODE(Switch)

/* Text node */
BEGIN_NODE(Text)
EXPOSED_FIELD(Text,fontStyle,sfnode,fontStyle,FIELDTYPE_SFNode)
EXPOSED_FIELD(Text,length,mffloat,length,FIELDTYPE_MFFloat)
EVENT_OUT(Text,lineBounds,mfvec2f,lineBounds,FIELDTYPE_MFVec2f)
EXPOSED_FIELD(Text,maxExtent,sffloat,maxExtent,FIELDTYPE_SFFloat)
EXPOSED_FIELD(Text,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(Text,origin,sfvec3f,origin,FIELDTYPE_SFVec3f)
FIELD(Text,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(Text,string,mfstring,string,FIELDTYPE_MFString)
EVENT_OUT(Text,textBounds,sfvec2f,textBounds,FIELDTYPE_SFVec2f)
END_NODE(Text)

/* TextureBackground node */
BEGIN_NODE(TextureBackground)
EXPOSED_FIELD(TextureBackground,backTexture,sfnode,backTexture,FIELDTYPE_SFNode)
EVENT_OUT(TextureBackground,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(TextureBackground,bottomTexture,sfnode,bottomTexture,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureBackground,frontTexture,sfnode,frontTexture,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureBackground,groundAngle,mffloat,groundAngle,FIELDTYPE_MFFloat)
EXPOSED_FIELD(TextureBackground,groundColor,mfcolor,groundColor,FIELDTYPE_MFColor)
EVENT_OUT(TextureBackground,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(TextureBackground,leftTexture,sfnode,leftTexture,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureBackground,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureBackground,rightTexture,sfnode,rightTexture,FIELDTYPE_SFNode)
EVENT_IN(TextureBackground,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
EXPOSED_FIELD(TextureBackground,skyAngle,mffloat,skyAngle,FIELDTYPE_MFFloat)
EXPOSED_FIELD(TextureBackground,skyColor,mfcolor,skyColor,FIELDTYPE_MFColor)
EXPOSED_FIELD(TextureBackground,topTexture,sfnode,topTexture,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureBackground,transparency,mffloat,transparency,FIELDTYPE_MFFloat)
END_NODE(TextureBackground)

/* TextureCoordinate node */
BEGIN_NODE(TextureCoordinate)
EXPOSED_FIELD(TextureCoordinate,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureCoordinate,point,mfvec2f,point,FIELDTYPE_MFVec2f)
END_NODE(TextureCoordinate)

/* TextureCoordinateGenerator node */
BEGIN_NODE(TextureCoordinateGenerator)
EXPOSED_FIELD(TextureCoordinateGenerator,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureCoordinateGenerator,mode,sfstring,mode,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureCoordinateGenerator,parameter,mffloat,parameter,FIELDTYPE_MFFloat)
END_NODE(TextureCoordinateGenerator)

/* TextureProperties node */
BEGIN_NODE(TextureProperties)
EXPOSED_FIELD(TextureProperties,anisotropicDegree,sffloat,anisotropicDegree,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TextureProperties,borderColor,sfcolorrgba,borderColor,FIELDTYPE_SFColorRGBA)
EXPOSED_FIELD(TextureProperties,borderWidth,sfint32,borderWidth,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TextureProperties,boundaryModeR,sfstring,boundaryModeR,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureProperties,boundaryModeS,sfstring,boundaryModeS,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureProperties,boundaryModeT,sfstring,boundaryModeT,FIELDTYPE_SFString)
FIELD(TextureProperties,generateMipMaps,sfbool,generateMipMaps,FIELDTYPE_SFBool)
EXPOSED_FIELD(TextureProperties,magnificationFilter,sfstring,magnificationFilter,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureProperties,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureProperties,minificationFilter,sfstring,minificationFilter,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureProperties,textureCompression,sfstring,textureCompression,FIELDTYPE_SFString)
EXPOSED_FIELD(TextureProperties,texturePriority,sffloat,texturePriority,FIELDTYPE_SFFloat)
END_NODE(TextureProperties)

/* TextureTransform node */
BEGIN_NODE(TextureTransform)
EXPOSED_FIELD(TextureTransform,center,sfvec2f,center,FIELDTYPE_SFVec2f)
EXPOSED_FIELD(TextureTransform,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TextureTransform,rotation,sffloat,rotation,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TextureTransform,scale,sfvec2f,scale,FIELDTYPE_SFVec2f)
EXPOSED_FIELD(TextureTransform,translation,sfvec2f,translation,FIELDTYPE_SFVec2f)
END_NODE(TextureTransform)

/* TimeSensor node */
BEGIN_NODE(TimeSensor)
EXPOSED_FIELD(TimeSensor,cycleInterval,sftime,cycleInterval,FIELDTYPE_SFTime)
EVENT_OUT(TimeSensor,cycleTime,sftime,cycleTime,FIELDTYPE_SFTime)
EVENT_OUT(TimeSensor,elapsedTime,sftime,elapsedTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(TimeSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(TimeSensor,fraction_changed,sffloat,fraction_changed,FIELDTYPE_SFFloat)
EVENT_OUT(TimeSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(TimeSensor,isPaused,sftime,isPaused,FIELDTYPE_SFTime)
EXPOSED_FIELD(TimeSensor,loop,sfbool,loop,FIELDTYPE_SFBool)
EXPOSED_FIELD(TimeSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TimeSensor,pauseTime,sftime,pauseTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(TimeSensor,resumeTime,sftime,resumeTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(TimeSensor,startTime,sftime,startTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(TimeSensor,stopTime,sftime,stopTime,FIELDTYPE_SFTime)
EVENT_OUT(TimeSensor,time,sftime,time,FIELDTYPE_SFTime)
END_NODE(TimeSensor)

/* TimeTrigger node */
BEGIN_NODE(TimeTrigger)
EXPOSED_FIELD(TimeTrigger,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(TimeTrigger,set_boolean,sfbool,set_boolean,FIELDTYPE_SFBool)
EVENT_OUT(TimeTrigger,triggerTime,sftime,triggerTime,FIELDTYPE_SFTime)
END_NODE(TimeTrigger)

/* TouchSensor node */
BEGIN_NODE(TouchSensor)
EXPOSED_FIELD(TouchSensor,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(TouchSensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(TouchSensor,hitNormal_changed,sfvec3f,hitNormal_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(TouchSensor,hitPoint_changed,sfvec3f,hitPoint_changed,FIELDTYPE_SFVec3f)
EVENT_OUT(TouchSensor,hitTexCoord_changed,sfvec2f,hitTexCoord_changed,FIELDTYPE_SFVec2f)
EVENT_OUT(TouchSensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(TouchSensor,isOver,sfbool,isOver,FIELDTYPE_SFBool)
EXPOSED_FIELD(TouchSensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_OUT(TouchSensor,touchTime,sftime,touchTime,FIELDTYPE_SFTime)
END_NODE(TouchSensor)

/* Transform node */
BEGIN_NODE(Transform)
EVENT_IN(Transform,addChildren,mfnode,addChildren,FIELDTYPE_MFNode)
FIELD(Transform,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(Transform,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Transform,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Transform,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(Transform,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EVENT_IN(Transform,removeChildren,mfnode,removeChildren,FIELDTYPE_MFNode)
EXPOSED_FIELD(Transform,rotation,sfrotation,rotation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(Transform,scale,sfvec3f,scale,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Transform,scaleOrientation,sfrotation,scaleOrientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(Transform,translation,sfvec3f,translation,FIELDTYPE_SFVec3f)
END_NODE(Transform)

/* TransmitterPdu node */
BEGIN_NODE(TransmitterPdu)
EXPOSED_FIELD(TransmitterPdu,address,sfstring,address,FIELDTYPE_SFString)
EXPOSED_FIELD(TransmitterPdu,antennaLocation,sfvec3f,antennaLocation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(TransmitterPdu,antennaPatternLength,sfint32,antennaPatternLength,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,antennaPatternType,sfint32,antennaPatternType,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,applicationID,sfint32,applicationID,FIELDTYPE_SFInt32)
FIELD(TransmitterPdu,bboxCenter,sfvec3f,bboxCenter,FIELDTYPE_SFVec3f)
FIELD(TransmitterPdu,bboxSize,sfvec3f,bboxSize,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(TransmitterPdu,cryptoKeyID,sfint32,cryptoKeyID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,cryptoSystem,sfint32,cryptoSystem,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EXPOSED_FIELD(TransmitterPdu,entityID,sfint32,entityID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,frequency,sfint32,frequency,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,inputSource,sfint32,inputSource,FIELDTYPE_SFInt32)
EVENT_OUT(TransmitterPdu,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EVENT_OUT(TransmitterPdu,isNetworkReader,sfbool,isNetworkReader,FIELDTYPE_SFBool)
EVENT_OUT(TransmitterPdu,isNetworkWriter,sfbool,isNetworkWriter,FIELDTYPE_SFBool)
EVENT_OUT(TransmitterPdu,isRtpHeaderHeard,sfbool,isRtpHeaderHeard,FIELDTYPE_SFBool)
EVENT_OUT(TransmitterPdu,isStandAlone,sfbool,isStandAlone,FIELDTYPE_SFBool)
EXPOSED_FIELD(TransmitterPdu,lengthOfModulationParameters,sfint32,lengthOfModulationParameters,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TransmitterPdu,modulationTypeDetail,sfint32,modulationTypeDetail,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,modulationTypeMajor,sfint32,modulationTypeMajor,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,modulationTypeSpreadSpectrum,sfint32,modulationTypeSpreadSpectrum,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,modulationTypeSystem,sfint32,modulationTypeSystem,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,multicastRelayHost,sfstring,multicastRelayHost,FIELDTYPE_SFString)
EXPOSED_FIELD(TransmitterPdu,multicastRelayPort,sfint32,multicastRelayPort,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,networkMode,sfstring,networkMode,FIELDTYPE_SFString)
EXPOSED_FIELD(TransmitterPdu,port,sfint32,port,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,power,sffloat,power,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeCategory,sfint32,radioEntityTypeCategory,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeCountry,sfint32,radioEntityTypeCountry,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeDomain,sfint32,radioEntityTypeDomain,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeKind,sfint32,radioEntityTypeKind,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeNomenclature,sfint32,radioEntityTypeNomenclature,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioEntityTypeNomenclatureVersion,sfint32,radioEntityTypeNomenclatureVersion,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,radioID,sfint32,radioID,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,readInterval,sffloat,readInterval,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TransmitterPdu,relativeAntennaLocation,sfvec3f,relativeAntennaLocation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(TransmitterPdu,rtpHeaderExpected,sfbool,rtpHeaderExpected,FIELDTYPE_SFBool)
EXPOSED_FIELD(TransmitterPdu,siteID,sfint32,siteID,FIELDTYPE_SFInt32)
EVENT_OUT(TransmitterPdu,timestamp,sftime,timestamp,FIELDTYPE_SFTime)
EXPOSED_FIELD(TransmitterPdu,transmitFrequencyBandwidth,sffloat,transmitFrequencyBandwidth,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TransmitterPdu,transmitState,sfint32,transmitState,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,whichGeometry,sfint32,whichGeometry,FIELDTYPE_SFInt32)
EXPOSED_FIELD(TransmitterPdu,writeInterval,sffloat,writeInterval,FIELDTYPE_SFFloat)
END_NODE(TransmitterPdu)

/* TriangleFanSet node */
BEGIN_NODE(TriangleFanSet)
EXPOSED_FIELD(TriangleFanSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(TriangleFanSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleFanSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(TriangleFanSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleFanSet,coord,sfnode,coord,FIELDTYPE_SFNode)
FIELD(TriangleFanSet,fanCount,mfint32,fanCount,FIELDTYPE_MFInt32)
EXPOSED_FIELD(TriangleFanSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleFanSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleFanSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(TriangleFanSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
FIELD(TriangleFanSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleFanSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(TriangleFanSet)

/* TriangleSet node */
BEGIN_NODE(TriangleSet)
EXPOSED_FIELD(TriangleSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(TriangleSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(TriangleSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(TriangleSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
FIELD(TriangleSet,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(TriangleSet)

/* TriangleSet2D node */
BEGIN_NODE(TriangleSet2D)
EXPOSED_FIELD(TriangleSet2D,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(TriangleSet2D,solid,sfbool,solid,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleSet2D,vertices,mfvec2f,vertices,FIELDTYPE_MFVec2f)
END_NODE(TriangleSet2D)

/* TriangleStripSet node */
BEGIN_NODE(TriangleStripSet)
EXPOSED_FIELD(TriangleStripSet,attrib,mfnode,attrib,FIELDTYPE_MFNode)
FIELD(TriangleStripSet,ccw,sfbool,ccw,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleStripSet,color,sfnode,color,FIELDTYPE_SFNode)
FIELD(TriangleStripSet,colorPerVertex,sfbool,colorPerVertex,FIELDTYPE_SFBool)
EXPOSED_FIELD(TriangleStripSet,coord,sfnode,coord,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleStripSet,fogCoord,sfnode,fogCoord,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleStripSet,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TriangleStripSet,normal,sfnode,normal,FIELDTYPE_SFNode)
FIELD(TriangleStripSet,normalPerVertex,sfbool,normalPerVertex,FIELDTYPE_SFBool)
FIELD(TriangleStripSet,solid,sfbool,solid,FIELDTYPE_SFBool)
FIELD(TriangleStripSet,stripCount,mfint32,stripCount,FIELDTYPE_MFInt32)
EXPOSED_FIELD(TriangleStripSet,texCoord,sfnode,texCoord,FIELDTYPE_SFNode)
END_NODE(TriangleStripSet)

/* TwoSidedMaterial node */
BEGIN_NODE(TwoSidedMaterial)
EXPOSED_FIELD(TwoSidedMaterial,ambientIntensity,sffloat,ambientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TwoSidedMaterial,backAmbientIntensity,sffloat,backAmbientIntensity,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TwoSidedMaterial,backDiffuseColor,sfcolor,backDiffuseColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,backEmissiveColor,sfcolor,backEmissiveColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,backShininess,sffloat,backShininess,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TwoSidedMaterial,backSpecularColor,sfcolor,backSpecularColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,backTransparency,sffloat,backTransparency,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TwoSidedMaterial,diffuseColor,sfcolor,diffuseColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,emissiveColor,sfcolor,emissiveColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(TwoSidedMaterial,separateBackColor,sfbool,separateBackColor,FIELDTYPE_SFBool)
EXPOSED_FIELD(TwoSidedMaterial,shininess,sffloat,shininess,FIELDTYPE_SFFloat)
EXPOSED_FIELD(TwoSidedMaterial,specularColor,sfcolor,specularColor,FIELDTYPE_SFColor)
EXPOSED_FIELD(TwoSidedMaterial,transparency,sffloat,transparency,FIELDTYPE_SFFloat)
END_NODE(TwoSidedMaterial)

/* Viewpoint node */
BEGIN_NODE(Viewpoint)
EVENT_OUT(Viewpoint,bindTime,sftime,bindTime,FIELDTYPE_SFTime)
EXPOSED_FIELD(Viewpoint,centerOfRotation,sfvec3f,centerOfRotation,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Viewpoint,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(Viewpoint,fieldOfView,sffloat,fieldOfView,FIELDTYPE_SFFloat)
EVENT_OUT(Viewpoint,isBound,sfbool,isBound,FIELDTYPE_SFBool)
EXPOSED_FIELD(Viewpoint,jump,sfbool,jump,FIELDTYPE_SFBool)
EXPOSED_FIELD(Viewpoint,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(Viewpoint,orientation,sfrotation,orientation,FIELDTYPE_SFRotation)
EXPOSED_FIELD(Viewpoint,position,sfvec3f,position,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(Viewpoint,retainUserOffsets,sfbool,retainUserOffsets,FIELDTYPE_SFBool)
EVENT_IN(Viewpoint,set_bind,sfbool,set_bind,FIELDTYPE_SFBool)
END_NODE(Viewpoint)

/* ViewpointGroup node */
BEGIN_NODE(ViewpointGroup)
EXPOSED_FIELD(ViewpointGroup,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(ViewpointGroup,children,mfnode,children,FIELDTYPE_MFNode)
EXPOSED_FIELD(ViewpointGroup,description,sfstring,description,FIELDTYPE_SFString)
EXPOSED_FIELD(ViewpointGroup,displayed,sfbool,displayed,FIELDTYPE_SFBool)
EXPOSED_FIELD(ViewpointGroup,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(ViewpointGroup,retainUserOffsets,sfbool,retainUserOffsets,FIELDTYPE_SFBool)
EXPOSED_FIELD(ViewpointGroup,size,sfvec3f,size,FIELDTYPE_SFVec3f)
END_NODE(ViewpointGroup)

/* VisibilitySensor node */
BEGIN_NODE(VisibilitySensor)
EXPOSED_FIELD(VisibilitySensor,center,sfvec3f,center,FIELDTYPE_SFVec3f)
EXPOSED_FIELD(VisibilitySensor,enabled,sfbool,enabled,FIELDTYPE_SFBool)
EVENT_OUT(VisibilitySensor,enterTime,sftime,enterTime,FIELDTYPE_SFTime)
EVENT_OUT(VisibilitySensor,exitTime,sftime,exitTime,FIELDTYPE_SFTime)
EVENT_OUT(VisibilitySensor,isActive,sfbool,isActive,FIELDTYPE_SFBool)
EXPOSED_FIELD(VisibilitySensor,metadata,sfnode,metadata,FIELDTYPE_SFNode)
EXPOSED_FIELD(VisibilitySensor,size,sfvec3f,size,FIELDTYPE_SFVec3f)
END_NODE(VisibilitySensor)

/* WorldInfo node */
BEGIN_NODE(WorldInfo)
FIELD(WorldInfo,info,mfstring,info,FIELDTYPE_MFString)
EXPOSED_FIELD(WorldInfo,metadata,sfnode,metadata,FIELDTYPE_SFNode)
FIELD(WorldInfo,title,sfstring,title,FIELDTYPE_SFString)
END_NODE(WorldInfo)
