/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_41 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 31467, "epsg", 31467,
        "DHDN / 3-degree Gauss-Kruger zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",3500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 11,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"31467\"]]");
    p = add_epsg_def (filter, first, last, 31468, "epsg", 31468,
        "DHDN / 3-degree Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",4500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"31468\"]]");
    p = add_epsg_def (filter, first, last, 31469, "epsg", 31469,
        "DHDN / 3-degree Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+datum=potsdam +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],TOWGS84[598.1,73.7,418.2,0.202,0.045,-2.455,");
    add_srs_wkt (p, 4,
        "6.7],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",5500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"31469\"]]");
    p = add_epsg_def (filter, first, last, 31528, "epsg", 31528,
        "Conakry 1905 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 28N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "11\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-15],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"31528\"]]");
    p = add_epsg_def (filter, first, last, 31529, "epsg", 31529,
        "Conakry 1905 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 29N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "11\"]],TOWGS84[-23,259,-9,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6315\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4315\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31529\"]]");
    p = add_epsg_def (filter, first, last, 31600, "epsg", 31600,
        "Dealul Piscului 1930 / Stereo 33");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=45.9 +lon_0=25.39246588888889 +k=0.9");
    add_proj4text (p, 1,
        "996667 +x_0=500000 +y_0=500000 +ellps=intl +towgs84=103.");
    add_proj4text (p, 2,
        "25,-100.4,-307.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dealul Piscului 1930 / Stereo 33\",GEOGCS[\"Dea");
    add_srs_wkt (p, 1,
        "lul Piscului 1930\",DATUM[\"Dealul_Piscului_1930\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[103.25,-100.4,-307.19,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6316\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4316");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",45.9],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",25.39246588888889],PARAMETER[\"scale_factor\",0.9996667");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"31600\"]]");
    p = add_epsg_def (filter, first, last, 31700, "epsg", 31700,
        "Dealul Piscului 1970/ Stereo 70 (deprecated)");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=500000 +ellps=krass +towgs84=28,-121,-77,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dealul Piscului 1970/ Stereo 70 (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Dealul Piscului 1970\",DATUM[\"Dealul_Piscului_");
    add_srs_wkt (p, 2,
        "1970\",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7024\"]],TOWGS84[28,-121,-77,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6317\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "17\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",46],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "25],PARAMETER[\"scale_factor\",0.99975],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",500000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31700\"]]");
    p = add_epsg_def (filter, first, last, 31838, "epsg", 31838,
        "NGN / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 38N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-3.2,-5");
    add_srs_wkt (p, 3,
        ".7,2.8,0,0,0,0],AUTHORITY[\"EPSG\",\"6318\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",45],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"31838\"]]");
    p = add_epsg_def (filter, first, last, 31839, "epsg", 31839,
        "NGN / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 39N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-3.2,-5");
    add_srs_wkt (p, 3,
        ".7,2.8,0,0,0,0],AUTHORITY[\"EPSG\",\"6318\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",51],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"31839\"]]");
    p = add_epsg_def (filter, first, last, 31900, "epsg", 31900,
        "KUDAMS / KTM (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM (deprecated)\",GEOGCS[\"KUDAMS\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Kuwait_Utility\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-20.8,");
    add_srs_wkt (p, 3,
        "11.3,2.4,0,0,0,0],AUTHORITY[\"EPSG\",\"6319\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4319\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",48],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"31900\"]]");
    p = add_epsg_def (filter, first, last, 31901, "epsg", 31901,
        "KUDAMS / KTM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM\",GEOGCS[\"KUDAMS\",DATUM[\"Kuwait");
    add_srs_wkt (p, 1,
        "_Utility\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[-20.8,11.3,2.4,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6319\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4319\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",48],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "31901\"]]");
    p = add_epsg_def (filter, first, last, 31965, "epsg", 31965,
        "SIRGAS 2000 / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 11N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31965\"]]");
    p = add_epsg_def (filter, first, last, 31966, "epsg", 31966,
        "SIRGAS 2000 / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 12N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31966\"]]");
    p = add_epsg_def (filter, first, last, 31967, "epsg", 31967,
        "SIRGAS 2000 / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 13N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"31967\"]]");
    p = add_epsg_def (filter, first, last, 31968, "epsg", 31968,
        "SIRGAS 2000 / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 14N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31968\"]]");
    p = add_epsg_def (filter, first, last, 31969, "epsg", 31969,
        "SIRGAS 2000 / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 15N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31969\"]]");
    p = add_epsg_def (filter, first, last, 31970, "epsg", 31970,
        "SIRGAS 2000 / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 16N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31970\"]]");
    p = add_epsg_def (filter, first, last, 31971, "epsg", 31971,
        "SIRGAS 2000 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31971\"]]");
    p = add_epsg_def (filter, first, last, 31972, "epsg", 31972,
        "SIRGAS 2000 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31972\"]]");
    p = add_epsg_def (filter, first, last, 31973, "epsg", 31973,
        "SIRGAS 2000 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31973\"]]");
    p = add_epsg_def (filter, first, last, 31974, "epsg", 31974,
        "SIRGAS 2000 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31974\"]]");
    p = add_epsg_def (filter, first, last, 31975, "epsg", 31975,
        "SIRGAS 2000 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31975\"]]");
    p = add_epsg_def (filter, first, last, 31976, "epsg", 31976,
        "SIRGAS 2000 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "31976\"]]");
    p = add_epsg_def (filter, first, last, 31977, "epsg", 31977,
        "SIRGAS 2000 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31977\"]]");
    p = add_epsg_def (filter, first, last, 31978, "epsg", 31978,
        "SIRGAS 2000 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31978\"]]");
    p = add_epsg_def (filter, first, last, 31979, "epsg", 31979,
        "SIRGAS 2000 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31979\"]]");
    p = add_epsg_def (filter, first, last, 31980, "epsg", 31980,
        "SIRGAS 2000 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31980\"]]");
    p = add_epsg_def (filter, first, last, 31981, "epsg", 31981,
        "SIRGAS 2000 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31981\"]]");
    p = add_epsg_def (filter, first, last, 31982, "epsg", 31982,
        "SIRGAS 2000 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31982\"]]");
    p = add_epsg_def (filter, first, last, 31983, "epsg", 31983,
        "SIRGAS 2000 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 23S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31983\"]]");
    p = add_epsg_def (filter, first, last, 31984, "epsg", 31984,
        "SIRGAS 2000 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 24S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31984\"]]");
    p = add_epsg_def (filter, first, last, 31985, "epsg", 31985,
        "SIRGAS 2000 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 25S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"31985\"]]");
    p = add_epsg_def (filter, first, last, 31986, "epsg", 31986,
        "SIRGAS 1995 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31986\"]]");
    p = add_epsg_def (filter, first, last, 31987, "epsg", 31987,
        "SIRGAS 1995 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31987\"]]");
    p = add_epsg_def (filter, first, last, 31988, "epsg", 31988,
        "SIRGAS 1995 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31988\"]]");
    p = add_epsg_def (filter, first, last, 31989, "epsg", 31989,
        "SIRGAS 1995 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31989\"]]");
    p = add_epsg_def (filter, first, last, 31990, "epsg", 31990,
        "SIRGAS 1995 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31990\"]]");
    p = add_epsg_def (filter, first, last, 31991, "epsg", 31991,
        "SIRGAS 1995 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31991\"]]");
    p = add_epsg_def (filter, first, last, 31992, "epsg", 31992,
        "SIRGAS 1995 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31992\"]]");
    p = add_epsg_def (filter, first, last, 31993, "epsg", 31993,
        "SIRGAS 1995 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31993\"]]");
    p = add_epsg_def (filter, first, last, 31994, "epsg", 31994,
        "SIRGAS 1995 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31994\"]]");
    p = add_epsg_def (filter, first, last, 31995, "epsg", 31995,
        "SIRGAS 1995 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31995\"]]");
    p = add_epsg_def (filter, first, last, 31996, "epsg", 31996,
        "SIRGAS 1995 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31996\"]]");
    p = add_epsg_def (filter, first, last, 31997, "epsg", 31997,
        "SIRGAS 1995 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31997\"]]");
    p = add_epsg_def (filter, first, last, 31998, "epsg", 31998,
        "SIRGAS 1995 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 23S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31998\"]]");
    p = add_epsg_def (filter, first, last, 31999, "epsg", 31999,
        "SIRGAS 1995 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 24S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31999\"]]");
    p = add_epsg_def (filter, first, last, 32000, "epsg", 32000,
        "SIRGAS 1995 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 25S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"32000\"]]");
    p = add_epsg_def (filter, first, last, 32001, "epsg", 32001,
        "NAD27 / Montana North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=4");
    add_proj4text (p, 1,
        "7 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",48.71666666666667],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",47.85],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",47],PARAMETER[\"central_meridian\",-109.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32001\"]]");
    p = add_epsg_def (filter, first, last, 32002, "epsg", 32002,
        "NAD27 / Montana Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=4");
    add_proj4text (p, 1,
        "5.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",47.88333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",46.45],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",45.83333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-109.5],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32002\"]]");
    p = add_epsg_def (filter, first, last, 32003, "epsg", 32003,
        "NAD27 / Montana South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44");
    add_proj4text (p, 1,
        " +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana South\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",46.4],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_2\",44.86666666666667],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",44],PARAMETER[\"central_meridian\",-109.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32003\"]]");
    p = add_epsg_def (filter, first, last, 32005, "epsg", 32005,
        "NAD27 / Nebraska North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "1.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",41.85],PARAMETER[\"sta");
    add_srs_wkt (p, 8,
        "ndard_parallel_2\",42.81666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",41.33333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-100],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32005\"]]");
    p = add_epsg_def (filter, first, last, 32006, "epsg", 32006,
        "NAD27 / Nebraska South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",40.28333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",41.71666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",39.66666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-99.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"32006\"]]");
    p = add_epsg_def (filter, first, last, 32007, "epsg", 32007,
        "NAD27 / Nevada East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-115.5833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32007\"]]");
    p = add_epsg_def (filter, first, last, 32008, "epsg", 32008,
        "NAD27 / Nevada Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada Central\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",34.75],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-116.6666666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32008\"]]");
    p = add_epsg_def (filter, first, last, 32009, "epsg", 32009,
        "NAD27 / Nevada West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-118.5833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32009\"]]");
    p = add_epsg_def (filter, first, last, 32010, "epsg", 32010,
        "NAD27 / New Hampshire");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Hampshire\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",42.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-71.66666666666667],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9966667],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32010\"]]");
    p = add_epsg_def (filter, first, last, 32011, "epsg", 32011,
        "NAD27 / New Jersey");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Jersey\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-74.66666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999975],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32011\"]]");
    p = add_epsg_def (filter, first, last, 32012, "epsg", 32012,
        "NAD27 / New Mexico East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico East\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-104.3333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "909091],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32012\"]]");
    p = add_epsg_def (filter, first, last, 32013, "epsg", 32013,
        "NAD27 / New Mexico Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=1524");
    add_proj4text (p, 1,
        "00.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico Central\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",31],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-106.25],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"32013\"]]");
    p = add_epsg_def (filter, first, last, 32014, "epsg", 32014,
        "NAD27 / New Mexico West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico West\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-107.8333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "916667],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32014\"]]");
    p = add_epsg_def (filter, first, last, 32015, "epsg", 32015,
        "NAD27 / New York East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999");
    add_proj4text (p, 1,
        "966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",40],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-74.33333333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 11,
        "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32015\"]]");
    p = add_epsg_def (filter, first, last, 32016, "epsg", 32016,
        "NAD27 / New York Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",40],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-76.58333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9375],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32016\"]]");
    p = add_epsg_def (filter, first, last, 32017, "epsg", 32017,
        "NAD27 / New York West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",40],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-78.58333333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "375],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32017\"]]");
    p = add_epsg_def (filter, first, last, 32018, "epsg", 32018,
        "NAD27 / New York Long Island (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.");
    add_srs_wkt (p, 8,
        "03333333333333],PARAMETER[\"standard_parallel_2\",40.666");
    add_srs_wkt (p, 9,
        "66666666666],PARAMETER[\"latitude_of_origin\",40.5],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-74],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32018\"]]");
    p = add_epsg_def (filter, first, last, 32019, "epsg", 32019,
        "NAD27 / North Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Carolina\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",34.33333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",36.16666666666666],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",33.75],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-79],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32019\"]]");
    p = add_epsg_def (filter, first, last, 32020, "epsg", 32020,
        "NAD27 / North Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",47.43333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",48.73333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",47],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-100.5],PARAMETER[\"false_easting\",2000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32020\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 32021, "epsg", 32021,
        "NAD27 / North Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",46.18333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",47.48333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",45.66666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-100.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"32021\"]]");
    p = add_epsg_def (filter, first, last, 32022, "epsg", 32022,
        "NAD27 / Ohio North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",40.43333333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",41.7],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",39.66666666666666],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-82.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32022\"]]");
    p = add_epsg_def (filter, first, last, 32023, "epsg", 32023,
        "NAD27 / Ohio South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",38.73333333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",40.03333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",38],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-82.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32023\"]]");
    p = add_epsg_def (filter, first, last, 32024, "epsg", 32024,
        "NAD27 / Oklahoma North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",35.56666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",36.76666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",35],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-98],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32024\"]]");
    p = add_epsg_def (filter, first, last, 32025, "epsg", 32025,
        "NAD27 / Oklahoma South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",33.93333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",35.23333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",33.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-98],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32025\"]]");
    p = add_epsg_def (filter, first, last, 32026, "epsg", 32026,
        "NAD27 / Oregon North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",44.33333333333334],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",46],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "origin\",43.66666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-120.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32026\"]]");
    p = add_epsg_def (filter, first, last, 32027, "epsg", 32027,
        "NAD27 / Oregon South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",42.33333333333334],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",44],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "origin\",41.66666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-120.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32027\"]]");
    p = add_epsg_def (filter, first, last, 32028, "epsg", 32028,
        "NAD27 / Pennsylvania North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",40.88333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",41.95],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",40.16666666666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-77.75],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32028\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32029, "epsg", 32029,
        "NAD27 / Pennsylvania South (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.9333");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"standard_parallel_2\",40.8],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",39.33333333333334],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-77.75],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"32029\"]]");
    p = add_epsg_def (filter, first, last, 32030, "epsg", 32030,
        "NAD27 / Rhode Island");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "999938 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Rhode Island\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.08333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-71.5],PARAMETER[\"scale_factor\",0.99999");
    add_srs_wkt (p, 9,
        "38],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32030\"]]");
    p = add_epsg_def (filter, first, last, 32031, "epsg", 32031,
        "NAD27 / South Carolina North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina North\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",33.7666666666666");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"standard_parallel_2\",34.96666666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-81],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32031\"]]");
    p = add_epsg_def (filter, first, last, 32033, "epsg", 32033,
        "NAD27 / South Carolina South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina South\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",32.3333333333333");
    add_srs_wkt (p, 8,
        "4],PARAMETER[\"standard_parallel_2\",33.66666666666666],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",31.83333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-81],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32033\"]]");
    p = add_epsg_def (filter, first, last, 32034, "epsg", 32034,
        "NAD27 / South Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",44.41666666666666]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",45.68333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",43.83333333333334],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-100],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"32034\"]]");
    p = add_epsg_def (filter, first, last, 32035, "epsg", 32035,
        "NAD27 / South Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",42.83333333333334]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",44.4],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",42.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-100.3333333333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32035\"]]");
    p = add_epsg_def (filter, first, last, 32036, "epsg", 32036,
        "NAD27 / Tennessee (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee (deprecated)\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",35.25],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_2\",36.41666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",34.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-86],PARAMETER[\"false_easting\",100000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32036\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32037, "epsg", 32037,
        "NAD27 / Texas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",34.65],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_2\",36.18333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",34],PARAMETER[\"central_meridian\",-101.5],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32037\"]]");
    p = add_epsg_def (filter, first, last, 32038, "epsg", 32038,
        "NAD27 / Texas North Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",32.13333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",33.96666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",31.66666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-97.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32038\"]]");
    p = add_epsg_def (filter, first, last, 32039, "epsg", 32039,
        "NAD27 / Texas Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",30.11666666666667],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",31.88333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",29.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-100.3333333333333],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2000000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"32039\"]]");
    p = add_epsg_def (filter, first, last, 32040, "epsg", 32040,
        "NAD27 / Texas South Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.38333333333333 +lat_2=30.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",28.38333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",30.28333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",27.83333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-99],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32040\"]]");
    p = add_epsg_def (filter, first, last, 32041, "epsg", 32041,
        "NAD27 / Texas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.16666666666667 +lat_2=27.83333333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",26.16666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",27.83333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",25.66666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-98.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2041\"]]");
    p = add_epsg_def (filter, first, last, 32042, "epsg", 32042,
        "NAD27 / Utah North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.71666666666667 +lat_2=41.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",40.71666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",41.78333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",40.33333333333334],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-111.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2042\"]]");
    p = add_epsg_def (filter, first, last, 32043, "epsg", 32043,
        "NAD27 / Utah Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.01666666666667 +lat_2=40.65 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah Central\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",39.01666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",40.65],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",38.33333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-111.5],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32043\"]]");
    p = add_epsg_def (filter, first, last, 32044, "epsg", 32044,
        "NAD27 / Utah South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.21666666666667 +lat_2=38.35 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",37.21666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",38.35],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",36.66666666666666],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-111.5],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32044\"]]");
    p = add_epsg_def (filter, first, last, 32045, "epsg", 32045,
        "NAD27 / Vermont");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Vermont\",GEOGCS[\"NAD27\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",42.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "72.5],PARAMETER[\"scale_factor\",0.999964286],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"32045\"]]");
    p = add_epsg_def (filter, first, last, 32046, "epsg", 32046,
        "NAD27 / Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.03333333333333 +lat_2=39.2 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",38.03333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",39.2],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",37.66666666666666],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-78.5],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32046\"]]");
    p = add_epsg_def (filter, first, last, 32047, "epsg", 32047,
        "NAD27 / Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",36.76666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",37.96666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",36.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-78.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"32047\"]]");
    p = add_epsg_def (filter, first, last, 32048, "epsg", 32048,
        "NAD27 / Washington North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.5 +lat_2=48.73333333333333 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington North\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",47.5],PARAMETER[\"stan");
    add_srs_wkt (p, 8,
        "dard_parallel_2\",48.73333333333333],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",47],PARAMETER[\"central_meridian\",-120.83");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32048\"]]");
    p = add_epsg_def (filter, first, last, 32049, "epsg", 32049,
        "NAD27 / Washington South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.83333333333334 +lat_2=47.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington South\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",45.83333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",47.33333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",45.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-120.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32049\"]]");
    p = add_epsg_def (filter, first, last, 32050, "epsg", 32050,
        "NAD27 / West Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=40.25 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia North\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",39],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_2\",40.25],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",2000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"32050\"]]");
    p = add_epsg_def (filter, first, last, 32051, "epsg", 32051,
        "NAD27 / West Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.48333333333333 +lat_2=38.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia South\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",37.48333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",38.88333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",37],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-81],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32051\"]]");
    p = add_epsg_def (filter, first, last, 32052, "epsg", 32052,
        "NAD27 / Wisconsin North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.56666666666667 +lat_2=46.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",45.56666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",46.76666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",45.16666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-90],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32052\"]]");
    p = add_epsg_def (filter, first, last, 32053, "epsg", 32053,
        "NAD27 / Wisconsin Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.5 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",44.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "tandard_parallel_2\",45.5],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",43.83333333333334],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32053\"]]");
    p = add_epsg_def (filter, first, last, 32054, "epsg", 32054,
        "NAD27 / Wisconsin South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.73333333333333 +lat_2=44.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=42 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",42.73333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",44.06666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",42],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-90],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32054\"]]");
    p = add_epsg_def (filter, first, last, 32055, "epsg", 32055,
        "NAD27 / Wyoming East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-105.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-105.1666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999941177],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32055\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 32056, "epsg", 32056,
        "NAD27 / Wyoming East Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-107.3333333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",40.66666666666666],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-107.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999941177],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "32056\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

