/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_34 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 22275, "epsg", 22275,
        "Cape / Lo15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo15\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",15],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22275");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22277, "epsg", 22277,
        "Cape / Lo17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo17\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",17],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22277");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22279, "epsg", 22279,
        "Cape / Lo19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo19\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",19],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22279");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22281, "epsg", 22281,
        "Cape / Lo21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo21\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",21],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22281");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22283, "epsg", 22283,
        "Cape / Lo23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo23\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",23],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22283");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22285, "epsg", 22285,
        "Cape / Lo25");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo25\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",25],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22285");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22287, "epsg", 22287,
        "Cape / Lo27");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo27\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",27],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22287");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22289, "epsg", 22289,
        "Cape / Lo29");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo29\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",29],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22289");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22291, "epsg", 22291,
        "Cape / Lo31");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo31\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",31],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22291");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22293, "epsg", 22293,
        "Cape / Lo33");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo33\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",33],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"22293");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22332, "epsg", 22332,
        "Carthage / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +datum=carthage +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / UTM zone 32N\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"22332\"]]");
    p = add_epsg_def (filter, first, last, 22391, "epsg", 22391,
        "Carthage / Nord Tunisie");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +datum=carthage +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Nord Tunisie\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",36]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",9.9],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999625544],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"22391\"]]");
    p = add_epsg_def (filter, first, last, 22392, "epsg", 22392,
        "Carthage / Sud Tunisie");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=9.9 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +datum=carthage +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Sud Tunisie\",GEOGCS[\"Carthage\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"central_meridian\",9.9],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999625769],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"22392\"]]");
    p = add_epsg_def (filter, first, last, 22521, "epsg", 22521,
        "Corrego Alegre 1970-72 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 21S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-57]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22521\"]]");
    p = add_epsg_def (filter, first, last, 22522, "epsg", 22522,
        "Corrego Alegre 1970-72 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 22S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-51]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22522\"]]");
    p = add_epsg_def (filter, first, last, 22523, "epsg", 22523,
        "Corrego Alegre 1970-72 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 23S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-45]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22523\"]]");
    p = add_epsg_def (filter, first, last, 22524, "epsg", 22524,
        "Corrego Alegre 1970-72 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 24S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-39]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22524\"]]");
    p = add_epsg_def (filter, first, last, 22525, "epsg", 22525,
        "Corrego Alegre 1970-72 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=intl +towgs84=-206,172,");
    add_proj4text (p, 1,
        "-6,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 25S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-206,172,-6,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4225");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-33]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"22525\"]]");
    p = add_epsg_def (filter, first, last, 22700, "epsg", 22700,
        "Deir ez Zor / Levant Zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Zone\",GEOGCS[\"Deir ez Zo");
    add_srs_wkt (p, 1,
        "r\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",34.65],PARAMETER[\"central_meridian\",37");
    add_srs_wkt (p, 9,
        ".35],PARAMETER[\"scale_factor\",0.9996256],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",300000],PARAMETER[\"false_northing\",3000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22700");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 22770, "epsg", 22770,
        "Deir ez Zor / Syria Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Syria Lambert\",GEOGCS[\"Deir ez ");
    add_srs_wkt (p, 1,
        "Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)");
    add_srs_wkt (p, 2,
        "\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",34.65],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",37.35],PARAMETER[\"scale_factor\",0.9996256],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",300000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22");
    add_srs_wkt (p, 13,
        "770\"]]");
    p = add_epsg_def (filter, first, last, 22780, "epsg", 22780,
        "Deir ez Zor / Levant Stereographic");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=34.2 +lon_0=39.15 +k=0.9995341 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532");
    add_proj4text (p, 2,
        ",238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Stereographic\",GEOGCS[\"D");
    add_srs_wkt (p, 1,
        "eir ez Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 2,
        "0 (IGN)\",6378249.2,293.4660212936265,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],TOWGS84[-190.421,8.532,238.69,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4227");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",34.2],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",39.15],PARAMETER[\"scale_factor\",0.9995341],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"22780\"]]");
    p = add_epsg_def (filter, first, last, 22832, "epsg", 22832,
        "Douala / UTM zone 32N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Douala / UTM zone 32N (deprecated)\",GEOGCS[\"D");
    add_srs_wkt (p, 1,
        "ouala\",DATUM[\"Douala\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6228\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4228\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "22832\"]]");
    p = add_epsg_def (filter, first, last, 22991, "epsg", 22991,
        "Egypt 1907 / Blue Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=35 +k=1 +x_0=300000 +y_0=11");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Blue Belt\",GEOGCS[\"Egypt 1907\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,2");
    add_srs_wkt (p, 2,
        "98.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",30],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",35],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",300000],PARAMETER[\"false_northing\",110");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22991\"]]");
    p = add_epsg_def (filter, first, last, 22992, "epsg", 22992,
        "Egypt 1907 / Red Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=81");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Red Belt\",GEOGCS[\"Egypt 1907\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,29");
    add_srs_wkt (p, 2,
        "8.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",30],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",31],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",615000],PARAMETER[\"false_northing\",810");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22992\"]]");
    p = add_epsg_def (filter, first, last, 22993, "epsg", 22993,
        "Egypt 1907 / Purple Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=20");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Purple Belt\",GEOGCS[\"Egypt 1907\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,");
    add_srs_wkt (p, 2,
        "298.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-130,110,-13");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",700000],PARAMETER[\"false_northing\",2");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"22993\"]]");
    p = add_epsg_def (filter, first, last, 22994, "epsg", 22994,
        "Egypt 1907 / Extended Purple Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=12");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Extended Purple Belt\",GEOGCS[\"Eg");
    add_srs_wkt (p, 1,
        "ypt 1907\",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\"");
    add_srs_wkt (p, 2,
        ",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],TOWGS84[-13");
    add_srs_wkt (p, 3,
        "0,110,-13,0,0,0,0],AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4229\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",27],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",700000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"22994\"]]");
    p = add_epsg_def (filter, first, last, 23028, "epsg", 23028,
        "ED50 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 28N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-15],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23028\"]]");
    p = add_epsg_def (filter, first, last, 23029, "epsg", 23029,
        "ED50 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 29N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-9],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23029\"]]");
    p = add_epsg_def (filter, first, last, 23030, "epsg", 23030,
        "ED50 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 30N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-3],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23030\"]]");
    p = add_epsg_def (filter, first, last, 23031, "epsg", 23031,
        "ED50 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 31N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",3],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"23031\"]]");
    p = add_epsg_def (filter, first, last, 23032, "epsg", 23032,
        "ED50 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 32N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",9],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"23032\"]]");
    p = add_epsg_def (filter, first, last, 23033, "epsg", 23033,
        "ED50 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 33N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23033\"]]");
    p = add_epsg_def (filter, first, last, 23034, "epsg", 23034,
        "ED50 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 34N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23034\"]]");
    p = add_epsg_def (filter, first, last, 23035, "epsg", 23035,
        "ED50 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 35N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23035\"]]");
    p = add_epsg_def (filter, first, last, 23036, "epsg", 23036,
        "ED50 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 36N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23036\"]]");
    p = add_epsg_def (filter, first, last, 23037, "epsg", 23037,
        "ED50 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 37N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23037\"]]");
    p = add_epsg_def (filter, first, last, 23038, "epsg", 23038,
        "ED50 / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 38N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23038\"]]");
    p = add_epsg_def (filter, first, last, 23090, "epsg", 23090,
        "ED50 / TM 0 N");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 0 N\",GEOGCS[\"ED50\",DATUM[\"Europea");
    add_srs_wkt (p, 1,
        "n_Datum_1950\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",0],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"23090\"]]");
    p = add_epsg_def (filter, first, last, 23095, "epsg", 23095,
        "ED50 / TM 5 NE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 5 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",5],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23095\"]]");
    p = add_epsg_def (filter, first, last, 23239, "epsg", 23239,
        "Fahud / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-346,-1,224,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 39N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-346,-1,224,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23239\"]]");
    p = add_epsg_def (filter, first, last, 23240, "epsg", 23240,
        "Fahud / UTM zone 40N");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-346,-1,224,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 40N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-346,-1,224,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23240\"]]");
    p = add_epsg_def (filter, first, last, 23433, "epsg", 23433,
        "Garoua / UTM zone 33N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Garoua / UTM zone 33N (deprecated)\",GEOGCS[\"G");
    add_srs_wkt (p, 1,
        "aroua\",DATUM[\"Garoua\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936265,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6234\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4234\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"23433\"]]");
    p = add_epsg_def (filter, first, last, 23700, "epsg", 23700,
        "HD72 / EOV");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=47.14439372222222 +lon_0=19.04857177");
    add_proj4text (p, 1,
        "777778 +k_0=0.99993 +x_0=650000 +y_0=200000 +ellps=GRS67");
    add_proj4text (p, 2,
        " +towgs84=52.17,-71.82,-14.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HD72 / EOV\",GEOGCS[\"HD72\",DATUM[\"Hungarian_");
    add_srs_wkt (p, 1,
        "Datum_1972\",SPHEROID[\"GRS 1967\",6378160,298.247167427");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7036\"]],TOWGS84[52.17,-71.82,-14.");
    add_srs_wkt (p, 3,
        "9,0,0,0,0],AUTHORITY[\"EPSG\",\"6237\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4237\"]],PROJECTION[\"Hotine_Oblique_Mercato");
    add_srs_wkt (p, 7,
        "r_Azimuth_Center\"],PARAMETER[\"latitude_of_center\",47.");
    add_srs_wkt (p, 8,
        "14439372222222],PARAMETER[\"longitude_of_center\",19.048");
    add_srs_wkt (p, 9,
        "57177777778],PARAMETER[\"azimuth\",90],PARAMETER[\"recti");
    add_srs_wkt (p, 10,
        "fied_grid_angle\",90],PARAMETER[\"scale_factor\",0.99993");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",650000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"23700\"]]");
    p = add_epsg_def (filter, first, last, 23830, "epsg", 23830,
        "DGN95 / Indonesia TM-3 zone 46.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=94.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 46.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",94.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"23830\"]]");
    p = add_epsg_def (filter, first, last, 23831, "epsg", 23831,
        "DGN95 / Indonesia TM-3 zone 47.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=97.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",97.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"23831\"]]");
    p = add_epsg_def (filter, first, last, 23832, "epsg", 23832,
        "DGN95 / Indonesia TM-3 zone 47.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",100.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23832\"]]");
    p = add_epsg_def (filter, first, last, 23833, "epsg", 23833,
        "DGN95 / Indonesia TM-3 zone 48.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",103.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23833\"]]");
    p = add_epsg_def (filter, first, last, 23834, "epsg", 23834,
        "DGN95 / Indonesia TM-3 zone 48.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",106.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23834\"]]");
    p = add_epsg_def (filter, first, last, 23835, "epsg", 23835,
        "DGN95 / Indonesia TM-3 zone 49.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",109.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23835\"]]");
    p = add_epsg_def (filter, first, last, 23836, "epsg", 23836,
        "DGN95 / Indonesia TM-3 zone 49.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",112.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23836\"]]");
    p = add_epsg_def (filter, first, last, 23837, "epsg", 23837,
        "DGN95 / Indonesia TM-3 zone 50.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",115.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23837\"]]");
    p = add_epsg_def (filter, first, last, 23838, "epsg", 23838,
        "DGN95 / Indonesia TM-3 zone 50.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",118.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23838\"]]");
    p = add_epsg_def (filter, first, last, 23839, "epsg", 23839,
        "DGN95 / Indonesia TM-3 zone 51.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",121.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23839\"]]");
    p = add_epsg_def (filter, first, last, 23840, "epsg", 23840,
        "DGN95 / Indonesia TM-3 zone 51.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",124.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23840\"]]");
    p = add_epsg_def (filter, first, last, 23841, "epsg", 23841,
        "DGN95 / Indonesia TM-3 zone 52.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",127.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23841\"]]");
    p = add_epsg_def (filter, first, last, 23842, "epsg", 23842,
        "DGN95 / Indonesia TM-3 zone 52.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",130.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23842\"]]");
    p = add_epsg_def (filter, first, last, 23843, "epsg", 23843,
        "DGN95 / Indonesia TM-3 zone 53.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",133.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23843\"]]");
    p = add_epsg_def (filter, first, last, 23844, "epsg", 23844,
        "DGN95 / Indonesia TM-3 zone 53.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",136.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23844\"]]");
    p = add_epsg_def (filter, first, last, 23845, "epsg", 23845,
        "DGN95 / Indonesia TM-3 zone 54.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 54.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",139.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23845\"]]");
    p = add_epsg_def (filter, first, last, 23846, "epsg", 23846,
        "ID74 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",93],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"23846\"]]");
    p = add_epsg_def (filter, first, last, 23847, "epsg", 23847,
        "ID74 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",99],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"23847\"]]");
    p = add_epsg_def (filter, first, last, 23848, "epsg", 23848,
        "ID74 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",105],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23848\"]]");
    p = add_epsg_def (filter, first, last, 23849, "epsg", 23849,
        "ID74 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23849\"]]");
    p = add_epsg_def (filter, first, last, 23850, "epsg", 23850,
        "ID74 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",117],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23850\"]]");
    p = add_epsg_def (filter, first, last, 23851, "epsg", 23851,
        "ID74 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",123],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23851\"]]");
    p = add_epsg_def (filter, first, last, 23852, "epsg", 23852,
        "ID74 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",129],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23852\"]]");
    p = add_epsg_def (filter, first, last, 23853, "epsg", 23853,
        "ID74 / UTM zone 53N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53N (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"23853\"]]");
    p = add_epsg_def (filter, first, last, 23866, "epsg", 23866,
        "DGN95 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 46N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23866\"]]");
    p = add_epsg_def (filter, first, last, 23867, "epsg", 23867,
        "DGN95 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23867\"]]");
    p = add_epsg_def (filter, first, last, 23868, "epsg", 23868,
        "DGN95 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23868\"]]");
    p = add_epsg_def (filter, first, last, 23869, "epsg", 23869,
        "DGN95 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23869\"]]");
    p = add_epsg_def (filter, first, last, 23870, "epsg", 23870,
        "DGN95 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23870\"]]");
    p = add_epsg_def (filter, first, last, 23871, "epsg", 23871,
        "DGN95 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23871\"]]");
    p = add_epsg_def (filter, first, last, 23872, "epsg", 23872,
        "DGN95 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23872\"]]");
    p = add_epsg_def (filter, first, last, 23877, "epsg", 23877,
        "DGN95 / UTM zone 47S");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"23877\"]]");
    p = add_epsg_def (filter, first, last, 23878, "epsg", 23878,
        "DGN95 / UTM zone 48S");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23878\"]]");
    p = add_epsg_def (filter, first, last, 23879, "epsg", 23879,
        "DGN95 / UTM zone 49S");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23879\"]]");
    p = add_epsg_def (filter, first, last, 23880, "epsg", 23880,
        "DGN95 / UTM zone 50S");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23880\"]]");
    p = add_epsg_def (filter, first, last, 23881, "epsg", 23881,
        "DGN95 / UTM zone 51S");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23881\"]]");
    p = add_epsg_def (filter, first, last, 23882, "epsg", 23882,
        "DGN95 / UTM zone 52S");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23882\"]]");
    p = add_epsg_def (filter, first, last, 23883, "epsg", 23883,
        "DGN95 / UTM zone 53S");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 53S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23883\"]]");
    p = add_epsg_def (filter, first, last, 23884, "epsg", 23884,
        "DGN95 / UTM zone 54S");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 54S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23884\"]]");
    p = add_epsg_def (filter, first, last, 23886, "epsg", 23886,
        "ID74 / UTM zone 46S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46S (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23886\"]]");
    p = add_epsg_def (filter, first, last, 23887, "epsg", 23887,
        "ID74 / UTM zone 47S");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",99],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"23887\"]]");
    p = add_epsg_def (filter, first, last, 23888, "epsg", 23888,
        "ID74 / UTM zone 48S");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",105],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23888\"]]");
    p = add_epsg_def (filter, first, last, 23889, "epsg", 23889,
        "ID74 / UTM zone 49S");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23889\"]]");
    p = add_epsg_def (filter, first, last, 23890, "epsg", 23890,
        "ID74 / UTM zone 50S");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",117],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23890\"]]");
    p = add_epsg_def (filter, first, last, 23891, "epsg", 23891,
        "ID74 / UTM zone 51S");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",123],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23891\"]]");
    p = add_epsg_def (filter, first, last, 23892, "epsg", 23892,
        "ID74 / UTM zone 52S");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",129],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23892\"]]");
    p = add_epsg_def (filter, first, last, 23893, "epsg", 23893,
        "ID74 / UTM zone 53S");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",135],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23893\"]]");
    p = add_epsg_def (filter, first, last, 23894, "epsg", 23894,
        "ID74 / UTM zone 54S");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 54S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",141],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23894\"]]");
    p = add_epsg_def (filter, first, last, 23946, "epsg", 23946,
        "Indian 1954 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 46N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23946\"]]");
    p = add_epsg_def (filter, first, last, 23947, "epsg", 23947,
        "Indian 1954 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23947\"]]");
    p = add_epsg_def (filter, first, last, 23948, "epsg", 23948,
        "Indian 1954 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"23948\"]]");
    p = add_epsg_def (filter, first, last, 24047, "epsg", 24047,
        "Indian 1975 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"24047\"]]");
    p = add_epsg_def (filter, first, last, 24048, "epsg", 24048,
        "Indian 1975 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"24048\"]]");
    p = add_epsg_def (filter, first, last, 24100, "epsg", 24100,
        "Jamaica 1875 / Jamaica (Old Grid)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167");
    add_proj4text (p, 1,
        "638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356");
    add_proj4text (p, 2,
        "514.966204134 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Jamaica 1875 / Jamaica (Old Grid)\",GEOGCS[\"Ja");
    add_srs_wkt (p, 1,
        "maica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80\",6378249.144808011,293.4663076556349,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4241\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",18],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-77],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"false_easting\",550000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",400000],UNIT[\"Clarke's foot\",0.3047972654,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9005\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24100\"]]");
    p = add_epsg_def (filter, first, last, 24200, "epsg", 24200,
        "JAD69 / Jamaica National Grid");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250");
    add_proj4text (p, 1,
        "000 +y_0=150000 +ellps=clrk66 +towgs84=70,207,389.5,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD69 / Jamaica National Grid\",GEOGCS[\"JAD69\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Jamaica_1969\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[70,207,389.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6242\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4242\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "18],PARAMETER[\"central_meridian\",-77],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",250000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",150000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24200\"]]");
    p = add_epsg_def (filter, first, last, 24305, "epsg", 24305,
        "Kalianpur 1937 / UTM zone 45N");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",87],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24305\"]]");
    p = add_epsg_def (filter, first, last, 24306, "epsg", 24306,
        "Kalianpur 1937 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",93],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24306\"]]");
    p = add_epsg_def (filter, first, last, 24311, "epsg", 24311,
        "Kalianpur 1962 / UTM zone 41N");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 41N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",63],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24311");
    add_srs_wkt (p, 13,
        "\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

