/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_22 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 4530, "epsg", 4530,
        "CGCS2000 / 3-degree Gauss-Kruger zone 42");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 42\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",126],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",42500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AUTHORITY[\"EPSG\",\"4530\"]]");
    p = add_epsg_def (filter, first, last, 4531, "epsg", 4531,
        "CGCS2000 / 3-degree Gauss-Kruger zone 43");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 43\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",129],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",43500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AUTHORITY[\"EPSG\",\"4531\"]]");
    p = add_epsg_def (filter, first, last, 4532, "epsg", 4532,
        "CGCS2000 / 3-degree Gauss-Kruger zone 44");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 44\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",132],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",44500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AUTHORITY[\"EPSG\",\"4532\"]]");
    p = add_epsg_def (filter, first, last, 4533, "epsg", 4533,
        "CGCS2000 / 3-degree Gauss-Kruger zone 45");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger zone 45\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",135],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",45500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AUTHORITY[\"EPSG\",\"4533\"]]");
    p = add_epsg_def (filter, first, last, 4534, "epsg", 4534,
        "CGCS2000 / 3-degree Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 75E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4534\"]]");
    p = add_epsg_def (filter, first, last, 4535, "epsg", 4535,
        "CGCS2000 / 3-degree Gauss-Kruger CM 78E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 78E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",78],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4535\"]]");
    p = add_epsg_def (filter, first, last, 4536, "epsg", 4536,
        "CGCS2000 / 3-degree Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 81E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",81],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4536\"]]");
    p = add_epsg_def (filter, first, last, 4537, "epsg", 4537,
        "CGCS2000 / 3-degree Gauss-Kruger CM 84E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 84E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",84],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4537\"]]");
    p = add_epsg_def (filter, first, last, 4538, "epsg", 4538,
        "CGCS2000 / 3-degree Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 87E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",87],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4538\"]]");
    p = add_epsg_def (filter, first, last, 4539, "epsg", 4539,
        "CGCS2000 / 3-degree Gauss-Kruger CM 90E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 90E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",90],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4539\"]]");
    p = add_epsg_def (filter, first, last, 4540, "epsg", 4540,
        "CGCS2000 / 3-degree Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 93E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",93],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4540\"]]");
    p = add_epsg_def (filter, first, last, 4541, "epsg", 4541,
        "CGCS2000 / 3-degree Gauss-Kruger CM 96E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 96E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",96],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4541\"]]");
    p = add_epsg_def (filter, first, last, 4542, "epsg", 4542,
        "CGCS2000 / 3-degree Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 99E\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"China Geodetic Coordinate System 2000\",DATUM[\"Chin");
    add_srs_wkt (p, 2,
        "a_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",99],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AUTHORITY[\"EPSG\",\"4542\"]]");
    p = add_epsg_def (filter, first, last, 4543, "epsg", 4543,
        "CGCS2000 / 3-degree Gauss-Kruger CM 102E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 102E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",102],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4543\"]]");
    p = add_epsg_def (filter, first, last, 4544, "epsg", 4544,
        "CGCS2000 / 3-degree Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 105E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4544\"]]");
    p = add_epsg_def (filter, first, last, 4545, "epsg", 4545,
        "CGCS2000 / 3-degree Gauss-Kruger CM 108E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 108E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",108],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4545\"]]");
    p = add_epsg_def (filter, first, last, 4546, "epsg", 4546,
        "CGCS2000 / 3-degree Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 111E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4546\"]]");
    p = add_epsg_def (filter, first, last, 4547, "epsg", 4547,
        "CGCS2000 / 3-degree Gauss-Kruger CM 114E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 114E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",114],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4547\"]]");
    p = add_epsg_def (filter, first, last, 4548, "epsg", 4548,
        "CGCS2000 / 3-degree Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 117E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",117],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4548\"]]");
    p = add_epsg_def (filter, first, last, 4549, "epsg", 4549,
        "CGCS2000 / 3-degree Gauss-Kruger CM 120E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 120E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",120],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4549\"]]");
    p = add_epsg_def (filter, first, last, 4550, "epsg", 4550,
        "CGCS2000 / 3-degree Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 123E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",123],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4550\"]]");
    p = add_epsg_def (filter, first, last, 4551, "epsg", 4551,
        "CGCS2000 / 3-degree Gauss-Kruger CM 126E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 126E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",126],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4551\"]]");
    p = add_epsg_def (filter, first, last, 4552, "epsg", 4552,
        "CGCS2000 / 3-degree Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 129E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",129],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4552\"]]");
    p = add_epsg_def (filter, first, last, 4553, "epsg", 4553,
        "CGCS2000 / 3-degree Gauss-Kruger CM 132E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 132E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",132],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4553\"]]");
    p = add_epsg_def (filter, first, last, 4554, "epsg", 4554,
        "CGCS2000 / 3-degree Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CGCS2000 / 3-degree Gauss-Kruger CM 135E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"China Geodetic Coordinate System 2000\",DATUM[\"Chi");
    add_srs_wkt (p, 2,
        "na_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4490\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",135],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AUTHORITY[\"EPSG\",\"4554\"]]");
    p = add_epsg_def (filter, first, last, 4555, "epsg", 4555,
        "New Beijing");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 2,
        "4\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"4555\"]]");
    p = add_epsg_def (filter, first, last, 4558, "epsg", 4558,
        "RRAF 1991");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RRAF 1991\",DATUM[\"Reseau_de_Reference_des_Ant");
    add_srs_wkt (p, 1,
        "illes_Francaises_1991\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1047\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4558\"]]");
    p = add_epsg_def (filter, first, last, 4559, "epsg", 4559,
        "RRAF 1991 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RRAF 1991 / UTM zone 20N\",GEOGCS[\"RRAF 1991\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_de_Reference_des_Antilles_Francaises_199");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4558\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",-63],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4559\"]]");
    p = add_epsg_def (filter, first, last, 4568, "epsg", 4568,
        "New Beijing / Gauss-Kruger zone 13");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 13\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",75]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4568\"]]");
    p = add_epsg_def (filter, first, last, 4569, "epsg", 4569,
        "New Beijing / Gauss-Kruger zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 14\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",81]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4569\"]]");
    p = add_epsg_def (filter, first, last, 4570, "epsg", 4570,
        "New Beijing / Gauss-Kruger zone 15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 15\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",87]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4570\"]]");
    p = add_epsg_def (filter, first, last, 4571, "epsg", 4571,
        "New Beijing / Gauss-Kruger zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 16\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",93]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4571\"]]");
    p = add_epsg_def (filter, first, last, 4572, "epsg", 4572,
        "New Beijing / Gauss-Kruger zone 17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 17\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",99]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4572\"]]");
    p = add_epsg_def (filter, first, last, 4573, "epsg", 4573,
        "New Beijing / Gauss-Kruger zone 18");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 18\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",105");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4573\"]]");
    p = add_epsg_def (filter, first, last, 4574, "epsg", 4574,
        "New Beijing / Gauss-Kruger zone 19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 19\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4574\"]]");
    p = add_epsg_def (filter, first, last, 4575, "epsg", 4575,
        "New Beijing / Gauss-Kruger zone 20");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 20\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",117");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4575\"]]");
    p = add_epsg_def (filter, first, last, 4576, "epsg", 4576,
        "New Beijing / Gauss-Kruger zone 21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 21\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",123");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4576\"]]");
    p = add_epsg_def (filter, first, last, 4577, "epsg", 4577,
        "New Beijing / Gauss-Kruger zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 22\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",129");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4577\"]]");
    p = add_epsg_def (filter, first, last, 4578, "epsg", 4578,
        "New Beijing / Gauss-Kruger zone 23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger zone 23\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",135");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"4578\"]]");
    p = add_epsg_def (filter, first, last, 4579, "epsg", 4579,
        "New Beijing / Gauss-Kruger CM 75E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 75E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"457");
    add_srs_wkt (p, 11,
        "9\"]]");
    p = add_epsg_def (filter, first, last, 4580, "epsg", 4580,
        "New Beijing / Gauss-Kruger CM 81E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 81E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",81],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"458");
    add_srs_wkt (p, 11,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 4581, "epsg", 4581,
        "New Beijing / Gauss-Kruger CM 87E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 87E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",87],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"458");
    add_srs_wkt (p, 11,
        "1\"]]");
    p = add_epsg_def (filter, first, last, 4582, "epsg", 4582,
        "New Beijing / Gauss-Kruger CM 93E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 93E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",93],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"458");
    add_srs_wkt (p, 11,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 4583, "epsg", 4583,
        "New Beijing / Gauss-Kruger CM 99E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 99E\",GEOGCS[\"Ne");
    add_srs_wkt (p, 1,
        "w Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4555");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",99],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"458");
    add_srs_wkt (p, 11,
        "3\"]]");
    p = add_epsg_def (filter, first, last, 4584, "epsg", 4584,
        "New Beijing / Gauss-Kruger CM 105E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 105E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",105");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4584\"]]");
    p = add_epsg_def (filter, first, last, 4585, "epsg", 4585,
        "New Beijing / Gauss-Kruger CM 111E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 111E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4585\"]]");
    p = add_epsg_def (filter, first, last, 4586, "epsg", 4586,
        "New Beijing / Gauss-Kruger CM 117E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 117E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",117");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4586\"]]");
    p = add_epsg_def (filter, first, last, 4587, "epsg", 4587,
        "New Beijing / Gauss-Kruger CM 123E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 123E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",123");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4587\"]]");
    p = add_epsg_def (filter, first, last, 4588, "epsg", 4588,
        "New Beijing / Gauss-Kruger CM 129E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 129E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",129");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4588\"]]");
    p = add_epsg_def (filter, first, last, 4589, "epsg", 4589,
        "New Beijing / Gauss-Kruger CM 135E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 135E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",135");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "4589\"]]");
    p = add_epsg_def (filter, first, last, 4600, "epsg", 4600,
        "Anguilla 1957");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Anguilla 1957\",DATUM[\"Anguilla_1957\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6600\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"4600\"]]");
    p = add_epsg_def (filter, first, last, 4601, "epsg", 4601,
        "Antigua 1943");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Antigua 1943\",DATUM[\"Antigua_1943\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-255,-15,71,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6601\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4601\"]]");
    p = add_epsg_def (filter, first, last, 4602, "epsg", 4602,
        "Dominica 1945");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dominica 1945\",DATUM[\"Dominica_1945\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[725,685,536,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6602\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4602\"]]");
    p = add_epsg_def (filter, first, last, 4603, "epsg", 4603,
        "Grenada 1953");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grenada 1953\",DATUM[\"Grenada_1953\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[72,213.7,93,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6603\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4603\"]]");
    p = add_epsg_def (filter, first, last, 4604, "epsg", 4604,
        "Montserrat 1958");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Montserrat 1958\",DATUM[\"Montserrat_1958\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],TOWGS84[174,359,365,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6604\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4604");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def (filter, first, last, 4605, "epsg", 4605,
        "St. Kitts 1955");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Kitts 1955\",DATUM[\"St_Kitts_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[9,183,236,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6605\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4605\"]]");
    p = add_epsg_def (filter, first, last, 4606, "epsg", 4606,
        "St. Lucia 1955");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Lucia 1955\",DATUM[\"St_Lucia_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[-149,128,296,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6606\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4606\"]]");
    p = add_epsg_def (filter, first, last, 4607, "epsg", 4607,
        "St. Vincent 1945");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274");
    add_proj4text (p, 1,
        ".607,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Vincent 1945\",DATUM[\"St_Vincent_1945\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7012\"]],TOWGS84[195.671,332.517,274.607,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6607\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4607\"]]");
    p = add_epsg_def (filter, first, last, 4608, "epsg", 4608,
        "NAD27(76)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(76)\",DATUM[\"North_American_Datum_1927_1");
    add_srs_wkt (p, 1,
        "976\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821390");
    add_srs_wkt (p, 2,
        "06,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 3,
        "08\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4608\"]]");
    p = add_epsg_def (filter, first, last, 4609, "epsg", 4609,
        "NAD27(CGQ77)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(CGQ77)\",DATUM[\"North_American_Datum_192");
    add_srs_wkt (p, 1,
        "7_CGQ77\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982");
    add_srs_wkt (p, 2,
        "139006,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6609\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4609\"]]");
    p = add_epsg_def (filter, first, last, 4610, "epsg", 4610,
        "Xian 1980");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG ");
    add_srs_wkt (p, 1,
        "1975\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 5,
        "10\"]]");
    p = add_epsg_def (filter, first, last, 4611, "epsg", 4611,
        "Hong Kong 1980");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-16");
    add_proj4text (p, 1,
        "1.764,0.067753,-2.24365,-1.15883,-1.09425 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1980\",DATUM[\"Hong_Kong_1980\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],TOWGS84[-162.619,-276.959,-161.764,0.067753,");
    add_srs_wkt (p, 3,
        "-2.24365,-1.15883,-1.09425],AUTHORITY[\"EPSG\",\"6611\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4611\"]]");
    p = add_epsg_def (filter, first, last, 4612, "epsg", 4612,
        "JGD2000");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4612\"]]");
    p = add_epsg_def (filter, first, last, 4613, "epsg", 4613,
        "Segara");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara\",DATUM[\"Gunung_Segara\",SPHEROID[\"Bes");
    add_srs_wkt (p, 1,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6613\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4613\"]]");
    p = add_epsg_def (filter, first, last, 4614, "epsg", 4614,
        "QND95");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-119.425,-303.659,-11");
    add_proj4text (p, 1,
        ".0006,1.1643,0.174458,1.09626,3.65706 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"QND95\",DATUM[\"Qatar_National_Datum_1995\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-119.425,-303.659,-11.0006,1.1643");
    add_srs_wkt (p, 3,
        ",0.174458,1.09626,3.65706],AUTHORITY[\"EPSG\",\"6614\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4614\"]]");
    p = add_epsg_def (filter, first, last, 4615, "epsg", 4615,
        "Porto Santo");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Porto Santo\",DATUM[\"Porto_Santo_1936\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],TOWGS84[-499,-249,314,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6615\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4615\"]]");
    p = add_epsg_def (filter, first, last, 4616, "epsg", 4616,
        "Selvagem Grande");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-289,-124,60,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Selvagem Grande\",DATUM[\"Selvagem_Grande\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-289,-124,60,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6616\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4616\"]]");
    p = add_epsg_def (filter, first, last, 4617, "epsg", 4617,
        "NAD83(CSRS)");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4617\"]]");
    p = add_epsg_def (filter, first, last, 4618, "epsg", 4618,
        "SAD69");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69\",DATUM[\"South_American_Datum_1969\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7050\"]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6618\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4618\"]]");
    p = add_epsg_def (filter, first, last, 4619, "epsg", 4619,
        "SWEREF99");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4619\"]]");
    p = add_epsg_def (filter, first, last, 4620, "epsg", 4620,
        "Point 58");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Point 58\",DATUM[\"Point_58\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],TOWGS84[-106,-129,165,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6620\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4620\"]]");
    p = add_epsg_def (filter, first, last, 4621, "epsg", 4621,
        "Fort Marigot");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fort Marigot\",DATUM[\"Fort_Marigot\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[137,248,-430,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6621\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4621\"]]");
    p = add_epsg_def (filter, first, last, 4622, "epsg", 4622,
        "Guadeloupe 1948");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-467,-16,-300,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guadeloupe 1948\",DATUM[\"Guadeloupe_1948\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-467,-16,-300,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6622\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4622\"]]");
    p = add_epsg_def (filter, first, last, 4623, "epsg", 4623,
        "CSG67");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CSG67\",DATUM[\"Centre_Spatial_Guyanais_1967\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-186,230,110,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6623\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4623\"]]");
    p = add_epsg_def (filter, first, last, 4624, "epsg", 4624,
        "RGFG95");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGFG95\",DATUM[\"Reseau_Geodesique_Francais_Guy");
    add_srs_wkt (p, 1,
        "ane_1995\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6624\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"462");
    add_srs_wkt (p, 6,
        "4\"]]");
    p = add_epsg_def (filter, first, last, 4625, "epsg", 4625,
        "Martinique 1938");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=186,482,151,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Martinique 1938\",DATUM[\"Martinique_1938\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[186,482,151,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6625\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4625\"]]");
    p = add_epsg_def (filter, first, last, 4626, "epsg", 4626,
        "Reunion 1947");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=94,-948,-1262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Reunion 1947\",DATUM[\"Reunion_1947\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[94,-948,-1262,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6626\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4626\"]]");
    p = add_epsg_def (filter, first, last, 4627, "epsg", 4627,
        "RGR92");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGR92\",DATUM[\"Reseau_Geodesique_de_la_Reunion");
    add_srs_wkt (p, 1,
        "_1992\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6627\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4627\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def (filter, first, last, 4628, "epsg", 4628,
        "Tahiti 52");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahiti 52\",DATUM[\"Tahiti_52\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[162,117,154,0,0,0,0],AUTHORITY[\"EPSG\",\"662");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4628\"]]");
    p = add_epsg_def (filter, first, last, 4629, "epsg", 4629,
        "Tahaa 54");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486");
    add_proj4text (p, 1,
        ",1.6045,0.8823,0.5565,1.3746 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahaa 54\",DATUM[\"Tahaa_54\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[72.438,345.918,79.486,1.6045,0.8823,0.5565,1.37");
    add_srs_wkt (p, 3,
        "46],AUTHORITY[\"EPSG\",\"6629\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"4629\"]]");
    p = add_epsg_def (filter, first, last, 4630, "epsg", 4630,
        "IGN72 Nuku Hiva");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=84,274,65,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Nuku Hiva\",DATUM[\"IGN72_Nuku_Hiva\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[84,274,65,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6630\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4630\"]]");
    p = add_epsg_def (filter, first, last, 4631, "epsg", 4631,
        "K0 1949");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"K0 1949\",DATUM[\"K0_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 1,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 2,
        "OWGS84[145,-187,103,0,0,0,0],AUTHORITY[\"EPSG\",\"6631\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4631\"]]");
    p = add_epsg_def (filter, first, last, 4632, "epsg", 4632,
        "Combani 1950");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Combani 1950\",DATUM[\"Combani_1950\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-382,-59,-262,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6632\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4632\"]]");
    p = add_epsg_def (filter, first, last, 4633, "epsg", 4633,
        "IGN56 Lifou");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN56 Lifou\",DATUM[\"IGN56_Lifou\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[335.47,222.58,-230.94,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6633\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4633\"]]");
    p = add_epsg_def (filter, first, last, 4634, "epsg", 4634,
        "IGN72 Grand Terre");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Grand Terre\",DATUM[\"IGN72_Grande_Terre\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-13,-348,292,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6634\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"4634\"]]");
    p = add_epsg_def (filter, first, last, 4635, "epsg", 4635,
        "ST87 Ouvea");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103");
    add_proj4text (p, 1,
        ".344,3.5107,-4.9668,-5.7047,4.4798 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST87 Ouvea\",DATUM[\"ST87_Ouvea\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[-122.383,-188.696,103.344,3.5107,-4.9668,-5");
    add_srs_wkt (p, 3,
        ".7047,4.4798],AUTHORITY[\"EPSG\",\"6635\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4635\"]]");
    p = add_epsg_def (filter, first, last, 4636, "epsg", 4636,
        "Petrels 1972");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=365,194,166,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Petrels 1972\",DATUM[\"Petrels_1972\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[365,194,166,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6636\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4636\"]]");
    p = add_epsg_def (filter, first, last, 4637, "epsg", 4637,
        "Perroud 1950");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Perroud 1950\",DATUM[\"Pointe_Geologie_Perroud_");
    add_srs_wkt (p, 1,
        "1950\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[325,154,172,0,0,0,0],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6637\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "637\"]]");
    p = add_epsg_def (filter, first, last, 4638, "epsg", 4638,
        "Saint Pierre et Miquelon 1950");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Saint Pierre et Miquelon 1950\",DATUM[\"Saint_P");
    add_srs_wkt (p, 1,
        "ierre_et_Miquelon_1950\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[30,430,368,0,0,0,0],AUTHORITY[\"EPSG\",\"6638\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4638\"]]");
    p = add_epsg_def (filter, first, last, 4639, "epsg", 4639,
        "MOP78");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=253,-132,-127,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MOP78\",DATUM[\"MOP78\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 2,
        "84[253,-132,-127,0,0,0,0],AUTHORITY[\"EPSG\",\"6639\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4639\"]]");
    p = add_epsg_def (filter, first, last, 4640, "epsg", 4640,
        "RRAF 1991");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RRAF 1991\",DATUM[\"Reseau_de_Reference_des_Ant");
    add_srs_wkt (p, 1,
        "illes_Francaises_1991\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6640\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4640\"]]");
    p = add_epsg_def (filter, first, last, 4641, "epsg", 4641,
        "IGN53 Mare");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=287.58,177.78,-135.41");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN53 Mare\",DATUM[\"IGN53_Mare\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[287.58,177.78,-135.41,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6641\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4641\"]]");
    p = add_epsg_def (filter, first, last, 4642, "epsg", 4642,
        "ST84 Ile des Pins");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST84 Ile des Pins\",DATUM[\"ST84_Ile_des_Pins\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-13,-348,292,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6642\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4642\"]]");
    p = add_epsg_def (filter, first, last, 4643, "epsg", 4643,
        "ST71 Belep");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.");
    add_proj4text (p, 1,
        "429,16.3119,20.1721,-4.0349,-111.7 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST71 Belep\",DATUM[\"ST71_Belep\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[-480.26,-438.32,-643.429,16.3119,20.1721,-4");
    add_srs_wkt (p, 3,
        ".0349,-111.7],AUTHORITY[\"EPSG\",\"6643\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4643\"]]");
    p = add_epsg_def (filter, first, last, 4644, "epsg", 4644,
        "NEA74 Noumea");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-10.18,-350.43,291.37");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NEA74 Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-10.18,-350.43,291.37,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6644\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4644\"]]");
    p = add_epsg_def (filter, first, last, 4645, "epsg", 4645,
        "RGNC 1991");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGNC 1991\",DATUM[\"Reseau_Geodesique_Nouvelle_");
    add_srs_wkt (p, 1,
        "Caledonie_1991\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6645\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4645\"]]");
    p = add_epsg_def (filter, first, last, 4646, "epsg", 4646,
        "Grand Comoros");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-963,510,-359,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grand Comoros\",DATUM[\"Grand_Comoros\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[-963,510,-359,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6646\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4646\"]]");
    p = add_epsg_def (filter, first, last, 4647, "epsg", 4647,
        "ETRS89 / UTM zone 32N (zE-N)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",3250000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"4647\"]]");
    p = add_epsg_def (filter, first, last, 4652, "epsg", 4652,
        "New Beijing / 3-degree Gauss-Kruger zone 25");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 25\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",75],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",25500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"4652\"]]");
    p = add_epsg_def (filter, first, last, 4653, "epsg", 4653,
        "New Beijing / 3-degree Gauss-Kruger zone 26");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 26\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",78],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",26500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"4653\"]]");
    p = add_epsg_def (filter, first, last, 4654, "epsg", 4654,
        "New Beijing / 3-degree Gauss-Kruger zone 27");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 27\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",81],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",27500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"4654\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

