/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:29 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_12 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3244, "epsg", 3244,
        "WGS 84 / SCAR IMW SS10-12");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-117 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS10-12\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-117],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3244\"]]");
    p = add_epsg_def (filter, first, last, 3245, "epsg", 3245,
        "WGS 84 / SCAR IMW SS13-15");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-99 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS13-15\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-99],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "245\"]]");
    p = add_epsg_def (filter, first, last, 3246, "epsg", 3246,
        "WGS 84 / SCAR IMW SS16-18");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-81 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS16-18\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "246\"]]");
    p = add_epsg_def (filter, first, last, 3247, "epsg", 3247,
        "WGS 84 / SCAR IMW SS19-21");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-63 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS19-21\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "247\"]]");
    p = add_epsg_def (filter, first, last, 3248, "epsg", 3248,
        "WGS 84 / SCAR IMW SS25-27");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-27 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS25-27\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-27],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "248\"]]");
    p = add_epsg_def (filter, first, last, 3249, "epsg", 3249,
        "WGS 84 / SCAR IMW SS28-30");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-9 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS28-30\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-9],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "249\"]]");
    p = add_epsg_def (filter, first, last, 3250, "epsg", 3250,
        "WGS 84 / SCAR IMW SS31-33");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=9 +x_0=0 +y_0=0 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS31-33\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",9],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"325");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def (filter, first, last, 3251, "epsg", 3251,
        "WGS 84 / SCAR IMW SS34-36");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=27 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS34-36\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",27],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "251\"]]");
    p = add_epsg_def (filter, first, last, 3252, "epsg", 3252,
        "WGS 84 / SCAR IMW SS37-39");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=45 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS37-39\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",45],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "252\"]]");
    p = add_epsg_def (filter, first, last, 3253, "epsg", 3253,
        "WGS 84 / SCAR IMW SS40-42");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=63 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS40-42\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",63],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "253\"]]");
    p = add_epsg_def (filter, first, last, 3254, "epsg", 3254,
        "WGS 84 / SCAR IMW SS43-45");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=81 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS43-45\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",81],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "254\"]]");
    p = add_epsg_def (filter, first, last, 3255, "epsg", 3255,
        "WGS 84 / SCAR IMW SS46-48");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=99 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS46-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",99],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "255\"]]");
    p = add_epsg_def (filter, first, last, 3256, "epsg", 3256,
        "WGS 84 / SCAR IMW SS49-51");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=117 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS49-51\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "256\"]]");
    p = add_epsg_def (filter, first, last, 3257, "epsg", 3257,
        "WGS 84 / SCAR IMW SS52-54");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=135 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS52-54\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",135],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "257\"]]");
    p = add_epsg_def (filter, first, last, 3258, "epsg", 3258,
        "WGS 84 / SCAR IMW SS55-57");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=153 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS55-57\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",153],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "258\"]]");
    p = add_epsg_def (filter, first, last, 3259, "epsg", 3259,
        "WGS 84 / SCAR IMW SS58-60");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=171 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS58-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",171],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "259\"]]");
    p = add_epsg_def (filter, first, last, 3260, "epsg", 3260,
        "WGS 84 / SCAR IMW ST01-04");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-168 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST01-04\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-168],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3260\"]]");
    p = add_epsg_def (filter, first, last, 3261, "epsg", 3261,
        "WGS 84 / SCAR IMW ST05-08");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-144 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST05-08\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-144],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3261\"]]");
    p = add_epsg_def (filter, first, last, 3262, "epsg", 3262,
        "WGS 84 / SCAR IMW ST09-12");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-120 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST09-12\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-120],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3262\"]]");
    p = add_epsg_def (filter, first, last, 3263, "epsg", 3263,
        "WGS 84 / SCAR IMW ST13-16");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-96 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST13-16\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-96],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "263\"]]");
    p = add_epsg_def (filter, first, last, 3264, "epsg", 3264,
        "WGS 84 / SCAR IMW ST17-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-72 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST17-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-72],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "264\"]]");
    p = add_epsg_def (filter, first, last, 3265, "epsg", 3265,
        "WGS 84 / SCAR IMW ST21-24");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-48 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST21-24\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-48],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "265\"]]");
    p = add_epsg_def (filter, first, last, 3266, "epsg", 3266,
        "WGS 84 / SCAR IMW ST25-28");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-24 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST25-28\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-24],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "266\"]]");
    p = add_epsg_def (filter, first, last, 3267, "epsg", 3267,
        "WGS 84 / SCAR IMW ST29-32");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST29-32\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",0],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"326");
    add_srs_wkt (p, 13,
        "7\"]]");
    p = add_epsg_def (filter, first, last, 3268, "epsg", 3268,
        "WGS 84 / SCAR IMW ST33-36");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=24 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST33-36\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",24],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "268\"]]");
    p = add_epsg_def (filter, first, last, 3269, "epsg", 3269,
        "WGS 84 / SCAR IMW ST37-40");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=48 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST37-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",48],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "269\"]]");
    p = add_epsg_def (filter, first, last, 3270, "epsg", 3270,
        "WGS 84 / SCAR IMW ST41-44");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=72 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST41-44\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",72],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "270\"]]");
    p = add_epsg_def (filter, first, last, 3271, "epsg", 3271,
        "WGS 84 / SCAR IMW ST45-48");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=96 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST45-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",96],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "271\"]]");
    p = add_epsg_def (filter, first, last, 3272, "epsg", 3272,
        "WGS 84 / SCAR IMW ST49-52");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=120 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST49-52\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",120],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "272\"]]");
    p = add_epsg_def (filter, first, last, 3273, "epsg", 3273,
        "WGS 84 / SCAR IMW ST53-56");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=144 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST53-56\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",144],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "273\"]]");
    p = add_epsg_def (filter, first, last, 3274, "epsg", 3274,
        "WGS 84 / SCAR IMW ST57-60");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=168 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW ST57-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-76.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-79.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",168],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "274\"]]");
    p = add_epsg_def (filter, first, last, 3275, "epsg", 3275,
        "WGS 84 / SCAR IMW SU01-05");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU01-05\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-165]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3275\"]]");
    p = add_epsg_def (filter, first, last, 3276, "epsg", 3276,
        "WGS 84 / SCAR IMW SU06-10");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU06-10\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-135]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3276\"]]");
    p = add_epsg_def (filter, first, last, 3277, "epsg", 3277,
        "WGS 84 / SCAR IMW SU11-15");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU11-15\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-105]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3277\"]]");
    p = add_epsg_def (filter, first, last, 3278, "epsg", 3278,
        "WGS 84 / SCAR IMW SU16-20");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU16-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-75],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3278\"]]");
    p = add_epsg_def (filter, first, last, 3279, "epsg", 3279,
        "WGS 84 / SCAR IMW SU21-25");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU21-25\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-45],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3279\"]]");
    p = add_epsg_def (filter, first, last, 3280, "epsg", 3280,
        "WGS 84 / SCAR IMW SU26-30");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU26-30\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-15],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3280\"]]");
    p = add_epsg_def (filter, first, last, 3281, "epsg", 3281,
        "WGS 84 / SCAR IMW SU31-35");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU31-35\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",15],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3281\"]]");
    p = add_epsg_def (filter, first, last, 3282, "epsg", 3282,
        "WGS 84 / SCAR IMW SU36-40");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU36-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",45],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3282\"]]");
    p = add_epsg_def (filter, first, last, 3283, "epsg", 3283,
        "WGS 84 / SCAR IMW SU41-45");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU41-45\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3283\"]]");
    p = add_epsg_def (filter, first, last, 3284, "epsg", 3284,
        "WGS 84 / SCAR IMW SU46-50");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU46-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",105],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3284\"]]");
    p = add_epsg_def (filter, first, last, 3285, "epsg", 3285,
        "WGS 84 / SCAR IMW SU51-55");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU51-55\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",135],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3285\"]]");
    p = add_epsg_def (filter, first, last, 3286, "epsg", 3286,
        "WGS 84 / SCAR IMW SU56-60");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SU56-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",165],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3286\"]]");
    p = add_epsg_def (filter, first, last, 3287, "epsg", 3287,
        "WGS 84 / SCAR IMW SV01-10");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV01-10\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-150]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3287\"]]");
    p = add_epsg_def (filter, first, last, 3288, "epsg", 3288,
        "WGS 84 / SCAR IMW SV11-20");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV11-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-90],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3288\"]]");
    p = add_epsg_def (filter, first, last, 3289, "epsg", 3289,
        "WGS 84 / SCAR IMW SV21-30");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=-30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV21-30\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",-30],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3289\"]]");
    p = add_epsg_def (filter, first, last, 3290, "epsg", 3290,
        "WGS 84 / SCAR IMW SV31-40");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV31-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",30],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3290\"]]");
    p = add_epsg_def (filter, first, last, 3291, "epsg", 3291,
        "WGS 84 / SCAR IMW SV41-50");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV41-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",90],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3291\"]]");
    p = add_epsg_def (filter, first, last, 3292, "epsg", 3292,
        "WGS 84 / SCAR IMW SV51-60");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SV51-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",150],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3292\"]]");
    p = add_epsg_def (filter, first, last, 3293, "epsg", 3293,
        "WGS 84 / SCAR IMW SW01-60");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0");
    add_proj4text (p, 1,
        "=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SW01-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Polar_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "-80.23861111111111],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3293\"]]");
    p = add_epsg_def (filter, first, last, 3294, "epsg", 3294,
        "WGS 84 / USGS Transantarctic Mountains");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-78 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / USGS Transantarctic Mountains\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",63781");
    add_srs_wkt (p, 2,
        "37,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "standard_parallel_1\",-76.66666666666667],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_2\",-79.33333333333333],PARAMETER[\"lati");
    add_srs_wkt (p, 9,
        "tude_of_origin\",-78],PARAMETER[\"central_meridian\",162");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"3294\"]]");
    p = add_epsg_def (filter, first, last, 3296, "epsg", 3296,
        "RGPF / UTM zone 5S");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +south +ellps=GRS80 +towgs84=0.072,-0.");
    add_proj4text (p, 1,
        "507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGPF / UTM zone 5S\",GEOGCS[\"RGPF\",DATUM[\"Re");
    add_srs_wkt (p, 1,
        "seau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,");
    add_srs_wkt (p, 4,
        "-0.0093],AUTHORITY[\"EPSG\",\"6687\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4687\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-153],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"3296\"]]");
    p = add_epsg_def (filter, first, last, 3297, "epsg", 3297,
        "RGPF / UTM zone 6S");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=GRS80 +towgs84=0.072,-0.");
    add_proj4text (p, 1,
        "507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGPF / UTM zone 6S\",GEOGCS[\"RGPF\",DATUM[\"Re");
    add_srs_wkt (p, 1,
        "seau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,");
    add_srs_wkt (p, 4,
        "-0.0093],AUTHORITY[\"EPSG\",\"6687\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4687\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-147],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"3297\"]]");
    p = add_epsg_def (filter, first, last, 3298, "epsg", 3298,
        "RGPF / UTM zone 7S");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=GRS80 +towgs84=0.072,-0.");
    add_proj4text (p, 1,
        "507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGPF / UTM zone 7S\",GEOGCS[\"RGPF\",DATUM[\"Re");
    add_srs_wkt (p, 1,
        "seau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,");
    add_srs_wkt (p, 4,
        "-0.0093],AUTHORITY[\"EPSG\",\"6687\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4687\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-141],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"3298\"]]");
    p = add_epsg_def (filter, first, last, 3299, "epsg", 3299,
        "RGPF / UTM zone 8S");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +south +ellps=GRS80 +towgs84=0.072,-0.");
    add_proj4text (p, 1,
        "507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGPF / UTM zone 8S\",GEOGCS[\"RGPF\",DATUM[\"Re");
    add_srs_wkt (p, 1,
        "seau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,");
    add_srs_wkt (p, 4,
        "-0.0093],AUTHORITY[\"EPSG\",\"6687\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4687\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-135],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"3299\"]]");
    p = add_epsg_def (filter, first, last, 3300, "epsg", 3300,
        "Estonian Coordinate System of 1992");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.5");
    add_proj4text (p, 1,
        "1755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007");
    add_proj4text (p, 3,
        ",-0.014 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Estonian Coordinate System of 1992\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "ST92\",DATUM[\"Estonia_1992\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4133\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",59.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",58],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 10,
        "\",57.51755393055556],PARAMETER[\"central_meridian\",24]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",6375000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AUTHORITY[\"EPSG\",\"3300\"]]");
    p = add_epsg_def (filter, first, last, 3301, "epsg", 3301,
        "Estonian Coordinate System of 1997");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.5");
    add_proj4text (p, 1,
        "1755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Estonian Coordinate System of 1997\",GEOGCS[\"E");
    add_srs_wkt (p, 1,
        "ST97\",DATUM[\"Estonia_1997\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6180\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4180\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",59.3333333");
    add_srs_wkt (p, 8,
        "3333334],PARAMETER[\"standard_parallel_2\",58],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",57.51755393055556],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",24],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",6375000],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3301");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 3302, "epsg", 3302,
        "IGN63 Hiva Oa / UTM zone 7S");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=intl +towgs84=410.721,55");
    add_proj4text (p, 1,
        ".049,80.746,2.5779,2.3514,0.6664,17.3311 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN63 Hiva Oa / UTM zone 7S\",GEOGCS[\"IGN63 Hi");
    add_srs_wkt (p, 1,
        "va Oa\",DATUM[\"IGN63_Hiva_Oa\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[410.721,55.049,80.746,2.5779,2.3514,0.6664,17.3311],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6689\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "689\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3302\"]]");
    p = add_epsg_def (filter, first, last, 3303, "epsg", 3303,
        "Fatu Iva 72 / UTM zone 7S");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=intl +towgs84=347.103,10");
    add_proj4text (p, 1,
        "78.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fatu Iva 72 / UTM zone 7S\",GEOGCS[\"Fatu Iva 7");
    add_srs_wkt (p, 1,
        "2\",DATUM[\"Fatu_Iva_72\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[347.1");
    add_srs_wkt (p, 3,
        "03,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6688\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 7,
        "88\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 9,
        "41],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3303\"]]");
    p = add_epsg_def (filter, first, last, 3304, "epsg", 3304,
        "Tahiti 79 / UTM zone 6S");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=intl +towgs84=221.525,15");
    add_proj4text (p, 1,
        "2.948,176.768,-2.3847,-1.3896,-0.877,11.4741 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tahiti 79 / UTM zone 6S\",GEOGCS[\"Tahiti 79\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Tahiti_79\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[221.525,15");
    add_srs_wkt (p, 3,
        "2.948,176.768,-2.3847,-1.3896,-0.877,11.4741],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6690\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4690\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-147],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",10000000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "304\"]]");
    p = add_epsg_def (filter, first, last, 3305, "epsg", 3305,
        "Moorea 87 / UTM zone 6S");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=intl +towgs84=215.525,14");
    add_proj4text (p, 1,
        "9.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Moorea 87 / UTM zone 6S\",GEOGCS[\"Moorea 87\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Moorea_87\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[215.525,14");
    add_srs_wkt (p, 3,
        "9.593,176.229,-3.2624,-1.692,-1.1571,10.4773],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6691\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4691\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",-147],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",10000000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "305\"]]");
    p = add_epsg_def (filter, first, last, 3306, "epsg", 3306,
        "Maupiti 83 / UTM zone 5S");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +south +ellps=intl +towgs84=217.037,86");
    add_proj4text (p, 1,
        ".959,23.956,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Maupiti 83 / UTM zone 5S\",GEOGCS[\"Maupiti 83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Maupiti_83\",SPHEROID[\"International 1924\",63");
    add_srs_wkt (p, 2,
        "78388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[217.037,");
    add_srs_wkt (p, 3,
        "86.959,23.956,0,0,0,0],AUTHORITY[\"EPSG\",\"6692\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4692\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-153],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3306\"]]");
    p = add_epsg_def (filter, first, last, 3307, "epsg", 3307,
        "Nakhl-e Ghanem / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,-0.15,0.68,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nakhl-e Ghanem / UTM zone 39N\",GEOGCS[\"Nakhl-");
    add_srs_wkt (p, 1,
        "e Ghanem\",DATUM[\"Nakhl_e_Ghanem\",SPHEROID[\"WGS 84\",");
    add_srs_wkt (p, 2,
        "6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,-0.15,0.68,0,0,0,0],AUTHORITY[\"EPSG\",\"6693\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4693\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",51],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3307\"]]");
    p = add_epsg_def (filter, first, last, 3308, "epsg", 3308,
        "GDA94 / NSW Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-30.75 +lat_2=-35.75 +lat_0=-33.25 +lon");
    add_proj4text (p, 1,
        "_0=147 +x_0=9300000 +y_0=4500000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / NSW Lambert\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",-3");
    add_srs_wkt (p, 8,
        "0.75],PARAMETER[\"standard_parallel_2\",-35.75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",-33.25],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",147],PARAMETER[\"false_easting\",9300000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",4500000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"3308\"]]");
    p = add_epsg_def (filter, first, last, 3309, "epsg", 3309,
        "NAD27 / California Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=-4000000 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California Albers\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",34],PARAMETER[\"standar");
    add_srs_wkt (p, 8,
        "d_parallel_2\",40.5],PARAMETER[\"latitude_of_center\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"longitude_of_center\",-120],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",-4000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3309\"]]");
    p = add_epsg_def (filter, first, last, 3310, "epsg", 3310,
        "NAD83 / California Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=-4000000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California Albers\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_E");
    add_srs_wkt (p, 7,
        "qual_Area\"],PARAMETER[\"standard_parallel_1\",34],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_2\",40.5],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_center\",0],PARAMETER[\"longitude_of_center\",-120],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",-4000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3310\"]]");
    p = add_epsg_def (filter, first, last, 3311, "epsg", 3311,
        "NAD83(HARN) / California Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / California Albers\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_");
    add_srs_wkt (p, 8,
        "parallel_1\",34],PARAMETER[\"standard_parallel_2\",40.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"latitude_of_center\",0],PARAMETER[\"longitu");
    add_srs_wkt (p, 10,
        "de_of_center\",-120],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",-4000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"3311\"]]");
    p = add_epsg_def (filter, first, last, 3312, "epsg", 3312,
        "CSG67 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-186,230,110,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CSG67 / UTM zone 21N\",GEOGCS[\"CSG67\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Centre_Spatial_Guyanais_1967\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-186,230,110,0,0,0,0],AUTHORITY[\"EPSG\",\"6623\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4623\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-57],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3312\"]]");
    p = add_epsg_def (filter, first, last, 3313, "epsg", 3313,
        "RGFG95 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGFG95 / UTM zone 21N\",GEOGCS[\"RGFG95\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reseau_Geodesique_Francais_Guyane_1995\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6624\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4624\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3313\"]]");
    p = add_epsg_def (filter, first, last, 3314, "epsg", 3314,
        "Katanga 1955 / Katanga Lambert (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=0 +lon_0=26 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.");
    add_proj4text (p, 2,
        "95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Lambert (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4695\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"standard_parallel_1\",-6.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_2\",-11.5],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",26],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3314\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 3315, "epsg", 3315,
        "Katanga 1955 / Katanga TM (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9 +lon_0=26 +k=0.9998 +x_0=0 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga TM (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.9786982139006,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[-103.746,-9.614,-255.95,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 7,
        "95\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-9],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"scale_factor\",0.9998],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3315\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3316, "epsg", 3316,
        "Kasai 1953 / Congo TM zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kasai 1953 / Congo TM zone 22\",GEOGCS[\"Kasai ");
    add_srs_wkt (p, 1,
        "1953\",DATUM[\"Kasai_1953\",SPHEROID[\"Clarke 1880 (RGS)");
    add_srs_wkt (p, 2,
        "\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6696\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "96\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",22");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3316\"]]");
    p = add_epsg_def (filter, first, last, 3317, "epsg", 3317,
        "Kasai 1953 / Congo TM zone 24");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kasai 1953 / Congo TM zone 24\",GEOGCS[\"Kasai ");
    add_srs_wkt (p, 1,
        "1953\",DATUM[\"Kasai_1953\",SPHEROID[\"Clarke 1880 (RGS)");
    add_srs_wkt (p, 2,
        "\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6696\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "96\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"3317\"]]");
    p = add_epsg_def (filter, first, last, 3318, "epsg", 3318,
        "IGC 1962 / Congo TM zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 12\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3318\"]]");
    p = add_epsg_def (filter, first, last, 3319, "epsg", 3319,
        "IGC 1962 / Congo TM zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 14\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",14],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3319\"]]");
    p = add_epsg_def (filter, first, last, 3320, "epsg", 3320,
        "IGC 1962 / Congo TM zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 16\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",16],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3320\"]]");
    p = add_epsg_def (filter, first, last, 3321, "epsg", 3321,
        "IGC 1962 / Congo TM zone 18");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 18\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",18],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3321\"]]");
    p = add_epsg_def (filter, first, last, 3322, "epsg", 3322,
        "IGC 1962 / Congo TM zone 20");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 20\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",20],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3322\"]]");
    p = add_epsg_def (filter, first, last, 3323, "epsg", 3323,
        "IGC 1962 / Congo TM zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 22\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",22],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3323\"]]");
    p = add_epsg_def (filter, first, last, 3324, "epsg", 3324,
        "IGC 1962 / Congo TM zone 24");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 24\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",24],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3324\"]]");
    p = add_epsg_def (filter, first, last, 3325, "epsg", 3325,
        "IGC 1962 / Congo TM zone 26");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 26\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",26],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3325\"]]");
    p = add_epsg_def (filter, first, last, 3326, "epsg", 3326,
        "IGC 1962 / Congo TM zone 28");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 28\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3326\"]]");
    p = add_epsg_def (filter, first, last, 3327, "epsg", 3327,
        "IGC 1962 / Congo TM zone 30");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGC 1962 / Congo TM zone 30\",GEOGCS[\"IGC 1962");
    add_srs_wkt (p, 1,
        " 6th Parallel South\",DATUM[\"IGC_1962_Arc_of_the_6th_Pa");
    add_srs_wkt (p, 2,
        "rallel_South\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 3,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6697\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4697\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",30],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3327\"]]");
    p = add_epsg_def (filter, first, last, 3328, "epsg", 3328,
        "Pulkovo 1942(58) / GUGiK-80");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.16666666666666 +lon_0=19.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999714 +x_0=500000 +y_0=500000 +ellps=krass ");
    add_proj4text (p, 2,
        "+towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / GUGiK-80\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4179");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",52.16666666666666],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",19.16666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999714],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3328\"]]");
    p = add_epsg_def (filter, first, last, 3329, "epsg", 3329,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",5500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3329\"]]");
    p = add_epsg_def (filter, first, last, 3330, "epsg", 3330,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 6");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",18],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",6500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3330\"]]");
    p = add_epsg_def (filter, first, last, 3331, "epsg", 3331,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 7");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",21],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",7500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3331\"]]");
    p = add_epsg_def (filter, first, last, 3332, "epsg", 3332,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 8");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",24],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",8500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"3332\"]]");
    p = add_epsg_def (filter, first, last, 3333, "epsg", 3333,
        "Pulkovo 1942(58) / Gauss-Kruger zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 3\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-");
    add_srs_wkt (p, 4,
        "0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",3500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3333\"]]");
    p = add_epsg_def (filter, first, last, 3334, "epsg", 3334,
        "Pulkovo 1942(58) / Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 4\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-");
    add_srs_wkt (p, 4,
        "0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",4500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3334\"]]");
    p = add_epsg_def (filter, first, last, 3335, "epsg", 3335,
        "Pulkovo 1942(58) / Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 5\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-");
    add_srs_wkt (p, 4,
        "0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",5500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"3335\"]]");
    p = add_epsg_def (filter, first, last, 3336, "epsg", 3336,
        "IGN 1962 Kerguelen / UTM zone 42S");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,");
    add_proj4text (p, 1,
        "103,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN 1962 Kerguelen / UTM zone 42S\",GEOGCS[\"IG");
    add_srs_wkt (p, 1,
        "N 1962 Kerguelen\",DATUM[\"IGN_1962_Kerguelen\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[145,-187,103,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6698\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4698\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",69],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3336\"]]");
    p = add_epsg_def (filter, first, last, 3337, "epsg", 3337,
        "Le Pouce 1934 / Mauritius Grid");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-20.19506944444445 +lat_0=-20.195069444");
    add_proj4text (p, 1,
        "44445 +lon_0=57.52182777777778 +k_0=1 +x_0=1000000 +y_0=");
    add_proj4text (p, 2,
        "1000000 +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Le Pouce 1934 / Mauritius Grid\",GEOGCS[\"Le Po");
    add_srs_wkt (p, 1,
        "uce 1934\",DATUM[\"Le_Pouce_1934\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 2,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-770.1,158.4,-498.2,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6699\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4699\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",-20.19506944444445],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",57.52182777777778],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"3337\"]]");
    p = add_epsg_def (filter, first, last, 3338, "epsg", 3338,
        "NAD83 / Alaska Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alaska Albers\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_");
    add_srs_wkt (p, 7,
        "Area\"],PARAMETER[\"standard_parallel_1\",55],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",65],PARAMETER[\"latitude_of_cent");
    add_srs_wkt (p, 9,
        "er\",50],PARAMETER[\"longitude_of_center\",-154],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3338\"]]");
    p = add_epsg_def (filter, first, last, 3339, "epsg", 3339,
        "IGCB 1955 / Congo TM zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGCB 1955 / Congo TM zone 12\",GEOGCS[\"IGCB 19");
    add_srs_wkt (p, 1,
        "55\",DATUM[\"Institut_Geographique_du_Congo_Belge_1955\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7012\"]],TOWGS84[-79.9,-158,-168.9,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6701\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4701\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",12],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"3339\"]]");
    p = add_epsg_def (filter, first, last, 3340, "epsg", 3340,
        "IGCB 1955 / Congo TM zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGCB 1955 / Congo TM zone 14\",GEOGCS[\"IGCB 19");
    add_srs_wkt (p, 1,
        "55\",DATUM[\"Institut_Geographique_du_Congo_Belge_1955\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7012\"]],TOWGS84[-79.9,-158,-168.9,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6701\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4701\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",14],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"3340\"]]");
    p = add_epsg_def (filter, first, last, 3341, "epsg", 3341,
        "IGCB 1955 / Congo TM zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGCB 1955 / Congo TM zone 16\",GEOGCS[\"IGCB 19");
    add_srs_wkt (p, 1,
        "55\",DATUM[\"Institut_Geographique_du_Congo_Belge_1955\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7012\"]],TOWGS84[-79.9,-158,-168.9,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6701\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4701\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",16],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"3341\"]]");
    p = add_epsg_def (filter, first, last, 3342, "epsg", 3342,
        "IGCB 1955 / UTM zone 33S");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-79.9,-");
    add_proj4text (p, 1,
        "158,-168.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGCB 1955 / UTM zone 33S\",GEOGCS[\"IGCB 1955\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Institut_Geographique_du_Congo_Belge_1955\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7012\"]],TOWGS84[-79.9,-158,-168.9,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6701\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4701\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"3342\"]]");
    p = add_epsg_def (filter, first, last, 3343, "epsg", 3343,
        "Mauritania 1999 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 28N\",GEOGCS[\"Mauri");
    add_srs_wkt (p, 1,
        "tania 1999\",DATUM[\"Mauritania_1999\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6702\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4702\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-15],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"3343\"]]");
    p = add_epsg_def (filter, first, last, 3344, "epsg", 3344,
        "Mauritania 1999 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 29N\",GEOGCS[\"Mauri");
    add_srs_wkt (p, 1,
        "tania 1999\",DATUM[\"Mauritania_1999\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6702\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4702\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-9],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3344\"]]");
    p = add_epsg_def (filter, first, last, 3345, "epsg", 3345,
        "Mauritania 1999 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mauritania 1999 / UTM zone 30N\",GEOGCS[\"Mauri");
    add_srs_wkt (p, 1,
        "tania 1999\",DATUM[\"Mauritania_1999\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6702\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4702\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-3],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3345\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

