/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.types.rcp.ITypesIndexService;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.names.ITypeName;

public class TypesCompletionSessionProcessor
extends SessionProcessor {
    private static final CompletionProposal NULL_PROPOSAL = new CompletionProposal();
    public static final int BOOST = 50;
    private ImmutableSet<String> subtypes;
    private final ITypesIndexService service;
    private final OverlayImageProposalProcessor overlayDecorator;

    @Inject
    public TypesCompletionSessionProcessor(ITypesIndexService service, SharedImages images) {
        this.service = service;
        this.overlayDecorator = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        Set expectedTypes = context.getExpectedTypeNames();
        if (expectedTypes.isEmpty()) {
            return false;
        }
        ImmutableSet.Builder results = ImmutableSet.builder();
        for (ITypeName expectedType : expectedTypes) {
            if (expectedType.isPrimitiveType() || expectedType.isArrayType()) continue;
            results.addAll(this.service.subtypes(expectedType, context.getProject()));
        }
        this.subtypes = results.build();
        return !this.subtypes.isEmpty();
    }

    public void process(IProcessableProposal proposal) throws Exception {
        if (this.subtypes == null || this.subtypes.isEmpty()) {
            return;
        }
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().or((Object)NULL_PROPOSAL);
        switch (coreProposal.getKind()) {
            case 2: 
            case 5: 
            case 9: {
                this.handleProposal(proposal, coreProposal.getSignature());
                break;
            }
            case 26: 
            case 27: {
                this.handleProposal(proposal, coreProposal.getDeclarationSignature());
                break;
            }
            case 6: {
                this.handleProposal(proposal, Signature.getReturnType((char[])coreProposal.getSignature()));
                break;
            }
            case 24: 
            case 25: {
                this.handleProposal(proposal, coreProposal.getReceiverSignature());
            }
        }
    }

    private void handleProposal(IProcessableProposal proposal, char[] typeSignature) {
        if (this.isSubtype(typeSignature)) {
            proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)50);
            ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
            mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(50));
            mgr.addProcessor((ProposalProcessor)this.overlayDecorator);
        }
    }

    private boolean isSubtype(char[] typeSignature) {
        if (Signature.getArrayCount((char[])typeSignature) > 0) {
            return false;
        }
        if (this.isPrimitiveOrVoid(typeSignature)) {
            return false;
        }
        char[] erasedTypeSignature = Signature.getTypeErasure((char[])typeSignature);
        String type = new String(erasedTypeSignature, 1, erasedTypeSignature.length - 2);
        return this.subtypes.contains((Object)type);
    }

    private boolean isPrimitiveOrVoid(char[] typeSignature) {
        return typeSignature.length == 1;
    }
}

