/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.sse.ui.contentassist.AutoActivationDelegate;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalCategory;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerRegistry;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.contentassist.CompoundContentAssistProcessor;
import org.eclipse.wst.sse.ui.internal.contentassist.ContextInformationValidator;
import org.eclipse.wst.sse.ui.internal.contentassist.OptionalMessageDialog;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationReader;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public class StructuredContentAssistProcessor
implements IContentAssistProcessor,
IPropertyChangeListener,
IReleasable {
    private static final String CONTENT_ASSIST_PROCESSOR_EXTENDED_ID = "contentassistprocessor";
    private List fLegacyExtendedContentAssistProcessors;
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private final Comparator PAGE_ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CompletionProposalCategory d1 = (CompletionProposalCategory)o1;
            CompletionProposalCategory d2 = (CompletionProposalCategory)o2;
            return d1.getPageSortRank(StructuredContentAssistProcessor.this.fContentTypeID) - d2.getPageSortRank(StructuredContentAssistProcessor.this.fContentTypeID);
        }
    };
    private final Comparator DEFAULT_PAGE_ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CompletionProposalCategory d1 = (CompletionProposalCategory)o1;
            CompletionProposalCategory d2 = (CompletionProposalCategory)o2;
            return d1.getDefaultPageSortRank(StructuredContentAssistProcessor.this.fContentTypeID) - d2.getDefaultPageSortRank(StructuredContentAssistProcessor.this.fContentTypeID);
        }
    };
    private List fCategories;
    String fContentTypeID;
    private final String fPartitionTypeID;
    private ContentAssistant fAssistant;
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;
    private IPreferenceStore fPreferenceStore;
    private ITextViewer fViewer;
    private ITextInputListener fTextInputListener;
    private CompletionListener fCompletionListener;
    private IContextInformationValidator fContextInformationValidator;
    private AutoActivationDelegate fAutoActivation;
    static /* synthetic */ Class class$0;

    public StructuredContentAssistProcessor(ContentAssistant assistant, String partitionTypeID, ITextViewer viewer, IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)partitionTypeID);
        Assert.isNotNull((Object)assistant);
        CompletionProposalComputerRegistry.getDefault().initialize();
        this.fPreferenceStore = preferenceStore;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fContentTypeID = null;
        this.fViewer = viewer;
        if (viewer != null) {
            this.fTextInputListener = new TextInputListener();
            viewer.addTextInputListener(this.fTextInputListener);
            if (viewer.getDocument() != null) {
                this.fTextInputListener.inputDocumentChanged(null, viewer.getDocument());
            }
        }
        this.fPartitionTypeID = partitionTypeID;
        this.fAssistant = assistant;
        this.fCompletionListener = new CompletionListener();
        this.fAssistant.addCompletionListener((ICompletionListener)this.fCompletionListener);
        this.fLegacyExtendedContentAssistProcessors = null;
        this.fCategories = null;
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(SSEUIMessages.ContentAssist_computing_proposals, this.getProposalCategories().size() + 1);
        CompletionProposalInvocationContext context = this.createContext(viewer, offset);
        monitor.subTask(SSEUIMessages.ContentAssist_collecting_proposals);
        List proposals = this.collectProposals(viewer, offset, monitor, context);
        monitor.subTask(SSEUIMessages.ContentAssist_sorting_proposals);
        List filtered = this.filterAndSortProposals(proposals, monitor, context);
        this.fNumberOfComputedResults = filtered.size();
        ICompletionProposal[] result = filtered.toArray(new ICompletionProposal[filtered.size()]);
        monitor.done();
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(SSEUIMessages.ContentAssist_computing_contexts, this.getProposalCategories().size() + 1);
        monitor.subTask(SSEUIMessages.ContentAssist_collecting_contexts);
        List proposals = this.collectContextInformation(viewer, offset, monitor);
        monitor.subTask(SSEUIMessages.ContentAssist_sorting_contexts);
        List filtered = this.filterAndSortContextInformation(proposals, monitor);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fAutoActivation != null ? this.fAutoActivation.getCompletionProposalAutoActivationCharacters() : null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.fAutoActivation != null ? this.fAutoActivation.getContextInformationAutoActivationCharacters() : null;
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        return SSEUIMessages.ContentAssist_no_completions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new ContextInformationValidator();
        }
        return this.fContextInformationValidator;
    }

    public void install(ITextViewer viewer) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.fViewer != null) {
            this.fViewer.removeTextInputListener(this.fTextInputListener);
        }
        this.fViewer = viewer;
        if (this.fViewer != null) {
            if (this.fTextInputListener == null) {
                this.fTextInputListener = new TextInputListener();
            }
            this.fViewer.addTextInputListener(this.fTextInputListener);
        }
        if (this.fAssistant != null) {
            if (this.fCompletionListener == null) {
                this.fCompletionListener = new CompletionListener();
            }
            this.fAssistant.addCompletionListener((ICompletionListener)this.fCompletionListener);
        }
    }

    public void release() {
        if (this.fAutoActivation != null) {
            this.fAutoActivation.dispose();
            this.fAutoActivation = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.fViewer != null) {
            this.fViewer.removeTextInputListener(this.fTextInputListener);
            this.fViewer = null;
            this.fTextInputListener = null;
        }
        if (this.fAssistant != null && this.fCompletionListener != null) {
            this.fAssistant.removeCompletionListener((ICompletionListener)this.fCompletionListener);
            this.fCompletionListener = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, CompletionProposalInvocationContext context) {
        return proposals;
    }

    protected List filterAndSortContextInformation(List contexts, IProgressMonitor monitor) {
        return contexts;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected CompletionProposalInvocationContext createContext(ITextViewer viewer, int offset) {
        return new CompletionProposalInvocationContext(viewer, offset);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, CompletionProposalInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List categories = this.getCategories();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            List computed = cat.computeCompletionProposals(context, this.fContentTypeID, this.fPartitionTypeID, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        if (this.isFirstPage() && this.getLegacyExtendedContentAssistProcessors() != null && !this.getLegacyExtendedContentAssistProcessors().isEmpty()) {
            Iterator iter = this.getLegacyExtendedContentAssistProcessors().iterator();
            while (iter.hasNext()) {
                IContentAssistProcessor legacyProcessor = (IContentAssistProcessor)iter.next();
                ICompletionProposal[] legacyComputed = null;
                try {
                    legacyComputed = legacyProcessor.computeCompletionProposals(viewer, offset);
                }
                catch (Exception e) {
                    Logger.logException("Problem occurred while gathering proposals from " + legacyProcessor.getClass().getName(), e);
                }
                if (legacyComputed == null) continue;
                proposals.addAll(Arrays.asList(legacyComputed));
            }
        }
        return proposals;
    }

    private List collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ArrayList<IContextInformation> proposals = new ArrayList<IContextInformation>();
        CompletionProposalInvocationContext context = this.createContext(viewer, offset);
        List providers = this.getCategories();
        Iterator it = providers.iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            List computed = cat.computeContextInformation(context, this.fContentTypeID, this.fPartitionTypeID, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        if (this.getLegacyExtendedContentAssistProcessors() != null && !this.getLegacyExtendedContentAssistProcessors().isEmpty()) {
            Iterator iter = this.getLegacyExtendedContentAssistProcessors().iterator();
            while (iter.hasNext()) {
                IContentAssistProcessor legacyProcessor = (IContentAssistProcessor)iter.next();
                IContextInformation[] legacyComputed = legacyProcessor.computeContextInformation(viewer, offset);
                if (legacyComputed == null) continue;
                proposals.addAll(Arrays.asList(legacyComputed));
            }
        }
        return proposals;
    }

    private List getCategories() {
        List categories;
        if (this.fCategoryIteration == null) {
            categories = this.getProposalCategories();
        } else {
            int iteration = this.fRepetition % this.fCategoryIteration.size();
            this.fAssistant.setStatusMessage(this.createIterationMessage());
            this.fAssistant.setEmptyMessage(this.createEmptyMessage());
            ++this.fRepetition;
            categories = (List)this.fCategoryIteration.get(iteration);
        }
        return categories;
    }

    private void resetCategoryIteration() {
        this.fCategoryIteration = this.getCategoryIteration();
    }

    private List getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> sequence = new ArrayList<List<CompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        Iterator it = this.getSortedOwnPageCategories().iterator();
        while (it.hasNext()) {
            CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List getDefaultCategories() {
        List included = this.getDefaultCategoriesUnchecked();
        if (included.size() == 0 && CompletionProposalComputerRegistry.getDefault().hasUninstalledComputers()) {
            if (this.informUserAboutEmptyDefaultCategory()) {
                included = this.getDefaultCategoriesUnchecked();
            }
            CompletionProposalComputerRegistry.getDefault().resetUnistalledComputers();
        }
        Collections.sort(included, this.DEFAULT_PAGE_ORDER_COMPARATOR);
        return included;
    }

    private List getDefaultCategoriesUnchecked() {
        ArrayList<CompletionProposalCategory> included = new ArrayList<CompletionProposalCategory>();
        Iterator it = this.getProposalCategories().iterator();
        while (it.hasNext()) {
            CompletionProposalCategory category = (CompletionProposalCategory)it.next();
            if (!category.isIncludedOnDefaultPage(this.fContentTypeID) || !category.hasComputers(this.fContentTypeID, this.fPartitionTypeID)) continue;
            included.add(category);
        }
        return included;
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        ICompletionProposalCategoriesConfigurationReader properties = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getReadableConfiguration(this.fContentTypeID);
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY) && properties instanceof ICompletionProposalCategoriesConfigurationWriter && ((ICompletionProposalCategoriesConfigurationWriter)properties).hasAssociatedPropertiesPage()) {
            String linkMessage;
            String restoreButtonLabel;
            String message;
            String title;
            ICompletionProposalCategoriesConfigurationWriter propertiesExtension = (ICompletionProposalCategoriesConfigurationWriter)properties;
            Shell shell = SSEUIPlugin.getActiveWorkbenchShell();
            OptionalMessageDialog dialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell, title = SSEUIMessages.ContentAssist_all_disabled_title, null, message = SSEUIMessages.ContentAssist_all_disabled_message, 4, new String[]{restoreButtonLabel = JFaceResources.getString((String)"defaults"), IDialogConstants.CLOSE_LABEL}, 1, linkMessage = NLS.bind((String)SSEUIMessages.ContentAssist_all_disabled_preference_link, (Object)LegacyActionTools.removeMnemonics((String)restoreButtonLabel)), restoreButtonLabel){
                private final /* synthetic */ String val$linkMessage;
                private final /* synthetic */ String val$restoreButtonLabel;
                {
                    this.val$linkMessage = string;
                    this.val$restoreButtonLabel = string2;
                }

                protected Control createCustomArea(Composite composite) {
                    Composite parent = new Composite(composite, 0);
                    GridLayout layout = new GridLayout();
                    layout.marginHeight = 0;
                    layout.marginWidth = 0;
                    layout.verticalSpacing = 0;
                    parent.setLayout((Layout)layout);
                    Composite linkComposite = new Composite(parent, 0);
                    layout = new GridLayout();
                    layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                    layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                    layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                    linkComposite.setLayout((Layout)layout);
                    Link link = new Link(linkComposite, 0);
                    link.setText(this.val$linkMessage);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            3.access$0(this.this$1, 1035);
                            this.this$1.close();
                        }
                    });
                    GridData gridData = new GridData(4, 1, true, false);
                    gridData.widthHint = this.getMinimumMessageWidth();
                    link.setLayoutData((Object)gridData);
                    super.createCustomArea(parent);
                    return parent;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    Button[] buttons = new Button[]{this.createButton(parent, 1034, this.val$restoreButtonLabel, false), this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true)};
                    this.setButtons(buttons);
                }

                static /* synthetic */ void access$0(3 var0, int n) {
                    var0.setReturnCode(n);
                }
            };
            int returnValue = dialog.open();
            if (1034 == returnValue || 1035 == returnValue) {
                if (1034 == returnValue) {
                    propertiesExtension.loadDefaults();
                    propertiesExtension.saveConfiguration();
                }
                if (1035 == returnValue) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)propertiesExtension.getPropertiesPageID(), null, null).open();
                }
                return true;
            }
        }
        return false;
    }

    private List getSortedOwnPageCategories() {
        ArrayList<CompletionProposalCategory> sorted = new ArrayList<CompletionProposalCategory>();
        Iterator it = this.getProposalCategories().iterator();
        while (it.hasNext()) {
            CompletionProposalCategory category = (CompletionProposalCategory)it.next();
            if (!category.isDisplayedOnOwnPage(this.fContentTypeID) || !category.hasComputers(this.fContentTypeID, this.fPartitionTypeID)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, this.PAGE_ORDER_COMPARATOR);
        return sorted;
    }

    private String createEmptyMessage() {
        return NLS.bind((String)SSEUIMessages.ContentAssist_no_message, (Object[])new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return NLS.bind((String)SSEUIMessages.ContentAssist_toggle_affordance_update_message, (Object[])new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration;
        int n = iteration = this.fCategoryIteration != null ? repetition % this.fCategoryIteration.size() : 0;
        if (iteration == 0) {
            return SSEUIMessages.ContentAssist_defaultProposalCategory_title;
        }
        return ((CompletionProposalCategory)((List)this.fCategoryIteration.get(iteration)).get(0)).getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? NLS.bind((String)SSEUIMessages.ContentAssist_press, (Object[])new Object[]{binding.format()}) : SSEUIMessages.ContentAssist_click;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc;
        TriggerSequence binding;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((binding = (bindingSvc = (IBindingService)iWorkbench.getAdapter((Class)clazz)).getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals")) instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }

    private boolean isFirstPage() {
        return this.fCategoryIteration == null || this.fCategoryIteration.size() == 1 || this.fRepetition % this.fCategoryIteration.size() == 1;
    }

    private List getLegacyExtendedContentAssistProcessors() {
        if (this.fLegacyExtendedContentAssistProcessors == null) {
            this.fLegacyExtendedContentAssistProcessors = ExtendedConfigurationBuilder.getInstance().getConfigurations(CONTENT_ASSIST_PROCESSOR_EXTENDED_ID, this.fPartitionTypeID);
        }
        return this.fLegacyExtendedContentAssistProcessors;
    }

    private List getProposalCategories() {
        if (this.fCategories == null) {
            this.fCategories = CompletionProposalComputerRegistry.getDefault().getProposalCategories(this.fContentTypeID);
        }
        return this.fCategories;
    }

    protected void setAutoActivationDelay(int delay) {
        this.fAssistant.setAutoActivationDelay(delay);
    }

    static /* synthetic */ AutoActivationDelegate access$9(StructuredContentAssistProcessor structuredContentAssistProcessor) {
        return structuredContentAssistProcessor.fAutoActivation;
    }

    static /* synthetic */ String access$10(StructuredContentAssistProcessor structuredContentAssistProcessor) {
        return structuredContentAssistProcessor.fPartitionTypeID;
    }

    static /* synthetic */ void access$11(StructuredContentAssistProcessor structuredContentAssistProcessor, AutoActivationDelegate autoActivationDelegate) {
        structuredContentAssistProcessor.fAutoActivation = autoActivationDelegate;
    }

    private final class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor == StructuredContentAssistProcessor.this || event.processor instanceof CompoundContentAssistProcessor && ((CompoundContentAssistProcessor)event.processor).containsProcessor(StructuredContentAssistProcessor.this)) {
                StructuredContentAssistProcessor.this.fIterationGesture = StructuredContentAssistProcessor.this.getIterationGesture();
                KeySequence binding = StructuredContentAssistProcessor.this.getIterationBinding();
                StructuredContentAssistProcessor.this.resetCategoryIteration();
                Iterator it = StructuredContentAssistProcessor.this.getProposalCategories().iterator();
                while (it.hasNext()) {
                    CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
                    cat.sessionStarted();
                }
                StructuredContentAssistProcessor.this.fRepetition = 0;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    if (StructuredContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                        extension.setRepeatedInvocationMode(false);
                        extension.setShowEmptyList(false);
                    } else {
                        extension.setRepeatedInvocationMode(true);
                        extension.setStatusLineVisible(true);
                        extension.setStatusMessage(StructuredContentAssistProcessor.this.createIterationMessage());
                        extension.setShowEmptyList(true);
                        if (extension instanceof IContentAssistantExtension3) {
                            IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                            ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                        }
                    }
                }
            }
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor == StructuredContentAssistProcessor.this || event.processor instanceof CompoundContentAssistProcessor && ((CompoundContentAssistProcessor)event.processor).containsProcessor(StructuredContentAssistProcessor.this)) {
                Iterator it = StructuredContentAssistProcessor.this.getProposalCategories().iterator();
                while (it.hasNext()) {
                    CompletionProposalCategory cat = (CompletionProposalCategory)it.next();
                    cat.sessionEnded();
                }
                StructuredContentAssistProcessor.this.fCategoryIteration = null;
                StructuredContentAssistProcessor.this.fRepetition = -1;
                StructuredContentAssistProcessor.this.fIterationGesture = null;
                if (event.assistant instanceof IContentAssistantExtension2) {
                    IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                    extension.setShowEmptyList(false);
                    extension.setRepeatedInvocationMode(false);
                    extension.setStatusLineVisible(false);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(null);
                    }
                }
            }
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            StructuredContentAssistProcessor.this.fRepetition = 0;
        }
    }

    private class TextInputListener
    implements ITextInputListener {
        private TextInputListener() {
        }

        /*
         * Exception decompiling
         */
        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 121->125)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }
    }
}

