/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor.search;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.core.search.SearchEngine;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListProvider;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDSchema;

public class XSDAttributeSearchListProvider
extends XSDSearchListProvider {
    public XSDAttributeSearchListProvider(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public void populateComponentList(IComponentList list, SearchScope scope, IProgressMonitor pm) {
        ArrayList visitedSchemas = new ArrayList();
        int i = 0;
        while (i < this.schemas.length) {
            XSDSchema schema = this.schemas[i];
            XSDSearchListProvider.ComponentCollectingXSDVisitor visitor = new XSDSearchListProvider.ComponentCollectingXSDVisitor(list, IXSDSearchConstants.ATTRIBUTE_META_NAME);
            visitor.visitSchema(schema, true);
            visitedSchemas.addAll(visitor.getVisitedSchemas());
            ++i;
        }
        if (scope != null) {
            this.populateComponentListUsingSearch(list, scope, pm, this.createFileMap(visitedSchemas));
        }
    }

    private void populateComponentListUsingSearch(IComponentList list, SearchScope scope, IProgressMonitor pm, HashMap files) {
        SearchEngine searchEngine = new SearchEngine();
        XSDSearchListProvider.InternalSearchRequestor requestor = new XSDSearchListProvider.InternalSearchRequestor(list, files);
        this.findMatches(searchEngine, requestor, scope, IXSDSearchConstants.ATTRIBUTE_META_NAME);
    }
}

