/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.OutlineImageFigure;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.GroupRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsolutePolicyUtils;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.DotsFeedback;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.KeyboardMovingLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.layout.absolute.IPreferenceConstants;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsoluteBasedLayoutEditPolicy<C extends IAbstractComponentInfo>
extends KeyboardMovingLayoutEditPolicy
implements IVisualDataProvider,
IFeedbackProxy,
IPreferenceConstants {
    protected PlacementsSupport placementsSupport;
    private int m_frozenYValue;
    private final IObjectInfo m_layout;
    private Figure m_dotsFeedback;
    private Figure m_moveFeedback;
    private Figure m_createFeedback;
    private TextFeedback m_locationFeedback;
    private TextFeedback m_sizeFeedback;
    private Figure m_resizeFeedback;
    private TextFeedback m_textFeedback;
    protected boolean m_resizeOnCreate;
    private Point m_startLocation;
    private Map<IAbstractComponentInfo, PastedComponentInfo> m_pastedComponents;
    private Point m_pasteLocation;

    public AbsoluteBasedLayoutEditPolicy(ObjectInfo layout) {
        this.m_layout = layout;
        new BroadcastListenerHelper(layout, this, new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (parent instanceof IAbstractComponentInfo && !parent.isDeleting() && this.isOurChild(parent, child) && child instanceof IAbstractComponentInfo) {
                    AbsoluteBasedLayoutEditPolicy.this.onDelete(child);
                }
            }

            private boolean isOurChild(ObjectInfo parent, ObjectInfo child) {
                return AbsoluteBasedLayoutEditPolicy.this.getHostModel() == parent && parent != null && parent.getChildren().contains(child);
            }
        });
        new BroadcastListenerHelper(layout, this, new ObjectEventListener(){

            @Override
            public void refreshed() throws Exception {
                AbsoluteBasedLayoutEditPolicy.this.showSelectionFeedbacks();
            }

            @Override
            public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
                AbstractAlignmentActionsSupport alignmentSupport = AbsoluteBasedLayoutEditPolicy.this.getAlignmentActionsSupport();
                if (alignmentSupport != null) {
                    alignmentSupport.addAlignmentActions(objects, actions);
                }
            }
        });
    }

    protected final void createPlacementsSupport(IAbsoluteLayoutCommands layoutCommands) {
        this.placementsSupport = new PlacementsSupport(this, this, layoutCommands, this.getAllComponents());
    }

    protected final IPreferenceStore getPreferenceStore() {
        return this.getToolkit().getPreferences();
    }

    protected abstract ToolkitDescription getToolkit();

    @Override
    public int getGridStepX() {
        return this.getPreferenceStore().getInt("P_GRID_STEP_X");
    }

    @Override
    public int getGridStepY() {
        return this.getPreferenceStore().getInt("P_GRID_STEP_Y");
    }

    @Override
    public boolean useFreeSnapping() {
        return this.getPreferenceStore().getBoolean("P_USE_FREE_MODE");
    }

    @Override
    public boolean useGridSnapping() {
        return this.getPreferenceStore().getBoolean("P_USE_GRID");
    }

    public boolean isShowTextFeedback() {
        return this.getPreferenceStore().getBoolean("P_DISPLAY_LOCATION_SIZE_HINTS");
    }

    public boolean isShowGridFeedback() {
        return this.getPreferenceStore().getBoolean("P_DISPLAY_GRID");
    }

    @Override
    public boolean isSuppressingSnapping() {
        return DesignerPlugin.isShiftPressed();
    }

    public abstract List<C> getAllComponents();

    @Override
    protected String getResizeRequestType() {
        return "_absolute_resize";
    }

    @Override
    public boolean understandsRequest(Request request) {
        if ("orphan children".equals(request.getType()) || this.getResizeRequestType().equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    private Layer getTextFeedbackLayer() {
        return this.getLayer("Feedback Layer Abv 1");
    }

    protected final Polyline createLineFeedback(int x1, int y1, int x2, int y2) {
        Point begin = new Point(x1, y1);
        Point end = new Point(x2, y2);
        this.translateModelToFeedback(begin);
        this.translateModelToFeedback(end);
        Polyline line = new Polyline();
        line.addPoint(begin);
        line.addPoint(end);
        line.setLineStyle(3);
        this.addFeedback(line);
        return line;
    }

    public final String getSizeHintString(EditPart editPart, int width, int height) {
        return String.valueOf(Integer.toString(width)) + " x " + Integer.toString(height);
    }

    public String getLocationHintString(EditPart editPart, int x, int y) {
        return String.valueOf(Integer.toString(x)) + " x " + Integer.toString(y);
    }

    @Override
    protected void showLayoutTargetFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.eraseSelectionFeedbacks();
            this.placementsSupport.cleanup();
            this.showMoveFeedback((ChangeBoundsRequest)request);
        } else if (request instanceof CreateRequest) {
            this.placementsSupport.cleanup();
            this.showCreationFeedback((CreateRequest)request);
        } else if (request instanceof PasteRequest) {
            this.placementsSupport.cleanup();
            this.showPasteFeedback((PasteRequest)request);
        }
    }

    protected void eraseSelectionFeedbacks() {
    }

    protected void showSelectionFeedbacks() {
    }

    @Override
    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.m_dotsFeedback != null) {
            this.removeFeedback(this.m_dotsFeedback);
            this.m_dotsFeedback = null;
        }
        this.placementsSupport.clearFeedbacks();
        if (this.m_moveFeedback != null) {
            this.removeFeedback(this.m_moveFeedback);
            this.m_moveFeedback = null;
        }
        if (this.m_createFeedback != null) {
            this.removeFeedback(this.m_createFeedback);
            this.m_createFeedback = null;
        }
        if (this.m_locationFeedback != null) {
            this.m_locationFeedback.remove();
            this.m_locationFeedback = null;
        }
        if (this.m_sizeFeedback != null) {
            this.m_sizeFeedback.remove();
            this.m_sizeFeedback = null;
        }
        this.m_frozenYValue = 0;
    }

    private boolean isFreezeVerticalAxis(Request request) {
        return request.isControlKeyPressed() && this.m_frozenYValue != 0;
    }

    private void showMoveFeedback(ChangeBoundsRequest request) {
        Rectangle widgetBounds;
        if (this.m_moveFeedback != null) {
            this.removeFeedback(this.m_moveFeedback);
            this.m_moveFeedback = null;
        }
        boolean isKeyboardMoving = this.isKeyboardMoving();
        Figure hostFigure = this.getHostFigure();
        if (this.m_dotsFeedback == null && (this.useGridSnapping() || this.isKeyboardMoving()) && this.isShowGridFeedback()) {
            this.m_dotsFeedback = new DotsFeedback(this, hostFigure);
            this.addFeedback(this.m_dotsFeedback);
        }
        List<EditPart> editParts = request.getEditParts();
        List modelList = Lists.newArrayList();
        Object[] relativeBounds = new Rectangle[editParts.size()];
        if (editParts.size() > 1) {
            GraphicalEditPart firstEditPart = (GraphicalEditPart)editParts.get(0);
            widgetBounds = new Rectangle(firstEditPart.getFigure().getBounds());
            this.m_moveFeedback = new OutlineImageFigure(null);
            for (EditPart editPart : editParts) {
                IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
                Rectangle bounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
                widgetBounds.union(bounds);
                modelList.add(model);
                this.m_moveFeedback.add((Figure)new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE), bounds);
            }
            List<Figure> moveFeedbackFigures = this.m_moveFeedback.getChildren();
            int i = 0;
            while (i < moveFeedbackFigures.size()) {
                Figure figure = moveFeedbackFigures.get(i);
                figure.getBounds().translate(-widgetBounds.x, -widgetBounds.y);
                relativeBounds[i] = figure.getBounds().getCopy();
                ++i;
            }
        } else {
            EditPart editPart = editParts.get(0);
            IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
            widgetBounds = ((GraphicalEditPart)editPart).getFigure().getBounds().getCopy();
            relativeBounds[0] = new Rectangle(new Point(), widgetBounds.getSize());
            modelList.add(model);
            this.m_moveFeedback = new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
        }
        FigureUtils.translateFigureToAbsolute2(((GraphicalEditPart)editParts.get(0)).getFigure().getParent(), widgetBounds);
        this.translateAbsoluteToModel(widgetBounds);
        Point moveDelta = request.getMoveDelta();
        widgetBounds.x += moveDelta.x;
        widgetBounds.y = this.isFreezeVerticalAxis(request) ? this.m_frozenYValue : (this.m_frozenYValue = widgetBounds.y + moveDelta.y);
        this.addFeedback(this.m_moveFeedback);
        Point moveLocation = this.isKeyboardMoving() ? moveDelta : request.getLocation();
        this.placementsSupport.drag(moveLocation, (List)ImmutableList.copyOf((Collection)modelList), widgetBounds, (List)ImmutableList.copyOf((Object[])relativeBounds));
        widgetBounds = this.placementsSupport.getBounds();
        int newX = widgetBounds.x;
        int newY = widgetBounds.y;
        this.translateModelToFeedback(widgetBounds);
        this.m_moveFeedback.setBounds(widgetBounds);
        if (this.m_locationFeedback == null && this.isShowTextFeedback() && !isKeyboardMoving) {
            this.m_locationFeedback = new TextFeedback(this.getTextFeedbackLayer());
            this.m_locationFeedback.add();
        }
        if (this.m_locationFeedback != null) {
            EditPart firstEditPart = editParts.get(0);
            this.m_locationFeedback.setText(this.getLocationHintString(firstEditPart, newX, newY));
            Point locationFeedbackLocation = this.getLocationHintLocation(firstEditPart, widgetBounds, this.m_locationFeedback.getSize());
            this.m_locationFeedback.setLocation(locationFeedbackLocation);
        }
    }

    protected Point getLocationHintLocation(EditPart editPart, Rectangle widgetBounds, Dimension hintSize) {
        return widgetBounds.getLocation().getTranslated(-30, -25);
    }

    public void showResizeFeedback(ChangeBoundsRequest request) {
        Rectangle widgetBounds;
        if (this.m_resizeFeedback != null) {
            this.removeFeedback(this.m_resizeFeedback);
            this.m_resizeFeedback = null;
        }
        this.getPlacementsSupport().cleanup();
        List<EditPart> editParts = request.getEditParts();
        List modelList = Lists.newArrayList();
        Object[] relativeBounds = new Rectangle[editParts.size()];
        if (editParts.size() > 1) {
            GraphicalEditPart firstEditPart = (GraphicalEditPart)editParts.get(0);
            widgetBounds = new Rectangle(firstEditPart.getFigure().getBounds());
            this.m_resizeFeedback = new OutlineImageFigure(null);
            for (EditPart editPart : editParts) {
                IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
                Rectangle bounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
                widgetBounds.union(bounds);
                modelList.add(model);
                this.m_resizeFeedback.add((Figure)new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE), bounds);
            }
            List<Figure> moveFeedbackFigures = this.m_resizeFeedback.getChildren();
            int i = 0;
            while (i < moveFeedbackFigures.size()) {
                Figure figure = moveFeedbackFigures.get(i);
                figure.getBounds().translate(-widgetBounds.x, -widgetBounds.y);
                relativeBounds[i] = figure.getBounds().getCopy();
                ++i;
            }
        } else {
            EditPart editPart = editParts.get(0);
            IAbstractComponentInfo model = (IAbstractComponentInfo)editPart.getModel();
            widgetBounds = ((GraphicalEditPart)editPart).getFigure().getBounds().getCopy();
            relativeBounds[0] = new Rectangle(new Point(), widgetBounds.getSize());
            modelList.add(model);
            this.m_resizeFeedback = new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
        }
        boolean isKeyboardMoving = this.isKeyboardMoving();
        widgetBounds = request.getTransformedRectangle(widgetBounds.getCopy());
        FigureUtils.translateFigureToAbsolute2(this.getHostFigure(), widgetBounds);
        PolicyUtils.translateAbsoluteToModel(this, (Translatable)widgetBounds);
        Dimension sizeDelta = request.getSizeDelta();
        Point moveLocation = isKeyboardMoving ? new Point(sizeDelta.width, sizeDelta.height) : request.getLocation();
        this.getPlacementsSupport().drag(moveLocation, (List)ImmutableList.copyOf((Collection)modelList), widgetBounds, (List)ImmutableList.copyOf((Object[])relativeBounds), request.getResizeDirection());
        widgetBounds = this.getPlacementsSupport().getBounds();
        PolicyUtils.translateModelToFeedback(this, (Translatable)widgetBounds);
        if (this.m_dotsFeedback == null && (this.useGridSnapping() || isKeyboardMoving)) {
            this.m_dotsFeedback = new DotsFeedback(this, this.getHost().getFigure());
            this.addFeedback(this.m_dotsFeedback);
        }
        this.addFeedback(this.m_resizeFeedback);
        this.m_resizeFeedback.setBounds(widgetBounds);
        if (this.m_textFeedback == null && this.isShowTextFeedback() && !isKeyboardMoving) {
            this.m_textFeedback = new TextFeedback(this.getFeedbackLayer());
            this.m_textFeedback.add();
        }
        if (this.m_textFeedback != null) {
            this.m_textFeedback.setText(this.getSizeHintString(this.getHost(), widgetBounds.width, widgetBounds.height));
            this.m_textFeedback.setLocation(request.getLocation().getTranslated(10, 10));
        }
    }

    public void eraseResizeFeedback(ChangeBoundsRequest request) {
        this.eraseLayoutTargetFeedback(request);
        if (this.m_resizeFeedback != null) {
            this.removeFeedback(this.m_resizeFeedback);
            this.m_resizeFeedback = null;
        }
        if (this.m_textFeedback != null) {
            this.m_textFeedback.remove();
            this.m_textFeedback = null;
        }
    }

    final Command getResizeCommandImpl(ChangeBoundsRequest request) {
        CompoundEditCommand command = new CompoundEditCommand(this.m_layout.getUnderlyingModel());
        command.add(new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                AbsoluteBasedLayoutEditPolicy.this.getPlacementsSupport().commit();
            }
        });
        Command resizeCommand = this.getResizeCommand(request);
        if (resizeCommand != null) {
            command.add(resizeCommand);
        }
        return command;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return null;
    }

    private void showCreationFeedback(CreateRequest request) {
        Dimension preferredSize;
        Point topLeftPoint;
        if (this.m_createFeedback != null) {
            this.removeFeedback(this.m_createFeedback);
            this.m_createFeedback = null;
        }
        Point location = request.getLocation().getCopy();
        this.translateAbsoluteToModel(location);
        IAbstractComponentInfo newWidget = (IAbstractComponentInfo)request.getNewObject();
        Image image = newWidget.getImage();
        Dimension size = request.getSize();
        if (size != null) {
            this.m_resizeOnCreate = true;
            topLeftPoint = new Point(this.m_startLocation.x, this.m_startLocation.y);
            preferredSize = new Dimension(size.width + location.x - this.m_startLocation.x, size.height + location.y - this.m_startLocation.y);
            this.m_frozenYValue = 0;
        } else {
            this.m_resizeOnCreate = false;
            preferredSize = newWidget.getPreferredSize();
            if (preferredSize != null) {
                boolean freezeVerticalAxis = this.isFreezeVerticalAxis(request);
                int y = freezeVerticalAxis ? this.m_frozenYValue : (this.m_frozenYValue = location.y - preferredSize.height / 2);
                topLeftPoint = new Point(location.x - preferredSize.width / 2, y);
            } else {
                preferredSize = new Dimension(0, 0);
                topLeftPoint = location.getCopy();
            }
        }
        Rectangle widgetBounds = new Rectangle(topLeftPoint.x, topLeftPoint.y, preferredSize.width, preferredSize.height);
        this.m_createFeedback = new OutlineImageFigure(image);
        this.addFeedback(this.m_createFeedback);
        this.placementsSupport.drag(location, newWidget, widgetBounds, size == null ? 0 : 20);
        widgetBounds = this.placementsSupport.getBounds();
        Rectangle widgetModelBounds = widgetBounds.getCopy();
        if (size == null) {
            this.m_startLocation = widgetBounds.getLocation();
        }
        Figure hostFigure = this.getHostFigure();
        if (this.m_dotsFeedback == null && (this.useGridSnapping() || this.isKeyboardMoving())) {
            this.m_dotsFeedback = new DotsFeedback(this, hostFigure);
            this.addFeedback(this.m_dotsFeedback);
        }
        this.translateModelToFeedback(widgetBounds);
        this.m_createFeedback.setBounds(widgetBounds);
        if (this.isShowTextFeedback() && !this.isKeyboardMoving()) {
            if (this.m_locationFeedback == null) {
                this.m_locationFeedback = new TextFeedback(this.getTextFeedbackLayer());
                this.m_locationFeedback.add();
            }
            if (size != null && this.m_sizeFeedback == null) {
                this.m_sizeFeedback = new TextFeedback(this.getTextFeedbackLayer());
                this.m_sizeFeedback.add();
            }
            this.m_locationFeedback.setText(this.getLocationHintString(this.getHost(), widgetModelBounds.x, widgetModelBounds.y));
            this.m_locationFeedback.setLocation(widgetBounds.getLocation().getTranslated(-30, -25));
            if (size != null) {
                this.m_sizeFeedback.setText(this.getSizeHintString(this.getHost(), widgetModelBounds.width, widgetModelBounds.height));
                this.m_sizeFeedback.setLocation(widgetBounds.getBottomRight().getTranslated(30, 25));
            }
        }
    }

    private void showPasteFeedback(PasteRequest request) {
        List<IObjectInfo> pastingComponents = GlobalState.getPasteRequestProcessor().getPastingComponents(request);
        this.m_pastedComponents = Maps.newHashMap();
        ArrayList<IAbstractComponentInfo> pastedModels = new ArrayList<IAbstractComponentInfo>(pastingComponents.size());
        try {
            Rectangle widgetBounds;
            if (this.m_createFeedback != null) {
                this.removeFeedback(this.m_createFeedback);
                this.m_createFeedback = null;
            }
            Point location = request.getLocation().getCopy();
            this.translateAbsoluteToModel(location);
            request.setObjects(pastedModels);
            Object[] relativeBounds = new Rectangle[pastingComponents.size()];
            if (pastingComponents.size() > 1) {
                widgetBounds = new Rectangle();
                this.m_createFeedback = new OutlineImageFigure(null);
                int offsetX = Integer.MAX_VALUE;
                int offsetY = Integer.MAX_VALUE;
                for (IObjectInfo pastedObject : pastingComponents) {
                    IAbstractComponentInfo model = (IAbstractComponentInfo)pastedObject;
                    Rectangle bounds = model.getBounds();
                    offsetX = Math.min(offsetX, bounds.x);
                    offsetY = Math.min(offsetY, bounds.y);
                    this.m_pastedComponents.put(model, new PastedComponentInfo(model));
                    pastedModels.add(model);
                }
                int i = 0;
                for (Map.Entry<IAbstractComponentInfo, PastedComponentInfo> entry : this.m_pastedComponents.entrySet()) {
                    PastedComponentInfo pastedComponent = entry.getValue();
                    Rectangle bounds = pastedComponent.getComponent().getBounds();
                    relativeBounds[i] = new Rectangle(bounds.x - offsetX, bounds.y - offsetY, bounds.width, bounds.height);
                    widgetBounds.union(relativeBounds[i]);
                    this.m_createFeedback.add((Figure)new OutlineImageFigure(pastedComponent.getComponent().getImage(), AbsolutePolicyUtils.COLOR_OUTLINE), (Rectangle)relativeBounds[i]);
                    pastedComponent.setBounds((Rectangle)relativeBounds[i]);
                    ++i;
                }
            } else {
                IAbstractComponentInfo model = (IAbstractComponentInfo)pastingComponents.get(0);
                relativeBounds[0] = new Rectangle();
                widgetBounds = new Rectangle(new Point(0, 0), model.getBounds().getSize());
                this.m_pastedComponents.put(model, new PastedComponentInfo(model, widgetBounds.getCopy()));
                pastedModels.add(model);
                this.m_createFeedback = new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
            }
            this.addFeedback(this.m_createFeedback);
            widgetBounds.x = location.x - widgetBounds.width / 2;
            widgetBounds.y = this.isFreezeVerticalAxis(request) ? this.m_frozenYValue : (this.m_frozenYValue = location.y - widgetBounds.height / 2);
            if (this.m_dotsFeedback == null && (this.useGridSnapping() || this.isKeyboardMoving())) {
                this.m_dotsFeedback = new DotsFeedback(this, this.getHostFigure());
                this.addFeedback(this.m_dotsFeedback);
            }
            this.placementsSupport.drag(request.getLocation(), (List)ImmutableList.copyOf(pastedModels), widgetBounds, (List)ImmutableList.copyOf((Object[])relativeBounds));
            widgetBounds = this.placementsSupport.getBounds();
            this.m_pasteLocation = widgetBounds.getLocation();
            this.translateModelToFeedback(widgetBounds);
            this.m_createFeedback.setBounds(widgetBounds);
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    @Override
    protected final Command getPasteCommand(PasteRequest request) {
        Command pasteCommand = GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

            public void process(Object component) throws Exception {
                AbsoluteBasedLayoutEditPolicy.this.doPasteComponent(AbsoluteBasedLayoutEditPolicy.this.m_pasteLocation, (PastedComponentInfo)AbsoluteBasedLayoutEditPolicy.this.m_pastedComponents.get(component));
            }
        });
        EditCommand cleanupCommand = new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                AbsoluteBasedLayoutEditPolicy.this.placementsSupport.commitAdd();
                AbsoluteBasedLayoutEditPolicy.this.m_pastedComponents = null;
                AbsoluteBasedLayoutEditPolicy.this.m_pasteLocation = null;
            }
        };
        CompoundEditCommand resultCommand = new CompoundEditCommand(this.m_layout.getUnderlyingModel());
        resultCommand.add(pasteCommand);
        resultCommand.add(cleanupCommand);
        return resultCommand;
    }

    protected abstract void doPasteComponent(Point var1, PastedComponentInfo var2) throws Exception;

    protected void onDelete(ObjectInfo child) throws Exception {
        this.placementsSupport.delete((List)ImmutableList.of((Object)((IAbstractComponentInfo)((Object)child))));
    }

    @Override
    protected Command getOrphanCommand(GroupRequest request) {
        List<EditPart> editParts = request.getEditParts();
        final List widgets = Lists.newArrayList();
        for (EditPart editPart : editParts) {
            widgets.add((IAbstractComponentInfo)editPart.getModel());
        }
        return new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                AbsoluteBasedLayoutEditPolicy.this.placementsSupport.delete(widgets);
            }
        };
    }

    @Override
    public int getComponentGapValue(IAbstractComponentInfo component1, IAbstractComponentInfo component2, int direction) {
        switch (direction) {
            case 1: {
                return this.getPreferenceStore().getInt("P_COMPONENT_GAP_LEFT");
            }
            case 4: {
                return this.getPreferenceStore().getInt("P_COMPONENT_GAP_RIGHT");
            }
            case 8: {
                return this.getPreferenceStore().getInt("P_COMPONENT_GAP_TOP");
            }
            case 32: {
                return this.getPreferenceStore().getInt("P_COMPONENT_GAP_BOTTOM");
            }
        }
        return 6;
    }

    @Override
    public int getContainerGapValue(IAbstractComponentInfo component, int direction) {
        switch (direction) {
            case 1: {
                return this.getPreferenceStore().getInt("P_CONTAINER_GAP_LEFT");
            }
            case 4: {
                return this.getPreferenceStore().getInt("P_CONTAINER_GAP_RIGHT");
            }
            case 8: {
                return this.getPreferenceStore().getInt("P_CONTAINER_GAP_TOP");
            }
            case 32: {
                return this.getPreferenceStore().getInt("P_CONTAINER_GAP_BOTTOM");
            }
        }
        return 10;
    }

    @Override
    public Point getClientAreaOffset() {
        return new Point();
    }

    @Override
    public Figure addHorizontalFeedbackLine(int y, int x, int width) {
        Polyline line = this.createLineFeedback(x, y, x + width, y);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        return line;
    }

    @Override
    public Figure addHorizontalMiddleLineFeedback(int y, int x, int width) {
        Polyline line = this.createLineFeedback(x, y, x + width, y);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        line.setLineStyle(2);
        return line;
    }

    @Override
    public Figure addOutlineFeedback(Rectangle bounds) {
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback(feedbackBounds);
        Figure outline = new Figure();
        outline.setBorder(new LineBorder(AbsolutePolicyUtils.COLOR_OUTLINE));
        outline.setBounds(feedbackBounds);
        this.addFeedback(outline);
        return outline;
    }

    @Override
    public Figure addVerticalFeedbackLine(int x, int y, int height) {
        Polyline line = this.createLineFeedback(x, y, x, y + height);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        return line;
    }

    @Override
    public Figure addVerticalMiddleLineFeedback(int x, int y, int height) {
        Polyline line = this.createLineFeedback(x, y, x, y + height);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        line.setLineStyle(2);
        return line;
    }

    protected abstract AbstractAlignmentActionsSupport<C> getAlignmentActionsSupport();

    protected void translateModelToFeedback(Translatable t) {
        PolicyUtils.translateModelToFeedback(this, t);
    }

    protected void translateAbsoluteToModel(Translatable t) {
        PolicyUtils.translateAbsoluteToModel(this, t);
    }

    protected final PlacementsSupport getPlacementsSupport() {
        return this.placementsSupport;
    }

    protected static final class PastedComponentInfo {
        private final IAbstractComponentInfo m_component;
        private Rectangle m_bounds;

        public PastedComponentInfo(IAbstractComponentInfo model, Rectangle bounds) {
            this.m_component = model;
            this.m_bounds = bounds;
        }

        public PastedComponentInfo(IAbstractComponentInfo model) {
            this(model, null);
        }

        public final Rectangle getBounds() {
            return this.m_bounds;
        }

        public final void setBounds(Rectangle bounds) {
            this.m_bounds = bounds;
        }

        public final IAbstractComponentInfo getComponent() {
            return this.m_component;
        }
    }
}

