/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.gef.policy.validator.AbstractLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.CachingLayoutRequestValidator;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class CompatibleLayoutRequestValidator
extends AbstractLayoutRequestValidator {
    private static final ILayoutRequestValidator INSTANCE0 = new CompatibleLayoutRequestValidator();
    public static final ILayoutRequestValidator INSTANCE = new CachingLayoutRequestValidator(INSTANCE0);
    private static final String DEF_functions = StringUtils.join((Object[])new String[]{"def isComponentType(model, c) {", "  if (ReflectionUtils.isSuccessorOf(model, 'org.eclipse.wb.core.model.ObjectInfo')) {", "    return ReflectionUtils.isSuccessorOf(model.description.componentClass, c);", "  } else {", "    return ReflectionUtils.isSuccessorOf(model.componentClass, c);", "  }", "};"}, (String)"\n");

    private CompatibleLayoutRequestValidator() {
    }

    protected boolean validate(EditPart host, Object child) {
        return CompatibleLayoutRequestValidator.areCompatible(host, child);
    }

    protected boolean validateDescription(EditPart host, IComponentDescription childDescription) {
        return CompatibleLayoutRequestValidator.areCompatible(host, childDescription);
    }

    private static boolean areCompatible(final EditPart host, final Object child) {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<Boolean>(){

            @Override
            public Boolean runObject() throws Exception {
                Object parent = host.getModel();
                if (CompatibleLayoutRequestValidator.parentAgreeToAcceptChild(parent, child) && CompatibleLayoutRequestValidator.childAgreeToBeDroppedOnParent(parent, child)) {
                    return true;
                }
                return false;
            }
        }, false);
    }

    private static boolean parentAgreeToAcceptChild(Object parent, Object child) throws Exception {
        String script = CompatibleLayoutRequestValidator.getParameter(parent, "GEF.requestValidator.parent");
        if (script != null) {
            return CompatibleLayoutRequestValidator.executeScriptBoolean(script, parent, child);
        }
        return true;
    }

    private static boolean childAgreeToBeDroppedOnParent(Object parent, Object child) throws Exception {
        String script = CompatibleLayoutRequestValidator.getParameter(child, "GEF.requestValidator.child");
        if (script != null && !CompatibleLayoutRequestValidator.executeScriptBoolean(script, parent, child)) {
            return false;
        }
        return GlobalState.getValidatorHelper().canUseParentForChild(parent, child);
    }

    private static String getParameter(Object object, String name) {
        return GlobalState.getParametersProvider().getParameter(object, name);
    }

    private static boolean executeScriptBoolean(String script, Object parent, Object child) throws Exception {
        Map variables = Maps.newTreeMap();
        variables.put("parent", parent);
        variables.put("child", child);
        return (Boolean)ScriptUtils.evaluate(String.valueOf(DEF_functions) + script, (Map<String, Object>)variables);
    }
}

